/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.fical;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.fical.DocumentPaymentResult;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.print.BillFooter;
import rs.petcom.master.newFiscalization.print.BillPrint;
import rs.petcom.master.newFiscalization.tax.TaxRate;

public class Izvestaji {
    private static final Logger LOGGER = Logger.getLogger("global");

    public static Map<Long, String[]> currentSaleWithArticles(Connection connection, java.util.Date date) {
        HashMap<Long, String[]> currentSaleWithArticles = new HashMap<Long, String[]>();
        Date sqlDate = new Date(date.getTime());
        String[] articleValues = null;
        String query = "SELECT id, productName, quantity, price, round(quantity * price, 2) AS value FROM \n(SELECT\ndd.DocumentDetailsID AS id,\ndd.productName, \nROUND (\n\tSUM(if(d.DocumentTypeID = 22, dd.Quantity * -1, dd.Quantity) )\n,4)AS quantity, \nROUND (dd.PriceWithDiscount,2) AS price \nFROM documentdetails dd\nJOIN document d ON  dd.DocumentID = d.DocumentID\nJOIN user u ON d.sysUserAddID = u.UserID\nWHERE d.DocumentTypeID IN(3,22) and d.DocumentStatusID <> 2 AND d.Date > ?\ngroup BY dd.ProductID, dd.PriceWithDiscount\n) AS trt";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                articleValues = new String[]{rs.getString("productName"), String.valueOf(rs.getDouble("quantity")), String.valueOf(rs.getDouble("price")), String.valueOf(rs.getDouble("value"))};
                currentSaleWithArticles.put(rs.getLong("id"), articleValues);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return currentSaleWithArticles;
    }

    public static Map<String, Double> currentSale(Connection connection, Long wdFrom, Long wdTo, Integer wdId) {
        HashMap<String, Double> currentSale = new HashMap<String, Double>();
        String setQuery = "SET @wdFrom = ?, @wdTo = ?, @wdId = ? ;";
        String query = "SELECT\nif(pm.Name LIKE '%(%)%',SUBSTRING(pm.Name,1,CHAR_LENGTH(pm.Name)-3),pm.Name) AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and d.DocumentTypeID IN (3,18) and d.WorkDayID BETWEEN @wdFrom AND @wdTo  AND pm.PaymentMethodID = 1 and p.PointOfSaleID = @wdId\nUNION\nSELECT\nif(pm.Name LIKE '%(%)%',SUBSTRING(pm.Name,1,CHAR_LENGTH(pm.Name)-3),pm.Name) AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and d.DocumentTypeID IN (3,18) and d.WorkDayID BETWEEN @wdFrom AND @wdTo AND pm.PaymentMethodID = 2 and p.PointOfSaleID =@wdId\nUNION\nSELECT\nif(pm.Name LIKE '%(%)%',SUBSTRING(pm.Name,1,CHAR_LENGTH(pm.Name)-3),pm.Name) AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and d.DocumentTypeID IN (3,18) and d.WorkDayID BETWEEN @wdFrom AND @wdTo AND pm.PaymentMethodID = 3 and p.PointOfSaleID =@wdId\nUNION\nSELECT\nif(pm.Name LIKE '%(%)%',SUBSTRING(pm.Name,1,CHAR_LENGTH(pm.Name)-3),pm.Name) AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and  d.DocumentTypeID IN (3,18) and d.WorkDayID BETWEEN @wdFrom AND @wdTo AND pm.PaymentMethodID = 4 and p.PointOfSaleID =@wdId\nUNION\nSELECT\nif(pm.Name LIKE '%(%)%',SUBSTRING(pm.Name,1,CHAR_LENGTH(pm.Name)-3),pm.Name) AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and d.DocumentTypeID IN (3,18) and d.WorkDayID BETWEEN @wdFrom AND @wdTo AND pm.PaymentMethodID = 7 and p.PointOfSaleID = @wdId\nUNION\nSELECT\nif(pm.Name LIKE '%(%)%',SUBSTRING(pm.Name,1,CHAR_LENGTH(pm.Name)-3),pm.Name) AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and  d.DocumentTypeID IN (3,18) and d.WorkDayID BETWEEN @wdFrom AND @wdTo AND pm.PaymentMethodID = 8 and p.PointOfSaleID = @wdId\nUNION\nSELECT\nif(pm.Name LIKE '%(%)%',SUBSTRING(pm.Name,1,CHAR_LENGTH(pm.Name)-3),pm.Name) AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and d.DocumentTypeID IN (3,18) and  d.WorkDayID BETWEEN @wdFrom AND @wdTo AND pm.PaymentMethodID = 9 and p.PointOfSaleID = @wdId\nUNION\nSELECT\nif(pm.Name LIKE '%(%)%',SUBSTRING(pm.Name,1,CHAR_LENGTH(pm.Name)-3),pm.Name) AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and  d.DocumentTypeID IN (3,18) and d.WorkDayID BETWEEN @wdFrom AND @wdTo AND pm.PaymentMethodID = 10 and p.PointOfSaleID = @wdId\nunion\nSELECT\nif(pm.Name LIKE '%(%)%',SUBSTRING(pm.Name,1,CHAR_LENGTH(pm.Name)-3),pm.Name) AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null and  d.DocumentTypeID IN (3,18) and d.WorkDayID BETWEEN @wdFrom AND @wdTo AND pm.PaymentMethodID = 11 and p.PointOfSaleID = @wdId\nUNION\nSELECT\n'Ukupno' AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nFROM paymentmethod pm \nJOIN documentpayment dp ON pm.PaymentMethodID = dp.PaymentMethodID\nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and  d.DocumentTypeID IN (3,18) AND d.WorkDayID BETWEEN @wdFrom AND @wdTo AND pm.PaymentMethodID IN(1,2,3,4,7,8,9,10,11) and p.PointOfSaleID = @wdId UNION\nSELECT\n'Avans' AS methodName,\ncoalesce(ROUND(SUM(dp.Paid),2),0) AS paid\nfrom documentpayment dp \nJOIN document d ON d.DocumentID = dp.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and  d.DocumentTypeID IN (36) AND d.WorkDayID BETWEEN @wdFrom AND @wdTo and p.PointOfSaleID = @wdId UNION\nSELECT\n'Predracun' AS methodName,\ncoalesce(ROUND(SUM(d.SumWithDiscount),2),0) AS paid\nFROM document d \nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and  d.DocumentTypeID IN (20) AND d.WorkDayID BETWEEN @wdFrom AND @wdTo and p.PointOfSaleID = @wdId UNION\nSELECT\n'Refundacija' AS methodName,\ncoalesce(ROUND(SUM(d.SumWithDiscount),2),0) AS paid\nFROM document d \nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and  d.DocumentTypeID IN (22) AND d.WorkDayID BETWEEN @wdFrom AND @wdTo and p.PointOfSaleID = @wdId ";
        try {
            LOGGER.info("VREDNOST wdFrom " + wdFrom + ", wdTo" + wdTo + ",wdid" + wdId);
            PreparedStatement ps = connection.prepareStatement(setQuery);
            ps.setLong(1, wdFrom);
            ps.setLong(2, wdTo);
            ps.setInt(3, wdId);
            ps.execute();
            ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                try {
                    currentSale.put(rs.getString("methodName").trim(), rs.getDouble("paid"));
                }
                catch (Exception e) {
                    LOGGER.warning("Greska " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return currentSale;
    }

    public static Map<String, Double> vatRateSale(Connection connection, Long wdFrom, Long wdTo, Integer poscode) {
        HashMap<String, Double> currentSale = new HashMap<String, Double>();
        String query = "SELECT \nv.Code as rateName,\nROUND(SUM((dd.Quantity * dd.PriceWithDiscount)),2) AS rateValue\nFROM vat v\nJOIN documentdetails dd ON v.VatID = dd.VatID\nJOIN document d ON dd.DocumentID = d.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and p.PointOfSaleID = ? and d.DocumentTypeID IN (3,18) AND d.WorkDayID BETWEEN ? AND ?\ngroup BY v.VatID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, poscode);
            ps.setLong(2, wdFrom);
            ps.setLong(3, wdTo);
            ps.execute();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                currentSale.put(rs.getString("rateName").trim(), rs.getDouble("rateValue"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return currentSale;
    }

    public static ObservableList<BillFooter> vatRateDocuemntId(Connection connection, Long docuemntId, InvoiceResponse response) {
        ObservableList itemsList = FXCollections.observableArrayList();
        ObservableList billFooter = FXCollections.observableArrayList();
        String query = "SELECT v.Code as codeName,p.Name as NameRate ,v.Name as rateName,dd.Price ,d.ReferentNumber, d.ReferentDateTime,\n ROUND(SUM((dd.Quantity * dd.PriceWithDiscount)),2) AS totalAmount,ROUND(SUM((dd.Quantity * dd.PriceWithDiscount * v.Value3)),2) AS rateValue, sum(dd.Quantity) as Quantity  , dd.productName , dd.PriceWithDiscount \n FROM vat v\n JOIN documentdetails dd ON v.VatID = dd.VatID\n JOIN document d ON dd.DocumentID = d.DocumentID\ninner join paymentmethod p on p.PaymentMethodID = d.PaymentMethodID\n WHERE d.DocumentID =?\n group BY v.VatID , dd.ProductID ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, docuemntId);
            ResultSet rs = ps.executeQuery();
            double rateValueSum = 0.0;
            BigDecimal sum = BigDecimal.valueOf(0.0);
            String refNumber = "";
            String refTime = "";
            HashMap<String, BillPrint> billPrintMap = new HashMap<String, BillPrint>();
            String nameRate = "";
            while (rs.next()) {
                BillPrint billPrint;
                refNumber = rs.getString("ReferentNumber");
                refTime = rs.getString("ReferentDateTime");
                sum = sum.add(rs.getBigDecimal("totalAmount"));
                rateValueSum += rs.getDouble("rateValue");
                String codeName = rs.getString("codeName");
                String rateName = rs.getString("rateName");
                BigDecimal rateValue = rs.getBigDecimal("rateValue");
                nameRate = rs.getString("NameRate");
                if (billPrintMap.containsKey(codeName)) {
                    billPrint = (BillPrint)billPrintMap.get(codeName);
                    billPrint.setRateValueSum(billPrint.getRateValueSum().add(rateValue));
                    billPrintMap.putIfAbsent(codeName, billPrint);
                } else {
                    String codeVat = "";
                    for (TaxRate tx : response.getTaxItems()) {
                        if (!tx.getLabel().equals(codeName)) continue;
                        codeVat = tx.getCategoryName();
                    }
                    BillPrint billPrintCode = new BillPrint(codeName, codeVat, rateName, rateValue);
                    billPrintCode.setRateValueSum(rateValue);
                    billPrintMap.putIfAbsent(codeName, billPrintCode);
                }
                billPrint = new BillPrint(codeName, rs.getString("productName"), rs.getString("rateName"), rs.getBigDecimal("rateValue"), rs.getBigDecimal("totalAmount").subtract(rs.getBigDecimal("rateValue")), rs.getBigDecimal("totalAmount"), rs.getBigDecimal("PriceWithDiscount"), rs.getDouble("Quantity"));
                itemsList.add((Object)billPrint);
            }
            BillFooter billFooter1 = new BillFooter(refNumber, refTime, sum, rateValueSum, nameRate);
            billFooter1.setBillPrintMap(billPrintMap);
            billFooter1.setBillPrints((ObservableList<BillPrint>)itemsList);
            billFooter.add((Object)billFooter1);
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return billFooter;
    }

    public static void PrometPoOperaterima(String fiscalFolder, Long userId, int pointOfSalieID, Connection connection) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        try {
            PrintWriter writer = new PrintWriter(fiscalFolder + sdf.format(new java.util.Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            writer.println("<Linija>=====================</Linija>");
            writer.println("<Linija>PROMET PO OPERATERIMA</Linija>");
            writer.println("<Linija>=====================</Linija>");
            String upit = "select u.UserName, pm.Code, sum(dd.PriceWithDiscount * dd.Quantity) as Price   from documentdetails dd   left join document d on d.DocumentID = dd.DocumentID  left join user u on u.UserID = d.sysUserAddID   left join paymentmethod pm on pm.PaymentMethodID = d.PaymentMethodID  where d.Date > (select min(w1.DateFrom)                    from workday w1 \t\t\t\t     where w1.PointOfSaleID = ? \t\t\t\t       and w1.DateTo is null)";
            if (userId != 0L) {
                upit = upit + "and dd.sysUserAddID = " + userId;
            }
            upit = upit + "  group by u.UserName,pm.Code   order by u.UserName, pm.Code";
            try {
                PreparedStatement ps = connection.prepareStatement(upit);
                ps.setInt(1, pointOfSalieID);
                ResultSet rs = ps.executeQuery();
                String operater = "";
                double suma = 0.0;
                double sumaOperater = 0.0;
                while (rs.next()) {
                    suma += rs.getDouble("Price");
                    if (!operater.equals(rs.getString("UserName"))) {
                        sumaOperater = 0.0;
                        if (!operater.equals("")) {
                            writer.println(String.format("<Linija>%-10s %9.2f</Linija>", "Uk.operater", sumaOperater));
                            writer.println("<Linija>+++++++++++++++++++++</Linija>");
                            writer.println("<Linija></Linija>");
                        }
                        operater = rs.getString("UserName");
                        writer.println("<Linija>" + operater + "</Linija>");
                    }
                    sumaOperater += rs.getDouble("Price");
                    writer.println(String.format("<Linija> - %-10s %7.2f</Linija>", rs.getString("Code"), rs.getDouble("Price")));
                }
                ps.close();
                rs.close();
                if (!operater.equals("")) {
                    writer.println(String.format("<Linija>%-10s %9.2f</Linija>", "Uk.operater", sumaOperater));
                    writer.println("<Linija>+++++++++++++++++++++</Linija>");
                    writer.println("<Linija></Linija>");
                }
                if (userId == 0L) {
                    writer.println(String.format("<Linija>%-10s %9.2f</Linija>", "Ukupno ", suma));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            writer.println("</NefiskalnaStampa>");
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void ProdatiArtikli(String fiscalFolder, Long userId, PointOfSale pos, Connection connection) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        try {
            PrintWriter writer = new PrintWriter(fiscalFolder + sdf.format(new java.util.Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            writer.println("<Linija>+++++++++++++++++++++</Linija>");
            writer.println("<Linija>   PRODATI AKTIKLI   </Linija>");
            writer.println("<Linija>   PRODATI AKTIKLI   </Linija>");
            writer.println("<Linija>+++++++++++++++++++++</Linija>");
            String upit = "select \t\tu.UserName,\t\tp.ShortName,  sum(dd.Quantity) as Count,\t\tsum(dd.PriceWithDiscount * dd.Quantity) as Price, dd.PriceWithDiscount, w.Date AS WorkDay from documentdetails dd left join document d on d.DocumentID = dd.DocumentID left join user u on d.sysUserAddID = u.UserID inner join workday w on w.WorkDayID = d.WorkDayID and w.Date = ? left join product p on p.ProductID = dd.ProductID where d.DocumentTypeID = 3   and d.PointOfSaleID = ?";
            if (userId != 0L) {
                upit = upit + " and dd.sysUserAddID = " + userId;
            }
            upit = upit + "  group by u.UserName,p.ShortName,dd.PriceWithDiscount   order by u.UserName, p.ShortName";
            try {
                PreparedStatement ps = connection.prepareStatement(upit);
                WorkDay wd = WorkDay.getFromDb(pos, connection);
                ps.setDate(1, new Date(wd.getDate().getTime()));
                ps.setInt(2, pos.getPointOfSaleID());
                ResultSet rs = ps.executeQuery();
                String operater = "";
                double suma = 0.0;
                double sumaOperater = 0.0;
                while (rs.next()) {
                    suma += rs.getDouble("Price");
                    writer.println("<Linija>" + rs.getDate("WorkDay") + "</Linija>");
                    sumaOperater += rs.getDouble("Price");
                    writer.println(String.format("<Linija> - %-18s</Linija>", rs.getString("ShortName")));
                    writer.println(String.format("<Linija>  %-5.2fx %12.2f= %12.2f</Linija>", rs.getDouble("Count"), rs.getDouble("PriceWithDiscount"), rs.getDouble("Price")));
                }
                ps.close();
                rs.close();
                if (!operater.equals("")) {
                    writer.println(String.format("<Linija>%-10s %9.2f</Linija>", "Uk.operater", sumaOperater));
                    writer.println("<Linija>+++++++++++++++++++++</Linija>");
                    writer.println("<Linija></Linija>");
                }
                if (userId == 0L) {
                    writer.println(String.format("<Linija>%-10s %9.2f</Linija>", "Ukupno ", suma));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            writer.println("</NefiskalnaStampa>");
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Double> vatRatePdv(Connection connection, String code) {
        HashMap<String, Double> vatRatePdv = new HashMap<String, Double>();
        String[] array = code.split(",");
        StringBuilder inOperator = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            inOperator.append("?,");
        }
        inOperator.deleteCharAt(inOperator.length() - 1);
        try {
            String query = "select v.Value3 as ValuePdv , v.Code as Code from vat v where v.Code in(" + inOperator + ")";
            PreparedStatement ps = connection.prepareStatement(query);
            for (int i = 0; i < array.length; ++i) {
                ps.setString(i + 1, array[i]);
            }
            ps.execute();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vatRatePdv.put(rs.getString("Code").trim(), rs.getDouble("ValuePdv"));
            }
            return vatRatePdv;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return vatRatePdv;
        }
    }

    private static List<DocumentPaymentResult> getResult(ResultSet resultSet, ResultSet resultSet1) throws SQLException {
        Double paid;
        Integer paymentId;
        Long document;
        ArrayList<DocumentPaymentResult> documentsResult = new ArrayList<DocumentPaymentResult>();
        ArrayList<DocumentPaymentResult> paymentsResult = new ArrayList<DocumentPaymentResult>();
        while (resultSet.next()) {
            try {
                document = resultSet.getLong("DocumentID");
                paymentId = resultSet.getInt("PaymentMethodID");
                paid = resultSet.getDouble("paid");
                documentsResult.add(new DocumentPaymentResult(document, paid, paymentId));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        while (resultSet1.next()) {
            try {
                document = resultSet1.getLong("DocumentID");
                paymentId = resultSet1.getInt("PaymentMethodID");
                paid = resultSet1.getDouble("paid");
                paymentsResult.add(new DocumentPaymentResult(document, paid, paymentId));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ArrayList<DocumentPaymentResult> documentPaymentResults = new ArrayList<DocumentPaymentResult>();
        boolean isExist = false;
        for (DocumentPaymentResult documentPaymentResult : documentsResult) {
            isExist = false;
            for (DocumentPaymentResult documentPaymentResult1 : paymentsResult) {
                if (!Objects.equals(documentPaymentResult.getDocumentID(), documentPaymentResult1.getDocumentID()) || !(documentPaymentResult.getPaid() - documentPaymentResult1.getPaid() <= 1.0)) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            documentPaymentResults.add(documentPaymentResult);
        }
        return documentPaymentResults;
    }

    public static void differentCurrentSale(Connection connection, Long wdFrom, Long wdTo) {
        String setQuery = "SET @wdFrom = ?, @wdTo = ? ;";
        String sql = "SELECT d.DocumentID,coalesce(ROUND((d.SumWithDiscount),2),0)  AS paid, d.PaymentMethodID  from  document d WHERE  d.DocumentTypeID IN (3,18) and  d.DocumentStatusID =1 and d.ReferentNumber is not null and PaymentMethodID IN(1,2,3,4,7,8,9,10,11)   and d.WorkDayID BETWEEN @wdFrom AND @wdTo group by d.DocumentId\n";
        String sql1 = "SELECT DocumentID , coalesce(ROUND((Paid),2),0) as paid, PaymentMethodID   from documentpayment WHERE documentpayment.DocumentID in (SELECT d.DocumentID  from documentdetails dd JOIN document d ON dd.DocumentID = d.DocumentID WHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and  d.DocumentTypeID IN (3,18)and PaymentMethodID IN(1,2,3,4,7,8,9,10,11) AND d.WorkDayID BETWEEN @wdFrom AND @wdTo group by d.DocumentID) ";
        LOGGER.info("DOSAO SAM DA SREDIM RAZLIKE KOD DOCUMENT PAYMENTA ZA PERIDICNI");
        String query = "insert into documentpayment (DocumentID,PaymentMethodID,Paid) values(?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(setQuery);
            ps.setLong(1, wdFrom);
            ps.setLong(2, wdTo);
            ps.execute();
            ps = connection.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            ps = connection.prepareStatement(sql1);
            ResultSet rs1 = ps.executeQuery();
            List<DocumentPaymentResult> documentPaymentResults = Izvestaji.getResult(rs, rs1);
            for (DocumentPaymentResult documentPaymentResult : documentPaymentResults) {
                ps = connection.prepareStatement(query);
                ps.setLong(1, documentPaymentResult.getDocumentID());
                ps.setInt(2, documentPaymentResult.getPaymentMethodID());
                ps.setDouble(3, documentPaymentResult.getPaid());
                ps.executeUpdate();
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Double> vatRateSaleAvanas(Connection connection, Long wdFrom, Long wdTo, Integer poscode) {
        HashMap<String, Double> currentSale = new HashMap<String, Double>();
        String query = "SELECT \nv.Code as rateName,\nROUND(SUM((dd.Quantity * dd.PriceWithDiscount)),2) AS rateValue\nFROM vat v\nJOIN documentdetails dd ON v.VatID = dd.VatID\nJOIN document d ON dd.DocumentID = d.DocumentID\nJOIN pointofsale p  ON d.PointOfSaleID = p.PointOfSaleID \nWHERE d.DocumentStatusID =1 and d.ReferentNumber is not null  and p.PointOfSaleID = ? and d.DocumentTypeID IN (36) AND d.WorkDayID BETWEEN ? AND ?\ngroup BY v.VatID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, poscode);
            ps.setLong(2, wdFrom);
            ps.setLong(3, wdTo);
            ps.execute();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                currentSale.put(rs.getString("rateName").trim(), rs.getDouble("rateValue"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return currentSale;
    }
}

