/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.fical;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Deferred;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Present;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.Round;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.Contact;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.fical.XmlBill;

public class FiscalPrinter {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static NumberFormat nf;
    static String putanjaDnevnogIzvestaja;

    public static String printBill(String fiscalFolder, Bill bill, double gotovina, double kartica, double cek, double virman, String user, Connection connection, PointOfSale pos) throws IOException {
        String result = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        StringBuilder sb = new StringBuilder();
        sb.append("PointOfSale: " + pos.getName() + "\n");
        WorkDay wd = WorkDay.getFromDb(pos, connection);
        sb.append("WorkDay: (" + wd.getWorkDayID() + ") " + Settings.getDateFromatter().format(wd.getDate()) + "\n");
        String filename = sdf.format(new Date());
        StringBuilder fiscalSb = new StringBuilder();
        fiscalSb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        fiscalSb.append("<FiscalRecipet>\n");
        ArrayList<RoundItem> itemList = new ArrayList<RoundItem>();
        for (int r = 0; r < bill.getRoundList().size(); ++r) {
            Round round = bill.getRoundList().get(r);
            for (RoundItem roundItem : round.getItemList()) {
                FiscalPrinter.addItem(itemList, roundItem);
            }
        }
        double sumaStavki = 0.0;
        for (int i = 0; i < itemList.size(); ++i) {
            fiscalSb.append("    <FiscalItem>\n");
            fiscalSb.append("        <Naziv>" + itemList.get(i).getProductDepartment().getProduct().getShortName() + "</Naziv>\n");
            fiscalSb.append("        <Cena>" + itemList.get(i).getProductDepartment().getProduct().getPrice() + "</Cena>\n");
            fiscalSb.append("        <Kolicina>" + itemList.get(i).getQuantity() + "</Kolicina>\n");
            fiscalSb.append("        <PoreskaGrupa>" + Vat.getById(itemList.get(i).getProductDepartment().getProduct().getVatID(), connection).getCode() + "</PoreskaGrupa>\n");
            fiscalSb.append("    </FiscalItem>\n");
            sb.append("    - " + itemList.get(i).getProductDepartment().getProduct().getShortName() + " > " + itemList.get(i).getQuantity() + " x " + itemList.get(i).getProductDepartment().getProduct().getPrice() + " = " + itemList.get(i).getQuantity() * itemList.get(i).getProductDepartment().getProduct().getPrice() + "\n");
            sumaStavki += itemList.get(i).getQuantity() * itemList.get(i).getProductDepartment().getProduct().getPrice();
        }
        fiscalSb.append("    <Placanje>\n");
        fiscalSb.append("        <Gotovina>" + gotovina + "</Gotovina>\n");
        fiscalSb.append("        <Cek>" + cek + "</Cek>\n");
        fiscalSb.append("        <Kartica>" + kartica + "</Kartica>\n");
        fiscalSb.append("        <Virman>" + virman + "</Virman>\n");
        fiscalSb.append("    </Placanje>\n");
        fiscalSb.append("    <Konobar>" + user + "</Konobar>\n");
        fiscalSb.append("</FiscalRecipet>\n");
        sb.append("Iznos racuna : " + sumaStavki);
        try {
            File f = File.createTempFile(filename, ".xml");
            FileWriter writer = new FileWriter(f.getAbsoluteFile());
            writer.write(fiscalSb.toString());
            writer.flush();
            writer.close();
            f.renameTo(new File(fiscalFolder + filename + ".xml"));
            LOGGER.info("fiskalni ra\u010dun: Iznos: " + sumaStavki + " " + fiscalFolder + filename + ".xml");
            if (sumaStavki > 0.0) {
                Thread.sleep(400L);
                File f2 = new File(fiscalFolder + "fromfp\\" + filename + ".txt");
                int vremeCekanja = 0;
                while (!f2.exists() || f2.isDirectory()) {
                    Thread.sleep(200L);
                    if ((vremeCekanja += 200) != 5000) continue;
                    LOGGER.warning("Vreme \u010dekanja na \u0161tampu ra\u010duna ve\u0107e od 5s");
                    break;
                }
                result = new String(Files.readAllBytes(Paths.get(f2.getAbsolutePath(), new String[0]))).trim();
                if (f2.delete()) {
                    System.out.println("File is deleted");
                } else {
                    System.out.println("Could not delete file");
                }
            }
        }
        catch (Exception ee) {
            LOGGER.severe("Problem pri \u0161tampi fiskalnog ra\u010duna;" + ee.getMessage());
            File f = new File(fiscalFolder + "\\Err\\" + filename + ".xml");
            FileWriter writer = new FileWriter(f.getAbsoluteFile());
            writer.write(fiscalSb.toString());
            writer.flush();
            writer.close();
            User u = new User();
            u.setUserID(1L);
            Log.writeLog(u, ee.getMessage(), connection);
        }
        User u = new User();
        u.setUserID(1L);
        Log.writeLog(u, sb.toString(), connection);
        return result;
    }

    public static String newPrintBillTrgovina(String fiscalFolder, Bill bill, double gotovina, double kartica, double cek, double virman, String user, ScreensController controller, PointOfSale pos, boolean waitingFPmaster) {
        ArrayList<RoundItem> itemList = new ArrayList<RoundItem>();
        for (int r = 0; r < bill.getRoundList().size(); ++r) {
            Round round = bill.getRoundList().get(r);
            for (RoundItem roundItem : round.getItemList()) {
                FiscalPrinter.addItem(itemList, roundItem);
            }
        }
        try {
            return XmlBill.writeFiscalReciept(itemList, user, gotovina, kartica, cek, virman, fiscalFolder, waitingFPmaster, controller);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String printBillTrgovina(String fiscalFolder, Bill bill, double gotovina, double kartica, double cek, double virman, String user, Connection connection, PointOfSale pos, boolean waitingFPmaster) throws IOException {
        File billFold = new File("./racuni");
        if (!billFold.exists()) {
            billFold.mkdir();
        }
        String result = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        String filename = sdf.format(new Date());
        StringBuilder sb = new StringBuilder();
        sb.append("PointOfSale: " + pos.getName() + "\n");
        WorkDay wd = WorkDay.getFromDb(pos, connection);
        sb.append("WorkDay: (" + wd.getWorkDayID() + ") " + Settings.getDateFromatter().format(wd.getDate()) + "\n");
        StringBuilder fiscalSb = new StringBuilder();
        fiscalSb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        fiscalSb.append("<FiscalRecipet>\n");
        ArrayList<RoundItem> itemList = new ArrayList<RoundItem>();
        for (int r = 0; r < bill.getRoundList().size(); ++r) {
            Round round = bill.getRoundList().get(r);
            for (RoundItem roundItem : round.getItemList()) {
                FiscalPrinter.addItem(itemList, roundItem);
            }
        }
        double sumaStavki = 0.0;
        for (int i = 0; i < itemList.size(); ++i) {
            fiscalSb.append("    <FiscalItem>\n");
            if (((RoundItem)itemList.get(i)).getProductDepartment().getProduct().getShortName().length() > 30) {
                fiscalSb.append("        <Naziv>" + itemList.get(i).getProductDepartment().getProduct().getShortName().substring(0, 30).replace("&", "") + "</Naziv>\n");
            } else {
                fiscalSb.append("        <Naziv>" + itemList.get(i).getProductDepartment().getProduct().getShortName().replace("&", "") + "</Naziv>\n");
            }
            fiscalSb.append("        <Cena>" + Settings.round(itemList.get(i).getProductDepartment().getProduct().getPrice() * (1.0 - itemList.get(i).getProductDepartment().getProduct().getDiscount() / 100.0), 2) + "</Cena>\n");
            fiscalSb.append("        <Kolicina>" + itemList.get(i).getQuantity() + "</Kolicina>\n");
            fiscalSb.append("        <PoreskaGrupa>" + Vat.getById(itemList.get(i).getProductDepartment().getProduct().getVatID(), connection).getCode() + "</PoreskaGrupa>\n");
            fiscalSb.append("    </FiscalItem>\n");
            sb.append("    - " + itemList.get(i).getProductDepartment().getProduct().getShortName() + " > " + itemList.get(i).getQuantity() + " x " + Settings.round(itemList.get(i).getProductDepartment().getProduct().getPrice(), 2) + " = " + itemList.get(i).getQuantity() * Settings.round(itemList.get(i).getProductDepartment().getProduct().getPrice(), 2) + "\n");
            sumaStavki += Settings.round(itemList.get(i).getQuantity() * (itemList.get(i).getProductDepartment().getProduct().getPrice() * (1.0 - itemList.get(i).getProductDepartment().getProduct().getDiscount() / 100.0)), 2);
        }
        fiscalSb.append("    <Placanje>\n");
        fiscalSb.append("        <Gotovina>" + gotovina + "</Gotovina>\n");
        fiscalSb.append("        <Cek>" + cek + "</Cek>\n");
        fiscalSb.append("        <Kartica>" + kartica + "</Kartica>\n");
        fiscalSb.append("        <Virman>" + virman + "</Virman>\n");
        fiscalSb.append("    </Placanje>\n");
        fiscalSb.append("    <Konobar>" + user + "</Konobar>\n");
        fiscalSb.append("</FiscalRecipet>\n");
        sb.append("Iznos racuna : " + Settings.round(sumaStavki, 2));
        try {
            File f = new File(billFold + File.separator + filename + ".xml");
            FileWriter writer = new FileWriter(f.getAbsoluteFile());
            writer.write(fiscalSb.toString());
            writer.flush();
            writer.close();
            f.renameTo(new File(fiscalFolder + filename + ".xml"));
            LOGGER.info("fiskalni ra\u010dun: Iznos: " + sumaStavki + " " + fiscalFolder + filename + ".xml");
            if (sumaStavki > 0.0) {
                Thread.sleep(400L);
                File f2 = new File(fiscalFolder + "fromfp\\" + filename + ".txt");
                int vremeCekanja = 0;
                while ((!f2.exists() || f2.isDirectory()) && waitingFPmaster) {
                    Thread.sleep(200L);
                    if ((vremeCekanja += 200) != 5000) continue;
                    LOGGER.warning("Vreme \u010dekanja na \u0161tampu ra\u010duna ve\u0107e od 5s");
                    break;
                }
                result = new String(Files.readAllBytes(Paths.get(f2.getAbsolutePath(), new String[0]))).trim();
                if (f2.delete()) {
                    System.out.println("File is deleted");
                } else {
                    System.out.println("Could not delete file");
                }
            }
        }
        catch (Exception ee) {
            LOGGER.severe("Problem pri \u0161tampi fiskalnog ra\u010duna;" + ee.getMessage());
            File f = new File(fiscalFolder + "\\Err\\" + filename + ".xml");
            FileWriter writer = new FileWriter(f.getAbsoluteFile());
            writer.write(fiscalSb.toString());
            writer.flush();
            writer.close();
            User u = new User();
            u.setUserID(1L);
            Log.writeLog(u, ee.getMessage(), connection);
        }
        User u = new User();
        u.setUserID(1L);
        Log.writeLog(u, sb.toString(), connection);
        return result;
    }

    public static void openCassBox(ScreensController controller) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        try {
            PrintWriter writer = new PrintWriter(controller.getSettings().getFiscalFolder() + sdf.format(new Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<Fioka>-</Fioka>");
            writer.close();
            String log = "PointOfSale: " + controller.getPointOfSale().getName() + "Otvaranje fioke";
            Log.writeLog(controller.getUser(), log, controller.getSettings().getConnection());
            LOGGER.info("Otvaranje fioke");
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            LOGGER.severe(e.getMessage());
        }
    }

    private static void addItem(ArrayList<RoundItem> list, RoundItem ri) {
        boolean inserted = false;
        list.add(ri);
        for (int a = 0; a < ri.getAdditionalList().size(); ++a) {
            inserted = false;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getProductDepartment().getProduct().getProductID() != ri.getAdditionalList().get(a).getProductDepartment().getProduct().getProductID()) continue;
                list.get(i).setQuantity(list.get(i).getQuantity() + ri.getAdditionalList().get(a).getQuantity());
                inserted = true;
                break;
            }
            if (inserted) continue;
            list.add(ri.getAdditionalList().get(a));
        }
    }

    public static boolean printReport(ScreensController controller, String report) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        String putanjaText = sdf.format(new Date());
        String putanja = controller.getSettings().getFiscalFolder() + putanjaText;
        try {
            PrintWriter writer = new PrintWriter(putanja + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<Izvestaj>" + report + "</Izvestaj>");
            writer.close();
            String log = "PointOfSale: " + controller.getPointOfSale().getName() + "\nIzvestaj: " + report;
            Log.writeLog(controller.getUser(), log, controller.getSettings().getConnection());
            switch (report) {
                case "1": {
                    LOGGER.info("Presek stanja");
                    break;
                }
                case "2": {
                    LOGGER.info("Promet artikala");
                    break;
                }
                case "3": {
                    LOGGER.info("Dnevni izve\u0161taj");
                    putanjaDnevnogIzvestaja = putanjaText;
                    break;
                }
                default: {
                    LOGGER.info("Izve\u0161taj " + report);
                    break;
                }
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            LOGGER.warning(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean printPeriodicni(Date datumOd, Date datumDo, ScreensController controller) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        SimpleDateFormat sdf2 = new SimpleDateFormat("dd.MM.yy");
        try {
            PrintWriter writer = new PrintWriter(controller.getSettings().getFiscalFolder() + sdf.format(new Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<Periodicni>");
            writer.println("\t<FromDate>" + sdf2.format(datumOd) + "</FromDate>");
            writer.println("\t<ToDate>" + sdf2.format(datumDo) + "</ToDate>");
            writer.println("</Periodicni>");
            writer.close();
            String log = "PointOfSale: " + controller.getPointOfSale().getName() + "\nPeriodi\u010dni izve\u0161taj: \n   DatumOd: " + sdf2.format(datumOd) + "\n   DatumDo: " + sdf2.format(datumDo);
            Log.writeLog(controller.getUser(), log, controller.getSettings().getConnection());
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean printNonFiscal(String fiscalFolder, String[] text) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        try {
            PrintWriter writer = new PrintWriter(fiscalFolder + sdf.format(new Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            for (String row : text) {
                writer.println("<Linija>" + row + "</Linija>");
            }
            writer.println("</NefiskalnaStampa>");
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean printNonFiscalGiftCard(ScreensController controller, String[] text) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        Address address = Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection());
        CompanyConfig config = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
        Address addressCompany = Address.getByID(config.getAddressID(), controller.getSettings().getConnection());
        try {
            PrintWriter writer = new PrintWriter(controller.getSettings().getFiscalFolder() + sdf.format(new Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            for (String row : text) {
                writer.println("<Linija>       " + addressCompany.getAddress() + "</Linija>");
                writer.println("<Linija>       " + addressCompany.getZip() + " " + addressCompany.getCity() + "</Linija>");
                writer.println("<Linija>       Maloprodajna jedinica: </Linija>");
                writer.println("<Linija>       " + controller.getObject().getName() + "</Linija>");
                writer.println("<Linija>       " + address.getAddress() + "</Linija>");
                writer.println("<Linija>       " + address.getZip() + " " + address.getCity() + "</Linija>");
                writer.println("<Linija>       " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()) + "</Linija>");
                writer.println("<Linija>++++++++++++++++++++++++++++++++</Linija>");
                writer.println("<Linija>Poklon vaucer:                         </Linija>");
                writer.println("<Linija>Iznos:               " + row + ".00 rsd</Linija>");
                writer.println("<Linija>++++++++++++++++++++++++++++++++</Linija>");
                writer.println("<Linija>Operater: " + controller.getUser().getUserName() + "</Linija>");
            }
            writer.println("</NefiskalnaStampa>");
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean printNonFiscalOrder(ScreensController controller, Bill bill) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        try {
            PrintWriter writer = new PrintWriter("", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            if (!bill.getPerson().getFirstLastName().equals("")) {
                writer.println("<Linija>Podaci o kupcu:                         </Linija>");
                writer.println("<Linija>" + bill.getPerson().getFirstLastName() + "</Linija>");
            }
            if (!bill.getPerson().getAddress().equals("")) {
                writer.println("<Linija>" + bill.getPerson().getAddress() + "</Linija>");
            }
            if (!bill.getPerson().getCity().equals("")) {
                writer.println("<Linija>" + bill.getPerson().getCity() + "</Linija>");
            }
            Contact contactPhone = Contact.getByPersonAndType(bill.getPerson().getPersonID(), 1, controller.getSettings().getConnection());
            Contact contactMobile = Contact.getByPersonAndType(bill.getPerson().getPersonID(), 2, controller.getSettings().getConnection());
            Contact contactMail = Contact.getByPersonAndType(bill.getPerson().getPersonID(), 4, controller.getSettings().getConnection());
            if (contactPhone != null && !contactPhone.getContact().equals("")) {
                writer.println("<Linija>" + contactPhone.getContact() + "</Linija>");
            }
            if (contactMobile != null && !contactMobile.getContact().equals("")) {
                writer.println("<Linija>" + contactMobile.getContact() + "</Linija>");
            }
            if (contactMail != null && !contactMail.getContact().equals("")) {
                writer.println("<Linija>" + contactMail.getContact() + "</Linija>");
            }
            writer.println("<Linija>++++++++++++++++++++++++++++++++</Linija>");
            String poruka = bill.getNapomena();
            String porukaLinija = "";
            while (poruka.length() > 30) {
                porukaLinija = poruka.substring(0, 30);
                porukaLinija = porukaLinija.substring(0, porukaLinija.lastIndexOf(" "));
                poruka = poruka.substring(porukaLinija.length() + 1, poruka.length());
                writer.println("<Linija>" + porukaLinija + "</Linija>");
            }
            writer.println("<Linija>" + poruka + "</Linija>");
            writer.println("<Linija>++++++++++++++++++++++++++++++++</Linija>");
            String porukaLo = bill.getPerson().getLoyality().getNote();
            String porukaLinijaLo = "";
            while (poruka.length() > 30) {
                porukaLinijaLo = porukaLo.substring(0, 30);
                porukaLinijaLo = porukaLinijaLo.substring(0, porukaLinijaLo.lastIndexOf(" "));
                poruka = poruka.substring(porukaLinijaLo.length() + 1, porukaLo.length());
                writer.println("<Linija>" + porukaLinijaLo + "</Linija>");
            }
            writer.println("<Linija>" + porukaLo + "</Linija>");
            writer.println("<Linija>++++++++++++++++++++++++++++++++</Linija>");
            writer.println("<Linija>Operater: " + controller.getUser().getUserName() + "</Linija>");
            writer.println("<Linija>       " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()) + "</Linija>");
            writer.println("</NefiskalnaStampa>");
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean printNonFiscalPresent(ScreensController controller, Present present) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        Address address = Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection());
        CompanyConfig config = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
        Address addressCompany = Address.getByID(config.getAddressID(), controller.getSettings().getConnection());
        try {
            PrintWriter writer = new PrintWriter(controller.getSettings().getFiscalFolder() + sdf.format(new Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            writer.println("<Linija>       " + addressCompany.getAddress() + "</Linija>");
            writer.println("<Linija>       " + addressCompany.getZip() + " " + addressCompany.getCity() + "</Linija>");
            writer.println("<Linija>       Maloprodajna jedinica: </Linija>");
            writer.println("<Linija>       " + controller.getObject().getName() + "</Linija>");
            writer.println("<Linija>       " + address.getAddress() + "</Linija>");
            writer.println("<Linija>       " + address.getZip() + " " + address.getCity() + "</Linija>");
            writer.println("<Linija>       " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()) + "</Linija>");
            writer.println("<Linija>++++++++++++++++++++++++++++++++</Linija>");
            writer.println("<Linija>Poklon:                         </Linija>");
            String poruka = present.getMessage();
            String porukaLinija = "";
            while (poruka.length() > 30) {
                porukaLinija = poruka.substring(0, 30);
                porukaLinija = porukaLinija.substring(0, porukaLinija.lastIndexOf(" "));
                poruka = poruka.substring(porukaLinija.length() + 1, poruka.length());
                writer.println("<Linija>" + porukaLinija + "</Linija>");
            }
            writer.println("<Linija>" + poruka + "</Linija>");
            writer.println("<Linija>++++++++++++++++++++++++++++++++</Linija>");
            writer.println("<Linija>Operater: " + controller.getUser().getUserName() + "</Linija>");
            writer.println("</NefiskalnaStampa>");
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean printNonDefirredBill(ScreensController controller, Deferred deferred) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        String imePrezime = deferred.getName() + " " + deferred.getSurname();
        try {
            PrintWriter writer = new PrintWriter(controller.getSettings().getFiscalFolder() + sdf.format(new Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            writer.println("<Linija>       Maloprodajna jedinica: </Linija>");
            writer.println("<Linija>       " + controller.getObject().getName() + "</Linija>");
            writer.println("<Linija>       " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()) + "</Linija>");
            writer.println("<Linija>++++++++++++++++++++++++++++++++</Linija>");
            writer.println("<Linija>Kupac:" + CharBuffer.allocate(32 - imePrezime.length() - 6).toString().replace('\u0000', ' ') + imePrezime + "</Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija>Trenutno zaduzenje:" + CharBuffer.allocate(32 - String.valueOf(deferred.getCurrentAmount()).length() - 19).toString().replace('\u0000', ' ') + deferred.getCurrentAmount() + "</Linija>");
            writer.println("<Linija>++++++++++++++++++++++++++++++++</Linija>");
            writer.println("<Linija>Operater: " + controller.getUser().getUserName() + "</Linija>");
            writer.println("</NefiskalnaStampa>");
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean printNonFiscalOtpremnica(ScreensController controller, Bill bill, Document doc) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        Printer p = (Printer)Printer.getAllActivePrinter(controller.getSettings().getConnection()).get(0);
        File nefiskalniFolder = new File("");
        Person person = bill.getPerson();
        if (!nefiskalniFolder.exists()) {
            nefiskalniFolder.mkdir();
        }
        Object object = Object.getById(1, controller);
        Address address = Address.getByID(object.getAddressID(), controller.getSettings().getConnection());
        try {
            PrintWriter writer = new PrintWriter(nefiskalniFolder + File.separator + p.getServerName() + "_" + sdf.format(new Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            writer.println("<Linija>                              </Linija>");
            writer.println("<Linija>==============================</Linija>");
            writer.println("<Linija>     Otpremnica " + doc.getNumber() + "/" + doc.getYear() + "</Linija>");
            writer.println("<Linija>==============================</Linija>");
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("otpremnica.uska-stampa.detalji.firme"))) {
                writer.println("<Linija>                              </Linija>");
                writer.println("<Linija>" + object.getName() + "</Linija>");
                writer.println("<Linija>" + address.getAddress() + "</Linija>");
                writer.println("<Linija>" + address.getZip() + " " + address.getCity() + "</Linija>");
                writer.println("<Linija>PIB: " + object.getPIB() + "</Linija>");
                writer.println("<Linija>MB: " + object.getMB() + "</Linija>");
                writer.println("<Linija>                              </Linija>");
            } else {
                writer.println("<Linija>______________________________</Linija>");
                writer.println("<Linija>                              </Linija>");
                writer.println("<Linija>                              </Linija>");
                writer.println("<Linija>______________________________</Linija>");
            }
            writer.println("<Linija>==============================</Linija>");
            writer.println("<Linija>Kupac:</Linija>");
            writer.println("<Linija>" + person.getName() + "</Linija>");
            writer.println("<Linija>" + person.getAddress() + "</Linija>");
            writer.println("<Linija>PIB:" + person.getPIB() + "</Linija>");
            writer.println("<Linija>MB:" + person.getMB() + "</Linija>");
            writer.println("<Linija>______________________________</Linija>");
            ArrayList<RoundItem> itemList = new ArrayList<RoundItem>();
            for (int r = 0; r < bill.getRoundList().size(); ++r) {
                Round round = bill.getRoundList().get(r);
                for (RoundItem roundItem : round.getItemList()) {
                    FiscalPrinter.addItem(itemList, roundItem);
                }
            }
            double sumaStavkiRound = 0.0;
            double sumaStavki = 0.0;
            for (int i = 0; i < itemList.size(); ++i) {
                try {
                    writer.println("<Linija>" + itemList.get(i).getProductDepartment().getProduct().getShortName().replace("&", "").substring(0, 28) + "</Linija>");
                }
                catch (Exception e) {
                    writer.println("<Linija>" + itemList.get(i).getProductDepartment().getProduct().getShortName().replace("&", "") + "</Linija>");
                }
                String textProduct = itemList.get(i).getQuantity() + " x " + itemList.get(i).getProductDepartment().getProduct().getPrice();
                String textSum = String.valueOf(Settings.round(itemList.get(i).getQuantity() * itemList.get(i).getProductDepartment().getProduct().getPrice(), 2));
                writer.println("<Linija>  " + String.format("%-" + (28 - textSum.length()) + "s", textProduct) + textSum + "</Linija>");
                sumaStavkiRound += itemList.get(i).getQuantity() * itemList.get(i).getProductDepartment().getProduct().getPrice();
            }
            sumaStavki = Settings.round(sumaStavkiRound, 2);
            writer.println("<Linija>______________________________</Linija>");
            writer.println("<Linija>ZA UPLATU:" + CharBuffer.allocate(30 - String.valueOf(sumaStavki).length() - 10).toString().replace('\u0000', ' ') + String.valueOf(sumaStavki) + "</Linija>");
            writer.println("<Linija>GOTOVINA:" + CharBuffer.allocate(30 - String.valueOf(sumaStavki).length() - 9).toString().replace('\u0000', ' ') + String.valueOf(sumaStavki) + "</Linija>");
            writer.println("<Linija>UPLA\u0106ENO:" + CharBuffer.allocate(30 - String.valueOf(sumaStavki).length() - 9).toString().replace('\u0000', ' ') + String.valueOf(sumaStavki) + "</Linija>");
            writer.println("<Linija>POVRA\u0106AJ:" + CharBuffer.allocate(30 - String.valueOf(sumaStavki).length() - 6).toString().replace('\u0000', ' ') + String.valueOf(0.0) + "</Linija>");
            writer.println("<Linija>==============================</Linija>");
            writer.println("<Linija>       " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "</Linija>");
            writer.println("<Linija>Operater: " + controller.getUser().getUserName() + "</Linija>");
            writer.println("</NefiskalnaStampa>");
            System.out.println(writer.toString());
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean printNonFiscalOtpremnicaPregled(ScreensController controller, Document document) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        Object object = Object.getById(1, controller);
        Address address = Address.getByID(object.getAddressID(), controller.getSettings().getConnection());
        File nefiskalniFolder = new File("");
        if (!nefiskalniFolder.exists()) {
            nefiskalniFolder.mkdir();
        }
        try {
            PrintWriter writer = new PrintWriter(nefiskalniFolder + File.separator + sdf.format(new Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            writer.println("<Linija>                              </Linija>");
            writer.println("<Linija>                              </Linija>");
            writer.println("<Linija>==============================</Linija>");
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("otpremnica.uska-stampa.detalji.firme"))) {
                writer.println("<Linija>                              </Linija>");
                writer.println("<Linija>" + object.getName() + "</Linija>");
                writer.println("<Linija>" + address.getAddress() + "</Linija>");
                writer.println("<Linija>" + address.getZip() + " " + address.getCity() + "</Linija>");
                writer.println("<Linija>PIB: " + object.getPIB() + "</Linija>");
                writer.println("<Linija>                              </Linija>");
                writer.println("<Linija>______________________________</Linija>");
            } else {
                writer.println("<Linija>                              </Linija>");
                writer.println("<Linija>                              </Linija>");
                writer.println("<Linija>______________________________</Linija>");
            }
            ArrayList<DocumentDetails> itemList = DocumentDetails.getList(document.getDocumentID(), controller.getSettings().getConnection());
            double sumaStavkiRound = 0.0;
            double sumaStavki = 0.0;
            for (int i = 0; i < itemList.size(); ++i) {
                try {
                    writer.println("<Linija>" + itemList.get(i).getProductShortName().replace("&", "").substring(0, 28) + "</Linija>");
                }
                catch (Exception e) {
                    writer.println("<Linija>" + itemList.get(i).getProductShortName().replace("&", "") + "</Linija>");
                }
                String textProduct = itemList.get(i).getQuantity() + " x " + itemList.get(i).getPriceWithDiscount();
                String textSum = String.valueOf(Settings.round(itemList.get(i).getQuantity() * itemList.get(i).getPriceWithDiscount(), 2));
                writer.println("<Linija>  " + String.format("%-" + (28 - textSum.length()) + "s", textProduct) + textSum + "</Linija>");
                sumaStavkiRound += itemList.get(i).getQuantity() * itemList.get(i).getPriceWithDiscount();
            }
            sumaStavki = Settings.round(sumaStavkiRound, 2);
            writer.println("<Linija>______________________________</Linija>");
            writer.println("<Linija>ZA UPLATU:" + CharBuffer.allocate(30 - String.valueOf(sumaStavki).length() - 10).toString().replace('\u0000', ' ') + String.valueOf(sumaStavki) + "</Linija>");
            writer.println("<Linija>GOTOVINA:" + CharBuffer.allocate(30 - String.valueOf(sumaStavki).length() - 9).toString().replace('\u0000', ' ') + String.valueOf(sumaStavki) + "</Linija>");
            writer.println("<Linija>UPLA\u0106ENO:" + CharBuffer.allocate(30 - String.valueOf(sumaStavki).length() - 9).toString().replace('\u0000', ' ') + String.valueOf(sumaStavki) + "</Linija>");
            writer.println("<Linija>POVRA\u0106AJ:" + CharBuffer.allocate(30 - String.valueOf(sumaStavki).length() - 6).toString().replace('\u0000', ' ') + String.valueOf(0.0) + "</Linija>");
            writer.println("<Linija>==============================</Linija>");
            writer.println("<Linija>       " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "</Linija>");
            writer.println("<Linija>Operater: " + controller.getUser().getUserName() + "</Linija>");
            writer.println("</NefiskalnaStampa>");
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean printNonFiscalGotovinskiRacun(long documentId, Bill bill, ScreensController controller) {
        File billFold = new File("./racuni");
        if (!billFold.exists()) {
            billFold.mkdir();
        }
        Document document = Document.getByID(documentId, controller.getSettings().getConnection());
        CashBuyer cashBuyer = CashBuyer.getById(bill.getCashBuyer().getCashBuyerID(), controller);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        try {
            PrintWriter writer = new PrintWriter(controller.getSettings().getFiscalFolder() + sdf.format(new Date()) + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<NefiskalnaStampa>");
            writer.println("<Linija>_______________________________ </Linija>");
            writer.println("<Linija>############################### </Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija>" + controller.getObject().getPIB() + "</Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija>       " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()) + "</Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija>Kupac: </Linija>");
            writer.println("<Linija>" + cashBuyer.getName() + "</Linija>");
            writer.println("<Linija>" + cashBuyer.getAddress() + "</Linija>");
            writer.println("<Linija>" + cashBuyer.getZIP() + " " + cashBuyer.getCity() + "</Linija>");
            writer.println("<Linija>" + cashBuyer.getPIB() + "</Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija>############################### </Linija>");
            writer.println("<Linija>RACUN BR: " + document.getNumber() + "</Linija>");
            writer.println("<Linija>############################### </Linija>");
            ArrayList<RoundItem> itemList = new ArrayList<RoundItem>();
            for (int r = 0; r < bill.getRoundList().size(); ++r) {
                Round round = bill.getRoundList().get(r);
                for (RoundItem roundItem : round.getItemList()) {
                    FiscalPrinter.addItem(itemList, roundItem);
                }
            }
            double sumaStavki = 0.0;
            for (int i = 0; i < itemList.size(); ++i) {
                try {
                    writer.println("<Linija>" + ((RoundItem)itemList.get(i)).getProductDepartment().getProduct().getShortName().replace("&", "").substring(0, 30) + "</Linija>");
                }
                catch (Exception e) {
                    writer.println("<Linija>" + itemList.get(i).getProductDepartment().getProduct().getShortName().replace("&", "") + "</Linija>");
                }
                writer.println("<Linija>  " + itemList.get(i).getQuantity() + "x  " + itemList.get(i).getProductDepartment().getProduct().getPrice() + "    " + itemList.get(i).getQuantity() * itemList.get(i).getProductDepartment().getProduct().getPrice() + "   " + Vat.getById(itemList.get(i).getProductDepartment().getProduct().getVatID(), controller.getSettings().getConnection()).getCode().substring(Vat.getById(itemList.get(i).getProductDepartment().getProduct().getVatID(), controller.getSettings().getConnection()).getCode().length() - 2) + "</Linija>");
                sumaStavki += itemList.get(i).getQuantity() * itemList.get(i).getProductDepartment().getProduct().getPrice();
            }
            writer.println("<Linija>############################### </Linija>");
            writer.println("<Linija>Iznos:                   " + sumaStavki + "</Linija>");
            writer.println("<Linija>GOT. :                   " + sumaStavki + "</Linija>");
            writer.println("<Linija>############################### </Linija>");
            writer.println("<Linija>Operater:</Linija>");
            writer.println("<Linija>" + controller.getUser().getUserName() + "</Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija>Overa</Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija></Linija>");
            writer.println("<Linija>Broj isecka</Linija>");
            writer.println("<Linija>" + document.getFullNumber() + "</Linija>");
            writer.println("</NefiskalnaStampa>");
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String printCopy(Document document, String fiscalFolder, User user, boolean waitingFPmaster, Connection connection) {
        String result = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        PrintWriter writer = null;
        String text = "Kopija fiskalnog ra\u010duna za dokument: \n  ID: " + document.getDocumentID() + "\n  Broj: " + document.getNumber() + "\n  Date: " + sdf.format(document.getDate()) + "\n\n";
        String filename = sdf.format(new Date());
        try {
            writer = new PrintWriter(fiscalFolder + filename + ".xml", "UTF-8");
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            writer.println("<FiscalRecipet>");
            String query = "select \tp.ShortName,\tdd.PriceWithDiscount,\tdd.Quantity,\tv.Code from documentdetails dd left join document d on d.DocumentID = dd.DocumentID left join product p on p.ProductID = dd.ProductID left join vat v on v.VatID = p.VatID where dd.DocumentID = ?";
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, document.getDocumentID());
            ResultSet rs = ps.executeQuery();
            double gotovina = 0.0;
            while (rs.next()) {
                writer.println("    <FiscalItem>");
                writer.println("        <Naziv>" + rs.getString("ShortName") + "</Naziv>");
                writer.println("        <Cena>" + rs.getDouble("PriceWithDiscount") + "</Cena>");
                writer.println("        <Kolicina>" + rs.getDouble("Quantity") + "</Kolicina>");
                writer.println("        <PoreskaGrupa>" + rs.getString("Code") + "</PoreskaGrupa>");
                writer.println("    </FiscalItem>");
                gotovina += rs.getDouble("PriceWithDiscount") * rs.getDouble("Quantity");
            }
            writer.println("    <Placanje>");
            if (document.getPaymentMethodID() == PaymentMethod.getByCode("CASH", connection).getPaymentMethodID()) {
                writer.println("        <Gotovina>" + gotovina + "</Gotovina>");
                writer.println("        <Cek>0</Cek>");
                writer.println("        <Kartica>0</Kartica>");
                writer.println("        <Virman>0</Virman>");
            }
            if (document.getPaymentMethodID() == PaymentMethod.getByCode("CARD", connection).getPaymentMethodID()) {
                writer.println("        <Gotovina>0</Gotovina>");
                writer.println("        <Cek>0</Cek>");
                writer.println("        <Kartica>" + gotovina + "</Kartica>");
                writer.println("        <Virman>0</Virman>");
            }
            if (document.getPaymentMethodID() == PaymentMethod.getByCode("CHECK", connection).getPaymentMethodID() || document.getPaymentMethodID() == PaymentMethod.getByCode("F", connection).getPaymentMethodID()) {
                writer.println("        <Gotovina>0</Gotovina>");
                writer.println("        <Cek>" + gotovina + "</Cek>");
                writer.println("        <Kartica>0</Kartica>");
                writer.println("        <Virman>0</Virman>");
            }
            writer.println("    </Placanje>");
            writer.println("    <Konobar>" + user.getUserName() + "</Konobar>");
            writer.println("</FiscalRecipet>");
            writer.close();
            text = text + String.format("Ukupan iznos ra\u010duna: %10.2f", gotovina);
            Log.writeLog(user, text, connection);
            if (gotovina > 0.0) {
                Thread.sleep(100L);
                File f2 = new File(fiscalFolder + "fromfp\\" + filename + ".txt");
                int vremeCekanja = 0;
                while ((!f2.exists() || f2.isDirectory()) && waitingFPmaster) {
                    Thread.sleep(200L);
                    if ((vremeCekanja += 200) != 5000) continue;
                    LOGGER.warning("Vreme \u010dekanja na \u0161tampu ra\u010duna ve\u0107e od 5s");
                    break;
                }
                result = new String(Files.readAllBytes(Paths.get(f2.getAbsolutePath(), new String[0]))).trim();
                if (f2.delete()) {
                    System.out.println("File is deleted");
                } else {
                    System.out.println("Could not delete file");
                }
            }
        }
        catch (Exception e) {
            LOGGER.severe("Problem pri \u0161tampi fiskalnog ra\u010duna;" + e.getMessage());
            File f = new File(fiscalFolder + "\\Err\\" + sdf.format(new Date()) + ".xml");
            try {
                FileWriter writ = new FileWriter(f.getAbsoluteFile());
                writ.write(writer.toString());
                writ.flush();
                writ.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            User u = new User();
            u.setUserID(1L);
            Log.writeLog(u, e.getMessage(), connection);
        }
        return result;
    }

    public static String getIBFM(String fiscalFolder) {
        File f2 = new File(fiscalFolder + "fiscal.config");
        String result = "";
        try {
            result = new String(Files.readAllBytes(Paths.get(f2.getAbsolutePath(), new String[0]))).trim();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String getSummaryData(String fiscalFolder) throws IOException {
        String result = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Izvestaj>9</Izvestaj>";
        String filename = sdf.format(new Date());
        File f = File.createTempFile(filename, ".xml");
        FileWriter writer = new FileWriter(f.getAbsoluteFile());
        writer.write(request);
        writer.flush();
        writer.close();
        f.renameTo(new File(fiscalFolder + filename + ".xml"));
        File f2 = new File(fiscalFolder + "fromfp\\" + filename + ".txt");
        int vremeCekanja = 0;
        while (!f2.exists() || f2.isDirectory()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((vremeCekanja += 200) != 10000) continue;
            LOGGER.warning("Vreme \u010dekanja na odgovor kase ve\u0107e od 10s");
            break;
        }
        result = new String(Files.readAllBytes(Paths.get(f2.getAbsolutePath(), new String[0]))).trim();
        return result;
    }

    public static void showProductDisplay(String fiscalFolder, String articleName, double sumBill) {
        nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        nf.setGroupingUsed(true);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SS");
        String filename = sdf.format(new Date());
        try {
            PrintWriter printWriter = new PrintWriter(fiscalFolder + filename + ".xml", "UTF-8");
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            printWriter.println("<PrikazNaDispleju>");
            printWriter.println("<Linija1>" + articleName + "</Linija1>");
            printWriter.println("<Linija2>Ukupno:    " + String.format("%10s", String.valueOf(nf.format(sumBill))) + "</Linija2>");
            printWriter.println("</PrikazNaDispleju>");
            printWriter.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }

    public static String getPutanjaDnevnogIzvestaja() {
        return putanjaDnevnogIzvestaja;
    }
}

