/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.fical;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.Round;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.Product;

public class FiscalPrintFLink {
    Bill currentBill;
    Connection connection;
    ScreensController controller;
    Map<String, Double> paymentMethods;

    public FiscalPrintFLink(ScreensController controller) {
        this.controller = controller;
    }

    public FiscalPrintFLink(ScreensController controller, Map<String, Double> paymentMethods) {
        this.controller = controller;
        this.currentBill = controller.getCurrentBill();
        this.connection = controller.getSettings().getConnection();
        this.paymentMethods = paymentMethods;
    }

    public void printBill() {
        File file = this.makeFile();
        String content = this.makeFileContent();
        this.writeContentToFile(file, content);
    }

    public void printXReport() {
        File file = this.makeFile();
        String content = this.makeXReportFileContent();
        this.writeContentToFile(file, content);
    }

    private String makeXReportFileContent() {
        return "X,0,______,_,__;";
    }

    private String makeFileContent() {
        StringBuilder sb = this.getNewStringBuilder();
        List<Round> rounds = this.getRoundsFromBill();
        for (Round round : rounds) {
            List<RoundItem> items = this.getRoundItemsFromRound(round);
            for (RoundItem item : items) {
                this.makeContentforItem(sb, item);
            }
        }
        this.makeSumariseBillContent(sb);
        return sb.toString();
    }

    private void makeContentforItem(StringBuilder sb, RoundItem item) {
        Product product = this.getProductFromRoundItem(item);
        sb.append("S,0,______,_,__;");
        sb.append(this.getProductNameTrimedForFiscalPrint(product));
        sb.append(";");
        sb.append(this.getProductPriceWithDiscount(product));
        sb.append(";");
        sb.append(this.getProductQuantity(item));
        sb.append(";");
        sb.append("0;");
        sb.append("1;");
        sb.append(this.getVatCode(product));
        sb.append(";");
        sb.append("0;");
        sb.append(this.getProductId(product));
        sb.append(";");
        sb.append("0.00;");
        sb.append(";");
        sb.append("0;\r\n");
    }

    private void makeSumariseBillContent(StringBuilder sb) {
        for (Map.Entry<String, Double> set : this.paymentMethods.entrySet()) {
            if (set.getValue() == 0.0) continue;
            sb.append("T,0,______,_,__;");
            sb.append(this.FLinkPaymentCode(set.getKey()));
            sb.append(";");
            sb.append(this.FLinkPaymantValue(set.getValue()));
            sb.append(";");
            sb.append(";");
            sb.append(";");
            sb.append(";\r\n");
        }
    }

    private void writeContentToFile(File file, String content) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            osw.write(content);
            osw.flush();
            osw.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File makeFile() {
        String folder = this.getFolder();
        String fileName = this.getFileName();
        return new File(folder, fileName);
    }

    private String getFolder() {
        return this.controller.getSettings().getFiscalFolder();
    }

    private String getFileName() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        return sdf.format(new Date()) + ".inp";
    }

    private StringBuilder getNewStringBuilder() {
        return new StringBuilder();
    }

    private List<Round> getRoundsFromBill() {
        return this.currentBill.getRoundList();
    }

    private List<RoundItem> getRoundItemsFromRound(Round round) {
        return round.getItemList();
    }

    private Product getProductFromRoundItem(RoundItem item) {
        return item.getProductDepartment().getProduct();
    }

    private String getVatCode(Product product) {
        return Vat.getById(product.getVatID(), this.connection).getCode();
    }

    private String getProductNameTrimedForFiscalPrint(Product product) {
        if (product.getName().length() > 32) {
            return product.getName().substring(0, 32);
        }
        return product.getName();
    }

    private String getProductPriceWithDiscount(Product product) {
        return String.valueOf(Settings.roundOnTwo(product.getPrice() * (1.0 - product.getDiscount() / 100.0)));
    }

    private String getProductQuantity(RoundItem item) {
        return String.valueOf(item.getQuantity());
    }

    private String getProductId(Product product) {
        return String.valueOf(product.getProductID());
    }

    private String FLinkPaymentCode(String payment) {
        return PaymentMethod.FLinkPaymentCode(payment);
    }

    private String FLinkPaymantValue(Double value) {
        return String.valueOf(value);
    }
}

