/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.product.Product;

public class QuickGroupProduct {
    private long quickGroupProductId;
    private long productId;
    private String name;
    private Product product;

    public long getQuickGroupProductId() {
        return this.quickGroupProductId;
    }

    public void setQuickGroupProductId(long quickGroupProductId) {
        this.quickGroupProductId = quickGroupProductId;
    }

    public long getProductId() {
        return this.productId;
    }

    public void setProductId(long productId) {
        this.productId = productId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public static ObservableList<QuickGroupProduct> getList(ScreensController controller, long quickgroupId) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM quickgroupproduct qgp WHERE qgp.QuickGroupID = ? ORDER BY qgp.QuickGroupProductID ASC";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, quickgroupId);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                QuickGroupProduct quickGroupProduct = new QuickGroupProduct();
                quickGroupProduct.setQuickGroupProductId(rSet.getLong("QuickGroupProductID"));
                quickGroupProduct.setName(rSet.getString("Name"));
                quickGroupProduct.setProduct(Product.getByID(rSet.getLong("ProductID"), controller));
                list.add((Object)quickGroupProduct);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

