/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ProductGroup {
    private int ProductGroupID;
    private int ProductGroupDetailsID;
    private String Name;
    private int ProductGroupTypeID;
    private boolean selected;

    public ProductGroup(int ProductGroupID, String Name, int ProductGroupTypeID) {
        this.ProductGroupID = ProductGroupID;
        this.Name = Name;
        this.ProductGroupTypeID = ProductGroupTypeID;
    }

    public ProductGroup() {
    }

    public void setProductGroupDetailsID(int productGroupDetailsID) {
        this.ProductGroupDetailsID = productGroupDetailsID;
    }

    public int getProductGroupDetailsID() {
        return this.ProductGroupDetailsID;
    }

    public int getProductGroupID() {
        return this.ProductGroupID;
    }

    public void setProductGroupID(int productGroupID) {
        this.ProductGroupID = productGroupID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public int getProductGroupTypeID() {
        return this.ProductGroupTypeID;
    }

    public void setProductGroupTypeID(int productGroupTypeID) {
        this.ProductGroupTypeID = productGroupTypeID;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        return this.Name;
    }

    public static ObservableList<ProductGroup> getList(int groupType, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from productgroup where ProductGroupTypeID = ? order by Name";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, groupType);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductGroup pg = new ProductGroup(rs.getInt("ProductGroupID"), rs.getString("Name"), rs.getInt("ProductGroupTypeID"));
                list.add((Object)pg);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<ProductGroup> getList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from productgroup order by ProductGroupID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductGroup pg = new ProductGroup(rs.getInt("ProductGroupID"), rs.getString("Name"), rs.getInt("ProductGroupTypeID"));
                list.add((Object)pg);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<ProductGroup> getListByProductID(long productID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select distinct pg.`*`, pgd.ProductGroupDetailsID from productgroup pg join productgroupdetails pgd on pgd.ProductGroupID = pg.ProductGroupID where pgd.ProductID = ? order by pg.ProductGroupID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductGroup pg = new ProductGroup(rs.getInt("ProductGroupID"), rs.getString("Name"), rs.getInt("ProductGroupTypeID"));
                pg.setProductGroupDetailsID(rs.getInt("ProductGroupDetailsID"));
                list.add((Object)pg);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void insert(Connection connection) throws SQLException {
        String query = "INSERT INTO `productgroup` (`Name`, `ProductGroupTypeID`) VALUES (?, ?);";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setString(1, this.Name);
        ps.setInt(2, this.ProductGroupTypeID);
        ps.executeUpdate();
    }

    public void delete(Connection connection) throws SQLException {
        String query = "DELETE FROM `productgroup` WHERE  `ProductGroupID`=?;";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.ProductGroupID);
        ps.executeUpdate();
        ps.close();
    }

    public static ObservableList<ProductGroup> getListByProductGroupTypeID(int productGroupTypeID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select pg.* from productgroup pg join productgrouptype pgt on pgt.ProductGroupTypeID = pg.ProductGroupTypeID where pgt.ProductGroupTypeID = ? order by pgt.ProductGroupTypeID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productGroupTypeID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductGroup pg = new ProductGroup();
                pg.ProductGroupID = rs.getInt("ProductGroupID");
                pg.ProductGroupTypeID = rs.getInt("ProductGroupTypeID");
                pg.Name = rs.getString("Name");
                list.add((Object)pg);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

