/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductComponent;

public class ProductDeparmentComponent {
    long ProductComponentID = 0L;
    Product ArticleProduct = null;
    Product IngredientProduct = null;
    double Normative = 0.0;
    int Order = 0;

    public long getProductComponentID() {
        return this.ProductComponentID;
    }

    public void setProductComponentID(long productComponentID) {
        this.ProductComponentID = productComponentID;
    }

    public Product getArticleProduct() {
        return this.ArticleProduct;
    }

    public void setArticleProduct(Product articleProduct) {
        this.ArticleProduct = articleProduct;
    }

    public Product getIngredientProduct() {
        return this.IngredientProduct;
    }

    public void setIngredientProduct(Product ingredientProduct) {
        this.IngredientProduct = ingredientProduct;
    }

    public double getNormative() {
        return this.Normative;
    }

    public void setNormative(double normative) {
        this.Normative = normative;
    }

    public int getOrder() {
        return this.Order;
    }

    public void setOrder(int order) {
        this.Order = order;
    }

    public static ArrayList<ProductDeparmentComponent> getList(int departmentId, ScreensController controller) {
        ArrayList<ProductDeparmentComponent> list = new ArrayList<ProductDeparmentComponent>();
        String query = "select \tpc.ArticleProductDepartmenID,\tp.ProductID as articleID,\tp.Name as aName,\tpc.IngredientProductDepartmentID,\tpd2.ProductID as ingredientID,\tp2.Name as iName,\tpc.Normative, \tpc.`Order`  from productcomponent pc  left join productdepartment pd1 on pd1.ProductDepartmentID = pc.ArticleProductDepartmenID  left join product p on pd1.ProductID = p.ProductID  left join productdepartment pd2 on pd2.ProductDepartmentID = pc.IngredientProductDepartmentID  left join product p2 on p2.ProductID = pd2.ProductID where pd1.DepartmentID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, departmentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDeparmentComponent pdc = new ProductDeparmentComponent();
                Product pA = new Product();
                pA.setProductID(rs.getLong("articleID"));
                pA.setName(rs.getString("aName"));
                Product pI = new Product();
                pI.setProductID(rs.getLong("ingredientID"));
                pdc.setArticleProduct(pA);
                pdc.setIngredientProduct(pI);
                pdc.getArticleProduct().setName(rs.getString("aName"));
                pdc.getIngredientProduct().setName(rs.getString("iName"));
                pdc.setNormative(rs.getDouble("Normative"));
                pdc.setOrder(rs.getInt("Order"));
                list.add(pdc);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<ProductDeparmentComponent> getList(PointOfSale pos, ScreensController controller) {
        ArrayList<ProductDeparmentComponent> list = new ArrayList<ProductDeparmentComponent>();
        String query = "select \tpc.ArticleProductDepartmenID,\tp.ProductID as articleID,\tp.Name as aName,    p.ProductTypeID as aProductTypeID,\tpc.IngredientProductDepartmentID,\tpd2.ProductID as ingredientID,\tp2.Name as iName,\tpc.Normative,     p2.ProductTypeID as iProductTypeID,\tpc.`Order`  from productcomponent pc  left join productdepartment pd1 on pd1.ProductDepartmentID = pc.ArticleProductDepartmenID  left join product p on pd1.ProductID = p.ProductID  left join productdepartment pd2 on pd2.ProductDepartmentID = pc.IngredientProductDepartmentID  left join product p2 on p2.ProductID = pd2.ProductID where pd1.DepartmentID in (select psd.DepartmentID\t\t\t\t\t\t\t  from pointofsaledepartment psd\t\t\t\t\t\t\t where psd.PointOfSaleID = ?)";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, pos.getPointOfSaleID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDeparmentComponent pdc = new ProductDeparmentComponent();
                Product pA = new Product();
                pA.setProductID(rs.getLong("articleID"));
                pA.setName(rs.getString("aName"));
                pA.setProductTypeID(rs.getInt("aProductTypeID"));
                Product pI = new Product();
                pI.setProductID(rs.getLong("ingredientID"));
                pdc.setArticleProduct(pA);
                pdc.setIngredientProduct(pI);
                pdc.getArticleProduct().setName(rs.getString("aName"));
                pdc.getIngredientProduct().setName(rs.getString("iName"));
                pdc.getIngredientProduct().setProductTypeID(rs.getInt("iProductTypeID"));
                pdc.setNormative(rs.getDouble("Normative"));
                pdc.setOrder(rs.getInt("Order"));
                list.add(pdc);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<ProductDeparmentComponent> getFlatList(ArrayList<Product> componentList) {
        ArrayList<ProductDeparmentComponent> finalComponentList = new ArrayList<ProductDeparmentComponent>();
        for (Product p : componentList) {
            for (ProductComponent pc : p.getComponentList()) {
                boolean dodat = false;
                try {
                    for (ProductComponent pc1 : pc.getComponentList()) {
                        try {
                            for (ProductComponent pc2 : pc1.getComponentList()) {
                                ProductDeparmentComponent pdc = new ProductDeparmentComponent();
                                pdc.setArticleProduct(p);
                                pdc.setIngredientProduct(pc2.getProduct());
                                pdc.setNormative(pc1.getNormative() * pc2.getNormative());
                                finalComponentList.add(pdc);
                                dodat = true;
                            }
                        }
                        catch (NullPointerException e) {
                            ProductDeparmentComponent pdc = new ProductDeparmentComponent();
                            pdc.setArticleProduct(p);
                            pdc.setIngredientProduct(pc1.getProduct());
                            pdc.setNormative(pc1.getNormative() * pc.getNormative());
                            finalComponentList.add(pdc);
                            dodat = true;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (dodat) continue;
                ProductDeparmentComponent pdc = new ProductDeparmentComponent();
                pdc.setArticleProduct(p);
                pdc.setIngredientProduct(pc.getProduct());
                pdc.setNormative(pc.getNormative());
                finalComponentList.add(pdc);
            }
        }
        return finalComponentList;
    }
}

