/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.MailingList;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Description;
import rs.petcom.master.dal.product.ProductComponent;
import rs.petcom.master.dal.product.ProductDeparmentComponent;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.gui.trgovina.TimeSpinner;
import rs.petcom.renameconnection.ChangeConnection;

public class Product {
    private long ProductID;
    private int ProductTypeID;
    private int ProductCategoryID;
    private String ProductCategoryName;
    private String Code;
    private String Name;
    private String ShortName;
    private int VatID;
    private int UnitID;
    private boolean Active;
    private java.util.Date sysDTCreated;
    private java.util.Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private double NutritionalValue;
    private double EnergyValue;
    private String color;
    private String size;
    private int position;
    private double price;
    private double discount;
    private String UnitName;
    private String GroupName;
    private boolean Measurable;
    private boolean DiscountAllowed;
    private double writeOff;
    private String barcode;
    private String barcodeLast;
    private Barcode barcodeObject;
    private String plucode;
    private double NetAmount;
    private int NetAmountTypeID;
    private double nabavnaCena;
    private double nabavnaCenaBezPopusta;
    private double purchacePrice;
    private double purchacePriceWithoutRabat;
    private double srednjaNabavnaCena;
    private double srednjaNabavnaValue;
    private double nabavnaCenaValue;
    private ObservableList<AditionalFieldDetailsProduct> listAditionalFieldDetailsProduct;
    private ObservableList<AditionalFieldDetails> listAditionalFieldDetails;
    private ObservableList<AditionalField> listAditionalField;
    private double stock;
    private double stockReservation;
    private boolean isWeight;
    private String vatName;
    private String categoryName;
    private double vatValue;
    private double vatValue3;
    private AditionalField aditionalField;
    private double valueLager;
    private String numOfStickers = "1";
    private double valuePdv;
    private java.util.Date priceListDate;
    private long priceListDetailsId;
    private ArrayList<ProductComponent> componentList;
    private long ProductDepartmentID;
    private int KitchenDisplayID;
    private java.util.Date PreparationTime;
    private int GroupID;
    private long productAditionalID;
    private static final Logger LOGGER = Logger.getLogger("global");

    public double getValuePdv() {
        return this.valuePdv;
    }

    public void setValuePdv(double valuePdv) {
        this.valuePdv = valuePdv;
    }

    public long getPriceListDetailsId() {
        return this.priceListDetailsId;
    }

    public void setPriceListDetailsId(long priceListDetailsId) {
        this.priceListDetailsId = priceListDetailsId;
    }

    public void setNabavnaCenaBezPopusta(double nabavnaCenaBezPopusta) {
        this.nabavnaCenaBezPopusta = nabavnaCenaBezPopusta;
    }

    public double getNabavnaCenaBezPopusta() {
        return this.nabavnaCenaBezPopusta;
    }

    public double getVatValue3() {
        return this.vatValue3;
    }

    public void setVatValue3(double vatValue3) {
        this.vatValue3 = vatValue3;
    }

    public void setVatName(String vatName) {
        this.vatName = vatName;
    }

    public String getVatName() {
        return this.vatName;
    }

    public void setVatValue(double vatValue) {
        this.vatValue = vatValue;
    }

    public double getVatValue() {
        return this.vatValue;
    }

    public boolean isWeight() {
        return this.isWeight;
    }

    public void setWeight(boolean isWeight) {
        this.isWeight = isWeight;
    }

    public ObservableList<AditionalFieldDetailsProduct> getListAditionalFieldDetailsProduct() {
        return this.listAditionalFieldDetailsProduct;
    }

    public void setListAditionalFieldDetailsProduct(ObservableList<AditionalFieldDetailsProduct> listAditionalFieldDetailsProduct) {
        this.listAditionalFieldDetailsProduct = listAditionalFieldDetailsProduct;
    }

    public ObservableList<AditionalFieldDetails> getListAditionalFieldDetails() {
        return this.listAditionalFieldDetails;
    }

    public void setListAditionalFieldDetails(ObservableList<AditionalFieldDetails> listAditionalFieldDetails) {
        this.listAditionalFieldDetails = listAditionalFieldDetails;
    }

    public ObservableList<AditionalField> getListAditionalField() {
        return this.listAditionalField;
    }

    public void setListAditionalField(ObservableList<AditionalField> listAditionalField) {
        this.listAditionalField = listAditionalField;
    }

    public double getStock() {
        return this.stock;
    }

    public void setStock(double stock) {
        this.stock = stock;
    }

    public double getStockReservation() {
        return this.stockReservation;
    }

    public void setStockReservation(double stockReservation) {
        this.stockReservation = stockReservation;
    }

    public double getValueLager() {
        return this.valueLager;
    }

    public void setValueLager(double valueLager) {
        this.valueLager = valueLager;
    }

    public void setBarcodeLast(String barcodeLast) {
        this.barcodeLast = barcodeLast;
    }

    public String getBarcodeLast() {
        return this.barcodeLast;
    }

    public boolean isMeasurable() {
        return this.Measurable;
    }

    public void setMeasurable(boolean measurable) {
        this.Measurable = measurable;
    }

    public boolean isDiscountAllowed() {
        return this.DiscountAllowed;
    }

    public void setDiscountAllowed(boolean discountAllowed) {
        this.DiscountAllowed = discountAllowed;
    }

    public double getWriteOff() {
        return this.writeOff;
    }

    public void setWriteOff(double writeOff) {
        this.writeOff = writeOff;
    }

    public String getGroupName() {
        return this.GroupName;
    }

    public void setGroupName(String groupName) {
        this.GroupName = groupName;
    }

    public String getUnitName() {
        return this.UnitName;
    }

    public void setUnitName(String unitName) {
        this.UnitName = unitName;
    }

    public ArrayList<ProductComponent> getComponentList() {
        return this.componentList;
    }

    public void setComponentList(ArrayList<ProductComponent> componentList) {
        this.componentList = componentList;
    }

    public String getNumOfStickers() {
        return this.numOfStickers;
    }

    public void setNumOfStickers(String numOfStickers) {
        this.numOfStickers = numOfStickers;
    }

    public int getGroupID() {
        return this.GroupID;
    }

    public void setGroupID(int groupID) {
        this.GroupID = groupID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public int getProductTypeID() {
        return this.ProductTypeID;
    }

    public void setProductTypeID(int productTypeID) {
        this.ProductTypeID = productTypeID;
    }

    public int getProductCategoryID() {
        return this.ProductCategoryID;
    }

    public void setProductCategoryID(int productCategoryID) {
        this.ProductCategoryID = productCategoryID;
    }

    public String getProductCategoryName() {
        return this.ProductCategoryName;
    }

    public void setProductCategoryName(String productCategoryName) {
        this.ProductCategoryName = productCategoryName;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getShortName() {
        return this.ShortName;
    }

    public void setShortName(String shortName) {
        this.ShortName = shortName;
    }

    public int getVatID() {
        return this.VatID;
    }

    public void setVatID(int vatID) {
        this.VatID = vatID;
    }

    public int getUnitID() {
        return this.UnitID;
    }

    public void setUnitID(int unitID) {
        this.UnitID = unitID;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public java.util.Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(java.util.Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public java.util.Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(java.util.Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public double getNutritionalValue() {
        return this.NutritionalValue;
    }

    public void setNutritionalValue(double nutritionalValue) {
        this.NutritionalValue = nutritionalValue;
    }

    public double getEnergyValue() {
        return this.EnergyValue;
    }

    public void setEnergyValue(double energyValue) {
        this.EnergyValue = energyValue;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public long getProductDepartmentID() {
        return this.ProductDepartmentID;
    }

    public void setProductDepartmentID(long productDepartmentID) {
        this.ProductDepartmentID = productDepartmentID;
    }

    public int getKitchenDisplayID() {
        return this.KitchenDisplayID;
    }

    public void setKitchenDisplayID(int kitchenDisplayID) {
        this.KitchenDisplayID = kitchenDisplayID;
    }

    public java.util.Date getPreparationTime() {
        return this.PreparationTime;
    }

    public void setPreparationTime(java.util.Date preparationTime) {
        this.PreparationTime = preparationTime;
    }

    public long getProductAditionalID() {
        return this.productAditionalID;
    }

    public void setProductAditionalID(long productAditionalID) {
        this.productAditionalID = productAditionalID;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getPlucode() {
        return this.plucode;
    }

    public void setPlucode(String plucode) {
        this.plucode = plucode;
    }

    public Barcode getBarcodeObject() {
        return this.barcodeObject;
    }

    public void setBarcodeObject(Barcode barcodeObject) {
        this.barcodeObject = barcodeObject;
    }

    public double getNetAmount() {
        return this.NetAmount;
    }

    public void setNetAmount(double netAmount) {
        this.NetAmount = netAmount;
    }

    public int getNetAmountTypeID() {
        return this.NetAmountTypeID;
    }

    public void setNetAmountTypeID(int netAmountTypeID) {
        this.NetAmountTypeID = netAmountTypeID;
    }

    public void setNabavnaCena(double nabavnaCena) {
        this.nabavnaCena = nabavnaCena;
    }

    public double getNabavnaCena() {
        return this.nabavnaCena;
    }

    public double getNabavnaCenaValue() {
        return this.nabavnaCenaValue;
    }

    public void setNabavnaCenaValue(double nabavnaCenaValue) {
        this.nabavnaCenaValue = nabavnaCenaValue;
    }

    public double getPurchacePrice() {
        return this.purchacePrice;
    }

    public void setPurchacePrice(double purchacePrice) {
        this.purchacePrice = purchacePrice;
    }

    public double getPurchacePriceWithoutRabat() {
        return this.purchacePriceWithoutRabat;
    }

    public void setPurchacePriceWithoutRabat(double purchacePriceWithoutRabat) {
        this.purchacePriceWithoutRabat = purchacePriceWithoutRabat;
    }

    public double getSrednjaNabavnaCena() {
        return this.srednjaNabavnaCena;
    }

    public void setSrednjaNabavnaCena(double srednjaNabavnaCena) {
        this.srednjaNabavnaCena = srednjaNabavnaCena;
    }

    public double getSrednjaNabavnaValue() {
        return this.srednjaNabavnaValue;
    }

    public void setSrednjaNabavnaValue(double srednjaNabavnaValue) {
        this.srednjaNabavnaValue = srednjaNabavnaValue;
    }

    public java.util.Date getPriceListDate() {
        return this.priceListDate;
    }

    public void setPriceListDate(java.util.Date priceListDate) {
        this.priceListDate = priceListDate;
    }

    public static void changePDV(int pdvId, Connection connection) {
        String query = "UPDATE product SET `VatID` = ? ";
        try {
            PreparedStatement statement = connection.prepareStatement(query);
            statement.setInt(1, pdvId);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public static ObservableList<Product> getProductList(PointOfSale pos, String filter, Connection connection, int departmentID) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select p.*  from productdepartment pd join pointofsaledepartment posd on posd.DepartmentID = pd.DepartmentID join product p on p.ProductID = pd.ProductID where posd.PointOfSaleID = ? and (p.Code like ? or p.Name like ?) and p.active = 1";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, pos.getPointOfSaleID());
            ps.setString(2, "%" + filter + "%");
            ps.setString(3, "%" + filter + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException e) {
                    try {
                        product.sysDTEdit = new SimpleDateFormat("yyyy-MM-dd").parse("2019-01-01");
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.getCurrentPriceAndDiscount(pos, connection);
                product.writeOff = rs.getDouble("WriteOff");
                product.setBarcodeObject(Barcode.getBarCodeObject(product.getProductID(), connection));
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<Product> getList(int group, PointOfSale pos, Connection connection) {
        ArrayList<Product> list = new ArrayList<Product>();
        try {
            PreparedStatement ps = connection.prepareStatement("select p.*, \t\tgp.position, \t\tgp.color  from grouppointofsaleproduct gp   left join product p on p.ProductID = gp.ProductID  where GroupID = ?    and gp.PointOfSaleID = ?");
            ps.setLong(1, group);
            ps.setLong(2, pos.getPointOfSaleID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.color = rs.getString("color");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                try {
                    product.position = rs.getInt("position");
                }
                catch (NullPointerException e) {
                    product.position = 0;
                }
                list.add(product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Product getByShortName(String name, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from product  where  ShortName = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                return product;
            }
            ps.close();
            rs.close();
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Product getByFilterForRobnaKartica(String filter, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from product  where  ShortName = ?");
            ps.setString(1, filter);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                return product;
            }
            ps.close();
            rs.close();
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Product> getNewList(String filter, boolean filterByAll, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        Connection connection = controller.getSettings().getConnection();
        try {
            String filterAll = "'" + filter + "%'";
            PreparedStatement ps = connection.prepareStatement("SELECT  p.*, bc.* FROM product p LEFT JOIN barcode bc on bc.ProductID = p.ProductID  WHERE p.Active IS TRUE" + (filterByAll ? " AND (p.Code LIKE " + filterAll + " OR p.Name LIKE '%" + filter + "%' OR bc.BarCode LIKE " + filterAll + " OR p.PLUcode LIKE " + filterAll + ") ORDER BY LENGTH(p.Code), p.Code LIMIT " + controller.getSettings().getBrojArtikalaZaUcitavanje() : " AND (bc.BarCode = '" + filter + "' OR p.Code = '" + filter + "' OR p.PLUcode = '" + filter + "' ) ORDER BY LENGTH(p.Code), p.Code LIMIT 1"));
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                int indexExistedProduct = Product.alreadyExist(product.getProductID(), (ObservableList<Product>)list);
                if (indexExistedProduct != -1) {
                    ((Product)list.get(indexExistedProduct)).setBarcode(((Product)list.get(indexExistedProduct)).getBarcode() + "-" + rs.getString("BarCode"));
                    continue;
                }
                product = Product.getByID(rs.getLong("ProductID"), controller);
                product.setWeight(rs.getBoolean("isWeight"));
                product.setProductDepartmentID(ProductDepartment.getFromDB(product.getProductID(), 1L, controller).getProductDepartmentID());
                if (controller.getSettings().isKolStanje()) {
                    System.out.println("OVDE NE BI TREBALO DA UDJE AKO U SETAPU NIJE TRUE");
                    double stock = Product.getStockByProduct(product, WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), new java.util.Date(), controller.getSettings().getConnection()), controller);
                    product.setStock(stock);
                }
                product.setBarcode(rs.getString("BarCode"));
                if (AditionalFieldDetailsProduct.isEmtryList(controller, product)) {
                    product.setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID(product.getProductID(), controller.getSettings().getConnection()));
                }
                list.add((java.lang.Object)product);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getNewProductsTrgovinaFrontList(ScreensController controller, String limit, String filter, String textFilter) {
        String query = "SELECT p.*, current_price_before_date(p.ProductID, NOW(), 1) AS Price, bc.BarCode, u.Name AS JN\r\nFROM product p\r\nLEFT JOIN barcode bc ON bc.ProductID = p.ProductID\r\nLEFT JOIN unit u ON u.UnitID = p.UnitID\r\nWHERE IF('Sve' = 'Kod', p.Code = '" + textFilter + "', p.ProductID > 0)\r\nAND IF('" + filter + "' = 'Name', p.Name = '" + textFilter + "', p.ProductID > 0)\r\nAND IF('" + filter + "' = 'Barkod', bc.BarCode = '" + textFilter + "', p.ProductID > 0)\r\nAND (IF('" + filter + "' = 'Sve', bc.BarCode LIKE '" + textFilter + "%', p.ProductID > 0)\r\nOR IF('" + filter + "' = 'Sve', p.Name LIKE '%" + textFilter + "%', p.ProductID > 0)\r\nOR IF('" + filter + "' = 'Sve', p.Code LIKE '%" + textFilter + "%', p.ProductID > 0))  ORDER BY LENGTH(p.Code), p.Code, p.Name, p.ShortName " + (limit.equals("Sve") ? "" : "LIMIT " + limit);
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.plucode = rs.getString("PLUcode");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NetAmount = rs.getDouble("NetAmount");
                product.NetAmountTypeID = rs.getInt("NetAmountTypeID");
                product.Measurable = rs.getBoolean("Measurable");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.price = rs.getDouble("Price");
                product.barcode = rs.getString("BarCode");
                product.UnitName = rs.getString("JN");
                list.add((java.lang.Object)product);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Product getByCode(String name, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from product  where  Code = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                return product;
            }
            ps.close();
            rs.close();
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getLastCode(Connection connection) {
        long last = 0L;
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT MAX(CAST(p.Code AS UNSIGNED)) AS Code FROM product p;");
            ResultSet rs = ps.executeQuery();
            rs.next();
            if (rs.getString("Code") != null) {
                last = Long.parseLong(rs.getString("Code"));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return last;
        }
        return last + 1L;
    }

    public static long getLastBarCode(Connection connection) {
        long last = 0L;
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT MAX(CAST(bc.BarCode AS UNSIGNED)) AS Code FROM barcode bc;");
            ResultSet rs = ps.executeQuery();
            rs.next();
            if (rs.getString("Code") != null) {
                last = Long.parseLong(rs.getString("Code"));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return last;
        }
        return last + 1L;
    }

    public static Product getByBarcode(String barcode, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select p.*, v.Name as VatName, v.Value as VatValue, v.Value3 as VatValue3, b.*  from product p  join barcode b on b.ProductID = p.ProductID  join vat v on v.VatID = p.VatID where b.BarCode = ?");
            ps.setString(1, barcode);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Product product = new Product();
            product.ProductID = rs.getLong("ProductID");
            product.ProductTypeID = rs.getInt("ProductTypeID");
            product.ProductCategoryID = rs.getInt("ProductCategoryID");
            product.Code = rs.getString("Code");
            product.Name = rs.getString("Name");
            product.ShortName = rs.getString("ShortName");
            product.VatID = rs.getInt("VatID");
            product.UnitID = rs.getInt("UnitID");
            product.Active = rs.getBoolean("Active");
            product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
            try {
                product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            product.setBarcodeLast(rs.getString("BarCode"));
            product.sysUserAddID = rs.getLong("sysUserAddID");
            product.sysUserEditID = rs.getLong("sysUserEditID");
            product.NutritionalValue = rs.getDouble("NutritionalValue");
            product.EnergyValue = rs.getDouble("EnergyValue");
            product.setVatName(rs.getString("VatName"));
            product.setVatValue(rs.getDouble("VatValue"));
            product.setVatValue3(rs.getDouble("VatValue3"));
            product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
            product.writeOff = rs.getDouble("WriteOff");
            ps.close();
            rs.close();
            return product;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static Product getByShortNamePrijemnica(String barcode, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select p.*, v.Name as VatName, v.Value as VatValue, v.Value3 as VatValue3, b.*  from product p  join barcode b on b.ProductID = p.ProductID  join vat v on v.VatID = p.VatID where p.ShortName = ?");
            ps.setString(1, barcode);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.setBarcodeLast(rs.getString("BarCode"));
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.setVatName(rs.getString("VatName"));
                product.setVatValue(rs.getDouble("VatValue"));
                product.setVatValue3(rs.getDouble("VatValue3"));
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                ps.close();
                rs.close();
                return product;
            }
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Product getByID(long id, long departmentId, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select p.*, v.Name as VatName, v.Value as VatValue, v.Value3 as VatValue3   from product p join vat v on v.VatID = p.VatID where  p.ProductID = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.setBarcodeLast(Barcode.getBarCode(product.ProductID, connection));
                product.getCurrentPrice(departmentId, connection);
                product.setVatName(rs.getString("VatName"));
                product.setVatValue(rs.getDouble("VatValue"));
                product.setVatValue3(rs.getDouble("VatValue3"));
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.barcode = Barcode.getBarCode(product.getProductID(), connection);
                product.Measurable = rs.getBoolean("Measurable");
                ps.close();
                rs.close();
                return product;
            }
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Product getByID(long id, ScreensController controller) {
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("select p.*, v.Name as VatName, v.Value as VatValue, v.Value3 as VatValue3   from product p join vat v on v.VatID = p.VatID where  p.ProductID = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.setBarcodeLast(Barcode.getBarCode(product.ProductID, controller.getSettings().getConnection()));
                product.getCurrentPrice(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), controller.getSettings().getConnection());
                product.setVatName(rs.getString("VatName"));
                product.setVatValue(rs.getDouble("VatValue"));
                product.setVatValue3(rs.getDouble("VatValue3"));
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.barcode = Barcode.getBarCode(product.getProductID(), controller.getSettings().getConnection());
                product.Measurable = rs.getBoolean("Measurable");
                ps.close();
                rs.close();
                return product;
            }
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Product getByIDWithPrice(long id, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from product  where  ProductID = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            Product product = null;
            while (rs.next()) {
                product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.plucode = rs.getString("PLUcode");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.Measurable = rs.getBoolean("Measurable");
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.barcode = Barcode.getBarCode(product.getProductID(), connection);
            }
            rs.close();
            ps.close();
            return product;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Product> getByTypeID(int typeID, boolean active, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("select * from product where  ProductTypeID = ? and Active = ?");
            ps.setInt(1, typeID);
            ps.setBoolean(2, active);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static ObservableList<Product> getProductByMeasurable(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT p.ProductID, p.Measurable FROM product p");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.Measurable = rs.getBoolean("Measurable");
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static boolean isAditionalChild(long productID, Connection connection) {
        String query = "select * from productaditional pa where pa.ChildProductID = ?";
        int brojac = 0;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ++brojac;
            }
            if (brojac > 0) {
                return true;
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public ArrayList<Description> getDescriptionList(int posId, Connection connection) {
        ArrayList<Description> list = new ArrayList<Description>();
        String upit = "select *   from pointofsaleproductdescription psd   left join description d on psd.DescriptionID = d.DescriptionID  where d.Active    and psd.PointOfSaleID = ?    and psd.ProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setInt(1, posId);
            ps.setLong(2, this.getProductID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Description description = new Description();
                description.setDescriptionID(rs.getInt("DescriptionID"));
                description.setName(rs.getString("Name"));
                description.setActive(rs.getBoolean("Active"));
                description.setSysDTCreated(new java.util.Date(rs.getDate("sysDTCreated").getTime()));
                try {
                    description.setSysDTEdit(new java.util.Date(rs.getDate("sysDTEdit").getTime()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                description.setSysUserAddID(rs.getLong("sysUserAddID"));
                try {
                    description.setSysUserEditID(rs.getDate("sysUserEditID").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                description.setColor(rs.getString("color"));
                list.add(description);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public AditionalField getAditionalField() {
        return this.aditionalField;
    }

    public void setAditionalField(AditionalField aditionalField) {
        this.aditionalField = aditionalField;
    }

    public boolean equals(Product product) {
        return this.ProductID == product.ProductID && this.price == product.price;
    }

    public static ObservableList<Product> getObeservableList(Product excludedProduct, String filter, boolean activeOnly, Department department, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select p.*, pd.ProductDepartmentID  from product p left join productdepartment pd on pd.ProductID = p.ProductID";
        if (department != null) {
            query = query + " where pd.DepartmentID = ?  and (p.Code like ? or p.Name like ? or p.ShortName = ?)";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (department != null) {
                ps.setInt(1, department.getDepartmentID());
            }
            ps.setString(2, "%" + filter + "%");
            ps.setString(3, "%" + filter + "%");
            ps.setString(4, "%" + filter + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getObeservableList(PointOfSale pos, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select p.*, pd.ProductDepartmentID  from product p left join productdepartment pd on pd.ProductID = p.ProductID where pd.DepartmentID in (select psd.DepartmentID\t\t\t\t\t\t\t from pointofsaledepartment psd\t\t\t\t\t\t    where psd.PointOfSaleID = ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pos.getPointOfSaleID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public Product getCopy() {
        Product p = new Product();
        p.ProductID = this.ProductID;
        p.ProductTypeID = this.ProductTypeID;
        p.ProductCategoryID = this.ProductCategoryID;
        p.Code = this.Code;
        p.Name = this.Name;
        p.ShortName = this.ShortName;
        p.VatID = this.VatID;
        p.UnitID = this.UnitID;
        p.Active = this.Active;
        p.sysDTCreated = this.sysDTCreated;
        p.sysDTEdit = this.sysDTEdit;
        p.sysUserAddID = this.sysUserAddID;
        p.sysUserEditID = this.sysUserAddID;
        p.NutritionalValue = this.NutritionalValue;
        p.EnergyValue = this.EnergyValue;
        return p;
    }

    public void update(User user, Boolean mesaurable, Boolean DiscountAllowed, Connection connection) throws SQLException {
        String query = "update product set \t`ProductTypeID` = ?, \t`ProductCategoryID` = ?,\t`Code` = ?,\t`PLUcode` = ?,\t`Name` = ?,\t`ShortName` = ?,\t`VatID` = ?,\t`UnitID` = ?,\t`Active` = ?,\t`sysDTEdit` =  now(),\t`sysUserEditID` = ?,\t`NutritionalValue` = ?,\t`EnergyValue` = ?, Measurable = ?, DiscountAllowed = ?, WriteOff = ?, NetAmount = ?, NetAmountTypeID = ? where `ProductID` = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setInt(1, this.getProductTypeID());
        ps.setInt(2, this.getProductCategoryID());
        ps.setString(3, this.getCode());
        ps.setString(4, this.getPlucode());
        ps.setString(5, this.getName());
        ps.setString(6, this.getShortName());
        ps.setInt(7, this.getVatID());
        ps.setInt(8, this.getUnitID());
        ps.setBoolean(9, this.isActive());
        ps.setLong(10, user.getUserID());
        ps.setDouble(11, this.getNutritionalValue());
        ps.setDouble(12, this.getEnergyValue());
        ps.setBoolean(13, mesaurable);
        ps.setBoolean(14, DiscountAllowed);
        ps.setDouble(15, this.getWriteOff());
        ps.setDouble(16, this.getNetAmount());
        if (this.getNetAmountTypeID() > 0) {
            ps.setInt(17, this.getNetAmountTypeID());
        } else {
            ps.setNull(17, 4);
        }
        ps.setLong(18, this.getProductID());
        ps.executeUpdate();
        ps.close();
    }

    public void update(ScreensController controller) throws SQLException {
        String query = "update product set \t`ProductTypeID` = ?, \t`ProductCategoryID` = ?,\t`Code` = ?,\t`PLUcode` = ?,\t`Name` = ?,\t`ShortName` = ?,\t`VatID` = ?,\t`UnitID` = ?,\t`Active` = ?,\t`sysDTEdit` =  now(),\t`sysUserEditID` = ?,\t`NutritionalValue` = ?,\t`EnergyValue` = ?, Measurable = ?, DiscountAllowed = ?, WriteOff = ?, NetAmount = ?, NetAmountTypeID = ? where `ProductID` = ?";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
        ps.setInt(1, this.getProductTypeID());
        ps.setInt(2, this.getProductCategoryID());
        ps.setString(3, this.getCode());
        ps.setString(4, this.getPlucode());
        ps.setString(5, this.getName());
        ps.setString(6, this.getShortName());
        ps.setInt(7, this.getVatID());
        ps.setInt(8, this.getUnitID());
        ps.setBoolean(9, this.isActive());
        ps.setLong(10, controller.getUser().getUserID());
        ps.setDouble(11, this.getNutritionalValue());
        ps.setDouble(12, this.getEnergyValue());
        ps.setBoolean(13, this.isMeasurable());
        ps.setBoolean(14, this.isDiscountAllowed());
        ps.setDouble(15, this.getWriteOff());
        ps.setDouble(16, this.getNetAmount());
        if (this.getNetAmountTypeID() > 0) {
            ps.setInt(17, this.getNetAmountTypeID());
        } else {
            ps.setNull(17, 4);
        }
        ps.setLong(18, this.getProductID());
        ps.executeUpdate();
        ps.close();
    }

    public int updateByCode(ScreensController controller) throws SQLException {
        String query = "update product set \t`ProductTypeID` = ?, \t`ProductCategoryID` = ?,\t`Code` = ?,\t`PLUcode` = ?,\t`Name` = ?,\t`ShortName` = ?,\t`VatID` = ?,\t`UnitID` = ?,\t`Active` = ?,\t`sysDTEdit` =  now(),\t`sysUserEditID` = ?,\t`NutritionalValue` = ?,\t`EnergyValue` = ?, Measurable = ?, DiscountAllowed = ?, WriteOff = ?, NetAmount = ?, NetAmountTypeID = ? where `Code` = ?";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
        ps.setInt(1, this.getProductTypeID());
        ps.setInt(2, this.getProductCategoryID());
        ps.setString(3, this.getCode());
        ps.setString(4, this.getPlucode());
        ps.setString(5, this.getName());
        ps.setString(6, this.getShortName());
        ps.setInt(7, this.getVatID());
        ps.setInt(8, this.getUnitID());
        ps.setBoolean(9, this.isActive());
        ps.setLong(10, controller.getUser().getUserID());
        ps.setDouble(11, this.getNutritionalValue());
        ps.setDouble(12, this.getEnergyValue());
        ps.setBoolean(13, this.isMeasurable());
        ps.setBoolean(14, this.isDiscountAllowed());
        ps.setDouble(15, this.getWriteOff());
        ps.setDouble(16, this.getNetAmount());
        if (this.getNetAmountTypeID() > 0) {
            ps.setInt(17, this.getNetAmountTypeID());
        } else {
            ps.setNull(17, 4);
        }
        ps.setString(18, this.getCode());
        LOGGER.info(ps.toString());
        int numOfRowsAffected = ps.executeUpdate();
        ps.close();
        return numOfRowsAffected;
    }

    public void updateServer(Connection connection) {
        String query = "update product set \t`ProductTypeID` = ?, \t`ProductCategoryID` = ?,\t`Code` = ?,\t`PLUcode` = ?,\t`Name` = ?,\t`ShortName` = ?,\t`VatID` = ?,\t`UnitID` = ?,\t`Active` = ?,\t`sysDTEdit` =  ?,\t`sysUserEditID` = ?,\t`NutritionalValue` = ?,\t`EnergyValue` = ?, Measurable = ?, DiscountAllowed = ?, WriteOff = ?, NetAmount = ?, NetAmountTypeID = ? where `ProductID` = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.getProductTypeID());
            ps.setInt(2, this.getProductCategoryID());
            ps.setString(3, this.getCode());
            ps.setString(4, this.getPlucode());
            ps.setString(5, this.getName());
            ps.setString(6, this.getShortName());
            ps.setInt(7, this.getVatID());
            ps.setInt(8, this.getUnitID());
            ps.setBoolean(9, this.isActive());
            ps.setTimestamp(10, new Timestamp(this.getSysDTEdit().getTime()));
            ps.setLong(11, this.getSysUserEditID());
            ps.setDouble(12, this.getNutritionalValue());
            ps.setDouble(13, this.getEnergyValue());
            ps.setBoolean(14, this.isMeasurable());
            ps.setBoolean(15, this.isDiscountAllowed());
            ps.setDouble(16, this.getWriteOff());
            ps.setDouble(17, this.getNetAmount());
            if (this.getNetAmountTypeID() > 0) {
                ps.setInt(18, this.getNetAmountTypeID());
            } else {
                ps.setNull(18, 4);
            }
            ps.setLong(19, this.getProductID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateProductGroup(int groupID, int sort, int pos, long gpID, Connection connection) {
        String query = "UPDATE grouppointofsaleproduct SET \t`GroupID` = ?,\t`ProductID` = ?, `ProductDepartmentID` = ?,\t`Sort` = ?,\t`Active` = ?,\t`sysDTEdit` = now(),\t`position` = ?,`color` = ?,\t`PointOfSaleID` = ? WHERE `GroupProductID` = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, groupID);
            ps.setLong(2, this.ProductID);
            ps.setLong(3, this.ProductDepartmentID);
            ps.setInt(4, sort);
            ps.setBoolean(5, this.Active);
            ps.setInt(6, this.position);
            ps.setString(7, this.color);
            ps.setInt(8, pos);
            ps.setLong(9, gpID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateProductBySysDTEdit(Connection connection) {
        String query = "UPDATE `product` SET `sysDTEdit`= NOW() WHERE  `ProductID`= ?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ProductID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateProductByActivity(Connection connection) {
        String query = "UPDATE `product` SET `Active`= ? WHERE  `ProductID`= ?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setBoolean(1, this.Active);
            ps.setLong(2, this.ProductID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public long insert(User user, Connection connection) throws SQLException {
        String query = "insert into product ( \t`ProductTypeID`,\t`ProductCategoryID`,\t\t`Code`,\t`Name`,\t`ShortName`,\t`VatID`,\t`UnitID`,\t`Active`,\t`sysDTCreated`,\t`sysUserAddID`,\t`NutritionalValue`,\t`EnergyValue`, `Measurable`, `NetAmount`, `NetAmountTypeID`, `DiscountAllowed`, `WriteOff`) values (?,?,?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?)";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        if (this.getProductTypeID() == 0) {
            ps.setInt(1, 1);
        } else {
            ps.setInt(1, this.getProductTypeID());
        }
        ps.setInt(2, this.getProductCategoryID());
        try {
            if (this.getCode().equals("")) {
                ps.setNull(3, 12);
            } else {
                ps.setString(3, this.getCode());
            }
        }
        catch (NullPointerException e) {
            ps.setNull(3, 12);
        }
        ps.setString(4, this.getName());
        ps.setString(5, this.getShortName());
        ps.setInt(6, this.getVatID());
        ps.setInt(7, this.getUnitID());
        ps.setBoolean(8, this.isActive());
        ps.setLong(9, user.getUserID());
        ps.setDouble(10, this.getNutritionalValue());
        ps.setDouble(11, this.getEnergyValue());
        ps.setBoolean(12, this.isMeasurable());
        ps.setDouble(13, this.getNetAmount());
        if (this.getNetAmountTypeID() > 0) {
            ps.setInt(14, this.getNetAmountTypeID());
        } else {
            ps.setNull(14, 4);
        }
        ps.setBoolean(15, this.isDiscountAllowed());
        ps.setDouble(16, this.getWriteOff());
        System.out.println(ps);
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        rs.next();
        this.setProductID(rs.getLong(1));
        ps.close();
        rs.close();
        return this.getProductID();
    }

    public long insertSynchronisation(User user, Connection connection) throws SQLException {
        String query = "insert into product ( \t`ProductTypeID`,\t`ProductCategoryID`,\t\t`Code`,\t`Name`,\t`ShortName`,\t`VatID`,\t`UnitID`,\t`Active`,\t`sysDTCreated`,\t`sysUserAddID`,\t`NutritionalValue`,\t`EnergyValue`, `Measurable`, `NetAmount`, `NetAmountTypeID`, `DiscountAllowed`, `WriteOff`, `ProductID`) values (?,?,?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        if (this.getProductTypeID() == 0) {
            ps.setInt(1, 1);
        } else {
            ps.setInt(1, this.getProductTypeID());
        }
        if (this.getProductCategoryID() == 0) {
            ps.setInt(2, 1);
        } else {
            ps.setInt(2, this.getProductCategoryID());
        }
        try {
            if (this.getCode().equals("")) {
                ps.setNull(3, 12);
            } else {
                ps.setString(3, this.getCode());
            }
        }
        catch (NullPointerException e) {
            ps.setNull(3, 12);
        }
        ps.setString(4, this.getName());
        ps.setString(5, this.getShortName());
        ps.setInt(6, this.getVatID());
        ps.setInt(7, this.getUnitID());
        ps.setBoolean(8, this.isActive());
        ps.setLong(9, user.getUserID());
        ps.setDouble(10, this.getNutritionalValue());
        ps.setDouble(11, this.getEnergyValue());
        ps.setBoolean(12, this.isMeasurable());
        ps.setDouble(13, this.getNetAmount());
        if (this.getNetAmountTypeID() > 0) {
            ps.setInt(14, this.getNetAmountTypeID());
        } else {
            ps.setNull(14, 4);
        }
        ps.setBoolean(15, this.isDiscountAllowed());
        ps.setDouble(16, this.getWriteOff());
        ps.setLong(17, this.getProductID());
        System.out.println("");
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        rs.next();
        this.setProductID(rs.getLong(1));
        ps.close();
        rs.close();
        return this.getProductID();
    }

    public static ObservableList<Product> getAddList(Department department, String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select p.*   from product p join barcode bc on bc.ProductID = p.ProductID where (p.Code like ? or p.Name like ? or p.ShortName like ? or bc.BarCode like ?)";
        if (department != null) {
            query = query + "   and p.ProductID not in (select pd.ProductID \t\t\t\t\t\t\t from productdepartment pd\t\t\t\t\t\t\twhere DepartmentID = ?)";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, "%" + filter + "%");
            ps.setString(2, "%" + filter + "%");
            ps.setString(3, "%" + filter + "%");
            ps.setString(4, "%" + filter + "%");
            if (department != null) {
                ps.setInt(5, department.getDepartmentID());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getAddListZaVrstuDokumenta(String sVrstaDokumenta, Department department, String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement cs = null;
            cs = connection.prepareStatement("{ CALL getProductZaVrstuDokumenta(?, ?, ?) }");
            cs.setString(1, sVrstaDokumenta);
            if (department != null) {
                cs.setLong(2, department.getDepartmentID());
            } else {
                cs.setLong(2, -1L);
            }
            cs.setString(3, filter);
            cs.execute();
            ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                list.add((java.lang.Object)product);
            }
            cs.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) throws SQLException {
        String query = "delete from product where `ProductID` = ?";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, this.getProductID());
        ps.executeUpdate();
        ps.close();
    }

    public static void insertProductAditional(int departmentID, Product parent, Product child, Connection connection) {
        String query = "INSERT INTO productaditional ( parentproductid,  childproductid) VALUES (?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, parent.getProductID());
            ps.setLong(2, child.getProductID());
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            long productAditionalID = rs.getLong(1);
            Product.updateProductAdititionalDepartmentPosition(productAditionalID, child.getProductID(), connection);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updateProductAdititionalDepartmentPosition(long productAditionalID, long productID, Connection connection) {
        String query = "INSERT INTO productaditionaldepartmentposition (ProductAditionalID, ProductDepartmentID)select (select pa.ProductAditionalID from productaditional pa where pa.ProductAditionalID=?) as ProductAditionalID, pd.ProductDepartmentID from productdepartment pd where pd.ProductID = ? and pd.DepartmentID in (select d.DepartmentID from department d) ";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, productAditionalID);
            ps.setLong(2, productID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAdditionalProduct(long parentID, Product child, Connection connection) {
        String query = "DELETE FROM productaditional WHERE ParentProductID = ? and ChildProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, parentID);
            ps.setLong(2, child.getProductID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAditionalProductPositionColor(long parentID, Product child, Connection connection) {
        String query = "DELETE FROM productaditionaldepartmentposition where ProductAditionalID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, child.getProductAditionalID());
            ps.executeUpdate();
            Product.deleteAdditionalProduct(parentID, child, connection);
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<Product> getProductListWithComponents(Department department, ScreensController controller) {
        ArrayList<ProductDeparmentComponent> pdcList = ProductDeparmentComponent.getList(department.getDepartmentID(), controller);
        ObservableList<Product> productlist = Product.getObeservableList(new Product(), "", false, department, controller.getSettings().getConnection());
        ArrayList<Product> list = new ArrayList<Product>();
        for (Product p : productlist) {
            list.add(p);
        }
        for (Product p : list) {
            p.setComponentList(Product.getComponents(p, pdcList));
        }
        return list;
    }

    public static ArrayList<Product> getProductListWithComponents(PointOfSale pos, ScreensController controller) {
        ArrayList<ProductDeparmentComponent> pdcList = ProductDeparmentComponent.getList(pos, controller);
        ObservableList<Product> productlist = Product.getObeservableList(pos, controller.getSettings().getConnection());
        ArrayList<Product> list = new ArrayList<Product>();
        for (Product p : productlist) {
            list.add(p);
        }
        for (Product p : list) {
            p.setComponentList(Product.getComponents(p, pdcList));
        }
        return list;
    }

    private static ArrayList<ProductComponent> getComponents(Product product, ArrayList<ProductDeparmentComponent> pdcList) {
        ArrayList<ProductComponent> list = new ArrayList<ProductComponent>();
        for (ProductDeparmentComponent pdc : pdcList) {
            if (pdc.getArticleProduct().getProductID() != product.getProductID()) continue;
            ProductComponent pc = new ProductComponent();
            pc.setProduct(pdc.getIngredientProduct());
            pc.setNormative(pdc.getNormative());
            if (Product.countChildren(pdc.getIngredientProduct(), pdcList) > 0) {
                pc.setComponentList(Product.getChildren(pc.getProduct(), pdcList));
            }
            list.add(pc);
        }
        return list;
    }

    private static int countChildren(Product product, ArrayList<ProductDeparmentComponent> pdcList) {
        int result = 0;
        for (ProductDeparmentComponent pdc : pdcList) {
            if (product.getProductID() != pdc.getArticleProduct().getProductID()) continue;
            ++result;
        }
        return result;
    }

    private static ArrayList<ProductComponent> getChildren(Product product, ArrayList<ProductDeparmentComponent> pdcList) {
        ArrayList<ProductComponent> list = new ArrayList<ProductComponent>();
        for (ProductDeparmentComponent pdc : pdcList) {
            if (product.getProductID() != pdc.getArticleProduct().getProductID()) continue;
            ProductComponent pc = new ProductComponent();
            pc.setProduct(pdc.getIngredientProduct());
            pc.setNormative(pdc.getNormative());
            list.add(pc);
        }
        return list;
    }

    public boolean havePriceListDetailesID(Connection connection) {
        String query = "select * from pricelistdetails pld where pld.ProductID = ?";
        boolean postojiCena = false;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ProductID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                postojiCena = true;
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return postojiCena;
    }

    public static ArrayList<Product> getList(Connection connection) {
        ArrayList<Product> list = new ArrayList<Product>();
        String query = " select b.BarCode, p.* from product p left join barcode b on b.ProductID = p.ProductID\t\t\t\t\t\tand b.BarCodeID in (select max(bar.BarCodeID)\t\t\t\t\t\t\t\t\t\t\tfrom barcode bar\t\t\t\t\t\t\t\t\t\t\twhere bar.ProductID = p.ProductID\t\t\t\t\t\t\t\t\t\t\tgroup by bar.ProductID)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    product.setBarcodeLast(rs.getString("BarCode"));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                list.add(product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<Product> getList(String filter, String filterType, int limit, Connection connection) {
        ArrayList<Product> list = new ArrayList<Product>();
        String filterQuery = "";
        if (filterType == ScreensController.FILTER_ALL) {
            filterQuery = "(p.Name like ? or p.Code like ? or b.BarCode like ?)";
        }
        if (filterType == ScreensController.FILTER_CODE) {
            filterQuery = "(p.Code = ?)";
        }
        if (filterType == ScreensController.FILTER_BARCODE) {
            filterQuery = "b.BarCode = ?";
        }
        String query = " select b.*, p.* from product p left join barcode b on b.ProductID = p.ProductID where " + filterQuery + " limit " + limit;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (filterType == ScreensController.FILTER_ALL) {
                ps.setString(1, "%" + filter + "%");
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
            }
            if (filterType == ScreensController.FILTER_CODE || filterType == ScreensController.FILTER_BARCODE) {
                ps.setString(1, filter);
            }
            ResultSet rs = ps.executeQuery();
            System.out.println(ps);
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    product.setBarcodeLast(Barcode.getBarCode(product.ProductID, connection));
                    product.barcode = rs.getString("BarCode");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                int existProductIndex = -1;
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i).getProductID() != product.ProductID) continue;
                    existProductIndex = i;
                }
                if (existProductIndex > -1) {
                    list.get(existProductIndex).setBarcode(list.get(existProductIndex).getBarcode() + "-" + rs.getString("BarCode"));
                    continue;
                }
                list.add(product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<Product> getListByDepartment(int departmentId, Connection connection) {
        ArrayList<Product> list = new ArrayList<Product>();
        String query = "select *, v.Name as VatName, v.Value as VatValue from product p join vat v on v.VatID = p.VatID join productdepartment pd on pd.ProductID = p.ProductID where pd.DepartmentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, departmentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                try {
                    product.Code = rs.getString("Code");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    product.setBarcodeLast(Barcode.getBarCode(product.ProductID, connection));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.setVatName(rs.getString("VatName"));
                product.setVatValue(rs.getDouble("VatValue"));
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                list.add(product);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getListByDepartmentAndFilter(String filter, int departmentId, String filterType, ScreensController controller) {
        String query = "SELECT p.ProductID, p.sysDTCreated, p.Code, p.Name, b.BarCode FROM product p   JOIN productdepartment pd ON pd.ProductID = p.ProductID  LEFT JOIN barcode b ON b.ProductID = p.ProductID  WHERE pd.DepartmentID = ?";
        if (ScreensController.FILTER_ALL.equals(filterType)) {
            query = query + " AND  p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ? ORDER BY p.ProductID ";
        }
        if (ScreensController.FILTER_CODE.equals(filterType)) {
            query = query + " AND  p.Code LIKE ? ORDER BY p.ProductID ";
        }
        if (ScreensController.FILTER_BARCODE.equals(filterType)) {
            query = query + " AND b.BarCode LIKE ? ORDER BY p.ProductID ";
        }
        ObservableList list = FXCollections.observableArrayList();
        if (filter.trim().isEmpty()) {
            return list;
        }
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, departmentId);
            if (ScreensController.FILTER_ALL.equals(filterType)) {
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
                ps.setString(4, "%" + filter + "%");
            }
            if (ScreensController.FILTER_CODE.equals(filterType)) {
                ps.setString(2, filter + "%");
            }
            if (ScreensController.FILTER_BARCODE.equals(filterType)) {
                ps.setString(2, filter + "%");
            }
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.barcode = rs.getString("BarCode");
                try {
                    product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                list.add((java.lang.Object)product);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<Product> getListByDepartmentAndFilter(String filter, int departmentId, Connection connection, String filterType, int limit) {
        ArrayList<Product> list = new ArrayList<Product>();
        String filterQuery = "";
        if (filterType == ScreensController.FILTER_ALL) {
            filterQuery = "and (p.Name like ? or p.Code like ? or b.BarCode like ?) order by LENGTH(p.Code) ASC, p.Code, LENGTH(b.BarCode) ASC, b.BarCode, LENGTH(p.Name) ASC, p.Name limit ";
        }
        if (filterType == ScreensController.FILTER_NAZIV) {
            filterQuery = "and (p.Name like ?) limit ";
        }
        if (filterType == ScreensController.FILTER_CODE) {
            filterQuery = "and (p.Code like ?) order by LENGTH(p.Code) ASC, p.Code limit ";
        }
        if (filterType == ScreensController.FILTER_BARCODE) {
            filterQuery = "and (b.BarCode like ?) order by LENGTH(b.BarCode) ASC, b.BarCode limit ";
        }
        String query = "select *, v.Name as VatName, v.Value as VatValue, v.Value2 as VatValue2, v.Value3 as VatValue3, (SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = p.ProductID ORDER BY pld.ProductID DESC LIMIT 1) AS Cena  from product p  left join barcode b on b.ProductID = p.ProductID left join vat v on v.VatID = p.VatID where p.ProductTypeID = 1 and p.Active = 1 " + filterQuery + limit;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (filterType == ScreensController.FILTER_ALL) {
                ps.setString(1, "%" + filter + "%");
                ps.setString(2, filter + "%");
                ps.setString(3, filter + "%");
            }
            if (filterType == ScreensController.FILTER_CODE || filterType == ScreensController.FILTER_BARCODE || filterType == ScreensController.FILTER_NAZIV) {
                ps.setString(1, filter + "%");
            }
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                product.price = rs.getDouble("Cena");
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    product.setBarcodeLast(Barcode.getBarCode(product.ProductID, connection));
                    product.barcode = rs.getString("BarCode");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.setVatName(rs.getString("VatName"));
                product.setVatValue(rs.getDouble("VatValue"));
                product.setVatValue3(rs.getDouble("VatValue3"));
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.setNetAmount(rs.getDouble("NetAmount"));
                product.setNetAmountTypeID(rs.getInt("NetAmountTypeID"));
                int existProductIndex = -1;
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i).getProductID() != product.ProductID) continue;
                    existProductIndex = i;
                }
                if (existProductIndex > -1) {
                    list.get(existProductIndex).setBarcode(list.get(existProductIndex).getBarcode() + "-" + rs.getString("BarCode"));
                    continue;
                }
                list.add(product);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getListByChangedPrice(LocalDate dateFrom, LocalDate dateTo, String filter, int departmentID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *, v.Name as VatName, v.Value as VatValue from pricelistdetails pld2 join product p on p.ProductID = pld2.ProductID join vat v on v.VatID = p.VatID left join barcode b on b.ProductID = p.ProductID where pld2.PriceListDetailsID in (select \t\t\t\t\t\t\t\t\t((select max(pld1.PriceListDetailsID)\t\t\t\t\t\t\t\t\tfrom pricelistdetails pld1\t\t\t\t\t\t\t\t\twhere pld1.ProductID = pld.ProductID\t\t\t\t\t\t\t\t\t\t\tand pld1.PriceListID = pl.PriceListID\t\t\t\t\t\t\t\t\t\t\tand DATE(pld1.Date) >= ?\t\t\t\t\t\t\t\t\t\t\tand DATE(pld1.Date) <= ?))\t\t\t\t\t\t\t\t\tfrom pricelistdetails pld\t\t\t\t\t\t\t\t\t\t\t\t\tjoin pricelist pl on pl.PriceListID = pld.PriceListID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tand pl.PriceListTypeID = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tand pl.Active = true\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tand pl.DateFrom <= now()\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tand (pl.DateTo is null) or (pl.DateTo >= now())\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tand (pl.ObjectID in (select d.ObjectID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tfrom department d\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twhere d.DepartmentID = ?)  or pl.ObjectID is null) \t\t\t\t\t\t\t\t\twhere DATE(pld.Date) >= ?\t\t\t\t\t\t\t\t\t\tand DATE(pld.Date) <= ?)\t\tand (p.Name like ? or p.ShortName like ? or p.Code like ? or p.PLUcode like ? or b.BarCode like ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new Date(Settings.fromLocalDate(dateFrom).getTime()));
            ps.setDate(2, new Date(Settings.fromLocalDate(dateTo).getTime()));
            ps.setInt(3, departmentID);
            ps.setDate(4, new Date(Settings.fromLocalDate(dateFrom).getTime()));
            ps.setDate(5, new Date(Settings.fromLocalDate(dateTo).getTime()));
            ps.setString(6, "%" + filter + "%");
            ps.setString(7, "%" + filter + "%");
            ps.setString(8, "%" + filter + "%");
            ps.setString(9, "%" + filter + "%");
            ps.setString(10, "%" + filter + "%");
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.price = rs.getDouble("Price");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    product.setBarcodeLast(Barcode.getBarCode(product.ProductID, connection));
                    product.barcode = rs.getString("BarCode");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.setVatName(rs.getString("VatName"));
                product.setVatValue(rs.getDouble("VatValue"));
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.setNetAmount(rs.getDouble("NetAmount"));
                product.setNetAmountTypeID(rs.getInt("NetAmountTypeID"));
                int existProductIndex = -1;
                for (int i = 0; i < list.size(); ++i) {
                    if (((Product)list.get(i)).getProductID() != product.ProductID) continue;
                    existProductIndex = i;
                }
                if (existProductIndex > -1) {
                    ((Product)list.get(existProductIndex)).setBarcode(((Product)list.get(existProductIndex)).getBarcode() + "-" + rs.getString("BarCode"));
                    continue;
                }
                list.add((java.lang.Object)product);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getPocetnoStanjeList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM product p WHERE p.Active IS TRUE";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public ArrayList<ProductComponent> getComponents(WorkDay wd, Connection connection) {
        ArrayList<ProductComponent> list = new ArrayList<ProductComponent>();
        if (this.ProductTypeID == 1 || this.ProductTypeID == 2) {
            return list;
        }
        String query = "select p2.*, pc.Normative   from productcomponent pc  inner join productdepartment pd1 on pc.ArticleProductDepartmenID = pd1.ProductDepartmentID \t\t\t\t\t\t\t\t   and pd1.DepartmentID in (select DepartmentID  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  from pointofsaledepartment \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t where PointOfSaleID = ?)  inner join product p1 on pd1.ProductID  = p1.ProductID and pd1.ProductID = ?  left join productdepartment pd2 on pc.IngredientProductDepartmentID = pd2.ProductDepartmentID  left join product p2 on p2.ProductID = pd2.ProductID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, wd.getPointOfSaleID());
            ps.setLong(2, this.ProductID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                if (product.getProductTypeID() == 1 || product.getProductTypeID() == 2) {
                    ProductComponent pc = new ProductComponent();
                    pc.setProduct(product);
                    pc.setNormative(rs.getDouble("Normative"));
                    list.add(pc);
                }
                if (product.getProductTypeID() != 3) continue;
                ArrayList<ProductComponent> cl = product.getComponents(wd, connection);
                for (ProductComponent pcr : cl) {
                    pcr.setNormative(pcr.getNormative() * rs.getDouble("Normative"));
                    list.add(pcr);
                }
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getObeservableListActive(Object object, PointOfSale pos, Department department, String filter, boolean active, int groupID, int productTypeID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String filterPlus = "";
        String query = "";
        if (department == null || department.getDepartmentID() == -1) {
            filterPlus = groupID == -1 && productTypeID == -1 ? "" : (groupID != -1 && productTypeID == -1 ? " and gposp.GroupID = ?" : (groupID == -1 && productTypeID != -1 ? " and p.ProductTypeID = ?" : " and gposp.GroupID = ? and p.ProductTypeID = ?"));
        }
        query = "select DISTINCT p.*, \t\t-1 as ProductDepartmentID, \t\t-1 as KitchenDisplayID,     null as PreparationTime,  gposp.GroupID,  u.Name as UnitName, g.Name as GroupName,  pld.Price  from product p left join grouppointofsaleproduct gposp on gposp.ProductID = p.ProductID left join `group` g on g.GroupID = gposp.GroupID left join unit u on u.UnitID = p.UnitID left join pricelistdetails pld on pld.ProductID = gposp.ProductID left join pricelist pl on pl.PriceListID = pld.PriceListID left join pricelisttype plt on plt.TypeID = pl.PriceListTypeID where ((p.Name like ?) or (p.ShortName like ?) or (p.Code like ?))and p.Active = ?" + filterPlus;
        if (department != null && department.getDepartmentID() != -1) {
            filterPlus = groupID == -1 && productTypeID == -1 ? "" : (groupID != -1 && productTypeID == -1 ? " and gposp.GroupID = ?" : (groupID == -1 && productTypeID != -1 ? " and p.ProductTypeID = ?" : " and gposp.GroupID = ? and p.ProductTypeID = ?"));
            query = "select DISTINCT p.*, \t(select ProductDepartmentID \t   from productdepartment pd\t  where pd.ProductID = p.ProductID       and pd.DepartmentID = ? group by pd.ProductID) as ProductDepartmentID,\t(select KitchenDisplayID \t   from productdepartment pd\t  where pd.ProductID = p.ProductID       and pd.DepartmentID = ? group by pd.ProductID) as KitchenDisplayID,\t(select PreparationTime \t   from productdepartment pd\t  where pd.ProductID = p.ProductID       and pd.DepartmentID = ? group by pd.ProductID) as PreparationTime, gposp.GroupID,  u.Name as UnitName,  g.Name as GroupName,  pld.Price from product p  left join grouppointofsaleproduct gposp on gposp.ProductID = p.ProductID left join `group` g on g.GroupID = gposp.GroupID left join unit u on u.UnitID = p.UnitID left join pricelistdetails pld on pld.ProductID = gposp.ProductID  left join pricelist pl on pl.PriceListID = pld.PriceListID left join pricelisttype plt on plt.TypeID = pl.PriceListTypeID where ((p.Name like ?) or (p.ShortName like ?) or (p.Code like ?))  and p.Active = ?" + filterPlus + "   and (select ProductDepartmentID \t   \t   from productdepartment pd\t  \t  where pd.ProductID = p.ProductID       \tand pd.DepartmentID = ? group by pd.ProductID) is not null";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (department == null || department.getDepartmentID() == -1) {
                if (groupID == -1 && productTypeID == -1) {
                    ps.setString(1, "%" + filter + "%");
                    ps.setString(2, "%" + filter + "%");
                    ps.setString(3, "%" + filter + "%");
                    ps.setBoolean(4, active);
                } else if (groupID != -1 && productTypeID == -1) {
                    ps.setString(1, "%" + filter + "%");
                    ps.setString(2, "%" + filter + "%");
                    ps.setString(3, "%" + filter + "%");
                    ps.setBoolean(4, active);
                    ps.setInt(5, groupID);
                } else if (groupID == -1 && productTypeID != -1) {
                    ps.setString(1, "%" + filter + "%");
                    ps.setString(2, "%" + filter + "%");
                    ps.setString(3, "%" + filter + "%");
                    ps.setBoolean(4, active);
                    ps.setInt(5, productTypeID);
                } else {
                    ps.setString(1, "%" + filter + "%");
                    ps.setString(2, "%" + filter + "%");
                    ps.setString(3, "%" + filter + "%");
                    ps.setBoolean(4, active);
                    ps.setInt(5, groupID);
                    ps.setInt(6, productTypeID);
                }
            }
            if (department != null && department.getDepartmentID() != -1) {
                ps.setInt(1, department.getDepartmentID());
                ps.setInt(2, department.getDepartmentID());
                ps.setInt(3, department.getDepartmentID());
                ps.setString(4, "%" + filter + "%");
                ps.setString(5, "%" + filter + "%");
                ps.setString(6, "%" + filter + "%");
                ps.setBoolean(7, active);
                if (groupID == -1 && productTypeID == -1) {
                    ps.setInt(8, department.getDepartmentID());
                } else if (groupID != -1 && productTypeID == -1) {
                    ps.setInt(8, groupID);
                    ps.setInt(9, department.getDepartmentID());
                } else if (groupID == -1 && productTypeID != -1) {
                    ps.setInt(8, productTypeID);
                    ps.setInt(9, department.getDepartmentID());
                } else {
                    ps.setInt(8, groupID);
                    ps.setInt(9, productTypeID);
                    ps.setInt(10, department.getDepartmentID());
                }
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.price = rs.getDouble("Price");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NutritionalValue = rs.getDouble("NutritionalValue");
                product.EnergyValue = rs.getDouble("EnergyValue");
                product.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                product.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                product.PreparationTime = rs.getTime("PreparationTime");
                product.GroupID = rs.getInt("GroupID");
                product.UnitName = rs.getString("UnitName");
                product.GroupName = rs.getString("GroupName");
                product.Measurable = rs.getBoolean("Measurable");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getObeservableListActiveTrgovina(Object object, Department department, String filter, boolean active, String filterType, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "CALL filter(?, ?, ?, ?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (filterType.equals("Naziv")) {
                ps.setString(1, "%" + filter + "%");
            } else {
                ps.setString(1, filter + "%");
            }
            ps.setBoolean(2, active);
            if (department == null || department.getDepartmentID() == -1) {
                ps.setInt(3, 0);
            } else {
                ps.setInt(3, department.getDepartmentID());
            }
            ps.setInt(4, 0);
            ps.setString(5, filterType);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.plucode = rs.getString("PLUcode");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                product.UnitName = rs.getString("UnitName");
                product.NetAmount = rs.getDouble("NetAmount");
                product.NetAmountTypeID = rs.getInt("NetAmountTypeID");
                product.Measurable = rs.getBoolean("Measurable");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.barcode = Barcode.getBarCode(product.getProductID(), connection);
                list.add((java.lang.Object)product);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static double getCurrentStockOld(LocalDate date, LocalDateTime dateFrom, LocalDateTime dateTo, long productId, int departmentId, Connection connection) {
        double result = 0.0;
        String query = "select product_initial_stock(?,?,?) +  \t   product_input_current(?,?,?,?) - \t   product_output_current(?,?,?,?) as stock";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            ps.setDate(2, new Date(Settings.fromLocalDate(date).getTime()));
            ps.setInt(3, departmentId);
            ps.setLong(4, productId);
            ps.setTimestamp(5, Timestamp.valueOf(dateFrom));
            ps.setTimestamp(6, Timestamp.valueOf(dateTo));
            ps.setInt(7, departmentId);
            ps.setLong(8, productId);
            ps.setTimestamp(9, Timestamp.valueOf(dateFrom));
            ps.setTimestamp(10, Timestamp.valueOf(dateTo));
            ps.setInt(11, departmentId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            result = rs.getDouble("stock");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static double getCurrentStock(long productId, int departmentId, Connection connection) {
        double result = 0.0;
        String query = "SELECT `product_initial_stock`(" + productId + ", now(), " + departmentId + ") AS Stock";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            rs.next();
            result = rs.getDouble("stock");
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static long getLastIdByCode(Connection connection) {
        long code = 0L;
        String query = "SELECT p.ProductID  FROM product p ORDER BY p.ProductID DESC LIMIT 1";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            rs.next();
            code = rs.getLong(1);
            rs.close();
            ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return code;
    }

    public static double getCurrentStockX(java.util.Date wdDate, LocalDateTime from, java.util.Date to, long productId, int departmentId, Connection connection) {
        double result = 0.0;
        String query = "select product_stock_current(?,?,?,?,?) as stock";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            ps.setDate(2, new Date(wdDate.getTime()));
            ps.setTimestamp(3, Timestamp.valueOf(from));
            ps.setTimestamp(4, new Timestamp(to.getTime() + 5000L));
            ps.setInt(5, departmentId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            result = rs.getDouble("stock");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static double getInitialStock(LocalDateTime wdDate, long productId, int departmentId, Connection connection) {
        double result = 0.0;
        String query = "select product_initial_stock(?,?,?) as stock";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            ps.setDate(2, new Date(Settings.DatefromLocalDateTime(wdDate).getTime()));
            ps.setInt(3, departmentId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            result = rs.getDouble("stock");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static double getUlaz(LocalDateTime wdDate, long productId, int departmentId, Connection connection) {
        double result = 0.0;
        String query = "SELECT `product_input_current`(?, ?, ?, ?) as Ulaz";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            try {
                ps.setTimestamp(2, Timestamp.valueOf(WorkDay.getDateFromForDep(wdDate, departmentId, connection)));
            }
            catch (NullPointerException e) {
                ps.setNull(2, 93);
            }
            ps.setTimestamp(3, Timestamp.valueOf(wdDate));
            ps.setInt(4, departmentId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            result = rs.getDouble("Ulaz");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static double getIzlaz(LocalDateTime wdDate, long productId, int departmentId, Connection connection) {
        double result = 0.0;
        String query = "SELECT `product_output_current_bezUtrosaka`(?, ?, ?, ?) as Izlaz";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            try {
                ps.setTimestamp(2, Timestamp.valueOf(WorkDay.getDateFromForDep(wdDate, departmentId, connection)));
            }
            catch (NullPointerException e) {
                ps.setNull(2, 93);
            }
            ps.setTimestamp(3, Timestamp.valueOf(wdDate));
            ps.setInt(4, departmentId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            result = rs.getDouble("Izlaz");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static double getSoldItemsCurrent(LocalDateTime wdDate, long productId, int departmentId, Connection connection) throws SQLException {
        double soldItems = 0.0;
        String querySoldItems = "SELECT `sold_items_current_department`(?, ?, ?, ?) as SoldItem";
        PreparedStatement ps = connection.prepareStatement(querySoldItems);
        try {
            ps.setTimestamp(1, Timestamp.valueOf(WorkDay.getDateFromForDep(wdDate, departmentId, connection)));
        }
        catch (NullPointerException e) {
            ps.setNull(1, 93);
        }
        ps.setTimestamp(2, Timestamp.valueOf(wdDate));
        ps.setLong(3, productId);
        ps.setInt(4, departmentId);
        ResultSet rs1 = ps.executeQuery();
        rs1.next();
        soldItems = rs1.getDouble("SoldItem");
        ps.close();
        rs1.close();
        return soldItems;
    }

    public static ArrayList<DocumentDetails> getNegativeSctockList(PointOfSale pos, Connection connection) throws SQLException {
        ArrayList<DocumentDetails> list = new ArrayList<DocumentDetails>();
        ArrayList<Department> odeljena = pos.getDepartmentList(connection);
        String query = "select \tp.Code,p.Name,product_stock(p.ProductID, now(), ?) as stanje  from product p where p.ProductTypeID in (1,2,4)   and product_stock(p.ProductID, now(), ?) < 0";
        PreparedStatement ps = connection.prepareStatement(query);
        for (Department d : odeljena) {
            ps.setInt(1, d.getDepartmentID());
            ps.setInt(2, d.getDepartmentID());
            ps.executeQuery();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocumentDetails dd = new DocumentDetails();
                dd.setProductCode(rs.getString("Code"));
                dd.setProductName(rs.getString("Name"));
                dd.setQuantity(rs.getDouble("stanje"));
                list.add(dd);
            }
            ps.close();
            rs.close();
        }
        return list;
    }

    public double getNabavnaCena(Connection connection) {
        String query = "SELECT dd.PurchacePrice, dd.Discount FROM document d JOIN documentdetails dd on dd.DocumentID = d.DocumentID  WHERE dd.ProductID = ? and d.DocumentTypeID = 1 ORDER BY d.Date desc LIMIT 1";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ProductID);
            ResultSet rs = ps.executeQuery();
            System.out.println(ps);
            while (rs.next()) {
                this.nabavnaCena = rs.getDouble("PurchacePrice");
                this.nabavnaCenaBezPopusta = this.nabavnaCena * 100.0 / (100.0 - rs.getDouble("Discount"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.nabavnaCena = 0.0;
            this.nabavnaCenaBezPopusta = 0.0;
            e.printStackTrace();
        }
        return this.nabavnaCena;
    }

    public double getNabavnaCenaPDV(Connection connection) {
        String query = "SELECT dd.PriceWithDiscount FROM document d JOIN documentdetails dd on dd.DocumentID = d.DocumentID  WHERE dd.ProductID = ? and d.DocumentTypeID = 1 ORDER BY d.Date desc LIMIT 1";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ProductID);
            ResultSet rs = ps.executeQuery();
            System.out.println(ps);
            while (rs.next()) {
                this.nabavnaCena = rs.getDouble("PriceWithDiscount");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.nabavnaCena = 0.0;
            this.nabavnaCenaBezPopusta = 0.0;
            e.printStackTrace();
        }
        return this.nabavnaCena;
    }

    public void getPurchacePricePrijemnica(Connection connection) {
        String query = "SELECT dd.PurchacePrice, ROUND((dd.PurchacePrice * 100 / (100 - dd.Discount)), 4) AS PurchacePriceWithoutRabat, dd.Discount FROM document d JOIN documentdetails dd on dd.DocumentID = d.DocumentID  WHERE dd.ProductID = ? and d.DocumentTypeID = 1 ORDER BY d.Date DESC LIMIT 1";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ProductID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.purchacePrice = rs.getDouble("PurchacePrice");
                this.purchacePriceWithoutRabat = rs.getDouble("PurchacePriceWithoutRabat");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static double getPurchacePriceByProductID(long productId, ScreensController controller) {
        String query = "SELECT dd.PurchacePrice FROM document d JOIN documentdetails dd on dd.DocumentID = d.DocumentID  WHERE dd.ProductID = ? and d.DocumentTypeID = 1 ORDER BY d.Date DESC LIMIT 1";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, productId);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getDouble("PurchacePrice");
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    public double getNabavnaCenaOtpis(Connection connection) {
        String query = "SELECT dd.PurchacePrice, dd.Price FROM documentdetails dd WHERE dd.ProductID = ? AND dd.DocumentID IN (SELECT d.DocumentID FROM document d WHERE d.DocumentTypeID = 1)  ORDER BY dd.DocumentDetailsID DESC LIMIT 1";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ProductID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.nabavnaCena = rs.getDouble("Price");
                this.nabavnaCenaBezPopusta = rs.getDouble("PurchacePrice");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.nabavnaCena = 0.0;
            this.nabavnaCenaBezPopusta = 0.0;
            e.printStackTrace();
        }
        return this.nabavnaCena;
    }

    public Barcode getBarcodeByProductID(Connection connection) {
        String query = "select * from barcode bc where bc.ProductID = ? order by bc.BarCodeID desc limit 1";
        Barcode b = null;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ProductID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                b = new Barcode();
                b.setBarCodeID(rs.getLong("BarCodeID"));
                b.setBarCode(rs.getString("BarCode"));
                b.setIsWeight(rs.getBoolean("IsWeight"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return b != null ? b : new Barcode(-1L, "", this.ProductID);
    }

    public static double getStockByProduct(Product product, LocalDateTime datumPocetnogStanja, ScreensController controller) {
        double stock = 0.0;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT `stock_by_product`(?, ?, ?, now()) AS Stock");
            pStatement.setLong(1, product.getProductID());
            pStatement.setInt(2, Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID());
            pStatement.setTimestamp(3, Timestamp.valueOf(datumPocetnogStanja));
            System.out.println(pStatement);
            ResultSet rs = pStatement.executeQuery();
            rs.next();
            stock = rs.getDouble("Stock");
            return stock;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double getStockByProductByDate(Product product, LocalDateTime datumPocetnogStanja, LocalDateTime datumTrazenogStanja, ScreensController controller) {
        double stock = 0.0;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT `stock_by_product`(?, ?, ?, ?) AS Stock");
            pStatement.setLong(1, product.getProductID());
            pStatement.setInt(2, Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID());
            pStatement.setTimestamp(3, Timestamp.valueOf(datumPocetnogStanja));
            pStatement.setTimestamp(4, Timestamp.valueOf(datumTrazenogStanja));
            ResultSet rs = pStatement.executeQuery();
            rs.next();
            stock = rs.getDouble("Stock");
            return stock;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double getStockByProductByDate(Product product, LocalDateTime datumPocetnogStanja, java.util.Date datumTrazenogStanja, ScreensController controller) {
        double stock = 0.0;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT `stock_by_product`(?, ?, ?, ?) AS Stock");
            pStatement.setLong(1, product.getProductID());
            pStatement.setInt(2, Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID());
            pStatement.setTimestamp(3, Timestamp.valueOf(datumPocetnogStanja));
            pStatement.setTimestamp(4, new Timestamp(datumTrazenogStanja.getTime()));
            System.out.println(pStatement);
            ResultSet rs = pStatement.executeQuery();
            rs.next();
            stock = rs.getDouble("Stock");
            return stock;
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    public void getCurrentPriceAndDiscount(PointOfSale pos, Connection connection) {
        this.price = 0.0;
        this.discount = 0.0;
        try {
            PreparedStatement pStatement = connection.prepareStatement("{ CALL current_price_and_discount(?, ?) }");
            pStatement.setLong(1, this.ProductID);
            pStatement.setInt(2, pos.getPointOfSaleID());
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                this.price = rs.getDouble(1);
                this.discount = rs.getDouble(2);
            }
            rs.close();
            pStatement.close();
        }
        catch (SQLException e) {
            this.price = 0.0;
            this.discount = 0.0;
        }
    }

    public void getCurrentPriceAndDiscountOfferPrice(PointOfSale pos, Connection connection) {
        this.price = 0.0;
        try {
            PreparedStatement cs = connection.prepareStatement("{ CALL current_price_and_discount(?, ?) }");
            cs.setLong(1, this.ProductID);
            cs.setInt(2, pos.getPointOfSaleID());
            ResultSet rs = cs.executeQuery();
            while (rs.next()) {
                this.price = rs.getDouble(1);
            }
            rs.close();
            cs.close();
        }
        catch (SQLException e) {
            this.price = 0.0;
        }
    }

    public double getCurrentPrice(long departmentID, Connection connection) {
        this.price = 0.0;
        this.discount = 0.0;
        try {
            PreparedStatement cs = connection.prepareStatement(" SELECT current_price_before_date(?, now(), ?) AS Price");
            cs.setLong(1, this.ProductID);
            cs.setLong(2, departmentID);
            ResultSet rs = cs.executeQuery();
            while (rs.next()) {
                this.price = rs.getDouble("Price");
            }
            rs.close();
            cs.close();
        }
        catch (SQLException e) {
            this.price = 0.0;
        }
        return this.price;
    }

    public double getCurrentPriceBeforeDate(LocalDateTime date, long departmentID, Connection connection) {
        this.price = 0.0;
        this.discount = 0.0;
        try {
            PreparedStatement cs = connection.prepareStatement(" SELECT current_price_before_date(?, ?, ?) ");
            cs.setLong(1, this.ProductID);
            cs.setTimestamp(2, Timestamp.valueOf(date));
            cs.setLong(3, departmentID);
            ResultSet rs = cs.executeQuery();
            while (rs.next()) {
                this.price = rs.getDouble(1);
            }
            rs.close();
            cs.close();
        }
        catch (SQLException e) {
            this.price = 0.0;
        }
        return this.price;
    }

    public double getCurrentPriceBeforeDatePrijemnica(java.util.Date date, long departmentID, Connection connection) {
        this.price = 0.0;
        this.discount = 0.0;
        try {
            PreparedStatement cs = connection.prepareStatement(" SELECT current_price_before_date_prijemnica(?, ?, ?) ");
            cs.setLong(1, this.ProductID);
            cs.setTimestamp(2, new Timestamp(date.getTime()));
            cs.setLong(3, departmentID);
            System.out.println(cs);
            ResultSet rs = cs.executeQuery();
            while (rs.next()) {
                this.price = rs.getDouble(1);
            }
            rs.close();
            cs.close();
        }
        catch (SQLException e) {
            this.price = 0.0;
        }
        return this.price;
    }

    public double getCurrentPriceBeforeDatePrijemnicaCentralniMagacin(java.util.Date date, int objectID, Connection connection) {
        this.price = 0.0;
        this.discount = 0.0;
        try {
            PreparedStatement cs = connection.prepareStatement(" SELECT current_price_before_date_prijemnica_centralni_magacin(?, ?, ?) ");
            cs.setLong(1, this.ProductID);
            cs.setTimestamp(2, new Timestamp(date.getTime()));
            cs.setLong(3, objectID);
            ResultSet rs = cs.executeQuery();
            while (rs.next()) {
                this.price = rs.getDouble(1);
            }
            rs.close();
            cs.close();
        }
        catch (SQLException e) {
            this.price = 0.0;
        }
        return this.price;
    }

    public static double getCurrentPrice(long productiID, long departmentID, boolean priceLoyalty, Connection connection) {
        try {
            PreparedStatement cs = priceLoyalty ? connection.prepareStatement(" SELECT current_price_before_date_first_ever_price(?, now(), ?) ") : connection.prepareStatement(" SELECT current_price_before_date(?, now(), ?) ");
            cs.setLong(1, productiID);
            cs.setLong(2, departmentID);
            ResultSet rs = cs.executeQuery();
            if (rs.next()) {
                return rs.getDouble(1);
            }
            cs.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public boolean equals(java.lang.Object p) {
        return p instanceof Product ? ((Product)p).getProductID() == this.ProductID : false;
    }

    public static LocalDateTime getDateFromWarehouse(int warehouseId, Connection connection) throws SQLException {
        LocalDateTime dateFrom = null;
        String query = "SELECT MIN(d.Date) AS Datum FROM document d WHERE d.WarehouseID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setInt(1, warehouseId);
        ResultSet rs = ps.executeQuery();
        rs.next();
        dateFrom = rs.getTimestamp("Datum").toLocalDateTime();
        rs.close();
        ps.close();
        return dateFrom;
    }

    public static ObservableList<Product> getNewReceivingReportCentralniMagacin(String filter, ObservableList<AditionalField> aditionlFieldFilter, String aditFieldDetails, ScreensController controller, int warehouseId) {
        String fields = "";
        ObservableList list = FXCollections.observableArrayList();
        if (!aditionlFieldFilter.isEmpty()) {
            for (int i = 0; i < aditionlFieldFilter.size(); ++i) {
                fields = fields + ", (SELECT afd.Name FROM aditionalfielddetailsproduct afdp JOIN aditionalfielddetails afd ON afd.AditionalFieldDetailsID = afdp.AditionalFieldDetailsID AND afdp.AditionalFieldDetailsID WHERE afdp.ProductID = p.ProductID AND afdp.AditionalFieldID IN (SELECT af.AditionalFieldID FROM aditionalfield af WHERE af.Name = '" + ((AditionalField)aditionlFieldFilter.get(i)).getName() + "')) AS '" + ((AditionalField)aditionlFieldFilter.get(i)).getName() + "'";
            }
        }
        String query = null;
        query = "SELECT  p.ProductID, p.Code as Kod, bc.BarCode as BarKod, p.Name, u.Code as JM, COALESCE((SELECT SUM(dt.Stock * dd.Quantity)  FROM documentdetails dd LEFT JOIN document d ON d.DocumentID = dd.DocumentID LEFT JOIN documenttype dt ON dt.DocumentTypeID = d.DocumentTypeID WHERE d.WarehouseID = 1 AND dd.ProductID = p.ProductID GROUP BY dd.ProductID),0) AS Stanje, COALESCE((SELECT dd.PriceWithDiscount FROM documentdetails dd LEFT JOIN document d ON d.DocumentID = dd.DocumentID LEFT JOIN documenttype dt ON dt.DocumentTypeID = d.DocumentTypeID WHERE d.WarehouseID = 1 AND dd.ProductID = p.ProductID GROUP BY dd.ProductID),0) AS Cena " + fields + " FROM product p LEFT JOIN unit u on u.UnitID = p.UnitID LEFT JOIN barcode bc ON bc.ProductID = p.ProductID WHERE p.Active IS TRUE AND p.ProductTypeID = 1  AND (p.Code LIKE '%%' OR p.Name LIKE '%%' OR bc.BarCode LIKE '%%')  " + (aditFieldDetails.equals("") ? " " : "AND p.ProductID IN (select afdp.ProductID from aditionalfielddetailsproduct afdp where afdp.AditionalFieldDetailsID IN ('" + aditFieldDetails + "'))") + " ORDER BY p.ProductID;";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.setProductID(rs.getLong("ProductID"));
                product.setCode(rs.getString("Kod"));
                product.setBarcode(rs.getString("BarKod"));
                product.setName(rs.getString("Name"));
                product.setUnitName(rs.getString("JM"));
                product.setNabavnaCenaBezPopusta(rs.getDouble("Cena"));
                product.setStock(rs.getDouble("Stanje"));
                product.setPrice(product.getNabavnaCenaBezPopusta() * product.getStock());
                product.setListAditionalFieldDetails((ObservableList<AditionalFieldDetails>)FXCollections.observableArrayList());
                if (!aditionlFieldFilter.isEmpty()) {
                    product.setListAditionalField(aditionlFieldFilter);
                    for (AditionalField aField : aditionlFieldFilter) {
                        AditionalFieldDetails aditionalFieldDetails = new AditionalFieldDetails();
                        aditionalFieldDetails.setName(rs.getString(aField.getName()));
                        aField.setAditionalFieldDetails(aditionalFieldDetails);
                        product.getListAditionalFieldDetails().add((java.lang.Object)aditionalFieldDetails);
                        product.setAditionalField(aField);
                    }
                }
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getNewReceivingReport(String filter, ObservableList<AditionalField> aditionlFieldFilter, String aditFieldDetails, ScreensController controller, int departmentID, LocalDate to, boolean kod, boolean barkod, boolean artikal, boolean srednjaNcena, boolean srednjaNvrednost, boolean poslednjaNcena, boolean poslednjaNvrednost, boolean prodajnaCena, boolean prodajnaVrednost) {
        ChangeConnection.getConnectionAdmin(controller);
        String fields = "";
        ObservableList list = FXCollections.observableArrayList();
        if (!aditionlFieldFilter.isEmpty()) {
            for (int i = 0; i < aditionlFieldFilter.size(); ++i) {
                fields = fields + ", (SELECT afd.Name FROM aditionalfielddetailsproduct afdp JOIN aditionalfielddetails afd ON afd.AditionalFieldDetailsID = afdp.AditionalFieldDetailsID AND afdp.AditionalFieldDetailsID WHERE afdp.ProductID = p.ProductID AND afdp.AditionalFieldID IN (SELECT af.AditionalFieldID FROM aditionalfield af WHERE af.Name = '" + ((AditionalField)aditionlFieldFilter.get(i)).getName() + "')) AS '" + ((AditionalField)aditionlFieldFilter.get(i)).getName() + "'";
            }
        }
        String query = null;
        LocalDateTime dateFrom = null;
        LocalDateTime dateTo = null;
        LocalTime endLocalTime = LocalTime.of(23, 59, 59);
        try {
            dateFrom = WorkDay.datumPocetnogStanja(departmentID, Settings.fromLocalDate(to), controller.getSettings().getConnection());
            try {
                dateTo = WorkDay.getDateToForDep1(to, departmentID, controller.getSettings().getConnection());
            }
            catch (NullPointerException e) {
                dateTo = LocalDateTime.of(to, endLocalTime);
            }
            query = "SELECT\r\np.ProductID,\r\np.Code as Kod, \r\np.Name,\r\nu.Code as JM,\r\nbc.BarCode as BarKod,\r\nCASE \r\n \tWHEN " + srednjaNcena + " THEN\r\n\t\t(SELECT ROUND(AVG(dd.PurchacePrice), 4) AS PurchacePrice FROM documentdetails dd LEFT JOIN document d ON d.DocumentID = dd.DocumentID \r\n\t\t\tWHERE d.DocumentTypeID = 1 AND d.Date >= (SELECT `poslednji_popis_department_pre_datuma_v5`('1', now())) AND dd.ProductID = p.ProductID)\r\nELSE\r\n\t\t0\r\nEND AS SrednjaNabavna,\r\n(SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = p.ProductID AND pld.Date <= ? ORDER BY pld.ProductID DESC LIMIT 1) AS Cena,\r\nCOALESCE( SUM(IF(d.DocumentTypeID=29 AND d.Realized IS FALSE AND NOW() < d.DeliveryDate, IF(dd.Closed IS FALSE, dd.Quantity, 0), 0)), 0) AS Rezervisano,\r\nCOALESCE( SUM(IF(d.DocumentTypeID=11, dd.Quantity, IF(d.DocumentTypeID = 29, 0, dd.Quantity * dt.Stock))), 0) AS Stanje " + fields + "FROM documentdetails dd \r\nLEFT JOIN product p ON p.ProductID = dd.ProductID AND p.ProductTypeID = 1\r\nLEFT JOIN unit u ON u.UnitID = dd.UnitID\r\nLEFT JOIN barcode bc ON bc.ProductID = dd.ProductID\r\nLEFT JOIN document d ON d.DocumentID = dd.DocumentID\r\nLEFT JOIN documenttype dt ON dt.DocumentTypeID = d.DocumentTypeID\r\nWHERE d.DocumentStatusID IN (1)\r\nAND d.DocumentTypeID NOT IN (4) and d.DocumentTypeID <>2  \r\nAND IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) BETWEEN ? AND ?\r\nAND (d.DepartmentID = ? OR d.PointOfSaleID IN (SELECT posd.PointOfSaleID FROM pointofsaledepartment posd WHERE posd.DepartmentID = ?))\r\nAND (p.Code LIKE '%" + filter + "%' OR p.Name LIKE '%" + filter + "%' OR bc.BarCode LIKE '%" + filter + "%')AND p.Active=1 AND p.productCategoryID !=2 AND bc.BarCode = (SELECT bc1.BarCode FROM barcode bc1 WHERE bc1.ProductID = p.ProductID GROUP BY p.ProductID) " + (aditFieldDetails.equals("") ? " " : "AND p.ProductID IN (select afdp.ProductID from  aditionalfielddetailsproduct afdp where afdp.AditionalFieldDetailsID IN ('" + aditFieldDetails + "'))") + " GROUP BY dd.ProductID ";
            if (kod) {
                query = query + " ORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC";
            }
            if (barkod) {
                query = query + " ORDER BY CAST(TRIM(LEADING '0' FROM bc.BarCode) AS DECIMAL(15,0)) ASC";
            }
            if (artikal) {
                query = query + " ORDER BY p.Name ASC";
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, Timestamp.valueOf(dateTo));
            ps.setTimestamp(2, Timestamp.valueOf(dateFrom));
            ps.setTimestamp(3, Timestamp.valueOf(dateTo));
            ps.setInt(4, departmentID);
            ps.setInt(5, departmentID);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.setProductID(rs.getLong("ProductID"));
                product.setCode(rs.getString("Kod"));
                product.setBarcode(rs.getString("BarKod"));
                product.setName(rs.getString("Name"));
                product.setUnitName(rs.getString("JM"));
                product.setNabavnaCenaBezPopusta(ProductDepartment.getByProductAndDepartment(product.getProductID(), departmentID, controller) != null ? ProductDepartment.getByProductAndDepartment(product.getProductID(), departmentID, controller).getAverageValue() : 0.0);
                product.setStock(rs.getDouble("Stanje"));
                product.setStockReservation(rs.getDouble("Rezervisano"));
                product.setSrednjaNabavnaCena(rs.getDouble("SrednjaNabavna"));
                product.setSrednjaNabavnaValue(Settings.round(product.getSrednjaNabavnaCena() * product.getStock(), 2));
                product.setPrice(rs.getDouble("Cena"));
                if (poslednjaNcena) {
                    System.out.println("navbavna cena");
                    if (Boolean.parseBoolean(controller.getSettings().getActualByName("fifo_nabavna_cena"))) {
                        product.setNabavnaCena(ProductDepartment.getByProductAndDepartment(product.getProductID(), departmentID, controller) != null ? ProductDepartment.getByProductAndDepartment(product.getProductID(), departmentID, controller).getAverageValue() : 0.0);
                    } else {
                        product.getNabavnaCenaPDV(controller.getSettings().getConnection());
                    }
                } else {
                    product.setNabavnaCena(0.0);
                }
                product.setNabavnaCenaValue(Settings.round(product.getNabavnaCena() * product.getStock(), 2));
                product.setValueLager(Settings.round(product.getPrice() * product.getStock(), 2));
                product.setListAditionalFieldDetails((ObservableList<AditionalFieldDetails>)FXCollections.observableArrayList());
                if (!aditionlFieldFilter.isEmpty()) {
                    product.setListAditionalField(aditionlFieldFilter);
                    for (AditionalField aField : aditionlFieldFilter) {
                        AditionalFieldDetails aditionalFieldDetails = new AditionalFieldDetails();
                        aditionalFieldDetails.setName(rs.getString(aField.getName()));
                        aField.setAditionalFieldDetails(aditionalFieldDetails);
                        product.getListAditionalFieldDetails().add((java.lang.Object)aditionalFieldDetails);
                        product.setAditionalField(aField);
                    }
                }
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            ChangeConnection.getConnectionUser(controller);
            e.printStackTrace();
        }
        ChangeConnection.getConnectionUser(controller);
        return list;
    }

    public static double getNewReceivingReportByProductId(String filter, ScreensController controller, int departmentID, LocalDate to) {
        String query = null;
        LocalDateTime dateFrom = null;
        dateFrom = WorkDay.datumPocetnogStanja(departmentID, Settings.fromLocalDate(to), controller.getSettings().getConnection());
        query = "SELECT\r\np.ProductID,\r\np.Code as Kod, \r\np.Name,\r\nu.Code as JM,\r\nbc.BarCode as BarKod,  SUM(IF(d.DocumentTypeID=11, dd.Quantity, dd.Quantity * dt.Stock)) AS Stanje  FROM documentdetails dd, product p, unit u, barcode bc, document d, documenttype dt\r\nWHERE bc.ProductID = p.ProductID AND dd.ProductID = p.ProductID AND u.UnitID = p.UnitID AND dt.DocumentTypeID = d.DocumentTypeID AND d.DocumentID = dd.DocumentId AND d.DocumentStatusID IN (1,2) AND d.Date >= ? AND d.Date <= ? AND p.ProductTypeID = 1  AND (d.DepartmentID = ? OR d.PointOfSaleID IN (SELECT posd.PointOfSaleID FROM pointofsaledepartment posd WHERE posd.DepartmentID = ?)) AND p.ProductID = " + filter + " GROUP BY bc.BarCode ORDER BY p.ProductID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, Timestamp.valueOf(dateFrom));
            ps.setTimestamp(2, Timestamp.valueOf(Settings.LocalDateTimefromDate(Settings.fromLocalDate(to))));
            ps.setInt(3, departmentID);
            ps.setInt(4, departmentID);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Product product = new Product();
            product.setStock(rs.getDouble("Stanje"));
            ps.close();
            rs.close();
            return product.getStock();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static ObservableList<Product> getReceivingReportSalesProducts(ScreensController controller, PointOfSale pointOfSale, TimeSpinner vremeod, TimeSpinner vremedo, DatePicker dateFrom, DatePicker dateTo, CheckBox cbIzborGrupa, String grupe, CheckBox cbIzborDodatnihPolja, StringBuilder sbDodatnaPolja, CheckBox cbIzborKategorija, StringBuilder sbKategorije, String filter, boolean orderBy, boolean orderByName) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select p.Name, p.Code, bc1.BarCode, ( sum(dd.PriceWithDiscount * dd.Quantity)/v.Value) as NetAmount,((sum(dd.PriceWithDiscount * dd.Quantity)) - (sum(dd.PriceWithDiscount * dd.Quantity)/v.Value))as valuePdv, v.Code as vatName,u.Code as UnitName, dd.sysDTCreated as datum,\n   sum(dd.Quantity) as Quantity, dd.Price, dd.Discount, sum(dd.PriceWithDiscount * dd.Quantity) as Value,  pc.Name as Kategorija, case  when pg.Name is null then 'Bez grupe' else pg.Name end as group_name, (select afd2.Name from aditionalfielddetailsproduct afdp2  join aditionalfielddetails afd2 on afd2.AditionalFieldDetailsID = afdp2.AditionalFieldDetailsID where afdp2.ProductID = p.ProductID and afd2.AditionalFieldID = 0) as velicina, (select afd2.Name from aditionalfielddetailsproduct afdp2  join aditionalfielddetails afd2 on afd2.AditionalFieldDetailsID = afdp2.AditionalFieldDetailsID  where afdp2.ProductID = p.ProductID and afd2.AditionalFieldID = 0) as boja from documentdetails dd left join document d on d.DocumentID = dd.DocumentID\t inner join vat v on dd.VatID =v.VatID inner join unit u on u.UnitID = dd.UnitID  and d.DocumentTypeID = 3 and d.DocumentStatusID <>2   and d.DocumentID not in (select dr.DocumentParentID from documentrelationship dr where dr.RelationshipTypeID = 2)  and time(d.Date) >=   ?   and time(d.Date) <=   ?  \t\t\t\t\t\t\t inner join workday w on w.WorkDayID = d.WorkDayID  and (w.Date >= ? and w.Date <= ?) left join product p on p.ProductID = dd.ProductID  left join productcategory pc on pc.ProductCategoryID = p.ProductCategoryID left join (SELECT * FROM Barcode group by ProductId) bc1 on bc1.ProductID = p.ProductID left join productgroupdetails pgd on pgd.ProductID = dd.ProductID left join productgroup pg on pg.ProductGroupID = pgd.ProductGroupID where ((  ? = -1 ) or ((select ps.ObjectID from pointofsale ps where ps.PointOfSaleID = d.PointOfSaleID) = ?  )) and ((  ? = -1 ) or (d.PointOfSaleID = ?  ))  and ((  ?  = false) or (   ? = true and p.ProductID in (select pd.ProductID from productgroupdetails pd where  FIND_IN_SET(pd.ProductGroupID, ?  ) > 0))) and ((  ? = false) or ( ?  = true and dd.ProductID in (select afdp1.ProductID from aditionalfielddetailsproduct afdp1  where FIND_IN_SET(afdp1.AditionalFieldDetailsID, ?  ) > 0  ) ) ) and ((  ? = false) or ( ? = true and pc.ProductCategoryID in (select pc1.ProductCategoryID from productcategory pc1 where FIND_IN_SET(pc.ProductCategoryID, ?) > 0))) and (p.Code like ? or bc1.BarCode like ?) group by p.Name, p.Code, dd.Price, dd.Discount, bc1.BarCodeID order by " + (orderBy ? "Quantity DESC" : (orderByName ? "p.Name ASC" : "p.Code ASC"));
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTime(1, Time.valueOf(vremeod.getEditor().getText()));
            ps.setTime(2, vremedo.getEditor().getText().equals("00:00:00") ? Time.valueOf("23:59:59") : Time.valueOf(vremedo.getEditor().getText()));
            ps.setDate(3, new Date(Settings.fromLocalDate((LocalDate)dateFrom.getValue()).getTime()));
            ps.setDate(4, new Date(Settings.fromLocalDate((LocalDate)dateTo.getValue()).getTime()));
            ps.setInt(5, controller.getObject().getObjectID());
            ps.setInt(6, controller.getObject().getObjectID());
            try {
                ps.setInt(7, pointOfSale.getPointOfSaleID());
                ps.setInt(8, pointOfSale.getPointOfSaleID());
            }
            catch (NullPointerException e) {
                ps.setInt(7, 1);
                ps.setInt(8, 1);
            }
            ps.setBoolean(9, !cbIzborGrupa.isSelected());
            ps.setBoolean(10, !cbIzborGrupa.isSelected());
            ps.setString(11, grupe);
            ps.setBoolean(12, !cbIzborDodatnihPolja.isSelected());
            ps.setBoolean(13, !cbIzborDodatnihPolja.isSelected());
            ps.setString(14, sbDodatnaPolja.toString());
            ps.setBoolean(15, !cbIzborKategorija.isSelected());
            ps.setBoolean(16, !cbIzborKategorija.isSelected());
            ps.setString(17, sbKategorije.toString());
            ps.setString(18, "%" + filter + "%");
            ps.setString(19, "%" + filter + "%");
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.setName(rs.getString("Name"));
                product.setCode(rs.getString("Code"));
                product.setBarcode(rs.getString("BarCode"));
                product.setStock(rs.getDouble("Quantity"));
                product.setPrice(rs.getDouble("Price"));
                product.setNabavnaCena(rs.getDouble("Value"));
                product.setProductCategoryName(rs.getString("Kategorija"));
                product.setDiscount(rs.getDouble("Discount"));
                product.setGroupName(rs.getString("group_name"));
                product.setSize(rs.getString("velicina"));
                product.setColor(rs.getString("boja"));
                product.setVatName(rs.getString("vatName"));
                product.setUnitName(rs.getString("UnitName"));
                System.out.println("Datum je" + rs.getDate("datum"));
                product.setSysDTCreated(rs.getDate("datum"));
                product.setNetAmount(rs.getDouble("NetAmount"));
                product.setValuePdv(rs.getDouble("valuePdv"));
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void getReceivingReportToExcel(ScreensController controller, ObservableList<Product> list, String putanja, String name) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Lager lista");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Kod");
        header.createCell(1).setCellValue("BarKod");
        header.createCell(2).setCellValue("Name");
        header.createCell(3).setCellValue("JM");
        header.createCell(4).setCellValue("Stanje");
        header.createCell(5).setCellValue("Nabavna Cena");
        header.createCell(6).setCellValue("Prodajna Cena");
        header.createCell(7).setCellValue("Vrednost");
        int columnNumber = 8;
        for (java.lang.Object aditionalField : AditionalField.getList(controller.getSettings().getConnection())) {
            header.createCell(columnNumber).setCellValue(((AditionalField)aditionalField).getName());
            ++columnNumber;
        }
        sheet.setColumnWidth(0, 4100);
        sheet.setColumnWidth(1, 4100);
        sheet.setColumnWidth(2, 12800);
        sheet.setColumnWidth(3, 1600);
        sheet.setColumnWidth(4, 1600);
        sheet.setColumnWidth(5, 4100);
        sheet.setColumnWidth(6, 4100);
        sheet.setColumnWidth(7, 4100);
        int index = 1;
        for (Product product : list) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(product.getCode());
            row.createCell(1).setCellValue(product.getBarcode());
            row.createCell(2).setCellValue(product.getName());
            row.createCell(3).setCellValue(product.getUnitName());
            row.createCell(4).setCellValue(product.getStock());
            row.createCell(5).setCellValue(product.getNabavnaCena());
            row.createCell(6).setCellValue(product.getPrice());
            row.createCell(7).setCellValue(product.getValueLager());
            int columnNumberCell = 8;
            for (AditionalFieldDetails aditionalFieldDetails : product.getListAditionalFieldDetails()) {
                row.createCell(columnNumberCell).setCellValue(aditionalFieldDetails.getName());
                ++columnNumberCell;
            }
            ++index;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(putanja + File.separator + name);
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getPriceListToExcel(ScreensController controller, ObservableList<Product> list, String putanja, String name) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Cenovnik");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Kod");
        header.createCell(1).setCellValue("BarKod");
        header.createCell(2).setCellValue("Name");
        header.createCell(3).setCellValue("PDV");
        header.createCell(4).setCellValue("Cena po komadu");
        sheet.setColumnWidth(0, 4100);
        sheet.setColumnWidth(1, 4100);
        sheet.setColumnWidth(2, 12800);
        sheet.setColumnWidth(3, 1600);
        sheet.setColumnWidth(4, 1600);
        int index = 1;
        for (Product product : list) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(product.getCode());
            row.createCell(1).setCellValue(product.getBarcode());
            row.createCell(2).setCellValue(product.getName());
            row.createCell(3).setCellValue(product.getVatName());
            row.createCell(4).setCellValue(product.getPrice());
            ++index;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(putanja + File.separator + name);
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getReceivingReportToExcelForEmail(ScreensController controller, ObservableList<Product> list) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Lager lista");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Kod");
        header.createCell(1).setCellValue("BarKod");
        header.createCell(2).setCellValue("Name");
        header.createCell(3).setCellValue("JM");
        header.createCell(4).setCellValue("Stanje");
        header.createCell(5).setCellValue("Cena po komadu");
        header.createCell(6).setCellValue("Vrednost");
        int columnNumber = 7;
        for (java.lang.Object aditionalField : AditionalField.getList(controller.getSettings().getConnection())) {
            header.createCell(columnNumber).setCellValue(((AditionalField)aditionalField).getName());
            ++columnNumber;
        }
        sheet.setColumnWidth(0, 4100);
        sheet.setColumnWidth(1, 4100);
        sheet.setColumnWidth(2, 12800);
        sheet.setColumnWidth(3, 1600);
        sheet.setColumnWidth(4, 1600);
        sheet.setColumnWidth(8, 4100);
        sheet.setColumnWidth(9, 4100);
        int index = 1;
        for (Product product : list) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(product.getCode());
            row.createCell(1).setCellValue(product.getBarcode());
            row.createCell(2).setCellValue(product.getName());
            row.createCell(3).setCellValue(product.getUnitName());
            row.createCell(4).setCellValue(product.getStock());
            row.createCell(5).setCellValue(product.getNabavnaCenaBezPopusta());
            row.createCell(6).setCellValue(product.getPrice());
            int columnNumberCell = 7;
            for (AditionalFieldDetails aditionalFieldDetails : product.getListAditionalFieldDetails()) {
                row.createCell(columnNumberCell).setCellValue(aditionalFieldDetails.getName());
                ++columnNumberCell;
            }
            ++index;
        }
        try {
            File file = new File("LagerLista.xlsx");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            wb.write((OutputStream)fileOutputStream);
            FileInputStream inputStream = new FileInputStream(file);
            MailingList mailingList = new MailingList();
            mailingList.setName("Petar");
            mailingList.seteMail("dragisa1984@yahoo.com");
            mailingList.setReport("LagerLista");
            mailingList.setReportFileInput(inputStream);
            mailingList.insert(controller);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getReceivingReportToPDF(ScreensController controller, ObservableList<Product> list, String putanja, String name) {
        Document my_pdf_report = new Document();
        try {
            PdfWriter.getInstance((Document)my_pdf_report, (OutputStream)new FileOutputStream(putanja + File.separator + name));
            my_pdf_report.open();
            PdfPTable my_report_table = new PdfPTable(8);
            Font font = FontFactory.getFont((String)"Helvetica", (float)8.0f);
            PdfPCell table_cell = new PdfPCell(new Phrase("Kod", font));
            table_cell.setHorizontalAlignment(70);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("Barkod", font));
            table_cell.setHorizontalAlignment(76);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("Name", font));
            table_cell.setHorizontalAlignment(240);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("JM", font));
            table_cell.setHorizontalAlignment(30);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("Stanje", font));
            table_cell.setHorizontalAlignment(36);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("Nabavna Cena", font));
            table_cell.setHorizontalAlignment(40);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("Cena", font));
            table_cell.setHorizontalAlignment(40);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("Vrednost", font));
            table_cell.setHorizontalAlignment(40);
            my_report_table.addCell(table_cell);
            for (Product product : list) {
                table_cell = my_report_table.getDefaultCell();
                table_cell.setHorizontalAlignment(1);
                String Kod = product.getCode();
                table_cell = new PdfPCell(new Phrase(Kod, font));
                table_cell.setHorizontalAlignment(70);
                my_report_table.addCell(table_cell);
                String BarKod = product.getBarcode();
                table_cell = new PdfPCell(new Phrase(BarKod, font));
                table_cell.setHorizontalAlignment(76);
                my_report_table.addCell(table_cell);
                String Name = product.getName();
                try {
                    table_cell = new PdfPCell(new Phrase(Name.substring(0, 46), font));
                }
                catch (StringIndexOutOfBoundsException e) {
                    table_cell = new PdfPCell(new Phrase(Name, font));
                }
                table_cell.setHorizontalAlignment(240);
                my_report_table.addCell(table_cell);
                String JM = product.getUnitName();
                table_cell = new PdfPCell(new Phrase(JM, font));
                table_cell.setHorizontalAlignment(30);
                my_report_table.addCell(table_cell);
                String Stanje = String.valueOf(Settings.round(product.getStock(), 2));
                table_cell = new PdfPCell(new Phrase(Stanje, font));
                table_cell.setHorizontalAlignment(36);
                my_report_table.addCell(table_cell);
                String NabavnaCenaPoKomadu = String.valueOf(Settings.round(product.getNabavnaCenaBezPopusta(), 2));
                table_cell = new PdfPCell(new Phrase(NabavnaCenaPoKomadu, font));
                table_cell.setHorizontalAlignment(40);
                my_report_table.addCell(table_cell);
                String CenaPoKomadu = String.valueOf(Settings.round(product.getNabavnaCena(), 2));
                table_cell = new PdfPCell(new Phrase(CenaPoKomadu, font));
                table_cell.setHorizontalAlignment(40);
                my_report_table.addCell(table_cell);
                String Vrednost = String.valueOf(Settings.round(product.getPrice(), 2));
                table_cell = new PdfPCell(new Phrase(Vrednost, font));
                table_cell.setHorizontalAlignment(40);
                my_report_table.addCell(table_cell);
                my_report_table.setTotalWidth(new float[]{70.0f, 76.0f, 240.0f, 30.0f, 36.0f, 40.0f, 40.0f, 40.0f});
                my_report_table.setLockedWidth(true);
            }
            my_pdf_report.add((Element)my_report_table);
            my_pdf_report.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public static void getPriceListToPDF(ScreensController controller, ObservableList<Product> list, String putanja, String name) {
        Document my_pdf_report = new Document();
        try {
            PdfWriter.getInstance((Document)my_pdf_report, (OutputStream)new FileOutputStream(putanja + File.separator + name));
            my_pdf_report.open();
            PdfPTable my_report_table = new PdfPTable(4);
            Font font = FontFactory.getFont((String)"Helvetica", (float)9.0f);
            PdfPCell table_cell = new PdfPCell(new Phrase("Kod", font));
            table_cell.setHorizontalAlignment(80);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("Barkod", font));
            table_cell.setHorizontalAlignment(86);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("Name", font));
            table_cell.setHorizontalAlignment(240);
            my_report_table.addCell(table_cell);
            table_cell = new PdfPCell(new Phrase("Cena", font));
            table_cell.setHorizontalAlignment(50);
            my_report_table.addCell(table_cell);
            for (Product product : list) {
                table_cell = my_report_table.getDefaultCell();
                table_cell.setHorizontalAlignment(1);
                String Kod = product.getCode();
                table_cell = new PdfPCell(new Phrase(Kod, font));
                table_cell.setHorizontalAlignment(80);
                my_report_table.addCell(table_cell);
                String BarKod = product.getBarcode();
                table_cell = new PdfPCell(new Phrase(BarKod, font));
                table_cell.setHorizontalAlignment(86);
                my_report_table.addCell(table_cell);
                String Name = product.getShortName();
                try {
                    table_cell = new PdfPCell(new Phrase(Name.substring(0, 46), font));
                }
                catch (StringIndexOutOfBoundsException e) {
                    table_cell = new PdfPCell(new Phrase(Name, font));
                }
                table_cell.setHorizontalAlignment(240);
                my_report_table.addCell(table_cell);
                String CenaPoKomadu = String.valueOf(Settings.round(product.getNabavnaCenaBezPopusta(), 2));
                table_cell = new PdfPCell(new Phrase(CenaPoKomadu, font));
                table_cell.setHorizontalAlignment(50);
                my_report_table.addCell(table_cell);
                my_report_table.setTotalWidth(new float[]{80.0f, 86.0f, 260.0f, 30.0f});
                my_report_table.setLockedWidth(true);
            }
            my_pdf_report.add((Element)my_report_table);
            my_pdf_report.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<Product> getProductByPriceList(ScreensController controller, long priceListID) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT p.Code, p.ShortName, bc.BarCode, (SELECT pl.Title FROM pricelist pl WHERE pl.PriceListID = pld.PriceListID) AS Cenovnik,  pld.Price, pld.Discount, pld.Date AS Datum FROM product p JOIN barcode bc ON bc.ProductID = p.ProductID JOIN pricelistdetails pld ON pld.ProductID = p.ProductID WHERE pld.PriceListID = ? AND pld.Date in (SELECT MAX(pld1.Date) FROM pricelistdetails pld1  WHERE pld1.ProductID = p.ProductID AND pld1.PriceListID = pld.PriceListID) ORDER BY p.ProductID";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, priceListID);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Product product = new Product();
                product.setName(rSet.getString("ShortName"));
                product.setCode(rSet.getString("Code"));
                product.setBarcode(rSet.getString("BarCode"));
                product.setPrice(rSet.getDouble("Price"));
                product.setDiscount(rSet.getDouble("Discount"));
                product.setUnitName(rSet.getString("Cenovnik"));
                product.setSysDTEdit(new java.util.Date(rSet.getTimestamp("Datum").getTime()));
                list.add((java.lang.Object)product);
            }
            pStatement.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getProductPriceList(ScreensController controller, String filter, long vatId, int productCategoryId) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT p.Code, p.ShortName, v.Name AS VatName, p.ProductTypeID AS Tip, pc.Name As Category, bc.BarCode, pld.Price \r\n FROM product p\r\nLEFT JOIN barcode bc ON bc.ProductID = p.ProductID\r\n LEFT JOIN vat v ON v.VatID = p.VatID\r\n LEFT JOIN productcategory pc ON pc.ProductCategoryID = p.ProductCategoryID\r\n LEFT JOIN pricelistdetails pld ON pld.ProductID = p.ProductID\r\nWHERE pld.PriceListID = 1\r\n AND (p.Code LIKE ? OR bc.BarCode LIKE ?)  AND pld.Date in (SELECT MAX(pld1.Date) FROM pricelistdetails pld1\r\n WHERE pld1.ProductID = p.ProductID\r\nAND pld1.PriceListID = pld.PriceListID)\r\n AND (? = -1 OR p.VatID = ?) AND (? = -1 OR p.ProductCategoryID = ?)  ORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, "%" + filter + "%");
            pStatement.setString(2, "%" + filter + "%");
            pStatement.setLong(3, vatId);
            pStatement.setLong(4, vatId);
            pStatement.setInt(5, productCategoryId);
            pStatement.setInt(6, productCategoryId);
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Product product = new Product();
                product.setName(rSet.getString("ShortName"));
                product.setCode(rSet.getString("Code"));
                product.setBarcode(rSet.getString("BarCode"));
                product.setPrice(rSet.getDouble("Price"));
                product.setProductTypeID(rSet.getInt("Tip"));
                product.setVatName(rSet.getString("VatName"));
                product.setCategoryName(rSet.getString("Category"));
                list.add((java.lang.Object)product);
            }
            pStatement.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void getProductToExcelByPriceList(ScreensController controller, ObservableList<Product> list, String name, String path) {
        File directory = new File(String.valueOf(path));
        if (!directory.exists()) {
            directory.mkdir();
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Product");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Kod");
        header.createCell(1).setCellValue("Naziv");
        header.createCell(2).setCellValue("BarKod");
        header.createCell(3).setCellValue("Cenovnik");
        header.createCell(4).setCellValue("Cena");
        header.createCell(5).setCellValue("Popust");
        header.createCell(6).setCellValue("Datum");
        sheet.setColumnWidth(0, 3300);
        sheet.setColumnWidth(1, 12800);
        sheet.setColumnWidth(2, 4100);
        sheet.setColumnWidth(3, 4900);
        sheet.setColumnWidth(4, 1600);
        sheet.setColumnWidth(5, 2000);
        sheet.setColumnWidth(6, 3300);
        int index = 1;
        for (Product product : list) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(product.getCode());
            row.createCell(1).setCellValue(product.getName());
            row.createCell(2).setCellValue(product.getBarcode());
            row.createCell(3).setCellValue(product.getUnitName());
            row.createCell(4).setCellValue(product.getPrice());
            row.createCell(5).setCellValue(product.getDiscount());
            row.createCell(6).setCellValue(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(product.getSysDTEdit()));
            ++index;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(directory + File.separator + name + ".xlsx");
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return (this.Code != null ? this.Code + " -- " : "") + (this.Name != null ? this.Name + " -- " : "") + (this.barcode != null ? this.barcode : "");
    }

    public void getNewProductStock(ScreensController controller) {
        LocalDateTime pocetnostanjeDateTime = LocalDateTime.now();
        pocetnostanjeDateTime = WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), new java.util.Date(), controller.getSettings().getConnection());
        String query = "SELECT\r\nSUM(IF(d.DocumentTypeID=11, dd.Quantity, dd.Quantity * dt.Stock)) AS Stanje  \r\nFROM documentdetails dd, product p, document d, documenttype dt\r\nWHERE dd.ProductID = p.ProductID \r\nAND dt.DocumentTypeID = d.DocumentTypeID \r\nAND d.DocumentID = dd.DocumentId \r\nAND d.DocumentStatusID IN (1,2) \r\nAND d.Date >= ? AND d.Date <= ? \r\nAND p.ProductTypeID = 1 \r\nAND p.ProductID = ? \r\nORDER BY p.ProductID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, Timestamp.valueOf(pocetnostanjeDateTime));
            ps.setTimestamp(2, Timestamp.valueOf(LocalDateTime.now()));
            ps.setLong(3, this.ProductID);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            this.stock = rs.getDouble("Stanje");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static ObservableList<Product> getNewProductStockList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        LocalDateTime pocetnostanjeDateTime = LocalDateTime.now();
        pocetnostanjeDateTime = WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), new java.util.Date(), controller.getSettings().getConnection());
        String query = "SELECT dd.ProductID,\r\nSUM(IF(d.DocumentTypeID=11, dd.Quantity, IF(d.DocumentTypeID = 29, 0, dd.Quantity * dt.Stock))) AS Stanje  \r\nFROM documentdetails dd, product p, document d, documenttype dt\r\nWHERE dd.ProductID = p.ProductID \r\nAND dt.DocumentTypeID = d.DocumentTypeID \r\nAND d.DocumentID = dd.DocumentId \r\nAND d.DocumentStatusID IN (1) \r\nAND d.Date >= ? AND d.Date <= ? \r\nAND p.ProductTypeID = 1\r\nGROUP BY p.ProductID ORDER BY p.ProductID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, Timestamp.valueOf(pocetnostanjeDateTime));
            ps.setTimestamp(2, Timestamp.valueOf(LocalDateTime.now()));
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.setProductID(rs.getLong("ProductID"));
                product.setStock(rs.getDouble("Stanje"));
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getNewProductStockList(ScreensController controller, LocalDate stockDate) {
        ObservableList list = FXCollections.observableArrayList();
        java.util.Date sDate = Settings.fromLocalDate(stockDate);
        WorkDay wd = WorkDay.getLastOpenWDByDate(sDate, controller);
        LocalDateTime pocetnostanjeDateTime = LocalDateTime.now();
        pocetnostanjeDateTime = WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), sDate, controller.getSettings().getConnection());
        String query = "SELECT dd.ProductID,\r\nSUM(IF(d.DocumentTypeID=11, dd.Quantity, IF(d.DocumentTypeID = 29, 0, dd.Quantity * dt.Stock))) AS Stanje  \r\nFROM documentdetails dd, product p, document d, documenttype dt\r\nWHERE dd.ProductID = p.ProductID \r\nAND dt.DocumentTypeID = d.DocumentTypeID \r\nAND d.DocumentID = dd.DocumentId \r\nAND d.DocumentStatusID IN (1,2) \r\nAND d.Date >= ? AND d.Date <= ? \r\nAND p.ProductTypeID = 1\r\nGROUP BY p.ProductID ORDER BY p.ProductID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, Timestamp.valueOf(pocetnostanjeDateTime));
            ps.setTimestamp(2, Timestamp.valueOf(Settings.LocalDateTimefromDate(wd.getDateFrom())));
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.setProductID(rs.getLong("ProductID"));
                product.setStock(rs.getDouble("Stanje"));
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getNewProductReservationStockList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        LocalDateTime pocetnostanjeDateTime = LocalDateTime.now();
        pocetnostanjeDateTime = WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), new java.util.Date(), controller.getSettings().getConnection());
        String query = "SELECT dd.ProductID,\r\nCOALESCE( SUM(IF(d.DocumentTypeID=29 AND d.Realized IS FALSE AND NOW() < d.DeliveryDate, dd.Quantity, 0)), 0) AS Rezervisano  \r\nFROM documentdetails dd, product p, document d, documenttype dt\r\nWHERE dd.ProductID = p.ProductID \r\nAND dt.DocumentTypeID = d.DocumentTypeID \r\nAND d.DocumentID = dd.DocumentId \r\nAND d.DocumentStatusID IN (1,2) \r\nAND d.Date >= ? AND d.Date <= ? \r\nAND p.ProductTypeID = 1\r\nGROUP BY p.ProductID ORDER BY p.ProductID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, Timestamp.valueOf(pocetnostanjeDateTime));
            ps.setTimestamp(2, Timestamp.valueOf(LocalDateTime.now()));
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.setProductID(rs.getLong("ProductID"));
                product.setStockReservation(rs.getDouble("Rezervisano"));
                list.add((java.lang.Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static double getNewCurrentStock(ScreensController controller, LocalDateTime datumPocetnogStanja, LocalDateTime dateToForDep, long productId) {
        double stanje;
        String query = "SELECT\r\nCOALESCE( SUM(IF(d.DocumentTypeID=11, dd.Quantity, IF(d.DocumentTypeID = 29, 0, dd.Quantity * dt.Stock))), 0) AS Stanje\r\nFROM documentdetails dd, product p, document d, documenttype dt\r\nWHERE dd.ProductID = p.ProductID \r\nAND dt.DocumentTypeID = d.DocumentTypeID \r\nAND d.DocumentID = dd.DocumentId \r\nAND d.DocumentStatusID IN (1,2) \r\nAND IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) >= ? AND d.Date <= ? \r\nAND p.ProductTypeID = 1 AND (d.DepartmentID = 1 OR d.PointOfSaleID IN (SELECT posd.PointOfSaleID FROM pointofsaledepartment posd WHERE posd.DepartmentID = 1)) \r\nAND p.ProductID = ?  ORDER BY p.ProductID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, Timestamp.valueOf(datumPocetnogStanja));
            ps.setTimestamp(2, Timestamp.valueOf(dateToForDep));
            ps.setLong(3, productId);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            stanje = rs.getDouble("Stanje");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            stanje = 0.0;
        }
        return stanje;
    }

    public static double getNewCurrentStock(ScreensController controller, LocalDateTime datumPocetnogStanja, LocalDateTime dateToForDep, long productId, long documentId) {
        double stanje;
        String query = "SELECT\r\nCOALESCE( SUM(IF(d.DocumentTypeID=11, dd.Quantity, IF(d.DocumentTypeID = 29, 0, dd.Quantity * dt.Stock))), 0) AS Stanje\r\nFROM documentdetails dd, product p, document d, documenttype dt\r\nWHERE dd.ProductID = p.ProductID \r\nAND dt.DocumentTypeID = d.DocumentTypeID \r\nAND d.DocumentID = dd.DocumentId \r\nAND d.DocumentStatusID IN (1,2) \r\nAND IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) >= ? AND d.Date  <=  ?  \r\nAND p.ProductTypeID = 1 AND (d.DepartmentID = 1 OR d.PointOfSaleID IN (SELECT posd.PointOfSaleID FROM pointofsaledepartment posd WHERE posd.DepartmentID = 1)) \r\nAND p.ProductID = ? AND d.DocumentId!=? ORDER BY p.ProductID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, Timestamp.valueOf(datumPocetnogStanja));
            ps.setTimestamp(2, Timestamp.valueOf(dateToForDep));
            ps.setLong(3, productId);
            ps.setLong(4, documentId);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            stanje = rs.getDouble("Stanje");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            stanje = 0.0;
        }
        return stanje;
    }

    public static ObservableList<Product> getNewTrgovinaList(ScreensController controller, String limit, String filter, String textFilter, boolean doCheck) {
        String query = null;
        ObservableList<Product> listStock = null;
        ObservableList<Product> listStockReservation = null;
        query = "SELECT\r\np.*,\r\npd.ProductDepartmentID, \r\np.Code as Kod, \r\np.Name,\r\nu.Code as JM,\r\nbc.BarCode as BarKod,\r\n(SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = p.ProductID ORDER BY pld.Date DESC LIMIT 1) AS Cena\r\nFROM product p\r\nLEFT JOIN productdepartment pd ON pd.ProductID = p.ProductID\r\nLEFT JOIN unit u ON u.UnitID = p.UnitID\r\nLEFT JOIN barcode bc ON bc.ProductID = p.ProductID WHERE IF('" + filter + "' = '\u0160ifra', (p.Code = '" + textFilter + "' OR bc.BarCode = '" + textFilter + "'), p.ProductID > 0)\r\nAND IF('" + filter + "' = 'Naziv', p.Name LIKE '" + textFilter + "%', p.ProductID > 0)\r\nAND IF('" + filter + "' = 'Barkod', bc.BarCode LIKE '" + textFilter + "%', p.ProductID > 0)\r\nAND (IF('" + filter + "' = 'Sve', bc.BarCode LIKE '" + textFilter + "%', p.ProductID > 0)\r\nOR IF('" + filter + "' = 'Sve', p.Name LIKE '%" + textFilter + "%', p.ProductID > 0)\r\nOR IF('" + filter + "' = 'Sve', p.Code LIKE '" + textFilter + "%', p.ProductID > 0)) AND p.Active IS TRUE GROUP BY p.ProductID\r\nORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC, p.Code, p.Name, p.ShortName LIMIT " + limit;
        ObservableList list = FXCollections.observableArrayList();
        if (doCheck) {
            listStock = Product.getNewProductStockList(controller);
            listStockReservation = Product.getNewProductReservationStockList(controller);
        }
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.plucode = rs.getString("PLUcode");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NetAmount = rs.getDouble("NetAmount");
                product.NetAmountTypeID = rs.getInt("NetAmountTypeID");
                product.Measurable = rs.getBoolean("Measurable");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.price = rs.getDouble("Cena");
                product.barcode = rs.getString("BarKod");
                product.UnitName = rs.getString("JM");
                product.setProductDepartmentID(rs.getLong("ProductDepartmentID"));
                if (AditionalFieldDetailsProduct.isEmtryList(controller, product)) {
                    product.setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID(product.getProductID(), controller.getSettings().getConnection()));
                }
                if (listStock != null && listStockReservation != null && (controller.getSettings().isKolStanje() || !controller.getUser().hasRole("sell.without.stock") && !controller.getSettings().isSellWithoutStock())) {
                    for (Product p : listStock) {
                        if (p.getProductID() != product.getProductID()) continue;
                        product.setStock(p.getStock());
                    }
                    for (Product p : listStockReservation) {
                        if (p.getProductID() != product.getProductID()) continue;
                        product.setStockReservation(p.getStockReservation());
                    }
                }
                list.add((java.lang.Object)product);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getNewProductsTrgovinaList(ScreensController controller, String limit, String filter, String textFilter) {
        LocalDateTime pocetnostanjeDateTime = LocalDateTime.now();
        String query = null;
        pocetnostanjeDateTime = WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), new java.util.Date(), controller.getSettings().getConnection());
        query = " SELECT\r\np.*,\r\npd.ProductDepartmentID, \r\np.Code as Kod, \r\np.Name,\r\nu.Code as JM,\r\nbc.BarCode as BarKod,\r\n(SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = p.ProductID ORDER BY pld.ProductID DESC LIMIT 1) AS Cena,\r\nCASE\tWHEN false THEN\r\n\t\t(SELECT ROUND(AVG(dd.PurchacePrice), 4) AS PurchacePrice FROM documentdetails dd LEFT JOIN document d ON d.DocumentID = dd.DocumentID \r\n\t\t\tWHERE d.DocumentTypeID = 1 AND d.Date >= '" + pocetnostanjeDateTime + "' AND dd.ProductID = p.ProductID)\r\n\tELSE\r\n\t\t0\r\nEND AS SrednjaNabavna, \r\nCOALESCE( SUM(IF(d.DocumentTypeID = 29, 0, IF(d.DocumentTypeID=11, dd.Quantity, dd.Quantity * dt.Stock))), 0) AS Stanje,\r\nCOALESCE( SUM(IF(d.DocumentTypeID = 29, dd.Quantity, 0)), 0) AS StanjeRezervacije \r\nFROM documentdetails dd \r\nRIGHT JOIN product p ON dd.ProductID = p.ProductID OR dd.ProductID IS NULL AND p.ProductTypeID = 1\r\nLEFT JOIN productdepartment pd ON pd.ProductID = p.ProductID\r\nLEFT JOIN unit u ON u.UnitID = p.UnitID\r\nLEFT JOIN barcode bc ON bc.ProductID = p.ProductID\r\nLEFT JOIN document d ON d.DocumentID = dd.DocumentID OR dd.DocumentID IS NULL\r\nLEFT JOIN documenttype dt ON dt.DocumentTypeID = d.DocumentTypeID\r\nWHERE (d.DocumentStatusID IN (1,2) OR d.DocumentStatusID IS NULL) \r\nAND IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) BETWEEN '" + pocetnostanjeDateTime + "' AND NOW() OR d.DocumentTypeID IS NULL\r\nAND IF('" + filter + "' = '\u0160ifra', (p.Code = '" + textFilter + "' OR bc.BarCode = '" + textFilter + "'), p.ProductID > 0)\r\nAND IF('" + filter + "' = 'Naziv', p.Name LIKE '" + textFilter + "%', p.ProductID > 0)\r\nAND IF('" + filter + "' = 'Barkod', bc.BarCode LIKE '" + textFilter + "%', p.ProductID > 0)\r\nAND (IF('" + filter + "' = 'Sve', bc.BarCode LIKE '" + textFilter + "%', p.ProductID > 0)\r\nOR IF('" + filter + "' = 'Sve', p.Name LIKE '%" + textFilter + "%', p.ProductID > 0)\r\nOR IF('" + filter + "' = 'Sve', p.Code LIKE '" + textFilter + "%', p.ProductID > 0))  GROUP BY p.ProductID\r\nORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC, p.Code, p.Name, p.ShortName LIMIT " + limit;
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.plucode = rs.getString("PLUcode");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NetAmount = rs.getDouble("NetAmount");
                product.NetAmountTypeID = rs.getInt("NetAmountTypeID");
                product.Measurable = rs.getBoolean("Measurable");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.price = rs.getDouble("Cena");
                product.barcode = rs.getString("BarKod");
                product.UnitName = rs.getString("JM");
                product.setProductDepartmentID(rs.getLong("ProductDepartmentID"));
                if (controller.getSettings().isKolStanje()) {
                    product.setStock(rs.getDouble("Stanje"));
                    product.setStockReservation(rs.getDouble("StanjeRezervacije"));
                } else {
                    product.setStock(0.0);
                    product.setStock(0.0);
                }
                list.add((java.lang.Object)product);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getNewProductsTrgovinaListBack(ScreensController controller, String limit, String filter, String textFilter) {
        LocalDateTime pocetnostanjeDateTime = LocalDateTime.now();
        String query = null;
        pocetnostanjeDateTime = WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), new java.util.Date(), controller.getSettings().getConnection());
        query = " SELECT\r\np.*,\r\npd.ProductDepartmentID, \r\np.Code as Kod, \r\np.Name,\r\nu.Code as JM,\r\nbc.BarCode as BarKod,\r\n current_price_before_date(p.ProductID, NOW(), 1) AS Cena, CASE \r\n \tWHEN false THEN\r\n\t\t(SELECT ROUND(AVG(dd.PurchacePrice), 4) AS PurchacePrice FROM documentdetails dd LEFT JOIN document d ON d.DocumentID = dd.DocumentID \r\n\t\t\tWHERE d.DocumentTypeID = 1 AND d.Date >= '" + pocetnostanjeDateTime + "' AND dd.ProductID = p.ProductID)\r\n\tELSE\r\n\t\t0\r\nEND AS SrednjaNabavna \r\nFROM product p \r\nLEFT JOIN productdepartment pd ON pd.ProductID = p.ProductID\r\nLEFT JOIN unit u ON u.UnitID = p.UnitID\r\nLEFT JOIN barcode bc ON bc.ProductID = p.ProductID\r\nWHERE IF('" + filter + "' = '\u0160ifra', (p.Code LIKE '" + textFilter + "%' OR bc.BarCode LIKE '" + textFilter + "%'), p.ProductID > 0)\r\nAND IF('" + filter + "' = 'Naziv', p.Name LIKE '" + textFilter + "%', p.ProductID > 0)\r\nAND IF('" + filter + "' = 'Barkod', bc.BarCode LIKE '" + textFilter + "%', p.ProductID > 0)\r\nAND (IF('" + filter + "' = 'Sve', bc.BarCode LIKE '" + textFilter + "%', p.ProductID > 0)\r\nOR IF('" + filter + "' = 'Sve', p.Name LIKE '%" + textFilter + "%', p.ProductID > 0)\r\nOR IF('" + filter + "' = 'Sve', p.Code LIKE '" + textFilter + "%', p.ProductID > 0))  GROUP BY bc.BarCode  \r\nORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC, p.Code, p.Name, p.ShortName LIMIT " + limit;
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.plucode = rs.getString("PLUcode");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.NetAmount = rs.getDouble("NetAmount");
                product.NetAmountTypeID = rs.getInt("NetAmountTypeID");
                product.Measurable = rs.getBoolean("Measurable");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.price = rs.getDouble("Cena");
                product.barcode = rs.getString("BarKod");
                product.UnitName = rs.getString("JM");
                product.setProductDepartmentID(rs.getLong("ProductDepartmentID"));
                list.add((java.lang.Object)product);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getFilteredDetailsList(String productCategoryIDS, String vatIDS, boolean active, String popustDozvoljen, String merljiv, String tezinski, HashMap<Long, ObservableList<Long>> hashMap, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        ObservableList<Product> listStock = null;
        ObservableList<Product> listStockReservation = null;
        String dodatniQuery = "";
        String komplet = "";
        int broj = -1;
        for (Map.Entry<Long, ObservableList<Long>> entry : hashMap.entrySet()) {
            for (Long l : entry.getValue()) {
                ++broj;
                dodatniQuery = dodatniQuery + "SELECT * FROM aditionalfielddetailsproduct afdp WHERE (afdp.AditionalFieldID = " + entry.getKey() + " AND afdp.AditionalFieldDetailsID = " + l + ")\r\n";
                dodatniQuery = dodatniQuery + "UNION\r\n";
            }
        }
        if (!dodatniQuery.equals("")) {
            komplet = "AND p.ProductID IN (SELECT ProductID \r\n\t\t\tFROM (\r\n\t\t\t" + dodatniQuery.substring(0, dodatniQuery.length() - 7) + ") AS Nesto\r\n\t\t\tGROUP BY ProductID\r\n\t\t\tHAVING COUNT(*) > " + broj + ")\r\n";
        }
        String query = "SELECT p.*, current_price_before_date(p.ProductID, NOW(), 1) AS Price, bc.BarCode\r\nFROM product p\r\nLEFT JOIN barcode bc ON bc.ProductID = p.ProductID\r\nWHERE p.ProductTypeID = 1\r\n" + komplet + "AND ('-1' = '" + vatIDS + "' OR FIND_IN_SET(p.VatID, '" + vatIDS + "')) \r\nAND ('-1' = '" + productCategoryIDS + "' OR FIND_IN_SET(p.ProductCategoryID, '" + productCategoryIDS + "'))\r\nAND ('-1' = '" + tezinski + "' OR p.ProductID IN (SELECT bc.ProductID FROM barcode bc WHERE bc.IsWeight = " + tezinski + "))\r\nAND ('-1' = '" + merljiv + "' OR p.Measurable = " + merljiv + ")\r\nAND ('-1' = '" + popustDozvoljen + "' OR p.DiscountAllowed = " + popustDozvoljen + ") \r\nAND p.Active IS TRUE\r\nGROUP BY bc.ProductID \r\nORDER BY LENGTH(p.Code), p.Code, p.Name, p.ShortName";
        if (!controller.getSettings().isSellWithoutStock()) {
            listStock = Product.getNewProductStockList(controller);
            listStockReservation = Product.getNewProductReservationStockList(controller);
        }
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.plucode = rs.getString("PLUcode");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.UnitName = Unit.getUnitById(product.getUnitID(), controller.getSettings().getConnection()).getName();
                product.NetAmount = rs.getDouble("NetAmount");
                product.NetAmountTypeID = rs.getInt("NetAmountTypeID");
                product.Measurable = rs.getBoolean("Measurable");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.barcode = rs.getString("BarCode");
                product.price = rs.getDouble("Price");
                if (!controller.getSettings().isSellWithoutStock()) {
                    for (Product p : listStock) {
                        if (p.getProductID() != product.getProductID()) continue;
                        product.setStock(p.getStock());
                    }
                    for (Product p : listStockReservation) {
                        if (p.getProductID() != product.getProductID()) continue;
                        product.setStockReservation(p.getStockReservation());
                    }
                }
                product.barcodeLast = Barcode.getBarCode(product.getProductID(), controller.getSettings().getConnection());
                if (AditionalFieldDetailsProduct.isEmtryList(controller, product)) {
                    product.setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID(product.getProductID(), controller.getSettings().getConnection()));
                }
                list.add((java.lang.Object)product);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String convertArrayToStringMethod(ObservableList<Long> lista) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < lista.size(); ++i) {
            stringBuilder.append(",").append(lista.get(i));
        }
        return stringBuilder.toString();
    }

    public static ObservableList<Product> getFilteredDetailsListNew(String productCategoryIDS, String vatIDS, String popustDozvoljen, String merljiv, String tezinski, HashMap<Long, ObservableList<Long>> hashMap, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        ObservableList<Product> listStock = null;
        ObservableList<Product> listStockReservation = null;
        String dodatniQuery = "";
        int broj = -1;
        for (Map.Entry<Long, ObservableList<Long>> entry : hashMap.entrySet()) {
            if (!hashMap.get(entry.getKey()).isEmpty()) {
                ++broj;
            }
            String mini = Product.convertArrayToStringMethod(hashMap.get(entry.getKey()));
            dodatniQuery = dodatniQuery + "(afdp.AditionalFieldID = " + entry.getKey() + " AND FIND_IN_SET(afdp.AditionalFieldDetailsID, '" + (mini.length() == 0 ? "" : mini.substring(1, mini.length())) + "')) OR\r\n";
        }
        System.out.println(dodatniQuery);
        System.out.println(broj);
        String query = "SELECT p.*, COUNT(*) c, pd.ProductDepartmentID, current_price_before_date(p.ProductID, NOW(), 1) AS Price, bc.BarCode\r\nFROM product p\r\nLEFT JOIN barcode bc ON bc.ProductID = p.ProductID\r\nLEFT JOIN productdepartment pd ON pd.ProductID = p.ProductID\r\nLEFT JOIN aditionalfielddetailsproduct afdp ON afdp.ProductID = p.ProductID\r\nWHERE p.ProductTypeID = 1\r\nAND ('-1' = '" + vatIDS + "' OR FIND_IN_SET(p.VatID, '" + vatIDS + "')) \r\nAND ('-1' = '" + productCategoryIDS + "' OR FIND_IN_SET(p.ProductCategoryID, '" + productCategoryIDS + "'))\r\nAND ('-1' = '" + tezinski + "' OR p.ProductID IN (SELECT bc.ProductID FROM barcode bc WHERE bc.IsWeight = " + tezinski + "))\r\nAND ('-1' = '" + merljiv + "' OR p.Measurable = " + merljiv + ")\r\nAND ('-1' = '" + popustDozvoljen + "' OR p.DiscountAllowed = " + popustDozvoljen + ") \r\nAND p.Active IS TRUE\r\nAND (" + dodatniQuery.substring(0, dodatniQuery.length() - 6) + "))\r\nGROUP BY afdp.ProductID HAVING c > " + broj + "\r\nORDER BY LENGTH(p.Code), p.Code, p.Name, p.ShortName";
        if (!controller.getSettings().isSellWithoutStock()) {
            listStock = Product.getNewProductStockList(controller);
            listStockReservation = Product.getNewProductReservationStockList(controller);
        }
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.plucode = rs.getString("PLUcode");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.UnitName = Unit.getUnitById(product.getUnitID(), controller.getSettings().getConnection()).getName();
                product.NetAmount = rs.getDouble("NetAmount");
                product.NetAmountTypeID = rs.getInt("NetAmountTypeID");
                product.Measurable = rs.getBoolean("Measurable");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.barcode = rs.getString("BarCode");
                product.price = rs.getDouble("Price");
                if (!controller.getSettings().isSellWithoutStock()) {
                    for (Product p : listStock) {
                        if (p.getProductID() != product.getProductID()) continue;
                        product.setStock(p.getStock());
                    }
                    for (Product p : listStockReservation) {
                        if (p.getProductID() != product.getProductID()) continue;
                        product.setStockReservation(p.getStockReservation());
                    }
                }
                product.barcodeLast = Barcode.getBarCode(product.getProductID(), controller.getSettings().getConnection());
                if (AditionalFieldDetailsProduct.isEmtryList(controller, product)) {
                    product.setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID(product.getProductID(), controller.getSettings().getConnection()));
                }
                list.add((java.lang.Object)product);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Product> getNewFilteredList(String departmentIDS, String pointOfSaleIDS, String productTypeIDS, String productCategoryIDS, String aditionalFieldIDS, String aditionalFieldDetailsIDS, String vatIDS, boolean active, String popustDozvoljen, String merljiv, String tezinski, ScreensController controller) {
        String query = "";
        ObservableList<Product> listStock = null;
        ObservableList<Product> listStockReservation = null;
        query = "SELECT pd.ProductDepartmentID, p.*, current_price_before_date(p.ProductID, NOW(), pd.DepartmentID) AS Price, bc.BarCode\r\nFROM product p\r\nLEFT JOIN productdepartment pd ON pd.ProductID = p.ProductID\r\nLEFT JOIN unit u ON u.UnitID = p.UnitID\r\nLEFT JOIN barcode bc ON bc.ProductID = p.ProductID\r\nLEFT JOIN pointofsaledepartment posd ON posd.DepartmentID = pd.DepartmentID\r\nLEFT JOIN aditionalfielddetailsproduct afdp ON afdp.ProductID = pd.ProductID\r\nWHERE p.ProductTypeID = 1\r\nAND('-1' = '" + departmentIDS + "' OR FIND_IN_SET(posd.DepartmentID, '" + departmentIDS + "'))\r\nAND ('-1' = '" + pointOfSaleIDS + "' OR FIND_IN_SET(posd.PointOfSaleID, '" + pointOfSaleIDS + "'))\r\nAND ('-1' = '" + productTypeIDS + "' OR FIND_IN_SET(p.ProductTypeID, '" + productTypeIDS + "'))\r\nAND ('-1' = '" + vatIDS + "' OR FIND_IN_SET(p.VatID, '" + vatIDS + "')) AND ('-1' = '" + productCategoryIDS + "' OR FIND_IN_SET(p.ProductCategoryID, '" + productCategoryIDS + "'))\r\n AND ('-1' = '" + aditionalFieldIDS + "' OR FIND_IN_SET(afdp.AditionalFieldID, '" + aditionalFieldIDS + "'))\r\n AND ('-1' = '" + aditionalFieldDetailsIDS + "' OR FIND_IN_SET(afdp.AditionalFieldDetailsID, '" + aditionalFieldDetailsIDS + "')) AND ('-1' = '" + tezinski + "' OR p.ProductID IN (SELECT bc.ProductID FROM barcode bc WHERE bc.IsWeight = " + tezinski + "))\r\nAND ('-1' = '" + merljiv + "' OR p.Measurable = " + merljiv + ")\r\n AND ('-1' = '" + popustDozvoljen + "' OR p.DiscountAllowed = " + popustDozvoljen + ") AND p.Active IS " + active + "  GROUP BY p.ProductID,bc.BarCodeID ORDER BY LENGTH(p.Code), p.Code, p.Name, p.ShortName";
        if (!controller.getSettings().isSellWithoutStock()) {
            listStock = Product.getNewProductStockList(controller);
            listStockReservation = Product.getNewProductReservationStockList(controller);
        }
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.ProductID = rs.getLong("ProductID");
                product.ProductTypeID = rs.getInt("ProductTypeID");
                product.ProductCategoryID = rs.getInt("ProductCategoryID");
                product.Code = rs.getString("Code");
                product.plucode = rs.getString("PLUcode");
                product.Name = rs.getString("Name");
                product.ShortName = rs.getString("ShortName");
                product.VatID = rs.getInt("VatID");
                product.UnitID = rs.getInt("UnitID");
                product.Active = rs.getBoolean("Active");
                product.sysDTCreated = new java.util.Date(rs.getDate("sysDTCreated").getTime());
                try {
                    product.sysDTEdit = new java.util.Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.sysUserAddID = rs.getLong("sysUserAddID");
                product.sysUserEditID = rs.getLong("sysUserEditID");
                product.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                product.UnitName = Unit.getUnitById(product.getUnitID(), controller.getSettings().getConnection()).getName();
                product.NetAmount = rs.getDouble("NetAmount");
                product.NetAmountTypeID = rs.getInt("NetAmountTypeID");
                product.Measurable = rs.getBoolean("Measurable");
                product.DiscountAllowed = rs.getBoolean("DiscountAllowed");
                product.writeOff = rs.getDouble("WriteOff");
                product.barcode = rs.getString("BarCode");
                product.price = rs.getDouble("Price");
                if (!controller.getSettings().isSellWithoutStock()) {
                    for (Product p : listStock) {
                        if (p.getProductID() != product.getProductID()) continue;
                        product.setStock(p.getStock());
                    }
                    for (Product p : listStockReservation) {
                        if (p.getProductID() != product.getProductID()) continue;
                        product.setStockReservation(p.getStockReservation());
                    }
                }
                product.barcodeLast = Barcode.getBarCode(product.getProductID(), controller.getSettings().getConnection());
                if (AditionalFieldDetailsProduct.isEmtryList(controller, product)) {
                    product.setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID(product.getProductID(), controller.getSettings().getConnection()));
                }
                list.add((java.lang.Object)product);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int alreadyExist(long productID, ObservableList<Product> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (((Product)list.get(i)).getProductID() != productID) continue;
            return i;
        }
        return -1;
    }

    public static String getUnit(int unitId, ScreensController controller) {
        String queryString = "SELECT u.Code FROM unit u WHERE u.UnitID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(queryString);
            ps.setInt(1, unitId);
            ResultSet rSet = ps.executeQuery();
            rSet.next();
            return rSet.getString("Code");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getNetAmoubtUnit(int unitId, ScreensController controller) {
        String queryString = "SELECT * FROM netamounttype na WHERE na.NetAmountTypeID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(queryString);
            ps.setInt(1, unitId);
            ResultSet rSet = ps.executeQuery();
            rSet.next();
            return rSet.getString("Code");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean codeExsists(String code, String filter, Connection connection) throws SQLException {
        String query = "SELECT COUNT(p.ProductID) AS codeQuantity FROM product p WHERE p.code = ?\r\n" + filter;
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setString(1, code);
        ResultSet rs = ps.executeQuery();
        rs.next();
        int codeQuantity = rs.getInt("codeQuantity");
        return codeQuantity > 0;
    }
}

