/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.product.Product;

public class GroupPointOfSaleProduct {
    private static long GroupProductID;
    private int GroupID;
    private long ProductID;
    private long ProductDepartmentID;
    private int Sort;
    private boolean Active;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private int position;
    private String color;
    private String ColorDodatni;
    private int PointOfSaleID;
    private String GroupName;
    private String DodatniName;
    private int PositionDodatni;
    private boolean ActiveDodatni;

    public boolean isActiveDodatni() {
        return this.ActiveDodatni;
    }

    public void setActiveDodatni(boolean activeDodatni) {
        this.ActiveDodatni = activeDodatni;
    }

    public String getColorDodatni() {
        return this.ColorDodatni;
    }

    public void setColorDodatni(String colorDodatni) {
        this.ColorDodatni = colorDodatni;
    }

    public int getPositionDodatni() {
        return this.PositionDodatni;
    }

    public void setPositionDodatni(int positiondodatni) {
        this.PositionDodatni = positiondodatni;
    }

    public String getDodatniName() {
        return this.DodatniName;
    }

    public void setDodatniName(String dodatniName) {
        this.DodatniName = dodatniName;
    }

    public long getGroupProductID() {
        return GroupProductID;
    }

    public void setGroupProductID(long groupProductID) {
        GroupProductID = groupProductID;
    }

    public int getGroupID() {
        return this.GroupID;
    }

    public void setGroupID(int groupID) {
        this.GroupID = groupID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public long getProductDepartmentID() {
        return this.ProductDepartmentID;
    }

    public void setProductDepartmentID(long productDepartmentID) {
        this.ProductDepartmentID = productDepartmentID;
    }

    public int getSort() {
        return this.Sort;
    }

    public void setSort(int sort) {
        this.Sort = sort;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public int getPointOfSaleID() {
        return this.PointOfSaleID;
    }

    public void setPointOfSaleID(int pointOfSaleID) {
        this.PointOfSaleID = pointOfSaleID;
    }

    public String getGroupName() {
        return this.GroupName;
    }

    public void setGroupName(String groupName) {
        this.GroupName = groupName;
    }

    public static ObservableList<GroupPointOfSaleProduct> getListPosition(int posID, int groupID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT gposp.position  FROM grouppointofsaleproduct  gposp WHERE gposp.PointOfSaleID = ? AND gposp.GroupID = ? ORDER BY gposp.position";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, posID);
            ps.setInt(2, groupID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GroupPointOfSaleProduct gpp = new GroupPointOfSaleProduct();
                gpp.position = rs.getInt("position");
                list.add((Object)gpp);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<GroupPointOfSaleProduct> getAdditionalList(PointOfSale pos, Long p1, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT DISTINCT gposp.*, p.Name, gpp.position as PositionDodatni, gpp.Active as ActiveDodatni, gpp.color as ColorDodatni FROM grouppointofsaleproduct gposp JOIN productaditional pa ON pa.ParentProductID = gposp.ProductID JOIN product p ON p.ProductID = pa.ChildProductID JOIN product p1 ON p1.ProductID = gposp.ProductID JOIN grouppointofsaleproduct gpp ON gpp.ProductID = pa.ChildProductID WHERE gposp.PointOfSaleID = ? AND p1.ProductID = ? ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pos.getPointOfSaleID());
            ps.setLong(2, p1);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GroupPointOfSaleProduct gpp = new GroupPointOfSaleProduct();
                GroupProductID = rs.getLong("GroupProductID");
                gpp.GroupID = rs.getInt("GroupID");
                gpp.ProductID = rs.getLong("ProductID");
                gpp.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                gpp.Sort = rs.getInt("Sort");
                gpp.Active = rs.getBoolean("Active");
                try {
                    gpp.sysDTCreated = new Date(rs.getTimestamp("sysDTCreated").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    gpp.sysDTEdit = new Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                gpp.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    gpp.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                gpp.position = rs.getInt("position");
                gpp.color = rs.getString("color");
                gpp.PointOfSaleID = rs.getInt("PointOfSaleID");
                gpp.DodatniName = rs.getString("Name");
                gpp.PositionDodatni = rs.getInt("PositionDodatni");
                gpp.ActiveDodatni = rs.getBoolean("ActiveDodatni");
                gpp.ColorDodatni = rs.getString("ColorDodatni");
                list.add((Object)gpp);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<GroupPointOfSaleProduct> getListGroup(PointOfSale pos, Product product, String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT DISTINCT g.*, gpp.Sort as position  FROM grouppointofsaleproduct gpp  LEFT JOIN `group` g ON g.GroupID = gpp.GroupID  WHERE gpp.PointOfSaleID = ? AND gpp.ProductID = ?   AND g.Name LIKE ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pos.getPointOfSaleID());
            if (product != null) {
                ps.setLong(2, product.getProductID());
            } else {
                ps.setNull(2, -5);
            }
            ps.setString(3, "%" + filter + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GroupPointOfSaleProduct gpp = new GroupPointOfSaleProduct();
                gpp.GroupID = rs.getInt("GroupID");
                gpp.GroupName = rs.getString("Name");
                gpp.Active = rs.getBoolean("Active");
                list.add((Object)gpp);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<GroupPointOfSaleProduct> getListProductGroup(PointOfSale pos, Product product, String filter, int groupID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT DISTINCT gpp.*  FROM grouppointofsaleproduct gpp  LEFT JOIN `group` g ON g.GroupID = gpp.GroupID  WHERE gpp.PointOfSaleID = ? AND gpp.ProductID = ? AND g.GroupID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pos.getPointOfSaleID());
            if (product != null) {
                ps.setLong(2, product.getProductID());
            } else {
                ps.setNull(2, -5);
            }
            ps.setInt(3, groupID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GroupPointOfSaleProduct gpp = new GroupPointOfSaleProduct();
                GroupProductID = rs.getLong("GroupProductID");
                gpp.GroupID = rs.getInt("GroupID");
                gpp.ProductID = rs.getLong("ProductID");
                gpp.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                gpp.Sort = rs.getInt("Sort");
                gpp.Active = rs.getBoolean("Active");
                try {
                    gpp.sysDTCreated = new Date(rs.getTimestamp("sysDTCreated").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    gpp.sysDTEdit = new Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                gpp.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    gpp.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                gpp.PointOfSaleID = rs.getInt("PointOfSaleID");
                list.add((Object)gpp);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void insert(int position, Connection connection) {
        String query = "INSERT INTO grouppointofsaleproduct (\t`GroupID`,\t`ProductID`,\t ProductDepartmentID,\t`Sort`,\t`Active`,\t`sysDTCreated`,\t`sysUserAddID`,\t`position`,\t`color`,\t`PointOfSaleID`) VALUES (?,?,?,?,?,now(),?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.GroupID);
            ps.setLong(2, this.ProductID);
            ps.setLong(3, this.ProductDepartmentID);
            ps.setInt(4, this.Sort);
            ps.setBoolean(5, this.Active);
            ps.setLong(6, this.sysUserAddID);
            ps.setInt(7, position);
            ps.setString(8, this.color);
            ps.setInt(9, this.PointOfSaleID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insertTrgovina(Connection connection) {
        String query = "INSERT INTO grouppointofsaleproduct (\t`GroupID`,\t`ProductID`,\t ProductDepartmentID,\t`Sort`,\t`Active`,\t`sysDTCreated`,\t`sysUserAddID`,\t`PointOfSaleID`) VALUES (?,?,?,?,?,now(),?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.GroupID);
            ps.setLong(2, this.ProductID);
            ps.setLong(3, this.ProductDepartmentID);
            ps.setInt(4, this.Sort);
            ps.setBoolean(5, this.Active);
            ps.setLong(6, this.sysUserAddID);
            ps.setInt(7, this.PointOfSaleID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(Connection connection) {
        String query = "UPDATE grouppointofsaleproduct SET \t`GroupID` = ?,\t`ProductID` = ?,\t`Sort` = ?,\t`Active` = ?,\t`sysDTEdit` = now(),\t`sysUserEditID` = ?,\t`position` = ?,`color` = ?,\t`PointOfSaleID` = ? WHERE `GroupProductID` = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.GroupID);
            ps.setLong(2, this.ProductID);
            ps.setLong(3, this.ProductDepartmentID);
            ps.setInt(4, this.Sort);
            ps.setBoolean(5, this.Active);
            ps.setLong(6, this.sysUserEditID);
            ps.setInt(7, this.position);
            ps.setString(8, this.color);
            ps.setInt(9, this.PointOfSaleID);
            ps.setLong(10, GroupProductID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(long groupProductID, Connection connection) {
        String query = "DELETE FROM grouppointofsaleproduct WHERE GroupProductID= ? ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, groupProductID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

