/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class GroupPointOfSale {
    private int GroupPointOfSaleID;
    private int GroupID;
    private int PointOfSaleID;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private int Sort;
    private int ParentGroupID;

    public int getGroupPointOfSaleID() {
        return this.GroupPointOfSaleID;
    }

    public void setGroupPointOfSaleID(int groupPointOfSaleID) {
        this.GroupPointOfSaleID = groupPointOfSaleID;
    }

    public int getGroupID() {
        return this.GroupID;
    }

    public void setGroupID(int groupID) {
        this.GroupID = groupID;
    }

    public int getPointOfSaleID() {
        return this.PointOfSaleID;
    }

    public void setPointOfSaleID(int pointOfSaleID) {
        this.PointOfSaleID = pointOfSaleID;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public int getSort() {
        return this.Sort;
    }

    public void setSort(int sort) {
        this.Sort = sort;
    }

    public int getParentGroupID() {
        return this.ParentGroupID;
    }

    public void setParentGroupID(int parentGroupID) {
        this.ParentGroupID = parentGroupID;
    }

    public static GroupPointOfSale getFromDb(int pos, int group, Connection connection) throws SQLException {
        String query = "select * from grouppointofsale where PointOfSaleID = ? and GroupID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setInt(1, pos);
        ps.setInt(2, group);
        ResultSet rs = ps.executeQuery();
        rs.next();
        GroupPointOfSale gps = new GroupPointOfSale();
        gps.setGroupPointOfSaleID(rs.getInt("GroupPointOfSaleID"));
        gps.setGroupID(rs.getInt("GroupID"));
        gps.setPointOfSaleID(rs.getInt("PointOfSaleID"));
        gps.setSysDTCreated(rs.getTimestamp("sysDTCreated"));
        try {
            gps.setSysDTEdit(rs.getTimestamp("sysDTEdit"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        gps.setSysUserAddID(rs.getLong("sysUserAddID"));
        gps.setSysUserEditID(rs.getLong("sysUserEditID"));
        gps.setSort(rs.getInt("Sort"));
        gps.setParentGroupID(rs.getInt("ParentGroupID"));
        ps.close();
        rs.close();
        return gps;
    }

    public static ObservableList<GroupPointOfSale> getListForPOS(int groupID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT DISTINCT gpos.* FROM grouppointofsale gpos WHERE gpos.GroupID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, groupID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GroupPointOfSale gps = new GroupPointOfSale();
                gps.setGroupPointOfSaleID(rs.getInt("GroupPointOfSaleID"));
                gps.setGroupID(rs.getInt("GroupID"));
                gps.setPointOfSaleID(rs.getInt("PointOfSaleID"));
                gps.setSysDTCreated(rs.getTimestamp("sysDTCreated"));
                try {
                    gps.setSysDTEdit(rs.getTimestamp("sysDTEdit"));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                gps.setSysUserAddID(rs.getLong("sysUserAddID"));
                gps.setSysUserEditID(rs.getLong("sysUserEditID"));
                gps.setSort(rs.getInt("Sort"));
                gps.setParentGroupID(rs.getInt("ParentGroupID"));
                list.add((Object)gps);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<GroupPointOfSale> getListSortForPOS(int pointOfSaleID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT gpos.* FROM grouppointofsale gpos WHERE gpos.PointOfSaleID = ? GROUP BY gpos.Sort";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pointOfSaleID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GroupPointOfSale gps = new GroupPointOfSale();
                gps.setGroupPointOfSaleID(rs.getInt("GroupPointOfSaleID"));
                gps.setGroupID(rs.getInt("GroupID"));
                gps.setPointOfSaleID(rs.getInt("PointOfSaleID"));
                gps.setSysDTCreated(rs.getTimestamp("sysDTCreated"));
                try {
                    gps.setSysDTEdit(rs.getTimestamp("sysDTEdit"));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                gps.setSysUserAddID(rs.getLong("sysUserAddID"));
                gps.setSysUserEditID(rs.getLong("sysUserEditID"));
                gps.setSort(rs.getInt("Sort"));
                gps.setParentGroupID(rs.getInt("ParentGroupID"));
                list.add((Object)gps);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<GroupPointOfSale> getListSortForPOSParent(int pointOfSaleID, int parentGroupID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT gpos.* FROM grouppointofsale gpos WHERE gpos.PointOfSaleID = ? and gpos.ParentGroupID = ? GROUP BY gpos.Sort";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pointOfSaleID);
            ps.setInt(1, parentGroupID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GroupPointOfSale gps = new GroupPointOfSale();
                gps.setGroupPointOfSaleID(rs.getInt("GroupPointOfSaleID"));
                gps.setGroupID(rs.getInt("GroupID"));
                gps.setPointOfSaleID(rs.getInt("PointOfSaleID"));
                gps.setSysDTCreated(rs.getTimestamp("sysDTCreated"));
                try {
                    gps.setSysDTEdit(rs.getTimestamp("sysDTEdit"));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                gps.setSysUserAddID(rs.getLong("sysUserAddID"));
                gps.setSysUserEditID(rs.getLong("sysUserEditID"));
                gps.setSort(rs.getInt("Sort"));
                gps.setParentGroupID(rs.getInt("ParentGroupID"));
                list.add((Object)gps);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int getMaxPositionGrupe(int pointOfSaleID, Connection connection) {
        String query = "SELECT MAX(Sort) Sort FROM `grouppointofsale` WHERE ParentGroupID IS NULL and PointOfSaleID = ?";
        GroupPointOfSale gpos = new GroupPointOfSale();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pointOfSaleID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            gpos.Sort = rs.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return gpos.Sort;
    }

    public static int getMaxPositionPodgrupe(int parentGroupID, int pointOfSaleID, Connection connection) {
        String query = "SELECT MAX(Sort) Sort FROM `grouppointofsale` WHERE ParentGroupID = ? and PointOfSaleID = ?";
        GroupPointOfSale gpos = new GroupPointOfSale();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, parentGroupID);
            ps.setInt(2, pointOfSaleID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            gpos.Sort = rs.getInt(1);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return gpos.Sort;
    }

    public static void insert(int groupID, int posID, int sort, int parentGroupID, Connection connection) {
        String query1 = "INSERT INTO grouppointofsale (`GroupID`, `PointOfSaleID`, `Sort`, `ParentGroupID`, `sysUserAddID`) VALUES (?, ?, ?, ?, 1);";
        try {
            PreparedStatement ps = connection.prepareStatement(query1);
            ps.setInt(1, groupID);
            ps.setInt(2, posID);
            ps.setInt(3, sort);
            if (parentGroupID == 0) {
                ps.setString(4, null);
            } else {
                ps.setInt(4, parentGroupID);
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void delete(int groupID, Connection connection) {
        String query = "DELETE FROM grouppointofsale WHERE  GroupID in (?,  (select g.GroupID from `group` g  where g.ParentGroupID = ?))";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, groupID);
            ps.setInt(2, groupID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteWithPOS(int groupID, int posID, Connection connection) {
        String query = "DELETE FROM grouppointofsale WHERE  GroupID = ? AND PointOfSaleID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, groupID);
            ps.setInt(2, posID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

