/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;
import rs.petcom.master.dal.product.AditionalFieldDetails;

public class AditionalField {
    private long AditionalFieldID;
    private String Name;
    private boolean Front;
    private boolean Backoffice;
    private boolean selected;
    private ObservableList<AditionalFieldDetails> listAditionalFieldDetails;
    private AditionalFieldDetails aditionalFieldDetails;
    private String aditionalFieldDetail;
    private CheckBox selectBox;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setListAditionalFieldDetails(ObservableList<AditionalFieldDetails> listAditionalFieldDetails) {
        this.listAditionalFieldDetails = listAditionalFieldDetails;
    }

    public ObservableList<AditionalFieldDetails> getListAditionalFieldDetails() {
        return this.listAditionalFieldDetails;
    }

    public long getAditionalFieldID() {
        return this.AditionalFieldID;
    }

    public void setAditionalFieldID(long aditionalFieldID) {
        this.AditionalFieldID = aditionalFieldID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public boolean isFront() {
        return this.Front;
    }

    public void setFront(boolean front) {
        this.Front = front;
    }

    public boolean isBackoffice() {
        return this.Backoffice;
    }

    public void setBackoffice(boolean backoffice) {
        this.Backoffice = backoffice;
    }

    public AditionalFieldDetails getAditionalFieldDetails() {
        return this.aditionalFieldDetails;
    }

    public void setAditionalFieldDetails(AditionalFieldDetails aditionalFieldDetails) {
        this.aditionalFieldDetails = aditionalFieldDetails;
    }

    public String getAditionalFieldDetail() {
        return this.aditionalFieldDetail;
    }

    public void setAditionalFieldDetail(String aditionalFieldDetail) {
        this.aditionalFieldDetail = aditionalFieldDetail;
    }

    public CheckBox getSelectBox() {
        return this.selectBox;
    }

    public void setSelectBox(CheckBox selectBox) {
        this.selectBox = selectBox;
    }

    public AditionalField() {
    }

    public AditionalField(long aditionalFieldID, String name) {
        this.AditionalFieldID = aditionalFieldID;
        this.Name = name;
    }

    public void delete(Connection connection) throws SQLException {
        String query = "DELETE FROM `aditionalfield` WHERE  `AditionalFieldID`=?;";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.AditionalFieldID);
        ps.executeUpdate();
        ps.close();
    }

    public void insert(Connection connection) {
        String query = "INSERT INTO `aditionalfield` (`Name`, `Front`, `Backoffice`) VALUES (?, ?, ?);";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, this.Name);
            ps.setBoolean(2, this.Front);
            ps.setBoolean(3, this.Backoffice);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insertServer(Connection connection) throws SQLException {
        String query = "INSERT INTO `aditionalfield` (`AditionalFieldID`, `Name`, `Front`, `Backoffice`) VALUES (?, ?, ?, ?);";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.AditionalFieldID);
        ps.setString(2, this.Name);
        ps.setBoolean(3, this.Front);
        ps.setBoolean(4, this.Backoffice);
        ps.executeUpdate();
        ps.close();
    }

    public void update(Connection connection) {
        String query = "UPDATE `aditionalfield` SET `Name`=?, `Front`=?, `Backoffice`=? WHERE  `AditionalFieldID`=?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, this.Name);
            ps.setBoolean(2, this.Front);
            ps.setBoolean(3, this.Backoffice);
            ps.setLong(4, this.AditionalFieldID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<AditionalField> getList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from aditionalfield";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AditionalField aditionalField = new AditionalField();
                aditionalField.AditionalFieldID = rs.getLong("AditionalFieldID");
                aditionalField.Front = rs.getBoolean("Front");
                aditionalField.Backoffice = rs.getBoolean("Backoffice");
                aditionalField.Name = rs.getString("Name");
                list.add((Object)aditionalField);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<AditionalField> getListWithFilter(String aditionalFieldID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from aditionalfield af ";
        if (!aditionalFieldID.equals("")) {
            query = query + "where af.AditionalFieldID IN (" + aditionalFieldID + ")";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AditionalField aditionalField = new AditionalField();
                aditionalField.AditionalFieldID = rs.getLong("AditionalFieldID");
                aditionalField.Front = rs.getBoolean("Front");
                aditionalField.Backoffice = rs.getBoolean("Backoffice");
                aditionalField.Name = rs.getString("Name");
                list.add((Object)aditionalField);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<AditionalField> getFrontBack(boolean front, Connection connection) {
        ArrayList<AditionalField> list = new ArrayList<AditionalField>();
        String query = "select * from aditionalfield where " + (front ? "Front=1" : "Backoffice=1");
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AditionalField aditionalField = new AditionalField();
                aditionalField.AditionalFieldID = rs.getLong("AditionalFieldID");
                aditionalField.Front = rs.getBoolean("Front");
                aditionalField.Backoffice = rs.getBoolean("Backoffice");
                aditionalField.Name = rs.getString("Name");
                list.add(aditionalField);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<AditionalField> getListByProduct(long productID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select af.* from aditionalfield af join aditionalfielddetailsproduct afdp on afdp.AditionalFieldID = af.AditionalFieldID where afdp.ProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AditionalField aditionalField = new AditionalField();
                aditionalField.AditionalFieldID = rs.getLong("AditionalFieldID");
                aditionalField.Front = rs.getBoolean("Front");
                aditionalField.Backoffice = rs.getBoolean("Backoffice");
                aditionalField.Name = rs.getString("Name");
                list.add((Object)aditionalField);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static AditionalField getByName(String name, Connection connection) {
        String query = "SELECT * FROM aditionalfield af WHERE af.Name = '" + name + "'";
        AditionalField aditionalField = null;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                aditionalField = new AditionalField();
                aditionalField.AditionalFieldID = rs.getLong("AditionalFieldID");
                aditionalField.Front = rs.getBoolean("Front");
                aditionalField.Backoffice = rs.getBoolean("Backoffice");
                aditionalField.Name = rs.getString("Name");
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return aditionalField;
    }

    public static AditionalField getById(long id, Connection connection) {
        String query = "SELECT * FROM aditionalfield af WHERE af.AditionalFieldID = " + id + "";
        AditionalField aditionalField = null;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                aditionalField = new AditionalField();
                aditionalField.AditionalFieldID = rs.getLong("AditionalFieldID");
                aditionalField.Front = rs.getBoolean("Front");
                aditionalField.Backoffice = rs.getBoolean("Backoffice");
                aditionalField.Name = rs.getString("Name");
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return aditionalField;
    }

    public static AditionalField getByProductID(long productID, long aditionalfieldid, Connection connection) {
        String query = "select afd.* from aditionalfielddetailsproduct afdp  join aditionalfielddetails afd on afd.AditionalFieldDetailsID = afdp.AditionalFieldDetailsID  where afdp.ProductID = " + productID + " and afd.AditionalFieldID = " + aditionalfieldid;
        AditionalField aditionalField = null;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                aditionalField = new AditionalField();
                aditionalField.AditionalFieldID = rs.getLong("AditionalFieldID");
                aditionalField.Front = rs.getBoolean("Front");
                aditionalField.Backoffice = rs.getBoolean("Backoffice");
                aditionalField.Name = rs.getString("Name");
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return aditionalField;
    }

    public String toString() {
        return this.Name;
    }

    public boolean equals(Object obj) {
        return obj instanceof AditionalField ? this.AditionalFieldID == ((AditionalField)obj).AditionalFieldID : false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

