/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class PersonCategory {
    private int PersonCategoryID;
    private String Name;
    private boolean BuyerCol;
    private boolean SupplierCol;
    public static String BUYER = "Firma";
    public static String SUPPLIER = "Dobavlja\u010d";
    public static String LOYALTY = "Stalni kupac";
    public static String OPERATOR = "operator";
    public static String INTERN_BUYER = "Interna-firma";
    public static String RESERVE = "Kupac";

    public PersonCategory(int PersonCategoryID, String Name, boolean BuyerCol, boolean SupplierCol) {
        this.PersonCategoryID = PersonCategoryID;
        this.Name = Name;
        this.BuyerCol = BuyerCol;
        this.SupplierCol = SupplierCol;
    }

    public void setBuyerCol(boolean buyerCol) {
        this.BuyerCol = buyerCol;
    }

    public boolean isBuyerCol() {
        return this.BuyerCol;
    }

    public void setSupplierCol(boolean supplierCol) {
        this.SupplierCol = supplierCol;
    }

    public boolean isSupplierCol() {
        return this.SupplierCol;
    }

    public int getPersonCategoryID() {
        return this.PersonCategoryID;
    }

    public void setPersonCategoryID(int PersonCategoryID) {
        this.PersonCategoryID = PersonCategoryID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String toString() {
        return this.Name;
    }

    public static ObservableList<PersonCategory> getList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("select * from personcategory");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add((Object)new PersonCategory(rs.getInt("PersonCategoryID"), rs.getString("Name"), rs.getBoolean("Buyer"), rs.getBoolean("Supplier")));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static PersonCategory getByID(int id, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from personcategory where PersonCategoryID = ?");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return new PersonCategory(rs.getInt("PersonCategoryID"), rs.getString("Name"), rs.getBoolean("Buyer"), rs.getBoolean("Supplier"));
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static PersonCategory getByName(String name, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from personcategory where Name = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return new PersonCategory(rs.getInt("PersonCategoryID"), rs.getString("Name"), rs.getBoolean("Buyer"), rs.getBoolean("Supplier"));
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static void insertNewCategory(String string, boolean buyer, boolean supplier, ScreensController controller) {
        String query = "INSERT INTO `personcategory` (`Name`, `Buyer`, `Supplier`) VALUES ('" + string + "', ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setBoolean(1, buyer);
            pStatement.setBoolean(2, supplier);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updateCategory(String string, long id, ScreensController controller) {
        String query = "UPDATE `personcategory` SET `Name` = ? WHERE  `PersonCategoryID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, string);
            pStatement.setLong(2, id);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

