/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.person.Contact;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.LoyaltyGroup;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.person.PersonCategoryEnum;
import rs.petcom.master.dal.person.PersonVatType;

public class Person {
    private long PersonID;
    private int PersonTypeID;
    private int PersonCategoryID;
    private int PersonVatTypeID;
    private String FirstName;
    private String LastName;
    private String IdentificationNumber;
    private String Name;
    private String Address;
    private String City;
    private String ZIP;
    private String names1;
    private String note;
    private String PIB;
    private String MB;
    private boolean Active;
    private boolean Stalni;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private String Code;
    private int CurrencyPaymentDays;
    private double Discount;
    private double sumByBill;
    private double sumByBillWithDiscount;
    private double discountByBill;
    private String phone;
    private String eMail;
    private String mail;
    private Boolean eFaktura;
    private boolean taxExempt;
    private int detailsPrintNumber;
    private String tfJBKJ;
    private String LoyalityCard;
    private long LoyalityID;
    private double LoyalityDiscount;
    private long BuyerOfferPriceID;
    LoyaltyGroup lGroup;
    Loyality loyality;

    public Boolean geteFaktura() {
        return this.eFaktura;
    }

    public void seteFaktura(Boolean eFaktura) {
        this.eFaktura = eFaktura;
    }

    public Person(long personID) {
        this.PersonID = personID;
    }

    public Person(Map<String, Object> map) {
        this.FirstName = String.valueOf(map.get("firstName"));
        this.LastName = String.valueOf(map.get("lastName"));
        this.PIB = String.valueOf(map.get("PIB"));
    }

    public Person() {
    }

    public String getTfJBKJ() {
        return this.tfJBKJ;
    }

    public void setTfJBKJ(String tfJBKJ) {
        this.tfJBKJ = tfJBKJ;
    }

    public String getNames1() {
        return this.FirstName + " " + this.LastName;
    }

    public void setNames1(String names1) {
        this.names1 = this.FirstName + " " + this.LastName;
    }

    public long getBuyerOfferPriceID() {
        return this.BuyerOfferPriceID;
    }

    public void setBuyerOfferPriceID(long buyerOfferPriceID) {
        this.BuyerOfferPriceID = buyerOfferPriceID;
    }

    public void setCurrencyPaymentDays(int currencyPaymentDays) {
        this.CurrencyPaymentDays = currencyPaymentDays;
    }

    public int getCurrencyPaymentDays() {
        return this.CurrencyPaymentDays;
    }

    public void setLoyalityCard(String loyalityCard) {
        this.LoyalityCard = loyalityCard;
    }

    public String getLoyalityCard() {
        return this.LoyalityCard;
    }

    public void setLoyalityID(long loyalityID) {
        this.LoyalityID = loyalityID;
    }

    public long getLoyalityID() {
        return this.LoyalityID;
    }

    public void setLoyalityDiscount(double loyalityDiscount) {
        this.LoyalityDiscount = loyalityDiscount;
    }

    public double getLoyalityDiscount() {
        return this.LoyalityDiscount;
    }

    public void setStalni(boolean stalni) {
        this.Stalni = stalni;
    }

    public boolean isStalni() {
        return this.Stalni;
    }

    public long getPersonID() {
        return this.PersonID;
    }

    public void setPersonID(long personID) {
        this.PersonID = personID;
    }

    public int getPersonTypeID() {
        return this.PersonTypeID;
    }

    public void setPersonTypeID(int personTypeID) {
        this.PersonTypeID = personTypeID;
    }

    public int getPersonCategoryID() {
        return this.PersonCategoryID;
    }

    public void setPersonCategoryID(int personCategoryID) {
        this.PersonCategoryID = personCategoryID;
    }

    public int getPersonVatTypeID() {
        return this.PersonVatTypeID;
    }

    public void setPersonVatTypeID(int personVatTypeID) {
        this.PersonVatTypeID = personVatTypeID;
    }

    public String getFirstName() {
        return this.FirstName;
    }

    public void setFirstName(String firstName) {
        this.FirstName = firstName;
    }

    public String getLastName() {
        return this.LastName;
    }

    public void setLastName(String lastName) {
        this.LastName = lastName;
    }

    public String getIdentificationNumber() {
        return this.IdentificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.IdentificationNumber = identificationNumber;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getAddress() {
        return this.Address;
    }

    public void setAddress(String address) {
        this.Address = address;
    }

    public String getCity() {
        return this.City;
    }

    public void setCity(String city) {
        this.City = city;
    }

    public void setZIP(String zIP) {
        this.ZIP = zIP;
    }

    public String getZIP() {
        return this.ZIP;
    }

    public String getPIB() {
        return this.PIB;
    }

    public void setPIB(String pIB) {
        this.PIB = pIB;
    }

    public String getMB() {
        return this.MB;
    }

    public void setMB(String mB) {
        this.MB = mB;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(double discount) {
        this.Discount = discount;
    }

    public double getSumByBill() {
        return this.sumByBill;
    }

    public void setSumByBill(double sumByBill) {
        this.sumByBill = sumByBill;
    }

    public double getSumByBillWithDiscount() {
        return this.sumByBillWithDiscount;
    }

    public void setSumByBillWithDiscount(double sumByBillWithDiscount) {
        this.sumByBillWithDiscount = sumByBillWithDiscount;
    }

    public double getDiscountByBill() {
        return this.discountByBill;
    }

    public void setDiscountByBill(double discountByBill) {
        this.discountByBill = discountByBill;
    }

    public Loyality getLoyality() {
        return this.loyality;
    }

    public void setLoyality(Loyality loyality) {
        this.loyality = loyality;
    }

    public String toString() {
        return this.Name;
    }

    public int getDetailsPrintNumber() {
        return this.detailsPrintNumber;
    }

    public void setDetailsPrintNumber(int detailsPrintNumber) {
        this.detailsPrintNumber = detailsPrintNumber;
    }

    public boolean isBuyer(Connection connection) {
        return PersonCategory.getByID(this.PersonCategoryID, connection).isBuyerCol();
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String geteMail() {
        return this.eMail;
    }

    public void seteMail(String eMail) {
        this.eMail = eMail;
    }

    public boolean isTaxExempt() {
        return this.taxExempt;
    }

    public void setTaxExempt(boolean taxExempt) {
        this.taxExempt = taxExempt;
    }

    public LoyaltyGroup getlGroup() {
        return this.lGroup;
    }

    public void setlGroup(LoyaltyGroup lGroup) {
        this.lGroup = lGroup;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public long insert(User user, Connection connection) {
        String query = "insert into person ( \t`PersonTypeID`,\t`PersonCategoryID`,\t`PersonVatTypeID`,\t`FirstName`,\t`LastName`,\t`IdentificationNumber`,\t`Name`,\t`PIB`,\t`MB`,\t`Active`,\t`sysDTCreated`,\t`sysUserAddID`,\t`Code`,\t`Address`,  `City`,\t`ZIP` ,  `Discount`, `CurrencyPaymentDays`, `BuyerOfferPriceID`, `DetailsPrintNumber`, `Phone`, `Email`, `TaxExempt`, `Note`,`JBKJS`, efaktura)value (?,?,?,?,?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.PersonTypeID);
            ps.setInt(2, this.PersonCategoryID);
            ps.setInt(3, this.PersonVatTypeID);
            ps.setString(4, this.FirstName);
            ps.setString(5, this.LastName);
            ps.setString(6, this.IdentificationNumber);
            ps.setString(7, this.Name);
            try {
                ps.setString(8, this.PIB);
            }
            catch (NullPointerException e) {
                ps.setNull(8, 12);
            }
            try {
                ps.setString(9, this.MB);
            }
            catch (NullPointerException e) {
                ps.setNull(9, 12);
            }
            ps.setBoolean(10, this.Active);
            ps.setLong(11, user.getUserID());
            ps.setString(12, this.Code);
            ps.setString(13, this.Address);
            ps.setString(14, this.City);
            ps.setString(15, this.ZIP);
            ps.setDouble(16, this.Discount);
            ps.setInt(17, this.CurrencyPaymentDays);
            if (this.BuyerOfferPriceID != -1L) {
                ps.setLong(18, this.BuyerOfferPriceID);
            } else {
                ps.setNull(18, -5);
            }
            ps.setInt(19, this.detailsPrintNumber);
            ps.setString(20, this.phone);
            ps.setString(21, this.eMail);
            ps.setBoolean(22, this.taxExempt);
            if (this.getNote() != null) {
                ps.setString(23, this.getNote());
            } else {
                ps.setString(23, "");
            }
            ps.setString(24, this.tfJBKJ);
            if (this.eFaktura == null) {
                this.eFaktura = false;
            }
            ps.setBoolean(25, this.eFaktura);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.PersonID = rs.getLong(1);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.PersonID;
    }

    public static Boolean getTip(int pvtId, ScreensController controller) {
        System.out.println("Vrednost person vat " + pvtId);
        Connection connection = controller.getSettings().getConnection();
        PersonVatType pvt = PersonVatType.getById(connection, pvtId);
        switch (pvt.getName()) {
            case "Poljoprivredno gazdinstvo": {
                return true;
            }
            case "PDV obveznik": {
                return false;
            }
            case "Nije PDV obveznik": {
                return false;
            }
        }
        return false;
    }

    public void update(User user, Connection connection) {
        String query = "update person set `PersonTypeID` = ?,`PersonCategoryID` = ?,\t`PersonVatTypeID` = ?, `FirstName` = ?, `LastName` = ?, `Name` = ?, `Active` = ?,\t`sysDTEdit` = now(), `sysUserEditID` = ?, `Code` = ?, `Address` = ?,\t`City` = ?, `ZIP` = ?, `Discount` = ?,  `CurrencyPaymentDays` = ?,  `BuyerOfferPriceID` = ?, `DetailsPrintNumber` = ?, `Phone` = ?, `Email` = ?, `TaxExempt` = ?, `PIB` = ?, `MB` = ?, Note = ? , JBKJS = ?, efaktura = ? where `PersonID` = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.PersonTypeID);
            ps.setInt(2, this.PersonCategoryID);
            ps.setInt(3, this.PersonVatTypeID);
            ps.setString(4, this.FirstName);
            ps.setString(5, this.LastName);
            ps.setString(6, this.Name);
            ps.setBoolean(7, this.Active);
            ps.setLong(8, user.getUserID());
            ps.setString(9, this.Code);
            ps.setString(10, this.Address);
            ps.setString(11, this.City);
            ps.setString(12, this.ZIP);
            ps.setDouble(13, this.Discount);
            ps.setInt(14, this.CurrencyPaymentDays);
            if (this.BuyerOfferPriceID != -1L) {
                ps.setLong(15, this.BuyerOfferPriceID);
            } else {
                ps.setNull(15, -5);
            }
            ps.setInt(16, this.detailsPrintNumber);
            ps.setString(17, this.phone);
            ps.setString(18, this.eMail);
            ps.setBoolean(19, this.taxExempt);
            ps.setString(20, this.PIB);
            ps.setString(21, this.MB);
            if (this.note != null) {
                ps.setString(22, this.note);
            } else {
                ps.setString(22, "");
            }
            ps.setString(23, this.tfJBKJ);
            ps.setBoolean(24, this.eFaktura);
            ps.setLong(25, this.PersonID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateDobavljaci(User user, Connection connection) {
        String query = "update person set `PersonTypeID` = ?,`PersonCategoryID` = ?,\t`PersonVatTypeID` = ?, `FirstName` = ?, `LastName` = ?, `Name` = ?, `PIB` = ?, `MB` = ?, `Active` = ?,\t`sysDTEdit` = now(), `sysUserEditID` = ?, `Code` = ?, `Address` = ?,\t`City` = ?, `ZIP` = ?, `Discount` = ?, \t`CurrencyPaymentDays` = ? , \t`BuyerOfferPriceID` = ?, `DetailsPrintNumber` = ?, `Phone` = ?, `Email` = ?, `TaxExempt` = ? where `PersonID` = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.PersonTypeID);
            ps.setInt(2, this.PersonCategoryID);
            ps.setInt(3, this.PersonVatTypeID);
            ps.setString(4, this.FirstName);
            ps.setString(5, this.LastName);
            ps.setString(6, this.Name);
            ps.setString(7, this.PIB);
            ps.setString(8, this.MB);
            ps.setBoolean(9, this.Active);
            ps.setLong(10, user.getUserID());
            ps.setString(11, this.Code);
            ps.setString(12, this.Address);
            ps.setString(13, this.City);
            ps.setString(14, this.ZIP);
            ps.setDouble(15, this.Discount);
            ps.setInt(16, this.CurrencyPaymentDays);
            if (this.BuyerOfferPriceID != -1L) {
                ps.setLong(17, this.BuyerOfferPriceID);
            } else {
                ps.setNull(17, -5);
            }
            ps.setInt(18, this.detailsPrintNumber);
            ps.setString(19, this.phone);
            ps.setString(20, this.eMail);
            ps.setBoolean(21, this.taxExempt);
            ps.setLong(22, this.PersonID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Long personID, Connection connection) {
        String query = "delete from person where `PersonID` = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, personID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<Person> getList(String letter, String filter, Connection connection) {
        ArrayList<Person> list = new ArrayList<Person>();
        try {
            PreparedStatement ps = connection.prepareStatement("select p.*,        coalesce( (select max(l1.discount)                     from loyality l1 \t\t\t\t\twhere l1.PersonID = p.PersonID),0) as discount   from loyality l   left join person p on p.PersonID = l.PersonID  where l.Active = true  and ((? = '') or ((? > '') and (p.LastName like concat(?,'%'))))  and ((? = '') or ((? > '') and (concat(p.LastName, ' ', p.FirstName) like concat('%',?,'%'))))  order by p.LastName");
            ps.setString(1, letter);
            ps.setString(2, letter);
            ps.setString(3, letter);
            ps.setString(4, filter);
            ps.setString(5, filter);
            ps.setString(6, filter);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Discount = rs.getDouble("discount");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                list.add(person);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Person> getPersonListByCategories(ScreensController controller, PersonCategory personCategory) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT * FROM person p \r\nWHERE IF(-1 = ?, FIND_IN_SET(p.PersonCategoryID, '4,7'),  p.PersonCategoryID = ?)\r\nORDER BY p.Name, p.FirstName");
            pStatement.setLong(1, personCategory.getPersonCategoryID());
            pStatement.setLong(2, personCategory.getPersonCategoryID());
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Address = rs.getString("Address");
                person.City = rs.getString("City");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Discount = rs.getDouble("discount");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                list.add((Object)person);
            }
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Person> getObeservableList(String letter, String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        for (Person p : Person.getList(letter, filter, connection)) {
            list.add((Object)p);
        }
        return list;
    }

    public String getFirstLastName() {
        return this.FirstName != null ? (this.LastName != null ? this.FirstName + " " + this.LastName : this.FirstName) : (this.LastName != null ? this.LastName : "");
    }

    public static Person getByLastNameAndAddress(String lastName, String address, Connection connection) {
        Person person = null;
        try {
            PreparedStatement ps = connection.prepareStatement("select p.*  from person p  where p.LastName = ? AND p.Address = ? AND p.PersonCategoryID <> 2");
            ps.setString(1, lastName);
            ps.setString(2, address);
            ResultSet rs = ps.executeQuery();
            rs.next();
            person = new Person();
            person.PersonID = rs.getLong("PersonID");
            person.PersonTypeID = rs.getInt("PersonTypeID");
            person.PersonCategoryID = rs.getInt("PersonCategoryID");
            person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
            person.FirstName = rs.getString("FirstName");
            person.LastName = rs.getString("LastName");
            person.IdentificationNumber = rs.getString("IdentificationNumber");
            person.Name = rs.getString("Name");
            person.PIB = rs.getString("PIB");
            person.MB = rs.getString("MB");
            person.Active = rs.getBoolean("Active");
            person.sysDTCreated = rs.getDate("sysDTCreated");
            person.sysDTEdit = rs.getDate("sysDTEdit");
            person.sysUserAddID = rs.getLong("sysUserAddID");
            person.sysUserEditID = rs.getLong("sysUserEditID");
            person.Code = rs.getString("Code");
            person.Address = rs.getString("Address");
            person.City = rs.getString("City");
            person.ZIP = rs.getString("ZIP");
            person.Discount = rs.getDouble("Discount");
            person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
            person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
            person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
            person.phone = rs.getString("Phone");
            person.eMail = rs.getString("Email");
            person.taxExempt = rs.getBoolean("TaxExempt");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return person;
    }

    public static Person getByPIB(String pib, Connection connection) {
        Person person = null;
        try {
            PreparedStatement ps = connection.prepareStatement("select p.*  from person p  where p.PIB = ? ");
            ps.setString(1, pib);
            ResultSet rs = ps.executeQuery();
            rs.next();
            person = new Person();
            person.PersonID = rs.getLong("PersonID");
            person.PersonTypeID = rs.getInt("PersonTypeID");
            person.PersonCategoryID = rs.getInt("PersonCategoryID");
            person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
            person.FirstName = rs.getString("FirstName");
            person.LastName = rs.getString("LastName");
            person.IdentificationNumber = rs.getString("IdentificationNumber");
            person.Name = rs.getString("Name");
            person.PIB = rs.getString("PIB");
            person.seteFaktura(rs.getBoolean("efaktura"));
            person.MB = rs.getString("MB");
            person.Active = rs.getBoolean("Active");
            person.sysDTCreated = rs.getDate("sysDTCreated");
            person.sysDTEdit = rs.getDate("sysDTEdit");
            person.sysUserAddID = rs.getLong("sysUserAddID");
            person.sysUserEditID = rs.getLong("sysUserEditID");
            person.Code = rs.getString("Code");
            person.Address = rs.getString("Address");
            person.City = rs.getString("City");
            person.ZIP = rs.getString("ZIP");
            person.Discount = rs.getDouble("Discount");
            person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
            person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
            person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
            person.phone = rs.getString("Phone");
            person.eMail = rs.getString("Email");
            person.taxExempt = rs.getBoolean("TaxExempt");
            person.tfJBKJ = rs.getString("JBKJS");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return person;
    }

    public static Person getByCode(String code, Connection connection) {
        Person person = null;
        try {
            PreparedStatement ps = connection.prepareStatement("select p.*  from person p  where p.code = ? ");
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            rs.next();
            person = new Person();
            person.PersonID = rs.getLong("PersonID");
            person.PersonTypeID = rs.getInt("PersonTypeID");
            person.PersonCategoryID = rs.getInt("PersonCategoryID");
            person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
            person.FirstName = rs.getString("FirstName");
            person.LastName = rs.getString("LastName");
            person.IdentificationNumber = rs.getString("IdentificationNumber");
            person.Name = rs.getString("Name");
            person.PIB = rs.getString("PIB");
            person.MB = rs.getString("MB");
            person.Active = rs.getBoolean("Active");
            person.sysDTCreated = rs.getDate("sysDTCreated");
            person.sysDTEdit = rs.getDate("sysDTEdit");
            person.sysUserAddID = rs.getLong("sysUserAddID");
            person.sysUserEditID = rs.getLong("sysUserEditID");
            person.Code = rs.getString("Code");
            person.Discount = rs.getDouble("Discount");
            person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
            person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
            person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
            person.phone = rs.getString("Phone");
            person.eMail = rs.getString("Email");
            person.taxExempt = rs.getBoolean("TaxExempt");
            person.tfJBKJ = rs.getString("JBKJS");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return person;
    }

    public static ObservableList<Person> getList(boolean activeOnly, String filter, String personCategories, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT p.* FROM person p WHERE p.Active = ? AND (p.FirstName like ? or p.LastName like ? or p.Name like ? or p.PIB like ? or p.City like ? or p.Code like ?)";
        if (!personCategories.equals("")) {
            query = query + " AND FIND_IN_SET(p.PersonCategoryID , ?)  ORDER BY p.Name";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setBoolean(1, activeOnly);
            ps.setString(2, "%" + filter + "%");
            ps.setString(3, "%" + filter + "%");
            ps.setString(4, "%" + filter + "%");
            ps.setString(5, "%" + filter + "%");
            ps.setString(6, "%" + filter + "%");
            ps.setString(7, "%" + filter + "%");
            if (!personCategories.equals("")) {
                ps.setString(8, personCategories);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Address = rs.getString("Address");
                person.City = rs.getString("City");
                person.ZIP = rs.getString("ZIP");
                person.Discount = rs.getDouble("Discount");
                person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.Stalni = Person.isStalni(person.PersonID, connection);
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                if (person.isStalni()) continue;
                list.add((Object)person);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static boolean isStalni(long personID, Connection connection) {
        String query = "SELECT l.* FROM loyality l WHERE l.PersonID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, personID);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return true;
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static ObservableList<Person> getList(PersonCategory category, boolean activeOnly, String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            String query = "select p.*   from person p where p.Active = ? ";
            if (category != null) {
                query = query + "   and p.PersonCategoryID = ?";
            }
            query = query + "   and (p.Name like ? or \t\t p.FirstName like ? or \t\t p.LastName like ?)";
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setBoolean(1, activeOnly);
            if (category != null) {
                ps.setInt(2, category.getPersonCategoryID());
                ps.setString(3, "%" + filter + "%");
                ps.setString(4, "%" + filter + "%");
                ps.setString(5, "%" + filter + "%");
            } else {
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
                ps.setString(4, "%" + filter + "%");
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Discount = rs.getDouble("Discount");
                person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                list.add((Object)person);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Person getById(long id, ScreensController controller) {
        Person person = null;
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("select p.*   from person p where p.PersonID = ? ");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                return null;
            }
            person = new Person();
            person.PersonID = rs.getLong("PersonID");
            person.PersonTypeID = rs.getInt("PersonTypeID");
            person.PersonCategoryID = rs.getInt("PersonCategoryID");
            person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
            person.FirstName = rs.getString("FirstName");
            person.LastName = rs.getString("LastName");
            person.IdentificationNumber = rs.getString("IdentificationNumber");
            person.Name = person.PersonTypeID == 1 ? rs.getString("FirstName") + " " + rs.getString("LastName") : (rs.getString("Name") == null ? "" : rs.getString("Name"));
            person.PIB = rs.getString("PIB");
            person.MB = rs.getString("MB");
            person.Address = rs.getString("Address");
            person.City = rs.getString("City");
            person.ZIP = rs.getString("Zip");
            person.Active = rs.getBoolean("Active");
            person.sysDTCreated = rs.getDate("sysDTCreated");
            person.sysDTEdit = rs.getDate("sysDTEdit");
            person.sysUserAddID = rs.getLong("sysUserAddID");
            person.sysUserEditID = rs.getLong("sysUserEditID");
            person.Code = rs.getString("Code");
            person.Discount = rs.getDouble("Discount");
            person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
            person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
            person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
            person.phone = rs.getString("Phone");
            person.eMail = rs.getString("Email");
            person.taxExempt = rs.getBoolean("TaxExempt");
            person.loyality = Loyality.getByPerson(person, controller);
            person.setNote(rs.getString("Note"));
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return person;
    }

    public static ObservableList<Person> getLoyalityBillList(Connection connection, int PersonCategoryID, Date from, Date to, String filter) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT p.`*`, l.`*`, SUM(d.Sum) AS Sum, SUM(d.SumWithDiscount) AS SumWithDiscount \r\nFROM loyality l \r\nLEFT JOIN person p On p.PersonID = l.PersonID\r\nLEFT JOIN document d ON d.PersonID = p.PersonID AND d.DocumentID IS NOT NULL AND d.DocumentTypeID = 3\r\nWHERE p.PersonCategoryID = ?\r\nAND d.Date BETWEEN ? AND ?\r\nAND (p.FirstName LIKE ? OR p.LastName LIKE ? OR l.CardNumber LIKE ? OR p.Code LIKE ?)GROUP BY p.PersonID ORDER BY p.sysDTCreated DESC";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, PersonCategoryID);
            ps.setTimestamp(2, new Timestamp(from.getTime()));
            try {
                ps.setTimestamp(3, new Timestamp(to.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(3, new Timestamp(new Date().getTime()));
            }
            ps.setString(4, "%" + filter + "%");
            ps.setString(5, "%" + filter + "%");
            ps.setString(6, "%" + filter + "%");
            ps.setString(7, "%" + filter + "%");
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Address = rs.getString("Address");
                person.City = rs.getString("City");
                person.ZIP = rs.getString("Zip");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Discount = rs.getDouble("Discount");
                person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                Loyality loyality = new Loyality();
                loyality.setLoyalityID(rs.getLong("LoyalityID"));
                loyality.setPersonID(rs.getLong("PersonID"));
                loyality.setCardNumber(rs.getString("CardNumber"));
                loyality.setDiscount(rs.getDouble("Discount"));
                loyality.setActive(rs.getBoolean("Active"));
                loyality.setPoints(rs.getDouble("Points"));
                loyality.setBuyingPointsValue(rs.getDouble("BuyingPointsValue"));
                loyality.setSellingPointsValue(rs.getDouble("SellingPointsValue"));
                loyality.setNumberEntry(rs.getInt("NumberEntry"));
                loyality.setCurrentNumberEntry(rs.getInt("CurrentNumberEntry"));
                loyality.setDiscountEntry(rs.getDouble("DiscountEntry"));
                loyality.setVipLoyaltyPrice(rs.getBoolean("VIPLoyaltyPrice"));
                loyality.setNote(rs.getString("Note"));
                person.setLoyality(loyality);
                person.setSumByBill(rs.getDouble("Sum"));
                person.setSumByBillWithDiscount(rs.getDouble("SumWithDiscount"));
                person.setDiscountByBill(Settings.round(person.getSumByBill() - person.getSumByBillWithDiscount(), 2));
                list.add((Object)person);
            }
            ps.close();
            rs.close();
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Person> getLoyalityList(Connection connection, int PersonCategoryID) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM loyality l JOIN person p On p.PersonID = l.PersonID WHERE p.PersonCategoryID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, PersonCategoryID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Address = rs.getString("Address");
                person.City = rs.getString("City");
                person.ZIP = rs.getString("Zip");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Discount = rs.getDouble("Discount");
                person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                person.setSumByBill(Document.getBillSumByPerson(connection, person).getSum());
                Loyality loyality = new Loyality();
                loyality.setLoyalityID(rs.getLong("LoyalityID"));
                loyality.setPersonID(rs.getLong("PersonID"));
                loyality.setCardNumber(rs.getString("CardNumber"));
                loyality.setDiscount(rs.getDouble("Discount"));
                loyality.setActive(rs.getBoolean("Active"));
                loyality.setPoints(rs.getDouble("Points"));
                loyality.setBuyingPointsValue(rs.getDouble("BuyingPointsValue"));
                loyality.setSellingPointsValue(rs.getDouble("SellingPointsValue"));
                loyality.setNumberEntry(rs.getInt("NumberEntry"));
                loyality.setCurrentNumberEntry(rs.getInt("CurrentNumberEntry"));
                loyality.setDiscountEntry(rs.getDouble("DiscountEntry"));
                loyality.setVipLoyaltyPrice(rs.getBoolean("VIPLoyaltyPrice"));
                loyality.setNote(rs.getString("Note"));
                person.setLoyality(loyality);
                list.add((Object)person);
            }
            ps.close();
            rs.close();
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Person> getLoyalityListX(Connection connection, int PersonCategoryID) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM loyality l JOIN person p On p.PersonID = l.PersonID WHERE p.PersonCategoryID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, PersonCategoryID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Address = rs.getString("Address");
                person.City = rs.getString("City");
                person.ZIP = rs.getString("Zip");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Discount = rs.getDouble("Discount");
                person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                Loyality loyality = new Loyality();
                loyality.setLoyalityID(rs.getLong("LoyalityID"));
                loyality.setPersonID(rs.getLong("PersonID"));
                loyality.setCardNumber(rs.getString("CardNumber"));
                loyality.setDiscount(rs.getDouble("Discount"));
                loyality.setActive(rs.getBoolean("Active"));
                loyality.setPoints(rs.getDouble("Points"));
                loyality.setBuyingPointsValue(rs.getDouble("BuyingPointsValue"));
                loyality.setSellingPointsValue(rs.getDouble("SellingPointsValue"));
                loyality.setNumberEntry(rs.getInt("NumberEntry"));
                loyality.setCurrentNumberEntry(rs.getInt("CurrentNumberEntry"));
                loyality.setDiscountEntry(rs.getDouble("DiscountEntry"));
                loyality.setVipLoyaltyPrice(rs.getBoolean("VIPLoyaltyPrice"));
                loyality.setNote(rs.getString("Note"));
                person.setLoyality(loyality);
                list.add((Object)person);
            }
            ps.close();
            rs.close();
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Person> getLoyalityListWithFilter(Connection connection, int PersonCategoryID, int PersonTypeId, LoyaltyGroup loyaltyGroup) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM loyality l JOIN person p On p.PersonID = l.PersonID WHERE p.PersonCategoryID = ? AND p.PersonTypeID=? AND (-1 = ? OR l.LoyaltyGroupID = ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, PersonCategoryID);
            ps.setInt(2, PersonTypeId);
            ps.setLong(3, loyaltyGroup.getLoyaltyGroupId());
            ps.setLong(4, loyaltyGroup.getLoyaltyGroupId());
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Address = rs.getString("Address");
                person.City = rs.getString("City");
                person.ZIP = rs.getString("Zip");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Discount = rs.getDouble("Discount");
                person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.note = rs.getString("Note");
                person.taxExempt = rs.getBoolean("TaxExempt");
                Loyality loyality = new Loyality();
                loyality.setLoyalityID(rs.getLong("LoyalityID"));
                loyality.setPersonID(rs.getLong("PersonID"));
                loyality.setCardNumber(rs.getString("CardNumber"));
                loyality.setDiscount(rs.getDouble("Discount"));
                loyality.setActive(rs.getBoolean("Active"));
                loyality.setPoints(rs.getDouble("Points"));
                loyality.setBuyingPointsValue(rs.getDouble("BuyingPointsValue"));
                loyality.setSellingPointsValue(rs.getDouble("SellingPointsValue"));
                loyality.setNumberEntry(rs.getInt("NumberEntry"));
                loyality.setCurrentNumberEntry(rs.getInt("CurrentNumberEntry"));
                loyality.setDiscountEntry(rs.getDouble("DiscountEntry"));
                loyality.setVipLoyaltyPrice(rs.getBoolean("VIPLoyaltyPrice"));
                loyality.setNote(rs.getString("Note"));
                person.setLoyality(loyality);
                list.add((Object)person);
            }
            ps.close();
            rs.close();
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Person> getListByCategory(String category, boolean activeOnly, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            String query = "select p.*, l.LoyalityID, l.CardNumber as LoyalityCard, l.Discount as LoyalityDiscount from person p left join personcategory pc on pc.PersonCategoryID = p.PersonCategoryID left join loyality l on l.PersonID = p.PersonID where p.Active = ? and ";
            if (category.equals(PersonCategory.BUYER)) {
                query = query + "   pc.PersonCategoryID = " + PersonCategoryEnum.BUYER.getPersonCategoryId() + "";
            }
            if (category.equals(PersonCategory.SUPPLIER)) {
                query = query + "   pc.PersonCategoryID = " + PersonCategoryEnum.SUPPLIER.getPersonCategoryId() + "";
            }
            if (category.equals(PersonCategory.LOYALTY)) {
                query = query + "   pc.PersonCategoryID = " + PersonCategoryEnum.LOYALITY.getPersonCategoryId() + "";
            }
            if (category.equals(PersonCategory.INTERN_BUYER)) {
                query = query + "   pc.PersonCategoryID = " + PersonCategoryEnum.INTERNAL_BUYER.getPersonCategoryId() + "";
            }
            query = query + " ORDER BY p.Name";
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setBoolean(1, activeOnly);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Address = rs.getString("Address");
                person.City = rs.getString("City");
                person.ZIP = rs.getString("Zip");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Discount = rs.getDouble("Discount");
                person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                try {
                    person.LoyalityID = rs.getLong("LoyalityID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    person.LoyalityCard = rs.getString("LoyalityCard");
                }
                catch (NullPointerException e) {
                    person.setLoyalityCard("");
                }
                list.add((Object)person);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Person> getListByCategory(boolean activeOnly, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            String query = "select p.*, l.LoyalityID, l.CardNumber as LoyalityCard, l.Discount as LoyalityDiscount from person p left join personcategory pc on pc.PersonCategoryID = p.PersonCategoryID left join loyality l on l.PersonID = p.PersonID where p.Active = ? and ";
            query = query + "pc.PersonCategoryID IN (" + PersonCategoryEnum.BUYER.getPersonCategoryId() + "," + PersonCategoryEnum.FIZICKO_LICE.getPersonCategoryId() + "," + PersonCategoryEnum.SUPPLIER.getPersonCategoryId() + "," + PersonCategoryEnum.LOYALITY.getPersonCategoryId() + ")";
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setBoolean(1, activeOnly);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Address = rs.getString("Address");
                person.City = rs.getString("City");
                person.ZIP = rs.getString("Zip");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Discount = rs.getDouble("Discount");
                person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                try {
                    person.LoyalityID = rs.getLong("LoyalityID");
                }
                catch (NullPointerException e) {
                    person.setLoyalityID(-1L);
                }
                try {
                    person.LoyalityCard = rs.getString("LoyalityCard");
                }
                catch (NullPointerException e) {
                    person.setLoyalityCard("");
                }
                list.add((Object)person);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void getPersonToExcel(ScreensController controller, ObservableList<Person> list, String name, String path) {
        File directory = new File(String.valueOf(path));
        if (!directory.exists()) {
            directory.mkdir();
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Lager lista");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Ime");
        header.createCell(1).setCellValue("Prezime");
        header.createCell(2).setCellValue("Adresa");
        header.createCell(3).setCellValue("Grad");
        header.createCell(4).setCellValue("Kod");
        header.createCell(5).setCellValue("Telefon");
        header.createCell(6).setCellValue("Mobilni");
        header.createCell(7).setCellValue("eMail");
        sheet.setColumnWidth(0, 3300);
        sheet.setColumnWidth(1, 3300);
        sheet.setColumnWidth(2, 8000);
        sheet.setColumnWidth(3, 3300);
        sheet.setColumnWidth(4, 3200);
        sheet.setColumnWidth(5, 3200);
        sheet.setColumnWidth(6, 3600);
        sheet.setColumnWidth(7, 9600);
        int index = 1;
        for (Person person : list) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(person.getFirstName());
            row.createCell(1).setCellValue(person.getLastName());
            row.createCell(2).setCellValue(person.getAddress());
            row.createCell(3).setCellValue(person.getCity());
            row.createCell(4).setCellValue(person.getCode());
            for (Contact contact : Contact.getListByPerson(person, controller.getSettings().getConnection())) {
                if (contact.getContactTypeID() == 1) {
                    row.createCell(5).setCellValue(contact.getContact());
                }
                if (contact.getContactTypeID() == 2) {
                    row.createCell(6).setCellValue(contact.getContact());
                }
                if (contact.getContactTypeID() != 4) continue;
                row.createCell(7).setCellValue(contact.getContact());
            }
            ++index;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(directory + File.separator + name + ".xlsx");
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Person getByLoyaltyId(Loyality newValue, ScreensController controller) {
        return null;
    }

    public static ObservableList<Person> getPersonsByersList(ScreensController controller) {
        ObservableList personsList = FXCollections.observableArrayList();
        String query = "SELECT * FROM person p WHERE p.PersonTypeID IN (1, 2) and p.PersonCategoryId IN(2,4,7)";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.setPersonID(rs.getLong("PersonID"));
                person.setName(rs.getString("Name"));
                person.setPIB(rs.getString("PIB"));
                person.setMB(rs.getString("MB"));
                person.setAddress(rs.getString("Address"));
                person.setZIP(rs.getString("Zip"));
                person.setCity(rs.getString("City"));
                person.setPhone(rs.getString("Phone"));
                person.setTaxExempt(rs.getBoolean("taxExempt"));
                person.setTfJBKJ(rs.getString("JBKJS"));
                personsList.add((Object)person);
            }
            return personsList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Person> getPersonForLoyaliti(int personTypeId, ScreensController controller) {
        ObservableList personsList = FXCollections.observableArrayList();
        String query = " SELECT p.PersonID, p.Name, p.FirstName, p.LastName, p.City, p.Zip, p.PIB, p.MB, p.Address, p.Phone, p.Code, p.PersonTypeId,p.Discount, p.Email,p.BuyerOfferPriceID, p.taxExempt, p.efaktura  FROM person p WHERE p.PersonTypeID =? AND p.PersonCategoryID = 2";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, personTypeId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.setPersonID(rs.getLong("PersonID"));
                person.seteFaktura(rs.getBoolean("efaktura"));
                person.setName(rs.getString("Name"));
                person.setFirstName(rs.getString("FirstName"));
                person.setLastName(rs.getString("LastName"));
                person.setPIB(rs.getString("PIB"));
                person.setMB(rs.getString("MB"));
                person.setAddress(rs.getString("Address"));
                person.setPhone(rs.getString("Phone"));
                person.setCode(rs.getString("Code"));
                person.setPersonCategoryID(2);
                person.setDiscount(rs.getDouble("Discount"));
                person.setPersonTypeID(rs.getInt("personTypeId"));
                person.setMail(rs.getString("Email"));
                person.setCity(rs.getString("City"));
                person.setZIP(rs.getString("Zip"));
                person.setBuyerOfferPriceID(rs.getLong("BuyerOfferPriceID"));
                person.setTaxExempt(rs.getBoolean("taxExempt"));
                personsList.add((Object)person);
            }
            return personsList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Person> getPersonForLoyalitiWithCode(ScreensController controller) {
        ObservableList personsList = FXCollections.observableArrayList();
        String query = "SELECT p.PersonID, p.Name, p.FirstName, p.LastName, p.PIB, p.MB, p.Address, p.Phone, p.Code, p.Discount, p.PersonTypeId, p.Email, l.CardNumber FROM person p JOIN loyality l ON p.PersonID = l.PersonID WHERE COALESCE(p.Code,'') != ''";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.setPersonID(rs.getLong("PersonID"));
                person.setName(rs.getString("Name"));
                person.setFirstName(rs.getString("FirstName"));
                person.setLastName(rs.getString("LastName"));
                person.setPIB(rs.getString("PIB"));
                person.setMB(rs.getString("MB"));
                person.setAddress(rs.getString("Address"));
                person.setPhone(rs.getString("Phone"));
                person.setCode(rs.getString("Code"));
                person.setPersonCategoryID(2);
                person.setLoyalityCard(rs.getString("CardNumber"));
                person.setDiscount(rs.getDouble("Discount"));
                person.setPersonTypeID(rs.getInt("personTypeId"));
                person.seteMail(rs.getString("Email"));
                personsList.add((Object)person);
            }
            return personsList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Person> getPersonsForCashbuyersList(ScreensController controller) {
        ObservableList personsList = FXCollections.observableArrayList();
        String query = " SELECT * FROM person p WHERE p.PersonTypeID =2 AND p.PersonCategoryID IN (2,4,7)";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Person person = new Person();
                person.setPersonID(rs.getLong("PersonID"));
                person.setName(rs.getString("Name"));
                person.setFirstName(rs.getString("FirstName"));
                person.setLastName(rs.getString("LastName"));
                person.setPIB(rs.getString("PIB"));
                person.setMB(rs.getString("MB"));
                person.setAddress(rs.getString("Address"));
                person.setZIP(rs.getString("Zip"));
                person.setCity(rs.getString("City"));
                person.setPhone(rs.getString("Phone"));
                person.setCode(rs.getString("Code"));
                person.setPersonCategoryID(2);
                person.setDiscount(rs.getDouble("Discount"));
                person.setPersonTypeID(rs.getInt("personTypeId"));
                person.seteMail(rs.getString("Email"));
                person.setTaxExempt(rs.getBoolean("TaxExempt"));
                personsList.add((Object)person);
            }
            return personsList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Person> getAllPersonsList(boolean activeOnly, String filter, String personCategories, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT p.*, l.*, l.discount as LoyalityDiscount FROM person p left join loyality l on p.PersonId = l.PersonId  WHERE p.Active = ? AND (p.FirstName like ? or p.LastName like ? or p.Name like ? or p.PIB like ? or p.City like ? or p.Code like ?)";
        if (!personCategories.equals("")) {
            query = query + " AND FIND_IN_SET(p.PersonCategoryID , ?) AND p.PersonTypeId = 2  ORDER BY p.Name";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setBoolean(1, activeOnly);
            ps.setString(2, "%" + filter + "%");
            ps.setString(3, "%" + filter + "%");
            ps.setString(4, "%" + filter + "%");
            ps.setString(5, "%" + filter + "%");
            ps.setString(6, "%" + filter + "%");
            ps.setString(7, "%" + filter + "%");
            if (!personCategories.equals("")) {
                ps.setString(8, personCategories);
            }
            ResultSet rs = ps.executeQuery();
            System.out.println(ps);
            while (rs.next()) {
                Person person = new Person();
                person.PersonID = rs.getLong("PersonID");
                person.PersonTypeID = rs.getInt("PersonTypeID");
                person.PersonCategoryID = rs.getInt("PersonCategoryID");
                person.PersonVatTypeID = rs.getInt("PersonVatTypeID");
                person.FirstName = rs.getString("FirstName");
                person.LastName = rs.getString("LastName");
                person.IdentificationNumber = rs.getString("IdentificationNumber");
                person.Name = rs.getString("Name");
                person.PIB = rs.getString("PIB");
                person.MB = rs.getString("MB");
                person.Active = rs.getBoolean("Active");
                person.sysDTCreated = rs.getDate("sysDTCreated");
                person.sysDTEdit = rs.getDate("sysDTEdit");
                person.sysUserAddID = rs.getLong("sysUserAddID");
                person.sysUserEditID = rs.getLong("sysUserEditID");
                person.Code = rs.getString("Code");
                person.Address = rs.getString("Address");
                person.City = rs.getString("City");
                person.ZIP = rs.getString("ZIP");
                person.Discount = rs.getDouble("Discount");
                person.seteFaktura(rs.getBoolean("efaktura"));
                person.CurrencyPaymentDays = rs.getInt("CurrencyPaymentDays");
                person.BuyerOfferPriceID = rs.getLong("BuyerOfferPriceID");
                person.detailsPrintNumber = rs.getInt("DetailsPrintNumber");
                person.Stalni = Person.isStalni(person.PersonID, connection);
                person.phone = rs.getString("Phone");
                person.eMail = rs.getString("Email");
                person.taxExempt = rs.getBoolean("TaxExempt");
                person.setTfJBKJ(rs.getString("JBKJS"));
                person.setNote(rs.getString("Note"));
                Loyality loyality = new Loyality();
                loyality.setLoyalityID(rs.getLong("LoyalityId"));
                loyality.setPersonID(person.getPersonID());
                loyality.setCardNumber(rs.getString("CardNumber"));
                loyality.setDiscount(rs.getDouble("LoyalityDiscount"));
                loyality.setPoints(rs.getDouble("Points"));
                loyality.setBuyingPointsValue(rs.getDouble("BuyingPointsValue"));
                loyality.setSellingPointsValue(rs.getDouble("SellingPointsValue"));
                loyality.setNumberEntry(rs.getInt("NumberEntry"));
                loyality.setCurrentNumberEntry(rs.getInt("CurrentNumberEntry"));
                loyality.setDiscountEntry(rs.getDouble("DiscountEntry"));
                loyality.setVipLoyaltyPrice(rs.getBoolean("VIPLoyaltyPrice"));
                loyality.setNote(rs.getString("Note"));
                loyality.setLoyaltyGroupId(rs.getInt("LoyaltyGroupId"));
                loyality.setPeriodDays(rs.getString("PeriodDays"));
                person.setLoyality(loyality);
                list.add((Object)person);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void addNoteColumnToPerson(Connection connection) {
        String query = "ALTER TABLE person ADD Note varchar(500) NOT NULL DEFAULT '' ";
        try {
            Statement statement = connection.createStatement();
            statement.execute(query);
            System.out.println("Kreirana kolona Note u tabeli person");
        }
        catch (Exception e) {
            System.out.println("Kolona Note u tabeli person vec postoji");
        }
    }
}

