/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import rs.petcom.master.ScreensController;

public class LoyaltyLimit {
    private long loyaltyLimitId;
    private long loyaltyId;
    private double currentValue;
    private double limitValue;
    private Date dateTo;
    private int numberOfDates;
    private boolean active;

    public long getLoyaltyLimitId() {
        return this.loyaltyLimitId;
    }

    public void setLoyaltyLimitId(long loyaltyLimitId) {
        this.loyaltyLimitId = loyaltyLimitId;
    }

    public long getLoyaltyId() {
        return this.loyaltyId;
    }

    public void setLoyaltyId(long loyaltyId) {
        this.loyaltyId = loyaltyId;
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(double currentValue) {
        this.currentValue = currentValue;
    }

    public double getLimitValue() {
        return this.limitValue;
    }

    public void setLimitValue(double limitValue) {
        this.limitValue = limitValue;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public int getNumberOfDates() {
        return this.numberOfDates;
    }

    public void setNumberOfDates(int numberOfDates) {
        this.numberOfDates = numberOfDates;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `loyaltylimit` (`LoyaltyID`, `LimitValue`, `DateTo`, `NumberOfDates`, `Active`) VALUES (?, ?, ?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.loyaltyId);
            pStatement.setDouble(2, this.limitValue);
            try {
                pStatement.setTimestamp(3, new Timestamp(this.dateTo.getTime()));
            }
            catch (NullPointerException e) {
                pStatement.setNull(3, 93);
            }
            pStatement.setInt(4, this.numberOfDates);
            pStatement.setBoolean(5, this.active);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `loyaltylimit` SET `CurrentValue`= ?, `LimitValue`= ?, `DateTo`= ?, `NumberOfDates`= ?, `Active`= ? WHERE  `LoyaltyID`=?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setDouble(1, this.currentValue);
            pStatement.setDouble(2, this.limitValue);
            try {
                pStatement.setTimestamp(3, new Timestamp(this.dateTo.getTime()));
            }
            catch (NullPointerException e) {
                pStatement.setNull(3, 93);
            }
            pStatement.setInt(4, this.numberOfDates);
            pStatement.setBoolean(5, this.active);
            pStatement.setLong(6, this.loyaltyId);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateCurrentValue(ScreensController controller) {
        String query = "UPDATE `loyaltylimit` SET `CurrentValue`= ? WHERE  `LoyaltyID`=?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setDouble(1, this.currentValue);
            pStatement.setLong(2, this.loyaltyId);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static LoyaltyLimit getLoyaltyLimitByLoyaltyID(long loyaltyId, ScreensController controller) {
        String query = "SELECT * FROM loyaltylimit ll WHERE ll.LoyaltyID = ?";
        LoyaltyLimit loyaltyLimit = new LoyaltyLimit();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, loyaltyId);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            loyaltyLimit.setLoyaltyLimitId(rSet.getLong("LoyaltyLimitID"));
            loyaltyLimit.setLoyaltyId(rSet.getLong("LoyaltyID"));
            loyaltyLimit.setCurrentValue(rSet.getDouble("CurrentValue"));
            loyaltyLimit.setLimitValue(rSet.getDouble("LimitValue"));
            loyaltyLimit.setDateTo(new Date(rSet.getTimestamp("DateTo").getTime()));
            loyaltyLimit.setNumberOfDates(rSet.getInt("NumberOfDates"));
            loyaltyLimit.setActive(rSet.getBoolean("Active"));
        }
        catch (SQLException e) {
            return null;
        }
        return loyaltyLimit;
    }

    public static void delete(long loyaltyID, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("DELETE FROM loyaltylimit WHERE LoyaltyID = ?");
            ps.setLong(1, loyaltyID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

