/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class LoyaltyGroup {
    private long loyaltyGroupId;
    private String name;
    private double defaultDiscount;

    public long getLoyaltyGroupId() {
        return this.loyaltyGroupId;
    }

    public void setLoyaltyGroupId(long loyaltyGroupId) {
        this.loyaltyGroupId = loyaltyGroupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public double getDefaultDiscount() {
        return this.defaultDiscount;
    }

    public void setDefaultDiscount(double defaultDiscount) {
        this.defaultDiscount = defaultDiscount;
    }

    public long insert(ScreensController controller) {
        String query = "INSERT INTO `loyaltygroup` (`Name`, `DefaultDiscount`) VALUES (?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setDouble(2, this.defaultDiscount);
            pStatement.executeUpdate();
            ResultSet rs = pStatement.getGeneratedKeys();
            rs.next();
            this.loyaltyGroupId = rs.getLong(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.loyaltyGroupId;
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `loyaltygroup` SET `Name` = ?, `DefaultDiscount` = ? WHERE  `LoyaltyGroupID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setDouble(2, this.defaultDiscount);
            pStatement.setLong(3, this.loyaltyGroupId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<LoyaltyGroup> getLoyaltyGroupList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT * FROM loyaltygroup");
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                LoyaltyGroup loyaltyGroup = new LoyaltyGroup();
                loyaltyGroup.setLoyaltyGroupId(rSet.getLong("LoyaltyGroupID"));
                loyaltyGroup.setName(rSet.getString("Name"));
                loyaltyGroup.setDefaultDiscount(rSet.getDouble("DefaultDiscount"));
                list.add((Object)loyaltyGroup);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static LoyaltyGroup getById(long id, ScreensController controller) {
        LoyaltyGroup loyaltyGroup = new LoyaltyGroup();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT * FROM loyaltygroup lg where lg.LoyaltyGroupID = ?");
            pStatement.setLong(1, id);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            loyaltyGroup.setLoyaltyGroupId(rSet.getLong("LoyaltyGroupID"));
            loyaltyGroup.setName(rSet.getString("Name"));
            loyaltyGroup.setDefaultDiscount(rSet.getDouble("DefaultDiscount"));
        }
        catch (SQLException e) {
            return null;
        }
        return loyaltyGroup;
    }
}

