/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.LoyalitySettings;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.person.LoyaltyFinancialDiscount;
import rs.petcom.master.dal.person.LoyaltyGroup;
import rs.petcom.master.dal.person.LoyaltyLimit;
import rs.petcom.master.dal.person.Person;

public class Loyality {
    private Long LoyalityID;
    private Long PersonID;
    private String CardNumber;
    private double Discount;
    private Boolean Active;
    private java.util.Date sysDTCreated;
    private java.util.Date sysDTEdit;
    private Long sysUserAddID;
    private Long sysUserEditID;
    private double Points;
    private double BuyingPointsValue;
    private double SellingPointsValue;
    private int NumberEntry;
    private int CurrentNumberEntry;
    private double DiscountEntry;
    private boolean vipLoyaltyPrice;
    private String note;
    private long loyaltyGroupId;
    private LoyaltyGroup loyaltyGroup;
    private String periodDays;
    private Person person;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Long getLoyalityID() {
        return this.LoyalityID;
    }

    public void setLoyalityID(Long loyalityID) {
        this.LoyalityID = loyalityID;
    }

    public Long getPersonID() {
        return this.PersonID;
    }

    public void setPersonID(Long personID) {
        this.PersonID = personID;
    }

    public String getCardNumber() {
        return this.CardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.CardNumber = cardNumber;
    }

    public double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(double discount) {
        this.Discount = discount;
    }

    public Boolean getActive() {
        return this.Active;
    }

    public void setActive(Boolean active) {
        this.Active = active;
    }

    public java.util.Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(java.util.Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public java.util.Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(java.util.Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public Long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(Long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public Long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(Long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public double getPoints() {
        return this.Points;
    }

    public void setPoints(double points) {
        this.Points = points;
    }

    public double getBuyingPointsValue() {
        return this.BuyingPointsValue;
    }

    public void setBuyingPointsValue(double buyingPointsValue) {
        this.BuyingPointsValue = buyingPointsValue;
    }

    public double getSellingPointsValue() {
        return this.SellingPointsValue;
    }

    public void setSellingPointsValue(double sellingPointsValue) {
        this.SellingPointsValue = sellingPointsValue;
    }

    public int getNumberEntry() {
        return this.NumberEntry;
    }

    public void setNumberEntry(int numberEntry) {
        this.NumberEntry = numberEntry;
    }

    public int getCurrentNumberEntry() {
        return this.CurrentNumberEntry;
    }

    public void setCurrentNumberEntry(int currentNumberEntry) {
        this.CurrentNumberEntry = currentNumberEntry;
    }

    public double getDiscountEntry() {
        return this.DiscountEntry;
    }

    public void setDiscountEntry(double discountEntry) {
        this.DiscountEntry = discountEntry;
    }

    public boolean isVipLoyaltyPrice() {
        return this.vipLoyaltyPrice;
    }

    public void setVipLoyaltyPrice(boolean vipLoyaltyPrice) {
        this.vipLoyaltyPrice = vipLoyaltyPrice;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public long getLoyaltyGroupId() {
        return this.loyaltyGroupId;
    }

    public void setLoyaltyGroupId(long loyaltyGroupId) {
        this.loyaltyGroupId = loyaltyGroupId;
    }

    public LoyaltyGroup getLoyaltyGroup() {
        return this.loyaltyGroup;
    }

    public void setLoyaltyGroup(LoyaltyGroup loyaltyGroup) {
        this.loyaltyGroup = loyaltyGroup;
    }

    public String getPeriodDays() {
        return this.periodDays;
    }

    public void setPeriodDays(String periodDays) {
        this.periodDays = periodDays;
    }

    public long insert(ScreensController controller) {
        String query = "INSERT INTO loyality (`PersonID`, CardNumber, Discount, Active, `sysUserAddID`, `BuyingPointsValue`, `SellingPointsValue`, `NumberEntry`, `DiscountEntry`, `VIPLoyaltyPrice`, `Note`, `LoyaltyGroupID`, `PeriodDays`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setLong(1, this.PersonID);
            ps.setString(2, this.CardNumber);
            ps.setDouble(3, this.Discount);
            ps.setBoolean(4, this.Active);
            ps.setLong(5, this.sysUserAddID);
            ps.setDouble(6, Double.parseDouble(controller.getLoyalitySettings().getActualByName(controller, "value.loyality.buying.point")));
            ps.setDouble(7, Double.parseDouble(controller.getLoyalitySettings().getActualByName(controller, "value.loyality.sales.point")));
            ps.setInt(8, Integer.parseInt(controller.getLoyalitySettings().getActualByName(controller, "bill.no.discount.numbers")));
            ps.setDouble(9, Double.parseDouble(controller.getLoyalitySettings().getActualByName(controller, "bill.no.discount.percent")));
            ps.setBoolean(10, false);
            ps.setString(11, this.note);
            ps.setLong(12, this.loyaltyGroupId);
            ps.setString(13, this.periodDays);
            System.out.println(ps);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.LoyalityID = rs.getLong(1);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.LoyalityID;
    }

    public static ArrayList<Loyality> getList(ScreensController controller) {
        ArrayList<Loyality> list = new ArrayList<Loyality>();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("select l.* from loyality l ");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Loyality l = new Loyality();
                l.LoyalityID = rs.getLong("LoyalityID");
                l.PersonID = rs.getLong("PersonID");
                l.CardNumber = rs.getString("CardNumber");
                l.Discount = rs.getDouble("Discount");
                l.Active = rs.getBoolean("Active");
                l.sysDTCreated = rs.getDate("sysDTCreated");
                l.sysDTEdit = rs.getDate("sysDTEdit");
                l.sysUserAddID = rs.getLong("sysUserAddID");
                l.sysUserEditID = rs.getLong("sysUserEditID");
                l.BuyingPointsValue = rs.getDouble("BuyingPointsValue");
                l.SellingPointsValue = rs.getDouble("SellingPointsValue");
                l.Points = rs.getDouble("Points");
                l.NumberEntry = rs.getInt("NumberEntry");
                l.CurrentNumberEntry = rs.getInt("CurrentNumberEntry");
                l.DiscountEntry = rs.getDouble("DiscountEntry");
                l.vipLoyaltyPrice = rs.getBoolean("VIPLoyaltyPrice");
                l.note = rs.getString("Note");
                l.loyaltyGroupId = rs.getLong("LoyaltyGroupID");
                l.loyaltyGroup = LoyaltyGroup.getById(l.getLoyaltyGroupId(), controller);
                l.periodDays = rs.getString("PeriodDays");
                list.add(l);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Loyality getByPerson(Person person, ScreensController controller) {
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("select l.* from loyality l where l.PersonID = ?");
            ps.setLong(1, person.getPersonID());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Loyality l = new Loyality();
                l.LoyalityID = rs.getLong("LoyalityID");
                l.PersonID = rs.getLong("PersonID");
                l.CardNumber = rs.getString("CardNumber");
                l.Discount = rs.getDouble("Discount");
                l.Active = rs.getBoolean("Active");
                l.sysDTCreated = rs.getDate("sysDTCreated");
                l.sysDTEdit = rs.getDate("sysDTEdit");
                l.sysUserAddID = rs.getLong("sysUserAddID");
                l.sysUserEditID = rs.getLong("sysUserEditID");
                l.BuyingPointsValue = Settings.round(rs.getDouble("BuyingPointsValue"), 2);
                l.SellingPointsValue = Settings.round(rs.getDouble("SellingPointsValue"), 2);
                l.Points = Settings.round(rs.getDouble("Points"), 2);
                l.NumberEntry = rs.getInt("NumberEntry");
                l.CurrentNumberEntry = rs.getInt("CurrentNumberEntry");
                l.DiscountEntry = rs.getDouble("DiscountEntry");
                l.vipLoyaltyPrice = rs.getBoolean("VIPLoyaltyPrice");
                l.note = rs.getString("Note");
                l.loyaltyGroupId = rs.getLong("LoyaltyGroupID");
                l.loyaltyGroup = LoyaltyGroup.getById(l.getLoyaltyGroupId(), controller);
                l.periodDays = rs.getString("PeriodDays");
                l.setPerson(person);
                return l;
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void delete(long personID, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("DELETE FROM loyality WHERE PersonID = ?");
            ps.setLong(1, personID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<Loyality> getLoyList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        for (Loyality l : Loyality.getList(controller)) {
            list.add((Object)l);
        }
        return list;
    }

    public double getBuyingPointsValueByID(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT l.BuyingPointsValue FROM loyality l WHERE l.LoyalityID = ?");
            ps.setLong(1, this.LoyalityID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            this.BuyingPointsValue = rs.getDouble(1);
            ps.close();
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.BuyingPointsValue;
    }

    public void update(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement(" UPDATE loyality SET  \t\t`PersonID` = ?,\t\t`CardNumber` = ?,\t\t`Discount` = ?,\t\t`Active` = ?,\t\t`BuyingPointsValue` = ?,\t\t`SellingPointsValue` = ?,\t\t`NumberEntry` = ?,\t\t`DiscountEntry` = ?,\t\t`VIPLoyaltyPrice` = ?, \t\t`Note` = ?,\t\t`LoyaltyGroupID` = ?,\t\t`PeriodDays` = ?    WHERE `LoyalityID` = ?");
            ps.setLong(1, this.PersonID);
            ps.setString(2, this.CardNumber);
            ps.setDouble(3, this.Discount);
            ps.setBoolean(4, this.Active);
            ps.setDouble(5, this.BuyingPointsValue);
            ps.setDouble(6, this.SellingPointsValue);
            ps.setInt(7, this.NumberEntry);
            ps.setDouble(8, this.DiscountEntry);
            ps.setBoolean(9, this.vipLoyaltyPrice);
            ps.setString(10, this.note);
            ps.setLong(11, this.loyaltyGroupId);
            ps.setString(12, this.periodDays);
            ps.setLong(13, this.LoyalityID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updatePoints(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement(" UPDATE loyality SET `Points` = ? WHERE `LoyalityID` = ?");
            ps.setDouble(1, this.Points);
            ps.setLong(2, this.LoyalityID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void updateCurencyEntry(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement(" UPDATE loyality SET `CurrentNumberEntry` = ? WHERE `LoyalityID` = ?");
            ps.setDouble(1, this.CurrentNumberEntry);
            ps.setLong(2, this.LoyalityID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void addLoyaliti(Person selectedPerson, ScreensController controller) {
        Loyality l = new Loyality();
        l.setPersonID(selectedPerson.getPersonID());
        l.setCardNumber(selectedPerson.getCode());
        l.setActive(selectedPerson.isActive());
        l.setDiscount(selectedPerson.getDiscount());
        l.setSysDTCreated(selectedPerson.getSysDTCreated());
        l.setSysDTEdit(selectedPerson.getSysDTEdit());
        l.setSysUserAddID(selectedPerson.getSysUserAddID());
        l.setSysUserEditID(selectedPerson.getSysUserEditID());
        l.setVipLoyaltyPrice(false);
        l.setNote("");
        l.setPeriodDays("YEAR");
        l.setLoyaltyGroupId(1L);
        l.insert(controller);
        selectedPerson.setLoyality(l);
        LoyaltyLimit loyaltyLimit = new LoyaltyLimit();
        loyaltyLimit.setLoyaltyId(l.getLoyalityID());
        loyaltyLimit.setDateTo(Date.valueOf(LocalDate.now()));
        LoyalitySettings lSettings = new LoyalitySettings();
        loyaltyLimit.setLimitValue(Double.parseDouble(lSettings.getActualByName(controller, "loyalty.limit.value")));
        loyaltyLimit.setNumberOfDates(1);
        loyaltyLimit.setActive(false);
        loyaltyLimit.insert(controller);
    }

    public static void doLoyalitFinancialDiscount(Person selectedPerson, ScreensController controller) {
        for (LoyaltyFinancialDiscount loyaltyFinancialDiscount : LoyaltyFinancialDiscount.getListByLoyalty(selectedPerson.getLoyality().getLoyalityID(), controller)) {
            loyaltyFinancialDiscount.delete(controller);
        }
        for (LoyaltyFinancialDiscount loyaltyFinancialDiscount : LoyaltyFinancialDiscount.getListByLoyalty(selectedPerson.getLoyality().getLoyalityID(), controller)) {
            loyaltyFinancialDiscount.setLoyaltyID(selectedPerson.getLoyality().getLoyalityID());
            loyaltyFinancialDiscount.insert(controller);
        }
    }
}

