/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Person;

public class Contact {
    private long ContactID;
    private int ContactTypeID;
    private long PersonID;
    private String Contact;
    private boolean Active;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;

    public void setContactTypeID(int contactTypeID) {
        this.ContactTypeID = contactTypeID;
    }

    public int getContactTypeID() {
        return this.ContactTypeID;
    }

    public void setContact(String contact) {
        this.Contact = contact;
    }

    public String getContact() {
        return this.Contact;
    }

    public void setContactID(long contactID) {
        this.ContactID = contactID;
    }

    public long getContactID() {
        return this.ContactID;
    }

    public long getAddressID() {
        return this.ContactID;
    }

    public void setAddressID(long addressID) {
        this.ContactID = addressID;
    }

    public long getPersonID() {
        return this.PersonID;
    }

    public void setPersonID(long personID) {
        this.PersonID = personID;
    }

    public String getAddress() {
        return this.Contact;
    }

    public void setAddress(String address) {
        this.Contact = address;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public long insert(ScreensController controller) {
        String query = "insert into contact (ContactTypeID,PersonID,Contact,Active,sysUserAddID) values (?,?,?,?,?)";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setInt(1, this.ContactTypeID);
            ps.setLong(2, this.PersonID);
            ps.setString(3, this.Contact);
            ps.setBoolean(4, this.Active);
            ps.setLong(5, controller.getUser().getUserID());
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.ContactID = rs.getLong(1);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.ContactID;
    }

    public void update(ScreensController controller) {
        String query = " UPDATE contact SET  \t\t`ContactTypeID` = ?,\t\t`PersonID` = ?,\t\t`Contact` = ?,\t\t`Active` = ?,\t\t`sysDTEdit` = ?,\t\t`sysUserEditID` = ? WHERE `ContactID` = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setInt(1, this.ContactTypeID);
            ps.setLong(2, this.PersonID);
            ps.setString(3, this.Contact);
            ps.setBoolean(4, this.Active);
            ps.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now()));
            ps.setLong(6, controller.getUser().getUserID());
            ps.setLong(7, this.ContactID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<Contact> getListByPerson(Person person, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from contact  where PersonID = ?    and Active = true group by ContactTypeID order by ContactTypeID asc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (person != null) {
                ps.setLong(1, person.getPersonID());
            } else {
                ps.setNull(1, -5);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Contact a = new Contact();
                a.ContactID = rs.getLong("ContactID");
                a.ContactTypeID = rs.getInt("ContactTypeID");
                a.PersonID = rs.getLong("PersonID");
                a.Contact = rs.getString("Contact");
                a.Active = rs.getBoolean("Active");
                a.sysDTCreated = rs.getTimestamp("sysDTCreated");
                a.sysDTEdit = rs.getTimestamp("sysDTEdit");
                a.sysUserAddID = rs.getLong("sysUserAddID");
                a.sysUserEditID = rs.getLong("sysUserEditID");
                list.add((Object)a);
            }
            ps.close();
            rs.close();
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Contact getByID(long id, Connection connection) {
        String query = "select * from contact where ContactID = ? ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Contact a = new Contact();
            a.ContactID = rs.getLong("ContactID");
            a.ContactTypeID = rs.getInt("ContactTypeID");
            a.PersonID = rs.getLong("PersonID");
            a.Contact = rs.getString("Contact");
            a.Active = rs.getBoolean("Active");
            a.sysDTCreated = rs.getTimestamp("sysDTCreated");
            a.sysDTEdit = rs.getTimestamp("sysDTEdit");
            a.sysUserAddID = rs.getLong("sysUserAddID");
            a.sysUserEditID = rs.getLong("sysUserEditID");
            ps.close();
            rs.close();
            return a;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Contact getByPersonAndType(long personID, int contactType, Connection connection) {
        String query = "select * from contact where PersonID = ? and ContactTypeID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, personID);
            ps.setInt(2, contactType);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Contact a = new Contact();
                a.ContactID = rs.getLong("ContactID");
                a.ContactTypeID = rs.getInt("ContactTypeID");
                a.PersonID = rs.getLong("PersonID");
                a.Contact = rs.getString("Contact");
                a.Active = rs.getBoolean("Active");
                a.sysDTCreated = rs.getTimestamp("sysDTCreated");
                a.sysDTEdit = rs.getTimestamp("sysDTEdit");
                a.sysUserAddID = rs.getLong("sysUserAddID");
                a.sysUserEditID = rs.getLong("sysUserEditID");
                return a;
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void delete(long personID, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("DELETE FROM contact WHERE PersonID = ?");
            ps.setLong(1, personID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

