/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Excise;
import rs.petcom.master.dal.ExciseProduct;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.VeleprodajnaFaktura;
import rs.petcom.master.dal.product.Product;

public class VeleprodajnaFakturaDetailes {
    private long DocumentDetailsID;
    private long DocumentID;
    private long ProductID;
    private double PriceWithDiscount;
    private double Price;
    private double NewPrice;
    private double priceWithoutVat;
    private String ProductCode;
    private String ProductName;
    private Product product;
    private double Quantity;
    private double Sum;
    private double Discount;
    private double ExciseValue;
    private double SumWithDiscount;
    private double SumWitoutVat;
    private double SumVat;
    private double VatValue;
    private LocalDateTime dateEdit;
    private LocalDateTime dateCreate;
    private String jedinicaMere;

    public void setDateCreate(LocalDateTime dateCreate) {
        this.dateCreate = dateCreate;
    }

    public LocalDateTime getDateCreate() {
        return this.dateCreate;
    }

    public void setDateEdit(LocalDateTime dateEdit) {
        this.dateEdit = dateEdit;
    }

    public LocalDateTime getDateEdit() {
        return this.dateEdit;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setVatValue(double vatValue) {
        this.VatValue = vatValue;
    }

    public double getVatValue() {
        return this.VatValue;
    }

    public void setSumWithDiscount(double sumWithDiscount) {
        this.SumWithDiscount = sumWithDiscount;
    }

    public double getSumWithDiscount() {
        return this.SumWithDiscount;
    }

    public double getSumWitoutVat() {
        return this.SumWitoutVat;
    }

    public void setSumWitoutVat(double sumWitoutVat) {
        this.SumWitoutVat = sumWitoutVat;
    }

    public double getSumVat() {
        return this.SumVat;
    }

    public void setSumVat(double sumVat) {
        this.SumVat = sumVat;
    }

    public void setSum(double sum) {
        this.Sum = sum;
    }

    public double getSum() {
        return this.Sum;
    }

    public long getDocumentDetailsID() {
        return this.DocumentDetailsID;
    }

    public void setDocumentDetailsID(long documentDetailsID) {
        this.DocumentDetailsID = documentDetailsID;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public String getProductCode() {
        return this.ProductCode;
    }

    public void setProductCode(String productCode) {
        this.ProductCode = productCode;
    }

    public String getProductName() {
        return this.ProductName;
    }

    public void setProductName(String productName) {
        this.ProductName = productName;
    }

    public double getQuantity() {
        return this.Quantity;
    }

    public void setQuantity(double quantity) {
        this.Quantity = quantity;
    }

    public void setPrice(double price) {
        this.Price = price;
    }

    public double getPrice() {
        return this.Price;
    }

    public double getNewPrice() {
        return this.NewPrice;
    }

    public void setNewPrice(double newPrice) {
        this.NewPrice = newPrice;
    }

    public double getPriceWithoutVat() {
        return this.priceWithoutVat;
    }

    public void setPriceWithoutVat(double priceWithoutVat) {
        this.priceWithoutVat = priceWithoutVat;
    }

    public double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(double discount) {
        this.Discount = discount;
    }

    public double getExciseValue() {
        return this.ExciseValue;
    }

    public void setExciseValue(double exciseValue) {
        this.ExciseValue = exciseValue;
    }

    public double getPriceWithDiscount() {
        return this.PriceWithDiscount;
    }

    public void setPriceWithDiscount(double priceWithDiscount) {
        this.PriceWithDiscount = priceWithDiscount;
    }

    public String getJedinicaMere() {
        return this.jedinicaMere;
    }

    public void setJedinicaMere(String jedinicaMere) {
        this.jedinicaMere = jedinicaMere;
    }

    public static ObservableList<VeleprodajnaFakturaDetailes> getlist(VeleprodajnaFaktura veleprodajnaFaktura, long departmentID, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT d.*, p.*, doc.DeliveryDate FROM documentdetails d LEFT JOIN document doc ON doc.DocumentID = d.DocumentID LEFT JOIN product p ON p.ProductID = d.ProductID WHERE d.DocumentID = ? ORDER BY d.documentdetailsid ASC";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, veleprodajnaFaktura.getDocumentID());
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                VeleprodajnaFakturaDetailes pd = new VeleprodajnaFakturaDetailes();
                pd.DocumentDetailsID = resultSet.getLong("DocumentDetailsID");
                pd.DocumentID = resultSet.getLong("DocumentID");
                pd.ProductID = resultSet.getLong("ProductID");
                pd.ProductCode = resultSet.getString("Code");
                pd.ProductName = resultSet.getString("Name");
                pd.Quantity = resultSet.getDouble("Quantity");
                pd.NewPrice = resultSet.getDouble("NewPrice");
                pd.Discount = resultSet.getDouble("Discount");
                pd.PriceWithDiscount = resultSet.getDouble("PriceWithDiscount");
                pd.Price = pd.PriceWithDiscount * 100.0 / (100.0 - pd.Discount);
                pd.product = Product.getByID(pd.ProductID, controller);
                pd.VatValue = Vat.getById(pd.product.getVatID(), controller.getSettings().getConnection()).getValue3();
                pd.priceWithoutVat = pd.getPrice() - pd.getPrice() * pd.VatValue;
                ExciseProduct exciseProduct = ExciseProduct.getByProductId(controller.getSettings().getConnection(), pd.product.getProductID());
                pd.ExciseValue = exciseProduct != null ? Excise.getById(controller, exciseProduct.getExciseId()).getValue() * exciseProduct.getValue() : 0.0;
                try {
                    pd.dateEdit = resultSet.getTimestamp("DeliveryDate").toLocalDateTime();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    pd.dateEdit = resultSet.getTimestamp("sysDTCreated").toLocalDateTime();
                }
                pd.setJedinicaMere(Unit.getUnitById(resultSet.getInt("UnitID"), controller.getSettings().getConnection()).getCode());
                pd.Sum = pd.getNewPrice() * pd.Quantity;
                pd.SumWitoutVat = pd.getQuantity() * pd.getNewPrice() - pd.getNewPrice() * pd.VatValue;
                pd.SumWithDiscount = pd.getPriceWithDiscount() * pd.Quantity;
                pd.setSumVat(pd.getSum() - pd.getSumWitoutVat());
                list.add((Object)pd);
            }
            ps.close();
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(ScreensController controller) {
        try {
            DocumentDetails dd = new DocumentDetails();
            dd.setDocumentDetailsID(this.DocumentDetailsID);
            dd.delete(controller.getSettings().getConnection());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.DocumentDetailsID, controller.getSettings().getConnection());
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.update(controller);
    }

    public void updateWithDiscount(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.DocumentDetailsID, controller.getSettings().getConnection());
        dd.setProductID(this.ProductID);
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setDiscount(this.Discount);
        dd.update(controller);
    }

    public long insert(ScreensController controller) {
        long result;
        Product p = Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.DocumentID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        this.DocumentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public long insertWithDiscount(ScreensController controller) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.DocumentID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(this.product.getUnitID());
        dd.setVatID(this.product.getVatID());
        dd.setDiscount(this.Discount);
        dd.setNewPrice(this.NewPrice);
        dd.setPrice(Product.getCurrentPrice(this.product.getProductID(), Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), false, controller.getSettings().getConnection()));
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        dd.setProduct(this.product);
        return dd.insert(controller.getSettings().getConnection());
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

