/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.PrijemnicaCentralniMagacin;
import rs.petcom.master.dal.product.Product;

public class PrijemnicaCentralniMagacinDetailes {
    private long DocumentDetailsID;
    private long DocumentID;
    private long ProductID;
    private double PriceWithDiscount;
    private double Price;
    private String ProductCode;
    private String ProductName;
    private Product Product;
    private double Quantity;
    private double PriceWithoutVatAndDiscount;
    private double Sum;
    private double Discount;
    private double SumWithDiscount;
    private double Vat;
    private double SumWithVat;
    private double SellPrice;
    private double Margin;
    private LocalDateTime dateEdit;
    private LocalDateTime dateCreate;
    private double NewSellPrice;
    private double PurchasePrice;
    private double sumPurchasePrice;
    private double PurchasePriceWithoutRabat;
    private String jedinicaMere;

    public void setDateCreate(LocalDateTime dateCreate) {
        this.dateCreate = dateCreate;
    }

    public LocalDateTime getDateCreate() {
        return this.dateCreate;
    }

    public void setDateEdit(LocalDateTime dateEdit) {
        this.dateEdit = dateEdit;
    }

    public LocalDateTime getDateEdit() {
        return this.dateEdit;
    }

    public void setProduct(Product product) {
        this.Product = product;
    }

    public Product getProduct() {
        return this.Product;
    }

    public void setSellPrice(double sellPrice) {
        this.SellPrice = sellPrice;
    }

    public double getSellPrice() {
        return this.SellPrice;
    }

    public void setPriceWithoutVatAndDiscount(double priceWithoutVatAndDiscount) {
        this.PriceWithoutVatAndDiscount = priceWithoutVatAndDiscount;
    }

    public double getPriceWithoutVatAndDiscount() {
        return this.PriceWithoutVatAndDiscount;
    }

    public double getSumWithVat() {
        return this.SumWithVat;
    }

    public void setSumWithVat(double sumWithVat) {
        this.SumWithVat = sumWithVat;
    }

    public void setVat(double vat) {
        this.Vat = vat;
    }

    public double getVat() {
        return this.Vat;
    }

    public void setSumWithDiscount(double sumWithDiscount) {
        this.SumWithDiscount = sumWithDiscount;
    }

    public double getSumWithDiscount() {
        return this.SumWithDiscount;
    }

    public void setSum(double sum) {
        this.Sum = sum;
    }

    public double getSum() {
        return this.Sum;
    }

    public void setPurchasePrice(double nabavnaCenaProizvoda) {
        this.PurchasePrice = nabavnaCenaProizvoda;
    }

    public double getPurchasePrice() {
        return this.PurchasePrice;
    }

    public double getPurchasePriceWithoutRabat() {
        return this.PurchasePriceWithoutRabat;
    }

    public void setPurchasePriceWithoutRabat(double purchasePriceWithoutRabat) {
        this.PurchasePriceWithoutRabat = purchasePriceWithoutRabat;
    }

    public double getNewSellPrice() {
        return this.NewSellPrice;
    }

    public void setNewSellPrice(double sellPrice) {
        this.NewSellPrice = sellPrice;
    }

    public double getMargin() {
        return this.Margin;
    }

    public void setMargin(double margin) {
        this.Margin = margin;
    }

    public long getDocumentDetailsID() {
        return this.DocumentDetailsID;
    }

    public void setDocumentDetailsID(long documentDetailsID) {
        this.DocumentDetailsID = documentDetailsID;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public String getProductCode() {
        return this.ProductCode;
    }

    public void setProductCode(String productCode) {
        this.ProductCode = productCode;
    }

    public String getProductName() {
        return this.ProductName;
    }

    public void setProductName(String productName) {
        this.ProductName = productName;
    }

    public double getQuantity() {
        return this.Quantity;
    }

    public void setQuantity(double quantity) {
        this.Quantity = quantity;
    }

    public void setPrice(double price) {
        this.Price = price;
    }

    public double getPrice() {
        return this.Price;
    }

    public double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(double discount) {
        this.Discount = discount;
    }

    public double getPriceWithDiscount() {
        return this.PriceWithDiscount;
    }

    public void setPriceWithDiscount(double priceWithDiscount) {
        this.PriceWithDiscount = priceWithDiscount;
    }

    public double getSumPurchasePrice() {
        return this.sumPurchasePrice;
    }

    public void setSumPurchasePrice(double sumPurchasePrice) {
        this.sumPurchasePrice = sumPurchasePrice;
    }

    public String getJedinicaMere() {
        return this.jedinicaMere;
    }

    public void setJedinicaMere(String jedinicaMere) {
        this.jedinicaMere = jedinicaMere;
    }

    public static ObservableList<PrijemnicaCentralniMagacinDetailes> getlist(PrijemnicaCentralniMagacin prijemnica, int objectID, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT d.`*`, p.`*`, doc.DeliveryDate FROM documentdetails d LEFT JOIN document doc ON doc.DocumentID = d.DocumentID LEFT JOIN product p ON p.ProductID = d.ProductID WHERE d.DocumentID = ? ORDER BY d.documentdetailsid ASC";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, prijemnica.getDocumentID());
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                PrijemnicaCentralniMagacinDetailes pd = new PrijemnicaCentralniMagacinDetailes();
                pd.DocumentDetailsID = resultSet.getLong("DocumentDetailsID");
                pd.DocumentID = resultSet.getLong("DocumentID");
                pd.ProductID = resultSet.getLong("ProductID");
                pd.ProductCode = resultSet.getString("Code");
                pd.ProductName = resultSet.getString("Name");
                pd.Quantity = resultSet.getDouble("Quantity");
                pd.Price = resultSet.getDouble("Price");
                pd.Discount = resultSet.getDouble("Discount");
                pd.PriceWithDiscount = resultSet.getDouble("PriceWithDiscount");
                pd.PurchasePrice = resultSet.getDouble("PurchacePrice");
                pd.PurchasePriceWithoutRabat = pd.getPurchasePrice() + pd.getPurchasePrice() * pd.getDiscount() / (100.0 - pd.getDiscount());
                try {
                    pd.dateEdit = resultSet.getTimestamp("DeliveryDate").toLocalDateTime();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    pd.dateEdit = resultSet.getTimestamp("sysDTCreated").toLocalDateTime();
                }
                pd.Product = rs.petcom.master.dal.product.Product.getByID(pd.ProductID, controller);
                pd.Vat = pd.Product.getVatValue();
                pd.setJedinicaMere(Unit.getUnitById(resultSet.getInt("UnitID"), controller.getSettings().getConnection()).getName());
                pd.Sum = pd.getPurchasePriceWithoutRabat() * pd.Quantity;
                pd.SumWithDiscount = pd.getPurchasePrice() * pd.Quantity;
                pd.SumWithVat = pd.Sum * pd.Vat;
                pd.setSellPrice(pd.Product.getCurrentPriceBeforeDatePrijemnicaCentralniMagacin(Settings.DatefromLocalDateTime(pd.dateEdit), objectID, controller.getSettings().getConnection()));
                if (resultSet.getDouble("NewPrice") == 0.0) {
                    pd.setNewSellPrice(pd.Product.getCurrentPriceBeforeDatePrijemnicaCentralniMagacin(Settings.fromLocalDate(pd.dateEdit.toLocalDate()), objectID, controller.getSettings().getConnection()));
                } else {
                    pd.setNewSellPrice(resultSet.getDouble("NewPrice"));
                }
                pd.setMargin((pd.getNewSellPrice() - pd.getPriceWithDiscount()) / pd.getPriceWithDiscount() * 100.0);
                list.add((Object)pd);
            }
            ps.close();
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.DocumentDetailsID);
        dd.delete(connection);
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.DocumentDetailsID, controller.getSettings().getConnection());
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.update(controller);
    }

    public void updateWithDiscount(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.DocumentDetailsID, controller.getSettings().getConnection());
        dd.setProductID(this.ProductID);
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setDiscount(this.Discount);
        dd.setNewPrice(this.SellPrice);
        dd.setPurchacePrice(this.PurchasePrice);
        dd.update(controller);
    }

    public long insert(ScreensController controller) {
        long result;
        Product p = rs.petcom.master.dal.product.Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.DocumentID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        dd.setNewPrice(this.SellPrice);
        this.DocumentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public long insertWithDiscount(ScreensController controller) {
        long result;
        Product p = rs.petcom.master.dal.product.Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.DocumentID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setDiscount(this.Discount);
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        dd.setNewPrice(this.NewSellPrice);
        dd.setPurchacePrice(this.PurchasePrice);
        this.DocumentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

