/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.PocetnoStanje;
import rs.petcom.master.dal.product.Product;

public class PocetnoStanjeDetailes {
    private long PocetnoStanjeDetailesID;
    private long PocetnoStanjeID;
    private long ProductID;
    private String ProductCode;
    private String ProductName;
    private String barcode;
    private double Quantity;
    private double sellPrice;
    private LocalDateTime Date;
    private double pocetno;

    public PocetnoStanjeDetailes() {
    }

    public PocetnoStanjeDetailes(long PocetnoStanjeDetailesID, long PocetnoStanjeID, long ProductID, String ProductCode, String ProductName, String barcode, double Quantity, double sellPrice) {
        this.PocetnoStanjeDetailesID = PocetnoStanjeDetailesID;
        this.PocetnoStanjeID = PocetnoStanjeID;
        this.ProductID = ProductID;
        this.ProductCode = ProductCode;
        this.ProductName = ProductName;
        this.barcode = barcode;
        this.Quantity = Quantity;
        this.sellPrice = sellPrice;
        this.pocetno = 0.0;
    }

    public long getPocetnoStanjeDetailesID() {
        return this.PocetnoStanjeDetailesID;
    }

    public void setPocetnoStanjeDetailesID(long pocetnoStanjeDetailesID) {
        this.PocetnoStanjeDetailesID = pocetnoStanjeDetailesID;
    }

    public long getPocetnoStanjeID() {
        return this.PocetnoStanjeID;
    }

    public void setPocetnoStanjeID(long pocetnoStanjeID) {
        this.PocetnoStanjeID = pocetnoStanjeID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public String getProductCode() {
        return this.ProductCode;
    }

    public void setProductCode(String productCode) {
        this.ProductCode = productCode;
    }

    public String getProductName() {
        return this.ProductName;
    }

    public void setProductName(String productName) {
        this.ProductName = productName;
    }

    public double getQuantity() {
        return this.Quantity;
    }

    public void setQuantity(double quantity) {
        this.Quantity = quantity;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(double sellPrice) {
        this.sellPrice = sellPrice;
    }

    public void setDate(LocalDateTime date) {
        this.Date = date;
    }

    public LocalDateTime getDate() {
        return this.Date;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public double getPocetno() {
        return this.pocetno;
    }

    public void setPocetno(double pocetno) {
        this.pocetno = pocetno;
    }

    public static ObservableList<PocetnoStanjeDetailes> getlist(PocetnoStanje pocetnoStanje, String filter, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT d.DocumentDetailsID, d.DocumentID,\td.ProductID, doc.Date, p.Code, p.Name, d.Quantity, b.BarCode, \r\ncurrent_price_before_date(p.ProductID, doc.Date, 1) AS SellPrice FROM documentdetails d \r\nLEFT JOIN product p ON p.ProductID = d.ProductID LEFT JOIN barcode b ON d.ProductID = b.ProductID\r\nLEFT JOIN document doc ON doc.DocumentID=d.DocumentID WHERE d.DocumentID =?\r\nAND (p.Code LIKE ? OR b.BarCode LIKE ? OR p.Name LIKE ?) ";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            if (pocetnoStanje.getDocumentID() > 0L) {
                ps.setLong(1, pocetnoStanje.getDocumentID());
                ps.setString(2, filter + "%");
                ps.setString(3, filter + "%");
                ps.setString(4, filter + "%");
            } else {
                ps.setString(1, filter + "%");
                ps.setString(2, filter + "%");
                ps.setString(3, filter + "%");
            }
            ResultSet rs = ps.executeQuery();
            System.out.println(ps);
            double run = 0.0;
            double sum = 0.0;
            while (rs.next()) {
                run += 1.0;
                list.add((Object)new PocetnoStanjeDetailes(rs.getLong("DocumentDetailsID"), rs.getLong("DocumentID"), rs.getLong("ProductID"), rs.getString("Code"), rs.getString("Name"), rs.getString("BarCode"), rs.getDouble("Quantity"), rs.getDouble("SellPrice")));
                sum += rs.getDouble("Quantity") * rs.getDouble("SellPrice");
            }
            System.out.println(run);
            System.out.println(sum);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PocetnoStanjeDetailes> getFilteredList(String filter, Long pocetnoStanje, Connection connection, LocalDate pocetnjoStanjeDate) {
        Date psDate = Settings.sqlDateFromLocalDate(pocetnjoStanjeDate);
        ObservableList list = FXCollections.observableArrayList();
        if (filter.trim().isEmpty()) {
            return list;
        }
        String query = "SELECT d.DocumentDetailsID, d.DocumentID,\td.ProductID, p.Code, p.Name, d.Quantity, b.BarCode,  current_price_before_date(p.ProductID, d.sysDTCreated, 1) AS SellPrice FROM documentdetails d LEFT JOIN product p ON p.ProductID = d.ProductID LEFT JOIN barcode b ON d.ProductID = b.ProductID WHERE DocumentID = ? AND (p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?) ORDER BY p.ProductID ";
        if (pocetnoStanje < 1L) {
            query = "SELECT -1 as DocumentDetailsID, -1 as DocumentID, p.ProductID, p.Code, p.Name, b.BarCode, 0 AS Quantity,  current_price_before_date(p.ProductID, ?, 1) AS SellPrice FROM product p LEFT JOIN barcode b ON p.ProductID = b.ProductID WHERE p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?  ORDER BY p.ProductID";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (pocetnoStanje > 0L) {
                ps.setLong(1, pocetnoStanje);
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
                ps.setString(4, "%" + filter + "%");
            } else {
                ps.setDate(1, psDate);
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
                ps.setString(4, "%" + filter + "%");
            }
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add((Object)new PocetnoStanjeDetailes(rs.getLong("DocumentDetailsID"), rs.getLong("DocumentID"), rs.getLong("ProductID"), rs.getString("Code"), rs.getString("Name"), rs.getString("BarCode"), rs.getDouble("Quantity"), rs.getDouble("SellPrice")));
                if (list.size() != 100) continue;
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.PocetnoStanjeDetailesID);
        dd.delete(connection);
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.PocetnoStanjeDetailesID, controller.getSettings().getConnection());
        dd.setQuantity(this.Quantity);
        dd.update(controller);
    }

    public long insert(ScreensController controller) {
        long result;
        Product p = Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.PocetnoStanjeID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setQuantity(this.Quantity);
        dd.setNewPrice(this.sellPrice);
        dd.setDate(this.Date);
        dd.setSysUserAddID(controller.getUser().getUserID());
        dd.setProduct(p);
        dd.setCosts(this.pocetno);
        this.PocetnoStanjeDetailesID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public String toString() {
        return (this.ProductCode != null ? this.ProductCode + " -- " : "") + this.ProductName + " -- " + this.barcode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PocetnoStanjeDetailes)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PocetnoStanjeDetailes that = (PocetnoStanjeDetailes)obj;
        if (this.ProductCode == null ? that.ProductCode != null : !this.ProductCode.equals(that.ProductCode)) {
            return false;
        }
        if (this.ProductName == null ? that.ProductName != null : !this.ProductName.equals(that.ProductName)) {
            return false;
        }
        return !(this.barcode == null ? that.barcode != null : !this.barcode.equals(that.barcode));
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.ProductCode == null ? 0 : this.ProductCode.hashCode());
        result = 31 * result + (this.ProductName == null ? 0 : this.ProductName.hashCode());
        result = 31 * result + (this.barcode == null ? 0 : this.barcode.hashCode());
        return result;
    }
}

