/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentStatus;

public class PocetnoStanje {
    long DocumentID;
    int Number;
    Date Date;
    int DepartmentID;
    String Note;
    String status;
    private boolean locked;

    public PocetnoStanje() {
    }

    public PocetnoStanje(long DocumentID, int Number2, Date Date2, int DepartmentID, String Note, String status, boolean locked) {
        this.DocumentID = DocumentID;
        this.Number = Number2;
        this.Date = Date2;
        this.DepartmentID = DepartmentID;
        this.Note = Note;
        this.status = status;
        this.locked = locked;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmentID) {
        this.DepartmentID = departmentID;
    }

    public String getNote() {
        return this.Note;
    }

    public void setNote(String note) {
        this.Note = note;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public static ObservableList<PocetnoStanje> getlist(Department department, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.DocumentID,d.Date,d.Number,d.DepartmentID, d.Note, d.DocumentStatusID, d.documentLocked  from document d  where d.DocumentTypeID = 11   and d.DepartmentID = ? order by d.Date desc, d.Number desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add((Object)new PocetnoStanje(rs.getLong("DocumentID"), rs.getInt("Number"), new Date(rs.getTimestamp("Date").getTime()), rs.getInt("DepartmentID"), rs.getString("Note"), DocumentStatus.getStatusNameByID(rs.getInt("DocumentStatusID"), connection), rs.getBoolean("documentLocked")));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public long insert(ScreensController controller, Date d) throws SQLException {
        Department department = Department.getById(this.getDepartmentID(), controller.getSettings().getConnection());
        Document document = new Document();
        document.setDocumentTypeID(11);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        document.setYear(cal.get(1));
        document.setDate(d);
        if (this.Number == -1) {
            document.setNumber(Document.getNextNumber(11, department, controller, LocalDate.now()));
        } else {
            document.setNumber(this.Number);
        }
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(this.DepartmentID);
        document.setNote(this.Note);
        document.setDocumentStatusID(DocumentStatus.getStatusByName(controller, this.status).getDocumentStatusID());
        this.DocumentID = document.insertWithModifiedDate(controller.getSettings().getConnection());
        return document.getDocumentID();
    }

    public void update(ScreensController controller, Date d) {
        try {
            Document document = Document.getByID(this.DocumentID, controller.getSettings().getConnection());
            document.setDocumentTypeID(11);
            document.setDocumentStatusID(1);
            document.setDate(d);
            document.setDepartmentID(this.DepartmentID);
            document.setNote(this.Note);
            document.setDocumentStatusID(DocumentStatus.getStatusByName(controller, this.status).getDocumentStatusID());
            document.update(controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) throws SQLException {
        Document d = Document.getByID(this.DocumentID, connection);
        DocumentDetails.deleteDetailes(d, connection);
        Document.delete(this.DocumentID, connection);
    }

    public static boolean initialStockExsistsOnDate(LocalDate intialStockDate, Connection connection) {
        java.sql.Date initStockDate = Settings.sqlDateFromLocalDate(intialStockDate);
        String query = "SELECT * FROM document d \r\nWHERE d.DocumentTypeID  = 11\r\nAND CAST(d.Date AS DATE) = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, initStockDate);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

