/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.SQLHelper;
import rs.petcom.master.dal.document.Document;

public class Otpis {
    private long DocumentID;
    private int DepartmentID;
    private int Number;
    private String ExternalNumber;
    private Date Date;
    private Date DeliveryDate;
    private Date PaymentDate;
    private String Place;
    private String comment;
    private boolean locked;

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documnetID) {
        this.DocumentID = documnetID;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmnetID) {
        this.DepartmentID = departmnetID;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getExternalNumber() {
        return this.ExternalNumber;
    }

    public void setExternalNumber(String externalNumber) {
        this.ExternalNumber = externalNumber;
    }

    public Date getDeliveryDate() {
        return this.DeliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.DeliveryDate = deliveryDate;
    }

    public Date getPaymentDate() {
        return this.PaymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.PaymentDate = paymentDate;
    }

    public String getPlace() {
        return this.Place;
    }

    public void setPlace(String place) {
        this.Place = place;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void delete(Connection connection) throws SQLException {
        String query = "delete from document where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.DocumentID);
        ps.executeUpdate();
        ps.close();
    }

    public long insert(ScreensController controller) throws SQLException {
        Document document = new Document();
        document.setDocumentTypeID(7);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        document.setYear(cal.get(1));
        document.setDate(this.Date);
        document.setNumber(this.Number);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(this.DepartmentID);
        document.setNote(this.comment);
        this.DocumentID = document.insert(controller);
        return document.getDocumentID();
    }

    public void update(ScreensController controller) {
        Document document = Document.getByID(this.DocumentID, controller.getSettings().getConnection());
        document.setYear(document.getYear());
        document.setDate(this.Date);
        document.setPlace(this.Place);
        document.setNote(this.comment);
        document.setSysUserAddID(controller.getUser().getUserID());
        try {
            document.update(controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean exists(String externalNumber, Connection connection) {
        boolean result = false;
        String query = "select count(DocumentID)   from document  where DocumentTypeID = 7    and ExternalNumber = '" + externalNumber + "'";
        result = SQLHelper.QueryToInt(query, connection, 0) > 0;
        return result;
    }

    public static ObservableList<Otpis> getList(Date dateFrom, Date dateTo, Department department, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *   from document where DocumentTypeID = 7   and DATE(Date) >= ?    and Date < DATE_ADD(?,INTERVAL 1 DAY)    and DepartmentID = ? order by Date desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(dateFrom.getTime()));
            ps.setTimestamp(2, new Timestamp(dateTo.getTime()));
            ps.setInt(3, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Otpis p = new Otpis();
                p.DocumentID = rs.getLong("DocumentID");
                p.Number = rs.getInt("Number");
                p.Date = rs.getTimestamp("Date");
                p.DeliveryDate = rs.getTimestamp("DeliveryDate");
                p.PaymentDate = rs.getTimestamp("CurrencyDate");
                p.comment = rs.getString("Note");
                p.Place = rs.getString("Place");
                p.DepartmentID = rs.getInt("DepartmentID");
                p.ExternalNumber = rs.getString("ExternalNumber");
                p.locked = rs.getBoolean("documentLocked");
                list.add((Object)p);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void exportToXml(String fileName, Connection connection) throws FileNotFoundException, UnsupportedEncodingException, SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Department department = Department.getById(this.DepartmentID, connection);
        PrintWriter writer = new PrintWriter(fileName, "UTF-8");
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        writer.println("<Prijemnica>");
        writer.println("\t<PrijemnicaData>");
        writer.println("\t\t<PrijemnicaDataID>" + this.getDocumentID() + "</PrijemnicaDataID>");
        writer.println("\t\t<DepartmentCode>" + department.getCode() + "</DepartmentCode>");
        writer.println("\t\t<DepartmentName>" + department.getName() + "</DepartmentName>");
        writer.println("\t\t<Number>" + this.getNumber() + "</Number>");
        writer.println("\t\t<ExternalNumber>" + this.getExternalNumber() + "</ExternalNumber>");
        writer.println("\t\t<Date>" + sdf.format(this.getDate()) + "</Date>");
        writer.println("\t\t<DeliveryDate>" + sdf.format(this.getDeliveryDate()) + "</DeliveryDate>");
        writer.println("\t\t<PaymentDate>" + sdf.format(this.getPaymentDate()) + "</PaymentDate>");
        writer.println("\t\t<Place>" + this.Place + "</Place>");
        writer.println("\t\t<Comment>" + this.comment + "</Comment>");
        writer.println("\t</PrijemnicaData>");
        writer.println("\t<PrijemnicaStavke>");
        writer.println("\t</PrijemnicaStavke>");
        writer.println("</Prijemnica>");
        writer.close();
    }
}

