/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentRelationship;
import rs.petcom.master.dal.document.ReportMapModel;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class Faktura {
    private Document document;
    private long parentDocumentID;
    private Person customer;
    private String BI;
    int difoltnaValutaPlacanja;

    public void setBI(String bI) {
        this.BI = bI;
    }

    public String getBI() {
        return this.BI;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public long getParentDocumentID() {
        return this.parentDocumentID;
    }

    public void setParentDocumentID(long parentDocumentID) {
        this.parentDocumentID = parentDocumentID;
    }

    public Person getCustomer() {
        return this.customer;
    }

    public void setCustomer(Person customer) {
        this.customer = customer;
    }

    public void print(ScreensController controller, Window owner) {
        String reportFileName = "rs/petcom/master/jasper/InvoiceNew2.jasper";
        this.customer = Person.getById(this.document.getPersonID(), controller);
        CompanyConfig companyConfig = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get(controller.getSettings().getConnection()));
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("company", companyConfig);
        hm.put("document", this.document);
        hm.put("documentId", this.document.getDocumentID());
        hm.put("billAmount", ScreensController.BrojUSlova(this.document.getSumWithDiscount()));
        hm.put("gotovinski", false);
        hm.put("profaktura", false);
        hm.put("barcodeInReport", Boolean.parseBoolean(controller.getSettings().getActualByName("barkod.vidljiv.izlazni.dokumenti")));
        if (controller.getSettings().getActualByName("napomena.faktura") != null) {
            hm.put("napomena", controller.getSettings().getActualByName("napomena.faktura"));
        } else {
            hm.put("napomena", this.document.getNote());
        }
        hm.put("docNumber", String.valueOf(Document.getByID(DocumentRelationship.getChildID(this.document.getDocumentID(), controller), controller.getSettings().getConnection()).getNumber()));
        this.difoltnaValutaPlacanja = Integer.parseInt(controller.getSettings().getSetting("valuta.placanja", null));
        hm.put("valutaPlacanja", this.customer.getCurrencyPaymentDays() > 0 ? new Date(Settings.fromLocalDate(LocalDate.now().plusDays(this.customer.getCurrencyPaymentDays())).getTime()) : new Date(Settings.fromLocalDate(LocalDate.now().plusDays(this.difoltnaValutaPlacanja)).getTime()));
        hm.put("BI", this.BI != null && !this.BI.equals("") ? this.BI : this.document.getFullNumber());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            if (controller.getSettings().getActualByName("automatska.stampa.faktura").equals("true")) {
                for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.faktura")); ++i) {
                    JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                }
            } else {
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("report", (java.lang.Object)printViewPane);
                controller.showModalDialog("Faktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printExcise(ScreensController controller, Window owner) {
        String reportFileName = "rs/petcom/master/jasper/InvoiceExcise.jasper";
        this.customer = Person.getById(this.document.getPersonID(), controller);
        CompanyConfig companyConfig = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get(controller.getSettings().getConnection()));
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("object", controller.getObject());
        hm.put("company", companyConfig);
        hm.put("document", this.document);
        hm.put("documentId", this.document.getDocumentID());
        hm.put("billAmount", ScreensController.BrojUSlova(this.document.getSumWithDiscount()));
        hm.put("gotovinski", false);
        hm.put("profaktura", false);
        if (controller.getSettings().getActualByName("napomena.faktura") != null) {
            hm.put("napomena", controller.getSettings().getActualByName("napomena.faktura"));
        } else {
            hm.put("napomena", this.document.getNote());
        }
        hm.put("docNumber", String.valueOf(Document.getByID(DocumentRelationship.getChildID(this.document.getDocumentID(), controller), controller.getSettings().getConnection()).getNumber()));
        this.difoltnaValutaPlacanja = Integer.parseInt(controller.getSettings().getSetting("valuta.placanja", null));
        hm.put("valutaPlacanja", this.customer.getCurrencyPaymentDays() > 0 ? new Date(Settings.fromLocalDate(LocalDate.now().plusDays(this.customer.getCurrencyPaymentDays())).getTime()) : new Date(Settings.fromLocalDate(LocalDate.now().plusDays(this.difoltnaValutaPlacanja)).getTime()));
        hm.put("BI", this.BI != null && !this.BI.equals("") ? this.BI : this.document.getFullNumber());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            if (controller.getSettings().getActualByName("automatska.stampa.faktura").equals("true")) {
                for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.faktura")); ++i) {
                    JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                }
            } else {
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("report", (java.lang.Object)printViewPane);
                controller.showModalDialog("Faktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printVeleprodajnaFaktura(ScreensController controller, Window owner) {
        String reportFileName = "rs/petcom/master/jasper/InvoiceExcise.jasper";
        this.customer = Person.getById(this.document.getPersonID(), controller);
        CompanyConfig companyConfig = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get(controller.getSettings().getConnection()));
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        Document parentDoc = Document.getByID(this.document.getDocumentID(), controller.getSettings().getConnection());
        hm.put("object", controller.getObject());
        hm.put("company", companyConfig);
        hm.put("document", parentDoc);
        hm.put("documentId", parentDoc.getDocumentID());
        hm.put("billAmount", ScreensController.BrojUSlova(parentDoc.getSumWithDiscount()));
        hm.put("gotovinski", false);
        hm.put("profaktura", false);
        if (controller.getSettings().getActualByName("napomena.vp.faktura") != null) {
            hm.put("napomena", controller.getSettings().getActualByName("napomena.vp.faktura"));
        } else {
            hm.put("napomena", parentDoc.getNote());
        }
        hm.put("docNumber", String.valueOf(this.document.getNumber()));
        hm.put("valutaPlacanja", Date.valueOf(Settings.fromDate(parentDoc.getCurrencyDate())));
        hm.put("BI", this.BI != null && !this.BI.equals("") ? this.BI : parentDoc.getFullNumber());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            if (controller.getSettings().getActualByName("automatska.stampa.veleprodajnefaktura").equals("true")) {
                for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.veleprodajnefaktura")); ++i) {
                    JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                }
            } else {
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("report", (java.lang.Object)printViewPane);
                controller.showModalDialog("Faktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printVeleprodajnaFakturaBezAkciza(ScreensController controller, Window owner) {
        String reportFileName = "rs/petcom/master/jasper/InvoiceVeleprodajnaFaktura.jasper";
        this.customer = Person.getById(this.document.getPersonID(), controller);
        CompanyConfig companyConfig = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get(controller.getSettings().getConnection()));
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        Document parentDoc = Document.getByID(this.document.getDocumentID(), controller.getSettings().getConnection());
        hm.put("object", controller.getObject());
        hm.put("company", companyConfig);
        hm.put("document", parentDoc);
        hm.put("documentId", parentDoc.getDocumentID());
        hm.put("billAmount", ScreensController.BrojUSlova(parentDoc.getSumWithDiscount()));
        hm.put("gotovinski", false);
        hm.put("profaktura", false);
        if (controller.getSettings().getActualByName("napomena.vp.faktura") != null) {
            hm.put("napomena", controller.getSettings().getActualByName("napomena.vp.faktura"));
        } else {
            hm.put("napomena", parentDoc.getNote());
        }
        hm.put("docNumber", String.valueOf(this.document.getNumber()));
        hm.put("valutaPlacanja", Date.valueOf(Settings.fromDate(parentDoc.getCurrencyDate())));
        hm.put("BI", this.BI != null && !this.BI.equals("") ? this.BI : parentDoc.getFullNumber());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            if (controller.getSettings().getActualByName("automatska.stampa.veleprodajnefaktura").equals("true")) {
                for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.veleprodajnefaktura")); ++i) {
                    JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                }
            } else {
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("report", (java.lang.Object)printViewPane);
                controller.showModalDialog("Faktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printRezervacija(ScreensController controller, Window owner) {
        String reportFileName = "rs/petcom/master/jasper/InvoiceRezervacija.jasper";
        this.customer = Person.getById(this.document.getPersonID(), controller);
        CompanyConfig companyConfig = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get(controller.getSettings().getConnection()));
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        Document parentDoc = Document.getByID(this.document.getDocumentID(), controller.getSettings().getConnection());
        hm.put("object", controller.getObject());
        hm.put("company", companyConfig);
        hm.put("document", parentDoc);
        hm.put("documentId", parentDoc.getDocumentID());
        hm.put("billAmount", ScreensController.BrojUSlova(parentDoc.getSumWithDiscount()));
        hm.put("gotovinski", false);
        hm.put("profaktura", false);
        hm.put("napomena", parentDoc.getNote());
        hm.put("avansNapomena", parentDoc.getNote2());
        hm.put("docNumber", String.valueOf(this.document.getNumber()));
        hm.put("valutaPlacanja", Date.valueOf(Settings.fromDate(parentDoc.getCurrencyDate())));
        hm.put("BI", this.BI != null && !this.BI.equals("") ? this.BI : parentDoc.getFullNumber());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
            hm2.put("report", (java.lang.Object)printViewPane);
            controller.showModalDialog("Faktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printPorudzbenica(ScreensController controller, Window owner) {
        String reportFileName = "rs/petcom/master/jasper/InvoicePorudzbenica.jasper";
        this.customer = Person.getById(this.document.getPersonID(), controller);
        CompanyConfig companyConfig = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get(controller.getSettings().getConnection()));
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        Document parentDoc = Document.getByID(this.document.getDocumentID(), controller.getSettings().getConnection());
        hm.put("object", controller.getObject());
        hm.put("company", companyConfig);
        hm.put("document", parentDoc);
        hm.put("documentId", parentDoc.getDocumentID());
        hm.put("billAmount", ScreensController.BrojUSlova(parentDoc.getSumWithDiscount()));
        hm.put("gotovinski", false);
        hm.put("profaktura", false);
        hm.put("napomena", parentDoc.getNote());
        hm.put("docNumber", String.valueOf(this.document.getNumber()));
        hm.put("valutaPlacanja", Date.valueOf(Settings.fromDate(parentDoc.getCurrencyDate())));
        hm.put("BI", this.BI != null && !this.BI.equals("") ? this.BI : parentDoc.getFullNumber());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
            hm2.put("report", (java.lang.Object)printViewPane);
            controller.showModalDialog("Poridzbenica", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printEnglishVeleprodajnaFaktura(ScreensController controller, Window owner) {
        String reportFileName = "rs/petcom/master/jasper/InvoiceExciseEnglish.jasper";
        this.customer = Person.getById(this.document.getPersonID(), controller);
        CompanyConfig companyConfig = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get(controller.getSettings().getConnection()));
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("customer", this.customer);
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        Document parentDoc = Document.getByID(this.document.getDocumentID(), controller.getSettings().getConnection());
        hm.put("object", controller.getObject());
        hm.put("company", companyConfig);
        hm.put("document", parentDoc);
        hm.put("documentId", parentDoc.getDocumentID());
        hm.put("billAmount", ScreensController.BrojUSlova(parentDoc.getSumWithDiscount()));
        hm.put("gotovinski", false);
        hm.put("profaktura", false);
        if (controller.getSettings().getActualByName("napomena.vp.faktura") != null) {
            hm.put("napomena", controller.getSettings().getActualByName("napomena.vp.faktura"));
        } else {
            hm.put("napomena", parentDoc.getNote());
        }
        hm.put("docNumber", String.valueOf(this.document.getNumber()));
        hm.put("valutaPlacanja", Date.valueOf(Settings.fromDate(parentDoc.getCurrencyDate())));
        hm.put("BI", this.BI != null && !this.BI.equals("") ? this.BI : parentDoc.getFullNumber());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            if (controller.getSettings().getActualByName("automatska.stampa.veleprodajnefaktura").equals("true")) {
                for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.veleprodajnefaktura")); ++i) {
                    JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                }
            } else {
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("report", (java.lang.Object)printViewPane);
                controller.showModalDialog("Faktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printInterno(ScreensController controller, Window owner) {
        try {
            String reportFileName = "rs/petcom/master/jasper/InvoiceInterno.jasper";
            this.customer = Person.getById(this.document.getPersonID(), controller);
            Map<String, java.lang.Object> hm = ReportMapModel.getReportMap(controller);
            hm.put("document", this.document);
            hm.put("documentId", this.document.getDocumentID());
            hm.put("billAmount", ScreensController.BrojUSlova(this.document.getSumWithDiscount()));
            hm.put("docNumber", String.valueOf(this.document.getNumber()));
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
            hm2.put("report", (java.lang.Object)printViewPane);
            controller.showModalDialog("Profaktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printProfaktura(ScreensController controller, Window owner) {
        try {
            String reportFileName = "rs/petcom/master/jasper/InvoiceNew2.jasper";
            this.customer = Person.getById(this.document.getPersonID(), controller);
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            for (Images images : Images.getImagesList(controller)) {
                if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                    if (images.getName().equals("memorandum")) {
                        try {
                            hm.put("memorandum", ImageIO.read(images.getImage()));
                            hm.put("logo", null);
                            break;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    hm.put("memorandum", null);
                    continue;
                }
                hm.put("memorandum", null);
                if (images.getName().equals("logo")) {
                    try {
                        hm.put("logo", ImageIO.read(images.getImage()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                hm.put("logo", null);
            }
            hm.put("objekat", Object.get(controller.getSettings().getConnection()));
            CompanyConfig companyConfig = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
            try {
                hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
                hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            hm.put("customer", this.customer);
            try {
                hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            hm.put("barcodeInReport", Boolean.parseBoolean(controller.getSettings().getActualByName("barkod.vidljiv.izlazni.dokumenti")));
            hm.put("document", this.document);
            hm.put("documentId", this.document.getDocumentID());
            hm.put("billAmount", ScreensController.BrojUSlova(this.document.getSumWithDiscount()));
            if (this.document.getPaymentMethodID() == PaymentMethod.getByCode("OTP", controller.getSettings().getConnection()).getPaymentMethodID()) {
                hm.put("gotovinski", true);
                hm.put("profaktura", false);
                if (controller.getSettings().getActualByName("napomena.otpremnica") != null) {
                    hm.put("napomena", controller.getSettings().getActualByName("napomena.otpremnica"));
                } else {
                    hm.put("napomena", this.document.getNote());
                }
            } else {
                if (controller.getSettings().getActualByName("napomena.profaktura") != null) {
                    hm.put("napomena", controller.getSettings().getActualByName("napomena.profaktura"));
                } else {
                    hm.put("napomena", this.document.getNote());
                }
                hm.put("avansNapomena", this.document.getNote2());
                hm.put("gotovinski", false);
                hm.put("profaktura", true);
            }
            hm.put("docNumber", String.valueOf(this.document.getNumber()));
            hm.put("valutaPlacanja", this.customer.getCurrencyPaymentDays() > 0 ? new Date(Settings.fromLocalDate(LocalDate.now().plusDays(this.customer.getCurrencyPaymentDays())).getTime()) : new Date(Settings.fromLocalDate(LocalDate.now().plusDays(controller.getSettings().getValutaPlacanja())).getTime()));
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            if (((Boolean)hm.get("profaktura")).booleanValue() && !((Boolean)hm.get("gotovinski")).booleanValue()) {
                if (controller.getSettings().getActualByName("automatska.stampa.profaktura").equals("true")) {
                    for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.profaktura")); ++i) {
                        JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                    }
                } else {
                    JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                    HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                    hm2.put("report", (java.lang.Object)printViewPane);
                    controller.showModalDialog("Profaktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
                }
            } else if (controller.getSettings().getActualByName("automatska.stampa.otpremnica").equals("true")) {
                for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.otpremnica")); ++i) {
                    JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                }
            } else {
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("report", (java.lang.Object)printViewPane);
                controller.showModalDialog("Profaktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printPonuda(ScreensController controller, Window owner) {
        try {
            String reportFileName = "rs/petcom/master/jasper/InvoiceNew2.jasper";
            this.customer = Person.getById(this.document.getPersonID(), controller);
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            for (Images images : Images.getImagesList(controller)) {
                if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                    if (images.getName().equals("memorandum")) {
                        try {
                            hm.put("memorandum", ImageIO.read(images.getImage()));
                            hm.put("logo", null);
                            break;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    hm.put("memorandum", null);
                    continue;
                }
                hm.put("memorandum", null);
                if (images.getName().equals("logo")) {
                    try {
                        hm.put("logo", ImageIO.read(images.getImage()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                hm.put("logo", null);
            }
            hm.put("objekat", Object.get(controller.getSettings().getConnection()));
            CompanyConfig companyConfig = CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller);
            hm.put("customer", this.customer);
            try {
                hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
                hm.put("addressCompany", Address.getByID(companyConfig.getAddressID(), controller.getSettings().getConnection()));
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            hm.put("customer", this.customer);
            try {
                hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            hm.put("document", this.document);
            hm.put("documentId", this.document.getDocumentID());
            hm.put("billAmount", ScreensController.BrojUSlova(this.document.getSumWithDiscount()));
            if (this.document.getPaymentMethodID() == PaymentMethod.getByCode("OTP", controller.getSettings().getConnection()).getPaymentMethodID()) {
                hm.put("gotovinski", true);
                hm.put("profaktura", false);
                if (controller.getSettings().getActualByName("napomena.otpremnica") != null) {
                    hm.put("napomena", controller.getSettings().getActualByName("napomena.otpremnica"));
                } else {
                    hm.put("napomena", this.document.getNote());
                }
            } else {
                if (controller.getSettings().getActualByName("napomena.profaktura") != null) {
                    hm.put("napomena", controller.getSettings().getActualByName("napomena.profaktura"));
                } else {
                    hm.put("napomena", this.document.getNote());
                }
                hm.put("gotovinski", false);
                hm.put("profaktura", true);
            }
            hm.put("docNumber", String.valueOf(this.document.getNumber()));
            hm.put("valutaPlacanja", this.customer.getCurrencyPaymentDays() > 0 ? new Date(Settings.fromLocalDate(LocalDate.now().plusDays(this.customer.getCurrencyPaymentDays())).getTime()) : new Date(Settings.fromLocalDate(LocalDate.now().plusDays(controller.getSettings().getValutaPlacanja())).getTime()));
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            if (((Boolean)hm.get("profaktura")).booleanValue() && !((Boolean)hm.get("gotovinski")).booleanValue()) {
                if (controller.getSettings().getActualByName("automatska.stampa.profaktura").equals("true")) {
                    for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.profaktura")); ++i) {
                        JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                    }
                } else {
                    JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                    HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                    hm2.put("report", (java.lang.Object)printViewPane);
                    controller.showModalDialog("Profaktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
                }
            } else if (controller.getSettings().getActualByName("automatska.stampa.otpremnica").equals("true")) {
                for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.otpremnica")); ++i) {
                    JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                }
            } else {
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("report", (java.lang.Object)printViewPane);
                controller.showModalDialog("Profaktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

