/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.WorkDay;

public class DocumentPayment {
    private long DocumentPaymentID;
    private long DocumentID;
    private int PaymentMethodID;
    private double Paid;
    private double Tax;

    public static void updateTax(long documentID, double totalRateAmount, ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`documentpayment` SET `Tax` = ? WHERE  `DocumentID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setDouble(1, totalRateAmount);
            pStatement.setLong(2, documentID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static DocumentPayment findByLprf(String refNumber, ScreensController controller) {
        String sql = "select * from document where ReferentNumber = ?";
        try {
            PreparedStatement preparedStatement = controller.getSettings().getConnection().prepareStatement(sql);
            preparedStatement.setString(1, refNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.first()) {
                DocumentPayment documentPayment = DocumentPayment.getByDocumentId(resultSet.getLong("DocumentID"), controller);
                System.out.println("vrendost je findByLprf " + documentPayment.DocumentID);
                return documentPayment;
            }
            return new DocumentPayment();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getDocumentPaymentID() {
        return this.DocumentPaymentID;
    }

    public void setDocumentPaymentID(long documentPaymentID) {
        this.DocumentPaymentID = documentPaymentID;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public int getPaymentMethodID() {
        return this.PaymentMethodID;
    }

    public void setPaymentMethodID(int paymentMethodID) {
        this.PaymentMethodID = paymentMethodID;
    }

    public double getPaid() {
        return this.Paid;
    }

    public void setTax(double tax) {
        this.Tax = tax;
    }

    public double getTax() {
        return this.Tax;
    }

    public void setPaid(double paid) {
        this.Paid = paid;
    }

    public static void insert(long documentId, int paymentMethodId, double paid, Connection connection) throws SQLException {
        String query = "insert into documentpayment (DocumentID,PaymentMethodID,Paid) values(?,?,?)";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, documentId);
        ps.setInt(2, paymentMethodId);
        ps.setDouble(3, paid);
        ps.executeUpdate();
        ps.close();
    }

    public static DocumentPayment getByDocumentId(long documentId, ScreensController controller) {
        String query = "SELECT * FROM documentpayment dp WHERE dp.DocumentID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, documentId);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            DocumentPayment documentPayment = new DocumentPayment();
            documentPayment.setDocumentPaymentID(rSet.getLong("DocumentPaymentID"));
            documentPayment.setDocumentID(documentId);
            documentPayment.setPaymentMethodID(rSet.getInt("PaymentMethodID"));
            documentPayment.setPaid(rSet.getDouble("Paid"));
            try {
                documentPayment.setTax(rSet.getDouble("tax"));
            }
            catch (Exception e) {
                e.printStackTrace();
                documentPayment.setTax(0.0);
            }
            return documentPayment;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LinkedList<DocumentPayment> getCombinedPaymentByDocumentId(long documentId, ScreensController controller) {
        String query = "SELECT * FROM documentpayment dp WHERE dp.DocumentID = ?";
        LinkedList<DocumentPayment> payments = new LinkedList<DocumentPayment>();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, documentId);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                DocumentPayment documentPayment = new DocumentPayment();
                documentPayment.setDocumentPaymentID(rSet.getLong("DocumentPaymentID"));
                documentPayment.setDocumentID(documentId);
                documentPayment.setPaymentMethodID(rSet.getInt("PaymentMethodID"));
                documentPayment.setPaid(rSet.getDouble("Paid"));
                payments.add(documentPayment);
            }
            return payments;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updatePM(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`documentpayment` SET `PaymentMethodID` = ? WHERE  `DocumentPaymentID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, this.PaymentMethodID);
            pStatement.setLong(2, this.DocumentPaymentID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAll(WorkDay wDay, ScreensController controller) {
        String query = "DELETE dp FROM documentpayment dp LEFT JOIN document d ON d.DocumentID = dp.DocumentID WHERE d.Date < ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            System.out.println(pStatement);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAllBills(WorkDay wDay, ScreensController controller) {
        String query = "DELETE dp FROM documentpayment dp LEFT JOIN document d ON d.DocumentID = dp.DocumentID WHERE d.Date < ? AND d.DocumentTypeID IN (3,4,17)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            System.out.println(pStatement);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

