/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WarehouseCentral;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.product.Product;

public class DocumentDetails {
    private long DocumentDetailsID;
    private long ParentDocumentDetailsID;
    private long DocumentID;
    private long ProductID;
    private long ParentProductID;
    private double Quantity;
    private int VatID;
    private int UnitID;
    private double Price;
    private double Discount;
    private double PriceWithDiscount;
    private double Costs;
    private double NewPrice;
    private long DocumentChangeID;
    private LocalDateTime Date;
    private java.util.Date sysDTCreated;
    private java.util.Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private int WarehouseID;
    private int SaleTableID;
    private double PurchacePrice;
    private int OrderNumber;
    private boolean SubTotal;
    private boolean Closed;
    private int DescriptionID;
    private String ProductCode;
    private String ProductName;
    private String ProductShortName;
    private double Value;
    private String Barcode;
    private Product Product;
    private double refundQuantity;
    private static final Logger LOGGER = Logger.getLogger("global");

    public void setDate(LocalDateTime date) {
        this.Date = date;
    }

    public LocalDateTime getDate() {
        return this.Date;
    }

    public long getDocumentDetailsID() {
        return this.DocumentDetailsID;
    }

    public void setDocumentDetailsID(long documentDetailsID) {
        this.DocumentDetailsID = documentDetailsID;
    }

    public long getParentDocumentDetailsID() {
        return this.ParentDocumentDetailsID;
    }

    public void setParentDocumentDetailsID(long parentDocumentDetailsID) {
        this.ParentDocumentDetailsID = parentDocumentDetailsID;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public long getParentProductID() {
        return this.ParentProductID;
    }

    public void setParentProductID(long parentProductID) {
        this.ParentProductID = parentProductID;
    }

    public double getQuantity() {
        return this.Quantity;
    }

    public void setQuantity(double quantity) {
        this.Quantity = quantity;
    }

    public int getVatID() {
        return this.VatID;
    }

    public void setVatID(int vatID) {
        this.VatID = vatID;
    }

    public int getUnitID() {
        return this.UnitID;
    }

    public void setUnitID(int unitID) {
        this.UnitID = unitID;
    }

    public double getPrice() {
        return this.Price;
    }

    public void setPrice(double price) {
        this.Price = price;
    }

    public double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(double discount) {
        this.Discount = discount;
    }

    public double getPriceWithDiscount() {
        return this.PriceWithDiscount;
    }

    public void setPriceWithDiscount(double priceWithDiscount) {
        this.PriceWithDiscount = priceWithDiscount;
    }

    public double getCosts() {
        return this.Costs;
    }

    public void setCosts(double costs) {
        this.Costs = costs;
    }

    public double getNewPrice() {
        return this.NewPrice;
    }

    public void setNewPrice(double newPrice) {
        this.NewPrice = newPrice;
    }

    public long getDocumentChangeID() {
        return this.DocumentChangeID;
    }

    public void setDocumentChangeID(long documentChangeID) {
        this.DocumentChangeID = documentChangeID;
    }

    public java.util.Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(java.util.Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public java.util.Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(java.util.Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public int getWarehouseID() {
        return this.WarehouseID;
    }

    public void setWarehouseID(int warehouseID) {
        this.WarehouseID = warehouseID;
    }

    public int getSaleTableID() {
        return this.SaleTableID;
    }

    public void setSaleTableID(int saleTableID) {
        this.SaleTableID = saleTableID;
    }

    public double getPurchacePrice() {
        return this.PurchacePrice;
    }

    public void setPurchacePrice(double purchacePrice) {
        this.PurchacePrice = purchacePrice;
    }

    public int getOrderNumber() {
        return this.OrderNumber;
    }

    public void setOrderNumber(int orderNumber) {
        this.OrderNumber = orderNumber;
    }

    public boolean isSubTotal() {
        return this.SubTotal;
    }

    public void setSubTotal(boolean subTotal) {
        this.SubTotal = subTotal;
    }

    public boolean isClosed() {
        return this.Closed;
    }

    public void setClosed(boolean closed) {
        this.Closed = closed;
    }

    public int getDescriptionID() {
        return this.DescriptionID;
    }

    public void setDescriptionID(int descriptionID) {
        this.DescriptionID = descriptionID;
    }

    public String getProductCode() {
        return this.ProductCode;
    }

    public void setProductCode(String productCode) {
        this.ProductCode = productCode;
    }

    public String getProductName() {
        return this.ProductName;
    }

    public void setProductName(String productName) {
        this.ProductName = productName;
    }

    public String getProductShortName() {
        return this.ProductShortName;
    }

    public void setProductShortName(String productShortName) {
        this.ProductShortName = productShortName;
    }

    public void setValue(double value) {
        this.Value = value;
    }

    public double getValue() {
        return this.Value;
    }

    public String getBarcode() {
        return this.Barcode;
    }

    public void setBarcode(String barcode) {
        this.Barcode = barcode;
    }

    public Product getProduct() {
        return this.Product;
    }

    public void setProduct(Product product) {
        this.Product = product;
    }

    public double getRefundQuantity() {
        return this.refundQuantity;
    }

    public void setRefundQuantity(double refundQuantity) {
        this.refundQuantity = refundQuantity;
    }

    public long insert(Connection connection) {
        String query = "insert into documentdetails( \t\t`DocumentID`,\t\t`ParentDocumentDetailsID`,\t\t`ProductID`, `ProductName`,\t\t`ParentProductID`,\t\t`Quantity`,\t\t`VatID`,\t\t`UnitID`,\t\t`Price`,\t\t`Discount`,\t\t`PriceWithDiscount`,\t\t`Costs`,\t\t`NewPrice`,\t\t`DocumentChangeID`, `Date`,\t\t`sysUserAddID`,\t\t`WarehouseID`,\t\t`SaleTableID`,\t\t`PurchacePrice`,\t\t`OrderNumber`,\t\t`SubTotal`,\t\t`Closed`,\t\t`DescriptionID` ) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.DocumentID);
            if (this.ParentDocumentDetailsID > 0L) {
                ps.setLong(2, this.ParentDocumentDetailsID);
            } else {
                ps.setNull(2, -5);
            }
            ps.setLong(3, this.ProductID);
            if (this.Product == null) {
                ps.setString(4, this.ProductName);
            } else {
                ps.setString(4, this.Product.getName());
            }
            if (this.ParentProductID != 0L) {
                ps.setLong(5, this.ParentProductID);
            } else {
                ps.setNull(5, -5);
            }
            ps.setDouble(6, this.Quantity);
            if (this.VatID == 2000) {
                ps.setInt(7, 2000);
            } else {
                ps.setInt(7, this.VatID);
            }
            ps.setInt(8, this.UnitID);
            ps.setDouble(9, this.Price);
            ps.setDouble(10, this.Discount);
            ps.setDouble(11, this.PriceWithDiscount);
            ps.setDouble(12, this.Costs);
            ps.setDouble(13, this.NewPrice);
            if (this.DocumentChangeID != 0L) {
                ps.setLong(14, this.DocumentChangeID);
            } else {
                ps.setNull(14, -5);
            }
            if (this.Date != null) {
                ps.setTimestamp(15, Timestamp.valueOf(this.Date));
            } else {
                ps.setNull(15, 91);
            }
            ps.setLong(16, this.sysUserAddID);
            if (this.WarehouseID != 0) {
                ps.setLong(17, this.WarehouseID);
            } else {
                ps.setNull(17, -5);
            }
            if (this.SaleTableID != 0) {
                ps.setInt(18, this.SaleTableID);
            } else {
                ps.setNull(18, -5);
            }
            ps.setDouble(19, this.PurchacePrice);
            if (this.OrderNumber != 0) {
                ps.setInt(20, this.OrderNumber);
            } else {
                ps.setNull(20, 4);
            }
            ps.setBoolean(21, this.SubTotal);
            ps.setBoolean(22, this.Closed);
            if (this.DescriptionID != 0) {
                ps.setLong(23, this.DescriptionID);
            } else {
                ps.setNull(23, -5);
            }
            LOGGER.info(ps.toString());
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            long ddID = rs.getLong(1);
            ps.close();
            rs.close();
            return ddID;
        }
        catch (SQLException e) {
            throw new RuntimeException("Problem kod upisa detalja na dokumentu" + e.getMessage());
        }
    }

    public void updateByDocumentID(Document documentID, ScreensController controller) {
        String query = "update documentdetails set \t\t`ParentDocumentDetailsID` = ?,\t\t`DocumentID` = ?,\t\t`ProductID` = ?,\t\t`ParentProductID` = ?,\t\t`Quantity` = ?,\t\t`VatID` = ?,\t\t`UnitID` = ?,\t\t`Price` = ?,\t\t`Discount` = ?,\t\t`PriceWithDiscount` = ?,\t\t`Costs` = ?,\t\t`NewPrice` = ?,\t\t`DocumentChangeID` = ?,\t\t`sysUserEditID` = ?,\t\t`WarehouseID` = ?,\t\t`SaleTableID` = ?,\t\t`PurchacePrice` = ?,\t\t`OrderNumber` = ?,\t\t`SubTotal` = ?,\t\t`Closed` = ?,\t\t`DescriptionID` = ?, `Date` = ?, `sysDTEdit` = ?  where DocumentDetailsID = ? AND DocumentID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            if (this.ParentDocumentDetailsID > 0L) {
                ps.setLong(1, this.ParentDocumentDetailsID);
            } else {
                ps.setNull(1, -5);
            }
            ps.setLong(2, this.DocumentID);
            ps.setLong(3, this.ProductID);
            if (this.ParentProductID != 0L) {
                ps.setLong(4, this.ParentProductID);
            } else {
                ps.setNull(4, -5);
            }
            ps.setDouble(5, this.Quantity);
            ps.setInt(6, this.VatID);
            ps.setInt(7, this.UnitID);
            ps.setDouble(8, this.Price);
            ps.setDouble(9, 0.0);
            ps.setDouble(10, this.PriceWithDiscount);
            ps.setDouble(11, this.Costs);
            ps.setDouble(12, this.NewPrice);
            if (this.DocumentChangeID != 0L) {
                ps.setLong(13, this.DocumentChangeID);
            } else {
                ps.setNull(13, -5);
            }
            ps.setLong(14, controller.getUser().getUserID());
            if (this.WarehouseID != 0) {
                ps.setLong(15, this.WarehouseID);
            } else {
                ps.setNull(15, -5);
            }
            if (this.SaleTableID != 0) {
                ps.setInt(16, this.SaleTableID);
            } else {
                ps.setNull(16, -5);
            }
            ps.setDouble(17, this.PurchacePrice);
            if (this.OrderNumber != 0) {
                ps.setInt(18, this.OrderNumber);
            } else {
                ps.setNull(18, 4);
            }
            ps.setBoolean(19, this.SubTotal);
            ps.setBoolean(20, this.Closed);
            if (this.DescriptionID != 0) {
                ps.setLong(21, this.DescriptionID);
            } else {
                ps.setNull(21, -5);
            }
            if (this.Date != null) {
                ps.setTimestamp(22, Timestamp.valueOf(this.Date));
            } else {
                ps.setNull(22, 93);
            }
            ps.setTimestamp(23, Timestamp.valueOf(LocalDateTime.now()));
            ps.setLong(24, this.DocumentDetailsID);
            ps.setLong(25, this.DocumentID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updateRefundQuantity(Connection connection, DocumentDetails detail) {
        String query = "UPDATE documentdetails dd SET dd.refundQuantity = dd.refundQuantity + ? WHERE \r\ndd.DocumentDetailsID = ?";
        try {
            connection.setAutoCommit(false);
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDouble(1, detail.getQuantity());
            ps.setLong(2, detail.DocumentDetailsID);
            ps.execute();
            connection.commit();
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            try {
                connection.rollback();
                connection.setAutoCommit(true);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "update documentdetails set \t\t`ParentDocumentDetailsID` = ?,\t\t`DocumentID` = ?,\t\t`ProductID` = ?,\t\t`ParentProductID` = ?,\t\t`Quantity` = ?,\t\t`VatID` = ?,\t\t`UnitID` = ?,\t\t`Price` = ?,\t\t`Discount` = ?,\t\t`PriceWithDiscount` = ?,\t\t`Costs` = ?,\t\t`NewPrice` = ?,\t\t`DocumentChangeID` = ?,\t\t`sysUserEditID` = ?,\t\t`WarehouseID` = ?,\t\t`SaleTableID` = ?,\t\t`PurchacePrice` = ?,\t\t`OrderNumber` = ?,\t\t`SubTotal` = ?,\t\t`Closed` = ?,\t\t`DescriptionID` = ?, `Date` = ?, `sysDTEdit` = ?  where DocumentDetailsID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            if (this.ParentDocumentDetailsID > 0L) {
                ps.setLong(1, this.ParentDocumentDetailsID);
            } else {
                ps.setNull(1, -5);
            }
            ps.setLong(2, this.DocumentID);
            ps.setLong(3, this.ProductID);
            if (this.ParentProductID != 0L) {
                ps.setLong(4, this.ParentProductID);
            } else {
                ps.setNull(4, -5);
            }
            ps.setDouble(5, this.Quantity);
            ps.setInt(6, this.VatID);
            ps.setInt(7, this.UnitID);
            ps.setDouble(8, this.Price);
            ps.setDouble(9, this.Discount);
            ps.setDouble(10, this.PriceWithDiscount);
            ps.setDouble(11, this.Costs);
            ps.setDouble(12, this.NewPrice);
            if (this.DocumentChangeID != 0L) {
                ps.setLong(13, this.DocumentChangeID);
            } else {
                ps.setNull(13, -5);
            }
            ps.setLong(14, controller.getUser().getUserID());
            if (this.WarehouseID != 0) {
                ps.setLong(15, this.WarehouseID);
            } else {
                ps.setNull(15, -5);
            }
            if (this.SaleTableID != 0) {
                ps.setInt(16, this.SaleTableID);
            } else {
                ps.setNull(16, -5);
            }
            ps.setDouble(17, this.PurchacePrice);
            if (this.OrderNumber != 0) {
                ps.setInt(18, this.OrderNumber);
            } else {
                ps.setNull(18, 4);
            }
            ps.setBoolean(19, this.SubTotal);
            ps.setBoolean(20, this.Closed);
            if (this.DescriptionID != 0) {
                ps.setLong(21, this.DescriptionID);
            } else {
                ps.setNull(21, -5);
            }
            if (this.Date != null) {
                ps.setTimestamp(22, Timestamp.valueOf(this.Date));
            } else {
                ps.setNull(22, 93);
            }
            ps.setTimestamp(23, Timestamp.valueOf(LocalDateTime.now()));
            ps.setLong(24, this.DocumentDetailsID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Problem sa updatom stavki");
        }
    }

    public static DocumentDetails getByID(long id, Connection connection) {
        String query = "select dd.*,p.Name,p.ShortName   from documentdetails dd  left join product p on p.ProductID = dd.ProductID  where dd.DocumentDetailsID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            DocumentDetails dd = new DocumentDetails();
            dd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
            dd.ParentDocumentDetailsID = rs.getLong("ParentDocumentDetailsID");
            dd.DocumentID = rs.getLong("DocumentID");
            dd.ProductID = rs.getLong("ProductID");
            dd.ParentProductID = rs.getLong("ParentProductID");
            dd.Quantity = rs.getDouble("Quantity");
            dd.VatID = rs.getInt("VatID");
            dd.UnitID = rs.getInt("UnitID");
            dd.Price = rs.getDouble("Price");
            dd.Discount = rs.getDouble("Discount");
            dd.PriceWithDiscount = rs.getDouble("PriceWithDiscount");
            dd.Costs = rs.getDouble("Costs");
            dd.NewPrice = rs.getDouble("NewPrice");
            dd.DocumentChangeID = rs.getLong("DocumentChangeID");
            try {
                dd.Date = rs.getTimestamp("Date").toLocalDateTime();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            dd.sysDTCreated = rs.getTimestamp("sysDTCreated");
            dd.sysDTEdit = rs.getTimestamp("sysDTCreated");
            dd.sysUserAddID = rs.getLong("sysUserAddID");
            dd.sysUserEditID = rs.getLong("sysUserEditID");
            dd.WarehouseID = rs.getInt("WarehouseID");
            dd.SaleTableID = rs.getInt("SaleTableID");
            dd.PurchacePrice = rs.getDouble("PurchacePrice");
            dd.OrderNumber = rs.getInt("OrderNumber");
            dd.SubTotal = rs.getBoolean("SubTotal");
            dd.Closed = rs.getBoolean("Closed");
            dd.DescriptionID = rs.getInt("DescriptionID");
            dd.ProductName = rs.getString("Name");
            dd.ProductShortName = rs.getString("ShortName");
            dd.Value = dd.Quantity * dd.PriceWithDiscount;
            ps.close();
            rs.close();
            return dd;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<DocumentDetails> getChangedPriceDocumentDetails(int departmentId, LocalDateTime from, LocalDateTime to, Connection connection) {
        ArrayList<DocumentDetails> list = new ArrayList<DocumentDetails>();
        String query = "SELECT DISTINCT dd.* FROM documentdetails dd LEFT JOIN pricelistdetails pld on pld.ProductID = dd.ProductID JOIN product p on p.ProductID = dd.ProductID AND p.ProductTypeID = 1 WHERE dd.sysDTCreated BETWEEN ? AND ? AND dd.DocumentID IN (SELECT d.DocumentID FROM document d WHERE d.DocumentTypeID IN (3, 22) AND d.DocumentStatusID NOT IN (SELECT ds.DocumentStatusID FROM documentstatus ds WHERE ds.Name = 'Storniran')) AND dd.Price <> dd.PriceWithDiscount";
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setTimestamp(1, Timestamp.valueOf(from));
            pStatement.setTimestamp(2, Timestamp.valueOf(to));
            ResultSet rs = pStatement.executeQuery();
            System.out.println(pStatement);
            while (rs.next()) {
                DocumentDetails dd = new DocumentDetails();
                dd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
                dd.ParentDocumentDetailsID = rs.getLong("ParentDocumentDetailsID");
                dd.DocumentID = rs.getLong("DocumentID");
                dd.ProductID = rs.getLong("ProductID");
                dd.ParentProductID = rs.getLong("ParentProductID");
                dd.Quantity = rs.getDouble("Quantity");
                dd.VatID = rs.getInt("VatID");
                dd.UnitID = rs.getInt("UnitID");
                dd.Price = rs.getDouble("Price");
                dd.Discount = rs.getDouble("Discount");
                dd.PriceWithDiscount = rs.getDouble("PriceWithDiscount");
                dd.Costs = rs.getDouble("Costs");
                dd.DocumentChangeID = rs.getLong("DocumentChangeID");
                dd.sysDTCreated = rs.getTimestamp("sysDTCreated");
                dd.sysDTEdit = rs.getTimestamp("sysDTCreated");
                dd.sysUserAddID = rs.getLong("sysUserAddID");
                dd.sysUserEditID = rs.getLong("sysUserEditID");
                list.add(dd);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static DocumentDetails getDocumentDetailsByFullNumber(int fullNumber, Connection connection) {
        String query = "SELECT dd.*  FROM documentdetails dd JOIN document d ON d.DocumentID = dd.DocumentID  WHERE d.FullNumber = ?  AND d.DocumentTypeID = 3";
        DocumentDetails dd = new DocumentDetails();
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setInt(1, fullNumber);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                dd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
                dd.ParentDocumentDetailsID = rs.getLong("ParentDocumentDetailsID");
                dd.DocumentID = rs.getLong("DocumentID");
                dd.ProductID = rs.getLong("ProductID");
                dd.ParentProductID = rs.getLong("ParentProductID");
                dd.Quantity = rs.getDouble("Quantity");
                dd.VatID = rs.getInt("VatID");
                dd.UnitID = rs.getInt("UnitID");
                dd.Price = rs.getDouble("Price");
                dd.Discount = rs.getDouble("Discount");
                dd.PriceWithDiscount = rs.getDouble("PriceWithDiscount");
                dd.Costs = rs.getDouble("Costs");
                dd.NewPrice = rs.getDouble("NewPrice");
                dd.DocumentChangeID = rs.getLong("DocumentChangeID");
                dd.sysDTCreated = rs.getTimestamp("sysDTCreated");
                dd.sysDTEdit = rs.getTimestamp("sysDTCreated");
                dd.sysUserAddID = rs.getLong("sysUserAddID");
                dd.sysUserEditID = rs.getLong("sysUserEditID");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return dd;
    }

    public static ObservableList<DocumentDetails> getListByReferentNumber(String referentNumber, Connection connection) {
        ObservableList details = FXCollections.observableArrayList();
        String query = "SELECT dd.DocumentDetailsId ,dd.productName, ROUND(dd.Quantity,3) AS quantity,\r\nROUND(dd.RefundQuantity,3) AS RefundQuantity, ROUND(dd.PriceWithDiscount,2) AS price, \r\nROUND((dd.Quantity * dd.PriceWithDiscount),2) AS value, dd.DocumentID, dd.VatID,\r\ndd.sysUserAddID, dd.UnitID, dd.ProductID\r\nFROM documentdetails dd \r\nJOIN document d ON dd.DocumentID = d.DocumentID\r\nWHERE d.ReferentNumber = ? and d.DocumentTypeId IN (3,20,32)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, referentNumber);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocumentDetails dd = new DocumentDetails();
                dd.setDocumentDetailsID(rs.getLong("DocumentDetailsId"));
                dd.setProductName(rs.getString("productName"));
                dd.setRefundQuantity(rs.getDouble("RefundQuantity"));
                dd.setQuantity(rs.getDouble("quantity") - dd.getRefundQuantity());
                dd.setPrice(rs.getDouble("price"));
                dd.setValue(Settings.roundOnTwo(dd.getQuantity() * dd.getPrice()));
                dd.setDocumentID(rs.getLong("DocumentID"));
                dd.setVatID(rs.getInt("VatID"));
                dd.setSysUserAddID(rs.getLong("sysUserAddID"));
                dd.setUnitID(rs.getInt("UnitID"));
                dd.setProductID(rs.getLong("ProductID"));
                dd.setPriceWithDiscount(rs.getDouble("price"));
                if (!(dd.getQuantity() > 0.0)) continue;
                details.add((Object)dd);
            }
            return details;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<DocumentDetails> getList(long documentId, Connection connection) {
        ArrayList<DocumentDetails> list = new ArrayList<DocumentDetails>();
        String query = "select dd.*, p.Code, p.Name, p.ShortName,(SELECT bc.BarCode FROM barcode bc WHERE bc.ProductID = p.ProductID order BY bc.BarCodeID LIMIT 1) AS Barcode   from documentdetails dd   left join  product p on dd.ProductID = p.ProductID";
        if (documentId != 0L) {
            query = query + " where dd.DocumentID = ?  ";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (documentId != 0L) {
                ps.setLong(1, documentId);
            }
            ResultSet rs1 = ps.executeQuery();
            System.out.println(ps);
            while (rs1.next()) {
                DocumentDetails dd = new DocumentDetails();
                dd.DocumentDetailsID = rs1.getLong("DocumentDetailsID");
                dd.DocumentID = rs1.getLong("DocumentID");
                dd.ProductID = rs1.getLong("ProductID");
                dd.ParentProductID = rs1.getLong("ParentProductID");
                dd.Quantity = rs1.getDouble("Quantity");
                dd.VatID = rs1.getInt("VatID");
                dd.UnitID = rs1.getInt("UnitID");
                dd.Price = rs1.getDouble("Price");
                dd.Discount = rs1.getDouble("Discount");
                dd.PriceWithDiscount = rs1.getDouble("PriceWithDiscount");
                dd.Costs = rs1.getDouble("Costs");
                dd.NewPrice = rs1.getDouble("NewPrice");
                dd.DocumentChangeID = rs1.getLong("DocumentChangeID");
                dd.sysDTCreated = rs1.getTimestamp("sysDTCreated");
                dd.sysDTEdit = rs1.getTimestamp("sysDTCreated");
                dd.sysUserAddID = rs1.getLong("sysUserAddID");
                dd.sysUserEditID = rs1.getLong("sysUserEditID");
                dd.WarehouseID = rs1.getInt("WarehouseID");
                dd.SaleTableID = rs1.getInt("SaleTableID");
                dd.PurchacePrice = rs1.getDouble("PurchacePrice");
                dd.OrderNumber = rs1.getInt("OrderNumber");
                dd.SubTotal = rs1.getBoolean("SubTotal");
                dd.Closed = rs1.getBoolean("Closed");
                dd.DescriptionID = rs1.getInt("DescriptionID");
                dd.ProductName = rs1.getString("Name");
                dd.ProductCode = rs1.getString("Code");
                dd.ProductShortName = rs1.getString("ShortName");
                dd.Value = Settings.round(dd.Quantity * dd.PriceWithDiscount, 2);
                dd.setBarcode(rs1.getString("Barcode"));
                list.add(dd);
            }
            ps.close();
            rs1.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<DocumentDetails> getListForOrder(long documentId, Connection connection) {
        ArrayList<DocumentDetails> list = new ArrayList<DocumentDetails>();
        String query = "SELECT dd.DocumentDetailsID, dd.DocumentID, dd.ProductID, dd.Quantity FROM documentdetails dd WHERE dd.DocumentID IN (SELECT drs.DocumentParentID FROM documentrelationship drs WHERE drs.DocumentChildID = ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, documentId);
            ResultSet rs1 = ps.executeQuery();
            while (rs1.next()) {
                DocumentDetails dd = new DocumentDetails();
                dd.DocumentDetailsID = rs1.getLong("DocumentDetailsID");
                dd.DocumentID = rs1.getLong("DocumentID");
                dd.ProductID = rs1.getLong("ProductID");
                Product product = rs.petcom.master.dal.product.Product.getByID(dd.getProductID(), 1L, connection);
                dd.setProductName(product.getName());
                dd.setBarcode(product.getBarcode());
                dd.Quantity = rs1.getDouble("Quantity");
                list.add(dd);
            }
            ps.close();
            rs1.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<DocumentDetails> getObeservableList(long documentId, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        for (DocumentDetails dd : DocumentDetails.getList(documentId, connection)) {
            list.add((Object)dd);
        }
        return list;
    }

    public static ArrayList<DocumentDetails> getSoldItems(WorkDay workday, ScreensController controller) {
        ArrayList<DocumentDetails> list = new ArrayList<DocumentDetails>();
        String query = "CALL sold_items_workday(?, ?)";
        try {
            CallableStatement cs = controller.getSettings().getConnection().prepareCall(query);
            cs.setLong(1, workday.getWorkDayID());
            cs.setDate(2, new Date(workday.getDate().getTime()));
            ResultSet rs = cs.executeQuery();
            while (rs.next()) {
                DocumentDetails dd = new DocumentDetails();
                dd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
                dd.ParentDocumentDetailsID = rs.getLong("ParentDocumentDetailsID");
                dd.DocumentID = rs.getLong("DocumentID");
                dd.ProductID = rs.getLong("ProductID");
                dd.ParentProductID = rs.getLong("ParentProductID");
                dd.Quantity = rs.getDouble("Quantity");
                dd.VatID = rs.getInt("VatID");
                dd.UnitID = rs.getInt("UnitID");
                dd.Price = rs.getDouble("Price");
                dd.Discount = rs.getDouble("Discount");
                dd.PriceWithDiscount = rs.getDouble("PriceWithDiscount");
                dd.Costs = rs.getDouble("Costs");
                dd.NewPrice = rs.getDouble("NewPrice");
                dd.DocumentChangeID = rs.getLong("DocumentChangeID");
                dd.sysDTCreated = rs.getTimestamp("sysDTCreated");
                dd.sysDTEdit = rs.getTimestamp("sysDTCreated");
                dd.sysUserAddID = rs.getLong("sysUserAddID");
                dd.sysUserEditID = rs.getLong("sysUserEditID");
                dd.WarehouseID = rs.getInt("WarehouseID");
                dd.SaleTableID = rs.getInt("SaleTableID");
                dd.PurchacePrice = rs.getDouble("PurchacePrice");
                dd.OrderNumber = rs.getInt("OrderNumber");
                dd.SubTotal = rs.getBoolean("SubTotal");
                dd.Closed = rs.getBoolean("Closed");
                dd.DescriptionID = rs.getInt("DescriptionID");
                dd.Value = dd.Quantity * dd.PriceWithDiscount;
                boolean dodato = false;
                for (DocumentDetails dd1 : list) {
                    if (dd1.getProductID() != dd.getProductID() || dd1.getPriceWithDiscount() != dd.getPriceWithDiscount()) continue;
                    dd1.setQuantity(dd1.getQuantity() + dd.getQuantity());
                    dodato = true;
                }
                if (dodato) continue;
                list.add(dd);
            }
            cs.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<DocumentDetails> getSoldItems(Department department, java.util.Date dateFrom, java.util.Date dateTo, Connection connection) {
        ArrayList<DocumentDetails> list = new ArrayList<DocumentDetails>();
        String query = "select dd.ProductID,\t   dd.ParentProductID,\t   sum(dd.Quantity),\t\tdd.VatID,\t\tdd.UnitID,\t\tdd.Price,\t\tdd.Discount,\t\tdd.PriceWithDiscount,\t\tdd.Costs,\t\tdd.NewPrice,\t\tdd.DocumentChangeID,\t\tdd.WarehouseID,\t\tdd.SaleTableID,\t\tdd.PurchacePrice,\t\tdd.OrderNumber,\t\tdd.SubTotal,\t\tdd.Closed,\t\tdd.DescriptionID\tfrom documentdetails dd\tleft join document d on d.DocumentID = dd.DocumentID and d.DocumentTypeID = 3\tinner join workday w on w.WorkDayID = d.WorkDayID and w.Date >= ? and w.Date <= ?  where d.DocumentID not in (select dr.DocumentParentID from documentrelationship dr where dr.RelationshipTypeID = 2)   and w.PointOfSaleID in (select PointOfSaleID from pointofsaledepartment where DepartmentID = ?) group by dd.ProductID,dd.ParentProductID,dd.VatID,dd.UnitID,dd.Price,dd.Discount,\t\t  dd.PriceWithDiscount,dd.Costs,dd.NewPrice,dd.DocumentChangeID,dd.WarehouseID,\t\t  dd.SaleTableID,dd.PurchacePrice,dd.OrderNumber,dd.SubTotal,dd.Closed,dd.DescriptionID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new Date(dateFrom.getTime()));
            ps.setDate(2, new Date(dateTo.getTime()));
            ps.setInt(3, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocumentDetails dd = new DocumentDetails();
                dd.ProductID = rs.getLong("ProductID");
                dd.ParentProductID = rs.getLong("ParentProductID");
                dd.Quantity = rs.getDouble("Quantity");
                dd.VatID = rs.getInt("VatID");
                dd.UnitID = rs.getInt("UnitID");
                dd.Price = rs.getDouble("Price");
                dd.Discount = rs.getDouble("Discount");
                dd.PriceWithDiscount = rs.getDouble("PriceWithDiscount");
                dd.Costs = rs.getDouble("Costs");
                dd.NewPrice = rs.getDouble("NewPrice");
                dd.DocumentChangeID = rs.getLong("DocumentChangeID");
                dd.WarehouseID = rs.getInt("WarehouseID");
                dd.SaleTableID = rs.getInt("SaleTableID");
                dd.PurchacePrice = rs.getDouble("PurchacePrice");
                dd.OrderNumber = rs.getInt("OrderNumber");
                dd.SubTotal = rs.getBoolean("SubTotal");
                dd.Closed = rs.getBoolean("Closed");
                dd.DescriptionID = rs.getInt("DescriptionID");
                dd.Value = dd.Quantity * dd.PriceWithDiscount;
                boolean dodato = false;
                for (DocumentDetails dd1 : list) {
                    if (dd1.getProductID() != dd.ProductID) continue;
                    dd1.setQuantity(dd1.getQuantity() + dd.getQuantity());
                    dodato = true;
                }
                if (dodato) continue;
                list.add(dd);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        String query = "delete from documentdetails where DocumentDetailsID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.DocumentDetailsID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<DocumentDetails> getFilteredListWarehouse(String filter, Document otpremnica, WarehouseCentral department, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        if (filter.trim().isEmpty() && otpremnica == null) {
            return list;
        }
        String query = "SELECT d.*, b.BarCode, p.Code, p.Name FROM documentdetails d LEFT JOIN product p ON p.ProductID = d.ProductID LEFT JOIN barcode b ON d.ProductID = b.ProductID WHERE DocumentID = ? AND (p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?) ORDER BY p.ProductID ";
        if (otpremnica.getDocumentID() < 0L) {
            query = "SELECT -1 as DocumentDetailsID, -1 as DocumentID, p.ProductID, p.Code, p.Name, 0 AS Price, 0 AS Quantity, b.BarCode FROM product p LEFT JOIN barcode b ON p.ProductID = b.ProductID WHERE (p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?) ORDER BY p.ProductID";
        }
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            if (otpremnica.getDocumentID() > 0L) {
                ps.setLong(1, otpremnica.getDocumentID());
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
                ps.setString(4, "%" + filter + "%");
            } else {
                ps.setString(1, "%" + filter + "%");
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocumentDetails dd = new DocumentDetails();
                if (otpremnica.getDocumentID() > 0L) {
                    dd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
                    dd.DocumentID = rs.getLong("DocumentID");
                    dd.ProductCode = rs.getString("Code");
                    dd.ProductName = rs.getString("Name");
                    dd.ProductID = rs.getLong("ProductID");
                    dd.ParentProductID = rs.getLong("ParentProductID");
                    dd.Quantity = rs.getDouble("Quantity");
                    dd.VatID = rs.getInt("VatID");
                    dd.UnitID = rs.getInt("UnitID");
                    dd.Discount = rs.getDouble("Discount");
                    dd.PriceWithDiscount = rs.getDouble("PriceWithDiscount");
                    dd.Costs = rs.getDouble("Costs");
                    dd.NewPrice = rs.getDouble("NewPrice");
                    dd.DocumentChangeID = rs.getLong("DocumentChangeID");
                    dd.WarehouseID = rs.getInt("WarehouseID");
                    dd.SaleTableID = rs.getInt("SaleTableID");
                    dd.PurchacePrice = rs.getDouble("PurchacePrice");
                    dd.OrderNumber = rs.getInt("OrderNumber");
                    dd.SubTotal = rs.getBoolean("SubTotal");
                    dd.Closed = rs.getBoolean("Closed");
                    dd.DescriptionID = rs.getInt("DescriptionID");
                    dd.Value = dd.Quantity * dd.PriceWithDiscount;
                } else {
                    dd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
                    dd.DocumentID = rs.getLong("DocumentID");
                    dd.ProductCode = rs.getString("Code");
                    dd.ProductName = rs.getString("Name");
                    dd.ProductID = rs.getLong("ProductID");
                    dd.Quantity = rs.getDouble("Quantity");
                }
                if (rs.getDouble("Price") == 0.0) {
                    PreparedStatement ps2 = controller.getSettings().getConnection().prepareStatement("CALL `current_price_and_discount`(?, ?)");
                    ps2.setLong(1, dd.ProductID);
                    ps2.setInt(2, new PointOfSale(1, controller.getSettings().getConnection()).getPointOfSaleID());
                    ResultSet rs2 = ps2.executeQuery();
                    rs2.next();
                    try {
                        dd.Price = rs2.getDouble("Price");
                    }
                    catch (SQLException e) {
                        dd.Price = 0.0;
                    }
                    ps2.close();
                    rs2.close();
                } else {
                    dd.Price = rs.getDouble("Price");
                }
                dd.Barcode = rs.getString("BarCode");
                list.add((Object)dd);
                if (list.size() != 100) continue;
                break;
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<DocumentDetails> getFilteredList(String filter, Document otpremnica, Department department, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        if (filter.trim().isEmpty() && otpremnica == null) {
            return list;
        }
        String query = "SELECT d.*, b.BarCode, p.Code, p.Name FROM documentdetails d LEFT JOIN product p ON p.ProductID = d.ProductID LEFT JOIN barcode b ON d.ProductID = b.ProductID WHERE DocumentID = ? AND (p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?) ORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC, p.Code, p.Name, p.ShortName ";
        if (otpremnica.getDocumentID() < 0L) {
            query = "SELECT -1 as DocumentDetailsID, -1 as DocumentID, p.ProductID, p.Code, p.Name, 0 AS Price, 0 AS Quantity, b.BarCode FROM product p LEFT JOIN barcode b ON p.ProductID = b.ProductID WHERE (p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?) ORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC, p.Code, p.Name, p.ShortName ";
        }
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            if (otpremnica.getDocumentID() > 0L) {
                ps.setLong(1, otpremnica.getDocumentID());
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
                ps.setString(4, "%" + filter + "%");
            } else {
                ps.setString(1, "%" + filter + "%");
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocumentDetails dd = new DocumentDetails();
                if (otpremnica.getDocumentID() > 0L) {
                    dd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
                    dd.DocumentID = rs.getLong("DocumentID");
                    dd.ProductCode = rs.getString("Code");
                    dd.ProductName = rs.getString("Name");
                    dd.ProductID = rs.getLong("ProductID");
                    dd.ParentProductID = rs.getLong("ParentProductID");
                    dd.Quantity = rs.getDouble("Quantity");
                    dd.VatID = rs.getInt("VatID");
                    dd.UnitID = rs.getInt("UnitID");
                    dd.Discount = rs.getDouble("Discount");
                    dd.PriceWithDiscount = rs.getDouble("PriceWithDiscount");
                    dd.Costs = rs.getDouble("Costs");
                    dd.NewPrice = rs.getDouble("NewPrice");
                    dd.DocumentChangeID = rs.getLong("DocumentChangeID");
                    dd.WarehouseID = rs.getInt("WarehouseID");
                    dd.SaleTableID = rs.getInt("SaleTableID");
                    dd.PurchacePrice = rs.getDouble("PurchacePrice");
                    dd.OrderNumber = rs.getInt("OrderNumber");
                    dd.SubTotal = rs.getBoolean("SubTotal");
                    dd.Closed = rs.getBoolean("Closed");
                    dd.DescriptionID = rs.getInt("DescriptionID");
                    dd.Value = dd.Quantity * dd.PriceWithDiscount;
                } else {
                    dd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
                    dd.DocumentID = rs.getLong("DocumentID");
                    dd.ProductCode = rs.getString("Code");
                    dd.ProductName = rs.getString("Name");
                    dd.ProductID = rs.getLong("ProductID");
                    dd.Quantity = rs.getDouble("Quantity");
                }
                if (rs.getDouble("Price") == 0.0) {
                    PreparedStatement ps2 = controller.getSettings().getConnection().prepareStatement("CALL `current_price_and_discount`(?, ?)");
                    ps2.setLong(1, dd.ProductID);
                    ps2.setInt(2, new PointOfSale(1, controller.getSettings().getConnection()).getPointOfSaleID());
                    ResultSet rs2 = ps2.executeQuery();
                    rs2.next();
                    try {
                        dd.Price = rs2.getDouble("Price");
                    }
                    catch (SQLException e) {
                        dd.Price = 0.0;
                    }
                    ps2.close();
                    rs2.close();
                } else {
                    dd.Price = rs.getDouble("Price");
                }
                dd.Barcode = rs.getString("BarCode");
                list.add((Object)dd);
                if (list.size() != 100) continue;
                break;
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<DocumentDetails> getFilteredListInternaOtpremnica(String filter, Document otpremnica, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        if (filter.trim().isEmpty()) {
            return list;
        }
        String query = "SELECT -1 as DocumentDetailsID, -1 as DocumentID, p.ProductID, p.Code, p.Name, current_price_before_date(p.ProductID, NOW(), 1) AS Price, 0 AS Quantity, b.BarCode  FROM product p LEFT JOIN barcode b ON p.ProductID = b.ProductID  WHERE (p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?)  AND p.ProductID NOT IN (SELECT dd.productID FROM documentdetails dd WHERE dd.DocumentID = ?) AND p.Active IS TRUE ORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC, p.Code, p.Name, p.ShortName";
        if (otpremnica == null) {
            query = "SELECT -1 as DocumentDetailsID, -1 as DocumentID, p.ProductID, p.Code, p.Name, current_price_before_date(p.ProductID, NOW(), 1) AS Price, 0 AS Quantity, b.BarCode FROM product p LEFT JOIN barcode b ON p.ProductID = b.ProductID WHERE (p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?) AND p.Active IS TRUE ORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC, p.Code, p.Name, p.ShortName";
        }
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            if (otpremnica != null) {
                ps.setString(1, "%" + filter + "%");
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
                ps.setLong(4, otpremnica.getDocumentID());
            } else {
                ps.setString(1, "%" + filter + "%");
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
            }
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocumentDetails dd = new DocumentDetails();
                dd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
                dd.DocumentID = rs.getLong("DocumentID");
                dd.ProductID = rs.getLong("ProductID");
                dd.ProductCode = rs.getString("Code");
                dd.ProductName = rs.getString("Name");
                dd.Quantity = rs.getDouble("Quantity");
                dd.Barcode = rs.getString("BarCode");
                dd.Price = rs.getDouble("Price");
                list.add((Object)dd);
                if (list.size() != 100) continue;
                break;
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public String toString() {
        return (this.ProductCode != null ? this.ProductCode + " -- " : "") + this.ProductName + " -- " + this.Barcode;
    }

    public static void deleteDetailes(Document document, Connection connection) throws SQLException {
        String query = "delete from documentdetails where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, document.getDocumentID());
        ps.executeUpdate();
        ps.close();
    }

    public static ObservableList<DocumentDetails> getObeservableListStalniKupac(long documentId, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT p.Name, dd.Quantity, dd.Price, dd.Discount, dd.PriceWithDiscount, dd.sysDTCreated FROM documentdetails dd JOIN document d ON d.DocumentID = dd.DocumentID JOIN product p ON p.ProductID = dd.ProductID WHERE dd.DocumentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, documentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocumentDetails dd = new DocumentDetails();
                dd.ProductName = rs.getString("Name");
                dd.Quantity = rs.getDouble("Quantity");
                dd.Price = rs.getDouble("Price");
                dd.Discount = rs.getDouble("Discount");
                dd.PriceWithDiscount = rs.getDouble("PriceWithDiscount");
                dd.sysDTCreated = rs.getTimestamp("sysDTCreated");
                list.add((Object)dd);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<DocumentDetails> getNabavnaCenaList(Product product, Department department, ScreensController controller) {
        String query = "SELECT dd.PriceWithDiscount, dd.Quantity FROM documentdetails dd INNER JOIN document d ON d.DocumentID = dd.DocumentID WHERE dd.ProductID = ? AND d.DocumentTypeID = 1 AND DATE(d.Date) < now() AND d.DepartmentID = ? ORDER BY d.Date DESC";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, product.getProductID());
            pStatement.setLong(2, department.getDepartmentID());
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                DocumentDetails documentDetails = new DocumentDetails();
                documentDetails.setPriceWithDiscount(rSet.getDouble("PriceithDiscount"));
                documentDetails.setQuantity(rSet.getDouble("Quantity"));
                list.add((Object)documentDetails);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void deleteAll(WorkDay wDay, ScreensController controller) {
        String query = "DELETE dd FROM documentdetails dd LEFT JOIN document d ON d.DocumentID = dd.DocumentID WHERE d.Date < ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            System.out.println(pStatement);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAllBills(WorkDay wDay, ScreensController controller) {
        String query = "DELETE dd FROM documentdetails dd LEFT JOIN document d ON d.DocumentID = dd.DocumentID WHERE d.Date > ? AND d.DocumentTypeID IN (3,4,17)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            System.out.println(pStatement);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateDocumentDitailsForPrijemnica(Connection connection) {
        String query = "update  documentdetails  set Quantity=0 where DocumentDetailsID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.DocumentDetailsID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Problem sa brisanjem stavke");
        }
    }
}

