/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.PaymentRecord;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.SQLHelper;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Utility;
import rs.petcom.master.dal.WarehouseCentral;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentRelationship;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.fical.NarrowGotBill;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class Document {
    private long documentID;
    private int documentTypeID;
    private int documentStatusID;
    private int pointOfSaleID;
    private int number;
    private int year;
    private String fullNumber;
    private String payCardSlipNumber;
    private String alternativeFullNumber;
    private java.util.Date date;
    private java.util.Date deliveryDate;
    private java.util.Date currencyDate;
    private java.util.Date dateFrom;
    private java.util.Date dateTo;
    private String note;
    private String place;
    private long personID;
    private long cashBuyersID;
    private int warehouseID;
    private int paymentMethodID;
    private long loyalityID;
    private double sum;
    private double sumWithDiscount;
    private double paid;
    private String externalNumber;
    private boolean fromCashBox;
    private long workDayID;
    private java.util.Date sysDTCreated;
    private java.util.Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private int departmentID;
    private double discount;
    private double dependentExpenses;
    private String name;
    private String jmbg;
    private String personName;
    private String statusName;
    private String order;
    private double ulaz;
    private double izlaz;
    private double stanje;
    private double nabavnaCena;
    private double nabavnaVrednost;
    private double prodajnaCena;
    private double prodajnaVrednost;
    private String nazivDokumenta;
    private String paymentMethodName;
    private String objecttName;
    private String note2;
    private boolean realized;
    private boolean reservated;
    private boolean locked;
    private String bi;
    private String referentNumber;
    private Person person;
    private String referentDateTime;
    private String buyerIdentification;
    private Boolean closed;
    private static final Logger LOGGER = Logger.getLogger("global");

    public static void update(long documentID, Connection connection) throws SQLException {
        String query = "update document set DocumentStatusID = 2 where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, documentID);
        ps.executeUpdate();
        ps.close();
    }

    public static String findByRefNumberNote(int number, ScreensController controller) {
        String query = "select d.ReferentNumber, d.Discount as racunPopust,d.PaymentMethodID , d.Paid , d.SumWithDiscount, d.DocumentID , d.Note   from document d   \nwhere d.Number = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, number);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            boolean isExist = false;
            String note = "";
            while (rs.next()) {
                note = rs.getString("Note");
            }
            rs.close();
            ps.close();
            return note;
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String findByfullNumber(String avanastin, String refNumber, ScreensController controller) {
        String fullNumber = null;
        String query = "select d.FullNumber1 from document d \nwhere d.ReferentNumber = ? LIMIT 1";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, refNumber);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            boolean isExist = false;
            if (rs.next()) {
                fullNumber = rs.getString("FullNumber1");
                rs.close();
                ps.close();
            }
            return fullNumber;
        }
        catch (Exception e) {
            e.printStackTrace();
            return fullNumber;
        }
    }

    public static boolean findByRefNumber(String avanastin, String refNumber, ScreensController controller) {
        String query = "select d.DocumentTypeId, d.ReferentNumber,dd.Price,dd.Discount as stavkaPopust, d.Discount as racunPopust,d.PaymentMethodID , d.Paid , d.SumWithDiscount,dd.ProductID, d.DocumentID , dd.Quantity, dd.PriceWithDiscount  from document d inner join documentdetails dd on d.DocumentID = dd.DocumentID  \nwhere d.ReferentNumber = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, refNumber);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            boolean isExist = false;
            while (rs.next()) {
                RoundItem ri = new RoundItem();
                isExist = true;
                Long idProduct = rs.getLong("ProductID");
                Long idType = rs.getLong("DocumentTypeId");
                if (("avanstin".equals(avanastin) || "refundacija".equals(avanastin)) && idType != 36L) {
                    return false;
                }
                if ("konacniracun".equals(avanastin) && idType != 37L) {
                    return false;
                }
                ProductDepartment productDepartment = ProductDepartment.getByProductAndDepartment((long)idProduct, 1, controller);
                productDepartment.getProduct().setPrice(rs.getDouble("Price"));
                productDepartment.getProduct().setDiscount(rs.getDouble("stavkaPopust"));
                ri.setProductDepartment(productDepartment);
                ri.setRegularPrice(rs.getDouble("PriceWithDiscount"));
                ri.setQuantity(rs.getDouble("Quantity"));
                controller.getBillList().get(controller.getActiveBill()).setPaymetnMethodID(rs.getInt("PaymentMethodID"));
                controller.getBillList().get(controller.getActiveBill()).setPaid(rs.getDouble("Paid"));
                controller.getBillList().get(controller.getActiveBill()).getRoundList().get(0).getItemList().add(ri);
            }
            rs.close();
            ps.close();
            return isExist;
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Double findByRefNumberSum(String refNumber, ScreensController controller) {
        String query = "select d.SumWithDiscount, dp.paid from document d inner join documentpayment  dp on d.documentid=dp.documentid  \nwhere d.ReferentNumber = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, refNumber);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            boolean isExist = false;
            if (rs.next()) {
                double sum = rs.getDouble("SumWithDiscount");
                double paid = rs.getDouble("paid");
                double placanje = sum - paid;
                System.out.println("Placanje konacni " + placanje);
                return placanje;
            }
            return -1.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public static Double findByRefNumberSumFull(String avanstin, String fullNumber, ScreensController controller) {
        String query = "select d.SumWithDiscount, dp.paid from document d inner join documentpayment  dp on d.documentid=dp.documentid  \nwhere d.FullNumber1 = ? and d.DocumentTypeID= 36";
        try {
            double paid = 0.0;
            String full = Document.findByfullNumber(avanstin, fullNumber, controller);
            if ((full == null || full.isEmpty()) && paid == 0.0) {
                return -1.0;
            }
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, full);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            boolean isExist = false;
            while (rs.next()) {
                paid += rs.getDouble("paid");
            }
            if (paid == 0.0) {
                return -1.0;
            }
            return paid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public static String findByRefNumberSumFullText(String avanstin, String fullNumber, ScreensController controller) {
        String query = "select d.SumWithDiscount, dp.paid, d.ReferentNumber from document d inner join documentpayment  dp on d.documentid=dp.documentid  \nwhere d.FullNumber1 = ? and d.DocumentTypeID= 36";
        try {
            String full = Document.findByfullNumber(avanstin, fullNumber, controller);
            if (full == null || full.isEmpty()) {
                return "";
            }
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, full);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            boolean isExist = false;
            StringBuilder stringBuilder = new StringBuilder();
            while (rs.next()) {
                String paid = String.valueOf(rs.getDouble("paid"));
                String ref = rs.getString("ReferentNumber");
                stringBuilder.append("Avans broj: " + ref + ", uplata od :" + paid);
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Double findByRefNumberSumFullWithDiscount(String avanstin, String fullNumber, ScreensController controller) {
        String query = "select d.SumWithDiscount, dp.paid from document d inner join documentpayment  dp on d.documentid=dp.documentid  \nwhere d.FullNumber1 = ? and d.DocumentTypeID= 36 order by d.ReferentDateTime asc limit 1\n";
        try {
            double paid = 0.0;
            String full = Document.findByfullNumber(avanstin, fullNumber, controller);
            if ((full == null || full.isEmpty()) && paid == 0.0) {
                return -1.0;
            }
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, full);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            boolean isExist = false;
            while (rs.next()) {
                paid = rs.getDouble("SumWithDiscount");
            }
            if (paid == 0.0) {
                return -1.0;
            }
            return paid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public static String findByRefTime(String refNumber, ScreensController controller) {
        String query = "select d.ReferentDateTime, d.ReferentNumber,dd.Price, d.Discount,d.PaymentMethodID , d.Paid , d.SumWithDiscount,dd.ProductID, d.DocumentID , dd.Quantity, dd.PriceWithDiscount  from document d inner join documentdetails dd on d.DocumentID = dd.DocumentID  \nwhere d.ReferentNumber = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, refNumber);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            if (rs.first()) {
                String timestamp = rs.getString("ReferentDateTime");
                String[] array = timestamp.split("T");
                String date = array[0];
                String[] year = date.split("-");
                String time = array[1];
                String[] hourMinut = time.split(":");
                System.out.println("Hour minut " + hourMinut[2].substring(0, 2));
                LocalDateTime localDateTime = LocalDateTime.of(Integer.parseInt(year[0]), Integer.parseInt(year[1]), Integer.parseInt(year[2]), Integer.parseInt(hourMinut[0]), Integer.parseInt(hourMinut[1]), Integer.parseInt(hourMinut[2].substring(0, 2)));
                return String.valueOf(localDateTime);
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
            return "";
        }
        return "";
    }

    public static String findByRefTime1(String refNumber, ScreensController controller) {
        String query = "select d.ReferentDateTime, d.ReferentNumber,dd.Price, d.Discount,d.PaymentMethodID , d.Paid , d.SumWithDiscount,dd.ProductID, d.DocumentID , dd.Quantity, dd.PriceWithDiscount  from document d inner join documentdetails dd on d.DocumentID = dd.DocumentID  \nwhere d.ReferentNumber = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, refNumber);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            if (rs.first()) {
                String timestamp = rs.getString("ReferentDateTime");
                String[] array = timestamp.split("T");
                String date = array[0];
                String[] year = date.split("-");
                String time = array[1];
                String[] hourMinut = time.split(":");
                LocalDateTime localDateTime = LocalDateTime.of(Integer.parseInt(year[0]), Integer.parseInt(year[1]), Integer.parseInt(year[2]), Integer.parseInt(hourMinut[0]), Integer.parseInt(hourMinut[1]), Integer.parseInt(hourMinut[2].substring(0, 2)));
                return Settings.formatLocalDateTime(localDateTime, "dd.MM.yyyy hh:mm:ss");
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
            return "";
        }
        return "";
    }

    public static String findByRefNumberExternal(String refNumber, ScreensController controller) {
        String query = "select d.refExternalNumber from document d \nwhere d.ReferentNumber = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, refNumber);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            if (rs.first()) {
                String refExternalNumber = rs.getString("refExternalNumber");
                return refExternalNumber;
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
            return "";
        }
        return "";
    }

    public static double findByAvans(String refNumber, ScreensController controller) {
        String sql = "select * from documentpayment d where d.DocumentID in(select DocumentID from document d2 where d2.ReferentNumber = ?)";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(sql);
            ps.setString(1, refNumber);
            System.out.println("findByRefNumber " + ps);
            ResultSet rs = ps.executeQuery();
            if (rs.first()) {
                return rs.getDouble("Paid");
            }
            throw new RuntimeException("Ne postoji docukument sa ovakvim ref brojem");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Ne postoji docukument sa ovakvim ref brojem");
        }
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public long getDocumentID() {
        return this.documentID;
    }

    public void setDocumentID(long documentID) {
        this.documentID = documentID;
    }

    public int getDocumentTypeID() {
        return this.documentTypeID;
    }

    public void setDocumentTypeID(int documentTypeID) {
        this.documentTypeID = documentTypeID;
    }

    public int getDocumentStatusID() {
        return this.documentStatusID;
    }

    public void setDocumentStatusID(int documentStatusID) {
        this.documentStatusID = documentStatusID;
    }

    public int getPointOfSaleID() {
        return this.pointOfSaleID;
    }

    public void setPointOfSaleID(int pointOfSaleID) {
        this.pointOfSaleID = pointOfSaleID;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String getFullNumber() {
        return this.fullNumber;
    }

    public void setFullNumber(String fullNumber) {
        this.fullNumber = fullNumber;
    }

    public String getPayCardSlipNumber() {
        return this.payCardSlipNumber;
    }

    public void setPayCardSlipNumber(String payCardSlipNumber) {
        this.payCardSlipNumber = payCardSlipNumber;
    }

    public String getAlternativeFullNumber() {
        return this.alternativeFullNumber;
    }

    public void setAlternativeFullNumber(String alternativeFullNumber) {
        this.alternativeFullNumber = alternativeFullNumber;
    }

    public java.util.Date getDate() {
        return this.date;
    }

    public void setDate(java.util.Date date) {
        this.date = date;
    }

    public java.util.Date getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(java.util.Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public java.util.Date getCurrencyDate() {
        return this.currencyDate;
    }

    public void setCurrencyDate(java.util.Date currencyDate) {
        this.currencyDate = currencyDate;
    }

    public java.util.Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(java.util.Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public java.util.Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(java.util.Date dateTo) {
        this.dateTo = dateTo;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public long getPersonID() {
        return this.personID;
    }

    public void setPersonID(long personID) {
        this.personID = personID;
    }

    public long getCashBuyersID() {
        return this.cashBuyersID;
    }

    public void setCashBuyersID(long cashBuyersID) {
        this.cashBuyersID = cashBuyersID;
    }

    public int getWarehouseID() {
        return this.warehouseID;
    }

    public void setWarehouseID(int warehouseID) {
        this.warehouseID = warehouseID;
    }

    public int getPaymentMethodID() {
        return this.paymentMethodID;
    }

    public void setPaymentMethodID(int paymentMethodID) {
        this.paymentMethodID = paymentMethodID;
    }

    public long getLoyalityID() {
        return this.loyalityID;
    }

    public void setLoyalityID(long loyalityID) {
        this.loyalityID = loyalityID;
    }

    public double getSum() {
        return this.sum;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    public double getSumWithDiscount() {
        return this.sumWithDiscount;
    }

    public void setSumWithDiscount(double sumWithDiscount) {
        this.sumWithDiscount = sumWithDiscount;
    }

    public double getPaid() {
        return this.paid;
    }

    public void setPaid(double paid) {
        this.paid = paid;
    }

    public String getExternalNumber() {
        return this.externalNumber;
    }

    public void setExternalNumber(String externalNumber) {
        this.externalNumber = externalNumber;
    }

    public boolean isFromCashBox() {
        return this.fromCashBox;
    }

    public void setFromCashBox(boolean fromCashBox) {
        this.fromCashBox = fromCashBox;
    }

    public long getWorkDayID() {
        return this.workDayID;
    }

    public void setWorkDayID(long workDayID) {
        this.workDayID = workDayID;
    }

    public java.util.Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(java.util.Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public java.util.Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(java.util.Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public int getDepartmentID() {
        return this.departmentID;
    }

    public void setDepartmentID(int departmentID) {
        this.departmentID = departmentID;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public double getDependentExpenses() {
        return this.dependentExpenses;
    }

    public void setDependentExpenses(double dependentExpenses) {
        this.dependentExpenses = dependentExpenses;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJmbg() {
        return this.jmbg;
    }

    public void setJmbg(String jmbg) {
        this.jmbg = jmbg;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public double getUlaz() {
        return this.ulaz;
    }

    public void setUlaz(double ulaz) {
        this.ulaz = ulaz;
    }

    public double getIzlaz() {
        return this.izlaz;
    }

    public void setIzlaz(double izlaz) {
        this.izlaz = izlaz;
    }

    public double getStanje() {
        return this.stanje;
    }

    public void setStanje(double stanje) {
        this.stanje = stanje;
    }

    public double getNabavnaCena() {
        return this.nabavnaCena;
    }

    public void setNabavnaCena(double nabavnaCena) {
        this.nabavnaCena = nabavnaCena;
    }

    public double getNabavnaVrednost() {
        return this.nabavnaVrednost;
    }

    public void setNabavnaVrednost(double nabavnaVrednost) {
        this.nabavnaVrednost = nabavnaVrednost;
    }

    public double getProdajnaCena() {
        return this.prodajnaCena;
    }

    public void setProdajnaCena(double prodajnaCena) {
        this.prodajnaCena = prodajnaCena;
    }

    public double getProdajnaVrednost() {
        return this.prodajnaVrednost;
    }

    public void setProdajnaVrednost(double prodajnaVrednost) {
        this.prodajnaVrednost = prodajnaVrednost;
    }

    public String getNazivDokumenta() {
        return this.nazivDokumenta;
    }

    public void setNazivDokumenta(String nazivDokumenta) {
        this.nazivDokumenta = nazivDokumenta;
    }

    public String getPaymentMethodName() {
        return this.paymentMethodName;
    }

    public void setPaymentMethodName(String paymentMethodName) {
        this.paymentMethodName = paymentMethodName;
    }

    public String getObjecttName() {
        return this.objecttName;
    }

    public void setObjecttName(String objecttName) {
        this.objecttName = objecttName;
    }

    public boolean isRealized() {
        return this.realized;
    }

    public void setRealized(boolean realized) {
        this.realized = realized;
    }

    public boolean isReservated() {
        return this.reservated;
    }

    public void setReservated(boolean reservated) {
        this.reservated = reservated;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public String getBi() {
        return this.bi;
    }

    public void setBi(String bi) {
        this.bi = bi;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public String getReferentNumber() {
        return this.referentNumber;
    }

    public void setReferentNumber(String referentNumber) {
        this.referentNumber = referentNumber;
    }

    public String getNote2() {
        return this.note2;
    }

    public void setNote2(String note2) {
        this.note2 = note2;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public String getReferentDateTime() {
        return this.referentDateTime;
    }

    public void setReferentDateTime(String referentDateTime) {
        this.referentDateTime = referentDateTime;
    }

    public String getBuyerIdentification() {
        return this.buyerIdentification;
    }

    public void setBuyerIdentification(String buyerIdentification) {
        this.buyerIdentification = buyerIdentification;
    }

    public long insertWithModifiedDate(Connection connection) {
        String query = " INSERT INTO document( \t\t`DocumentID`,\t\t`DocumentTypeID`,\t\t`DocumentStatusID`,\t\t`PointOfSaleID`,\t\t`Number`,\t\t`Year`,\t\t`FullNumber`,\t\t`AlternativeFullNumber`,\t\t`Date`,\t\t`DeliveryDate`,\t\t`CurrencyDate`,\t\t`DateFrom`,\t\t`DateTo`,\t\t`Note`,\t\t`Place`,\t\t`PersonID`,\t\t`WarehouseID`,\t\t`PaymentMethodID`,\t\t`LoyalityID`,\t\t`Discount`,\t\t`Sum`,\t\t`SumWithDiscount`,\t\t`Paid`,\t\t`ExternalNumber`,\t\t`FromCashBox`,\t\t`WorkDayID`,\t\t`sysDTCreated`,\t\t`sysDTEdit`,\t\t`sysUserAddID`,\t\t`sysUserEditID`,\t\t`DepartmentID`, `documentLocked`) VALUES (null,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setInt(1, this.documentTypeID);
            ps.setInt(2, this.documentStatusID);
            if (this.pointOfSaleID > 0) {
                ps.setInt(3, this.pointOfSaleID);
            } else {
                ps.setNull(3, 4);
            }
            ps.setInt(4, this.number);
            ps.setInt(5, this.year);
            ps.setString(6, this.fullNumber);
            ps.setString(7, this.alternativeFullNumber);
            try {
                ps.setTimestamp(8, new Timestamp(this.date.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(8, Timestamp.valueOf(LocalDateTime.now()));
            }
            try {
                ps.setTimestamp(9, new Timestamp(this.deliveryDate.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(9, 93);
            }
            try {
                ps.setTimestamp(10, new Timestamp(this.currencyDate.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(10, 93);
            }
            try {
                ps.setTimestamp(11, new Timestamp(this.dateFrom.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(11, 93);
            }
            try {
                ps.setTimestamp(12, new Timestamp(this.dateTo.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(12, 93);
            }
            ps.setString(13, this.note);
            ps.setString(14, this.place);
            if (this.personID != 0L) {
                ps.setLong(15, this.personID);
            } else {
                ps.setNull(15, -5);
            }
            if (this.warehouseID != 0) {
                ps.setLong(16, this.warehouseID);
            } else {
                ps.setNull(16, -5);
            }
            if (this.paymentMethodID != 0) {
                ps.setInt(17, this.paymentMethodID);
            } else {
                ps.setNull(17, 4);
            }
            if (this.loyalityID != 0L) {
                ps.setLong(18, this.loyalityID);
            } else {
                ps.setNull(18, -5);
            }
            ps.setDouble(19, this.discount);
            ps.setDouble(20, this.sum);
            ps.setDouble(21, this.sumWithDiscount);
            ps.setDouble(22, this.paid);
            ps.setString(23, this.externalNumber);
            ps.setBoolean(24, this.fromCashBox);
            if (this.workDayID != 0L) {
                ps.setLong(25, this.workDayID);
            } else {
                ps.setNull(25, -5);
            }
            try {
                ps.setTimestamp(26, new Timestamp(this.sysDTCreated.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(26, new Timestamp(new java.util.Date().getTime()));
            }
            try {
                ps.setTimestamp(27, new Timestamp(this.sysDTEdit.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(27, 93);
            }
            ps.setLong(28, this.sysUserAddID);
            if (this.sysUserEditID != 0L) {
                ps.setLong(29, this.sysUserEditID);
            } else {
                ps.setNull(29, -5);
            }
            if (this.departmentID != 0) {
                ps.setInt(30, this.departmentID);
            } else {
                ps.setNull(30, 4);
            }
            ps.setBoolean(31, this.locked);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.documentID = rs.getLong(1);
            rs.close();
            ps.close();
            return this.documentID;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public long insert(ScreensController controller) {
        String query = " INSERT INTO document( \t\t`DocumentID`,\t\t`DocumentTypeID`,\t\t`DocumentStatusID`,\t\t`PointOfSaleID`,\t\t`Number`, `ReferentNumber`,\t\t`Year`,\t\t`FullNumber`,\t\t`AlternativeFullNumber`,\t\t`Date`,\t\t`DeliveryDate`,\t\t`CurrencyDate`,\t\t`DateFrom`,\t\t`DateTo`,\t\t`Note`, `Note2`, \t\t`Place`,\t\t`PersonID`,\t\t`WarehouseID`,\t\t`PaymentMethodID`,\t\t`LoyalityID`,\t\t`Discount`,\t\t`Sum`,\t\t`SumWithDiscount`,\t\t`Paid`,\t\t`ExternalNumber`,\t\t`FromCashBox`,\t\t`WorkDayID`,\t\t`sysDTCreated`,\t\t`sysDTEdit`,\t\t`sysUserAddID`,\t\t`sysUserEditID`,\t\t`DepartmentID`, `DependentExpenses`, `Name`, `JMBG`, `CashBuyersID`, `Realized`,  `Reservated`,     `ReferentDateTime`,`BuyerIdentification`) VALUES (null,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setInt(1, this.documentTypeID);
            ps.setInt(2, this.documentStatusID);
            if (this.pointOfSaleID > 0) {
                ps.setInt(3, this.pointOfSaleID);
            } else {
                ps.setNull(3, 4);
            }
            ps.setInt(4, this.number);
            ps.setString(5, this.referentNumber);
            ps.setInt(6, this.year);
            ps.setString(7, this.fullNumber);
            ps.setString(8, this.alternativeFullNumber);
            try {
                ps.setTimestamp(9, new Timestamp(this.date.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(9, new Timestamp(new java.util.Date().getTime()));
            }
            try {
                ps.setTimestamp(10, new Timestamp(this.deliveryDate.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(10, 93);
            }
            try {
                ps.setTimestamp(11, new Timestamp(this.currencyDate.getTime()));
            }
            catch (NullPointerException e) {
                Person person = Person.getById(this.personID, controller);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new java.util.Date());
                calendar.add(5, person == null ? 0 : person.getCurrencyPaymentDays());
                ps.setTimestamp(11, new Timestamp(calendar.getTime().getTime()));
            }
            try {
                ps.setTimestamp(12, new Timestamp(this.dateFrom.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(12, 93);
            }
            try {
                ps.setTimestamp(13, new Timestamp(this.dateTo.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(13, 93);
            }
            ps.setString(14, this.note);
            if (this.note2 != null) {
                ps.setString(15, this.note2);
            } else {
                ps.setString(15, "");
            }
            ps.setString(16, this.place);
            if (this.personID != 0L) {
                ps.setLong(17, this.personID);
            } else {
                ps.setNull(17, -5);
            }
            if (this.warehouseID != 0) {
                ps.setLong(18, this.warehouseID);
            } else {
                ps.setNull(18, -5);
            }
            if (this.paymentMethodID != 0) {
                ps.setInt(19, this.paymentMethodID);
            } else {
                ps.setNull(19, 4);
            }
            if (this.loyalityID != 0L) {
                ps.setLong(20, this.loyalityID);
            } else {
                ps.setNull(20, -5);
            }
            ps.setDouble(21, this.discount);
            ps.setDouble(22, this.sum);
            ps.setDouble(23, this.sumWithDiscount);
            ps.setDouble(24, this.paid);
            ps.setString(25, this.externalNumber);
            ps.setBoolean(26, this.fromCashBox);
            if (this.workDayID != 0L) {
                ps.setLong(27, this.workDayID);
            } else {
                WorkDay workDay = WorkDay.getByDateMax(controller.getSettings().getConnection());
                if (workDay != null) {
                    this.workDayID = workDay.getWorkDayID();
                    ps.setLong(27, this.workDayID);
                }
            }
            try {
                ps.setTimestamp(28, new Timestamp(this.sysDTCreated.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(28, new Timestamp(new java.util.Date().getTime()));
            }
            try {
                ps.setTimestamp(29, new Timestamp(this.sysDTEdit.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(29, 93);
            }
            ps.setLong(30, this.sysUserAddID);
            if (this.sysUserEditID != 0L) {
                ps.setLong(31, this.sysUserEditID);
            } else {
                ps.setNull(31, -5);
            }
            if (this.departmentID != 0) {
                ps.setInt(32, this.departmentID);
            } else {
                ps.setNull(32, 4);
            }
            ps.setDouble(33, this.dependentExpenses);
            if (this.name != null) {
                ps.setString(34, this.name);
            } else {
                ps.setNull(34, 12);
            }
            if (this.jmbg != null) {
                ps.setString(35, this.jmbg);
            } else {
                ps.setNull(35, 12);
            }
            if (this.cashBuyersID != 0L) {
                ps.setLong(36, this.cashBuyersID);
            } else {
                ps.setNull(36, -5);
            }
            ps.setBoolean(37, this.realized);
            ps.setBoolean(38, this.reservated);
            ps.setString(39, this.referentDateTime);
            ps.setString(40, this.buyerIdentification);
            LOGGER.info(ps.toString());
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.documentID = rs.getLong(1);
            rs.close();
            ps.close();
            return this.documentID;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public long insertSaveRecap(Connection connection) {
        String query = " INSERT INTO document( \t\t`DocumentID`,\t\t`DocumentTypeID`,\t\t`DocumentStatusID`,\t\t`PointOfSaleID`,\t\t`Number`,\t\t`Year`,\t\t`FullNumber`,\t\t`AlternativeFullNumber`,\t\t`Date`,\t\t`DeliveryDate`,\t\t`CurrencyDate`,\t\t`DateFrom`,\t\t`DateTo`,\t\t`Note`,\t\t`Place`,\t\t`PersonID`,\t\t`WarehouseID`,\t\t`PaymentMethodID`,\t\t`LoyalityID`,\t\t`Discount`,\t\t`Sum`,\t\t`SumWithDiscount`,\t\t`Paid`,\t\t`ExternalNumber`,\t\t`FromCashBox`,\t\t`WorkDayID`,\t\t`sysDTCreated`,\t\t`sysDTEdit`,\t\t`sysUserAddID`,\t\t`sysUserEditID`,\t\t`DepartmentID`, `DependentExpenses`, `Name`, `JMBG`, `CashBuyersID`) VALUES (null,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setInt(1, this.documentTypeID);
            ps.setInt(2, this.documentStatusID);
            if (this.pointOfSaleID > 0) {
                ps.setInt(3, this.pointOfSaleID);
            } else {
                ps.setNull(3, 4);
            }
            ps.setInt(4, this.number);
            ps.setInt(5, this.year);
            ps.setString(6, this.fullNumber);
            ps.setString(7, this.alternativeFullNumber);
            try {
                ps.setTimestamp(8, new Timestamp(this.date.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(8, 93);
            }
            try {
                ps.setTimestamp(9, new Timestamp(this.deliveryDate.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(9, 93);
            }
            try {
                ps.setTimestamp(10, new Timestamp(this.currencyDate.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(10, 93);
            }
            try {
                ps.setTimestamp(11, new Timestamp(this.dateFrom.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(11, 93);
            }
            try {
                ps.setTimestamp(12, new Timestamp(this.dateTo.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(12, 93);
            }
            ps.setString(13, this.note);
            ps.setString(14, this.place);
            if (this.personID != 0L) {
                ps.setLong(15, this.personID);
            } else {
                ps.setNull(15, -5);
            }
            if (this.warehouseID != 0) {
                ps.setLong(16, this.warehouseID);
            } else {
                ps.setNull(16, -5);
            }
            if (this.paymentMethodID != 0) {
                ps.setInt(17, this.paymentMethodID);
            } else {
                ps.setNull(17, 4);
            }
            if (this.loyalityID != 0L) {
                ps.setLong(18, this.loyalityID);
            } else {
                ps.setNull(18, -5);
            }
            ps.setDouble(19, this.discount);
            ps.setDouble(20, this.sum);
            ps.setDouble(21, this.sumWithDiscount);
            ps.setDouble(22, this.paid);
            ps.setString(23, this.externalNumber);
            ps.setBoolean(24, this.fromCashBox);
            if (this.workDayID != 0L) {
                ps.setLong(25, this.workDayID);
            } else {
                ps.setNull(25, -5);
            }
            try {
                ps.setTimestamp(26, new Timestamp(this.sysDTCreated.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(26, new Timestamp(new java.util.Date().getTime()));
            }
            try {
                ps.setTimestamp(27, new Timestamp(this.sysDTEdit.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(27, 93);
            }
            ps.setLong(28, this.sysUserAddID);
            if (this.sysUserEditID != 0L) {
                ps.setLong(29, this.sysUserEditID);
            } else {
                ps.setNull(29, -5);
            }
            if (this.departmentID != 0) {
                ps.setInt(30, this.departmentID);
            } else {
                ps.setNull(30, 4);
            }
            ps.setDouble(31, this.dependentExpenses);
            if (this.name != null) {
                ps.setString(32, this.name);
            } else {
                ps.setNull(32, 12);
            }
            if (this.jmbg != null) {
                ps.setString(33, this.jmbg);
            } else {
                ps.setNull(33, 12);
            }
            if (this.cashBuyersID != 0L) {
                ps.setLong(34, this.cashBuyersID);
            } else {
                ps.setNull(34, -5);
            }
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.documentID = rs.getLong(1);
            rs.close();
            ps.close();
            return this.documentID;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void updateCashBuyersID(ScreensController controller) {
        String query = "UPDATE document SET CashBuyersID = ? WHERE  DocumentID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.getCashBuyersID());
            pStatement.setLong(2, this.getDocumentID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updatePersonID(ScreensController controller) {
        String query = "UPDATE document SET PersonID = ? WHERE  DocumentID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.getPersonID());
            pStatement.setLong(2, this.getDocumentID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updatePaymentMethodID(ScreensController controller) {
        String query = "UPDATE document SET PaymentMethodID = ?  WHERE  DocumentID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.getPaymentMethodID());
            pStatement.setLong(2, this.getDocumentID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateDocumentStatusID(ScreensController controller) {
        String query = "UPDATE document SET DocumentStatusID = ? WHERE  DocumentID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, this.documentStatusID);
            pStatement.setLong(2, this.getDocumentID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) throws SQLException {
        String query = " UPDATE document SET  \t\t`DocumentTypeID` = ?,\t\t`DocumentStatusID` = ?,\t\t`PointOfSaleID` = ?,\t\t`Number` = ?,\t\t`Year` = ?,\t\t`FullNumber` = ?,\t\t`AlternativeFullNumber` = ?,\t\t`Date` = ?,\t\t`DeliveryDate` = ?,\t\t`CurrencyDate` = ?,\t\t`DateFrom` = ?,\t\t`DateTo` = ?,\t\t`Note` = ?,\t\t`Place` = ?,\t\t`PersonID` = ?,\t\t`WarehouseID` = ?,\t\t`PaymentMethodID` = ?,\t\t`LoyalityID` = ?,\t\t`Discount` = ?,\t\t`Sum` = ?,\t\t`SumWithDiscount` = ?,\t\t`Paid` = ?,\t\t`ExternalNumber` = ?,\t\t`FromCashBox` = ?,\t\t`WorkDayID` = ?,\t\t`sysDTEdit` = ?,\t\t`sysUserEditID` = ?,\t\t`DepartmentID` = ?, `DependentExpenses` = ?, `Name` = ?, `JMBG` = ?, `Realized` = ?, `PayCardSlipNumber` = ?,  `Reservated` = ?, `Note2` = ?  WHERE `DocumentID` = ?";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
        ps.setInt(1, this.documentTypeID);
        ps.setInt(2, this.documentStatusID);
        if (this.pointOfSaleID > 0) {
            ps.setInt(3, this.pointOfSaleID);
        } else {
            ps.setNull(3, 4);
        }
        ps.setInt(4, this.number);
        ps.setInt(5, this.year);
        ps.setString(6, this.fullNumber);
        ps.setString(7, this.alternativeFullNumber);
        ps.setTimestamp(8, new Timestamp(this.date.getTime()));
        if (this.deliveryDate != null) {
            ps.setTimestamp(9, new Timestamp(this.deliveryDate.getTime()));
        } else {
            ps.setNull(9, 93);
        }
        if (this.currencyDate != null) {
            ps.setTimestamp(10, new Timestamp(this.currencyDate.getTime()));
        } else {
            ps.setNull(10, 93);
        }
        try {
            ps.setTimestamp(11, new Timestamp(this.dateFrom.getTime()));
        }
        catch (NullPointerException e) {
            ps.setNull(11, 93);
        }
        try {
            ps.setTimestamp(12, new Timestamp(this.dateTo.getTime()));
        }
        catch (NullPointerException e) {
            ps.setNull(12, 93);
        }
        ps.setString(13, this.note);
        ps.setString(14, this.place);
        if (this.personID != 0L) {
            ps.setLong(15, this.personID);
        } else {
            ps.setNull(15, -5);
        }
        if (this.warehouseID != 0) {
            ps.setLong(16, this.warehouseID);
        } else {
            ps.setNull(16, -5);
        }
        if (this.paymentMethodID > 0) {
            ps.setInt(17, this.paymentMethodID);
        } else {
            ps.setNull(17, 4);
        }
        if (this.loyalityID != 0L) {
            ps.setLong(18, this.loyalityID);
        } else {
            ps.setNull(18, -5);
        }
        ps.setDouble(19, this.discount);
        ps.setDouble(20, this.sum);
        ps.setDouble(21, this.sumWithDiscount);
        ps.setDouble(22, this.paid);
        ps.setString(23, this.externalNumber);
        ps.setBoolean(24, this.fromCashBox);
        if (this.workDayID > 0L) {
            ps.setLong(25, this.workDayID);
        } else {
            ps.setNull(25, -5);
        }
        ps.setTimestamp(26, new Timestamp(new java.util.Date().getTime()));
        ps.setLong(27, controller.getUser().getUserID());
        if (this.departmentID > 0) {
            ps.setInt(28, this.departmentID);
        } else {
            ps.setNull(28, 4);
        }
        ps.setDouble(29, this.dependentExpenses);
        try {
            ps.setString(30, this.name);
        }
        catch (NullPointerException e) {
            ps.setNull(30, 12);
        }
        try {
            ps.setString(31, this.jmbg);
        }
        catch (NullPointerException e) {
            ps.setNull(31, 12);
        }
        ps.setBoolean(32, this.realized);
        ps.setString(33, this.payCardSlipNumber);
        ps.setBoolean(34, this.reservated);
        if (this.note2 != null) {
            ps.setString(35, this.note2);
        } else {
            ps.setString(35, "");
        }
        ps.setLong(36, this.documentID);
        System.out.println(ps);
        ps.executeUpdate();
        ps.close();
    }

    public void updateFullNumber(ScreensController controller) throws SQLException {
        String query = " UPDATE document SET  \t\t`DocumentTypeID` = ?,\t\t`DocumentStatusID` = ?,\t\t`PointOfSaleID` = ?,\t\t`Number` = ?,\t\t`Year` = ?,\t\t\t\t`AlternativeFullNumber` = ?,\t\t`Date` = ?,\t\t`DeliveryDate` = ?,\t\t`CurrencyDate` = ?,\t\t`DateFrom` = ?,\t\t`DateTo` = ?,\t\t`Note` = ?,\t\t`Place` = ?,\t\t`PersonID` = ?,\t\t`WarehouseID` = ?,\t\t`PaymentMethodID` = ?,\t\t`LoyalityID` = ?,\t\t`Discount` = ?,\t\t`Sum` = ?,\t\t`SumWithDiscount` = ?,\t\t`Paid` = ?,\t\t`ExternalNumber` = ?,\t\t`FromCashBox` = ?,\t\t`WorkDayID` = ?,\t\t`sysDTEdit` = ?,\t\t`sysUserEditID` = ?,\t\t`DepartmentID` = ?, `DependentExpenses` = ?, `Name` = ?, `JMBG` = ?, `Realized` = ?, `PayCardSlipNumber` = ?,  `Reservated` = ?, `Note2` = ?  WHERE `DocumentID` = ?";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
        ps.setInt(1, this.documentTypeID);
        ps.setInt(2, this.documentStatusID);
        if (this.pointOfSaleID > 0) {
            ps.setInt(3, this.pointOfSaleID);
        } else {
            ps.setNull(3, 4);
        }
        ps.setInt(4, this.number);
        ps.setInt(5, this.year);
        ps.setString(6, this.fullNumber);
        ps.setString(6, this.alternativeFullNumber);
        ps.setTimestamp(7, new Timestamp(this.date.getTime()));
        if (this.deliveryDate != null) {
            ps.setTimestamp(8, new Timestamp(this.deliveryDate.getTime()));
        } else {
            ps.setNull(8, 93);
        }
        if (this.currencyDate != null) {
            ps.setTimestamp(9, new Timestamp(this.currencyDate.getTime()));
        } else {
            ps.setNull(9, 93);
        }
        try {
            ps.setTimestamp(10, new Timestamp(this.dateFrom.getTime()));
        }
        catch (NullPointerException e) {
            ps.setNull(10, 93);
        }
        try {
            ps.setTimestamp(11, new Timestamp(this.dateTo.getTime()));
        }
        catch (NullPointerException e) {
            ps.setNull(11, 93);
        }
        ps.setString(12, this.note);
        ps.setString(13, this.place);
        if (this.personID != 0L) {
            ps.setLong(14, this.personID);
        } else {
            ps.setNull(14, -5);
        }
        if (this.warehouseID != 0) {
            ps.setLong(15, this.warehouseID);
        } else {
            ps.setNull(15, -5);
        }
        if (this.paymentMethodID > 0) {
            ps.setInt(16, this.paymentMethodID);
        } else {
            ps.setNull(16, 4);
        }
        if (this.loyalityID != 0L) {
            ps.setLong(17, this.loyalityID);
        } else {
            ps.setNull(17, -5);
        }
        ps.setDouble(18, this.discount);
        ps.setDouble(19, this.sum);
        ps.setDouble(20, this.sumWithDiscount);
        ps.setDouble(21, this.paid);
        ps.setString(22, this.externalNumber);
        ps.setBoolean(23, this.fromCashBox);
        if (this.workDayID > 0L) {
            ps.setLong(25, this.workDayID);
        } else {
            ps.setNull(25, -5);
        }
        ps.setTimestamp(26, new Timestamp(new java.util.Date().getTime()));
        ps.setLong(27, controller.getUser().getUserID());
        if (this.departmentID > 0) {
            ps.setInt(28, this.departmentID);
        } else {
            ps.setNull(28, 4);
        }
        ps.setDouble(29, this.dependentExpenses);
        try {
            ps.setString(30, this.name);
        }
        catch (NullPointerException e) {
            ps.setNull(30, 12);
        }
        try {
            ps.setString(31, this.jmbg);
        }
        catch (NullPointerException e) {
            ps.setNull(31, 12);
        }
        ps.setBoolean(32, this.realized);
        ps.setString(33, this.payCardSlipNumber);
        ps.setBoolean(34, this.reservated);
        if (this.note2 != null) {
            ps.setString(35, this.note2);
        } else {
            ps.setString(35, "");
        }
        ps.setLong(36, this.documentID);
        System.out.println(ps);
        ps.executeUpdate();
        ps.close();
    }

    public static void delete(Long documentId, Connection connection) throws SQLException {
        String query1 = "DELETE FROM documentdetailsdescription WHERE DocumentDetailsID  IN (SELECT DocumentDetailsID FROM documentdetails WHERE DocumentID = ?)";
        PreparedStatement ps1 = connection.prepareStatement(query1);
        ps1.setLong(1, documentId);
        ps1.executeUpdate();
        String query = "delete from documentdetails where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, documentId);
        ps.executeUpdate();
        query = "delete from document where DocumentID = ?";
        ps = connection.prepareStatement(query);
        ps.setLong(1, documentId);
        ps.executeUpdate();
        ps1.close();
        ps.close();
    }

    public static Document getByID(long documetnId, Connection connection) {
        block18: {
            String query = "select d.*,       p.Name as PersonName  from document d  left join documenttype dt on d.DocumentTypeID = dt.DocumentTypeID  left join person p on p.PersonID = d.PersonID  left join pointofsale ps on d.PointOfSaleID = ps.PointOfSaleID  where d.DocumentID = ?";
            try {
                PreparedStatement ps = connection.prepareStatement(query);
                ps.setLong(1, documetnId);
                System.out.println("nesa " + ps);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) break block18;
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.payCardSlipNumber = rs.getString("PayCardSlipNumber");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.note2 = rs.getString("Note2");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = rs.getString("PersonName");
                try {
                    d.name = rs.getString("Name");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                d.referentNumber = rs.getString("ReferentNumber");
                d.referentDateTime = rs.getString("ReferentDateTime");
                d.buyerIdentification = rs.getString("buyerIdentification");
                rs.close();
                ps.close();
                return d;
            }
            catch (NullPointerException | SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return new Document();
    }

    public static Document getByIDREfund(long documetnId, Connection connection) {
        String query = "select d.*,       p.Name as PersonName, dd.Closed as Closed  from document d  inner join documentdetails dd on dd.DocumentID = d.DocumentID  left join documenttype dt on d.DocumentTypeID = dt.DocumentTypeID  left join person p on p.PersonID = d.PersonID  left join pointofsale ps on d.PointOfSaleID = ps.PointOfSaleID  where d.DocumentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, documetnId);
            System.out.println("nesa " + ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Document d = new Document();
            d.setClosed(rs.getBoolean("Closed"));
            d.documentID = rs.getLong("DocumentID");
            d.documentTypeID = rs.getInt("DocumentTypeID");
            d.documentStatusID = rs.getInt("DocumentStatusID");
            d.pointOfSaleID = rs.getInt("PointOfSaleID");
            d.number = rs.getInt("Number");
            d.payCardSlipNumber = rs.getString("PayCardSlipNumber");
            d.year = rs.getInt("Year");
            d.fullNumber = rs.getString("FullNumber");
            d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
            d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
            try {
                d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            d.note = rs.getString("Note");
            d.note2 = rs.getString("Note2");
            d.place = rs.getString("Place");
            d.personID = rs.getLong("PersonID");
            d.cashBuyersID = rs.getLong("CashBuyersID");
            d.warehouseID = rs.getInt("WarehouseID");
            d.paymentMethodID = rs.getInt("PaymentMethodID");
            d.loyalityID = rs.getLong("LoyalityID");
            d.sum = rs.getDouble("Sum");
            d.sumWithDiscount = rs.getDouble("SumWithDiscount");
            d.paid = rs.getDouble("Paid");
            d.externalNumber = rs.getString("ExternalNumber");
            d.fromCashBox = rs.getBoolean("FromCashBox");
            d.workDayID = rs.getLong("WorkDayID");
            d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
            try {
                d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            d.sysUserAddID = rs.getLong("sysUserAddID");
            d.sysUserEditID = rs.getLong("sysUserEditID");
            try {
                d.departmentID = rs.getInt("DepartmentID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            d.dependentExpenses = rs.getDouble("DependentExpenses");
            d.discount = rs.getDouble("Discount");
            d.personName = rs.getString("PersonName");
            try {
                d.name = rs.getString("Name");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                d.jmbg = rs.getString("JMBG");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            d.realized = rs.getBoolean("Realized");
            d.reservated = rs.getBoolean("Reservated");
            d.referentNumber = rs.getString("ReferentNumber");
            d.referentDateTime = rs.getString("ReferentDateTime");
            d.buyerIdentification = rs.getString("buyerIdentification");
            rs.close();
            ps.close();
            return d;
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document getByDocumentID(long documetnId, Connection connection, ScreensController controller) {
        String query = "select d.* from document d where d.DocumentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, documetnId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Document d = new Document();
            d.documentID = rs.getLong("DocumentID");
            d.documentTypeID = rs.getInt("DocumentTypeID");
            d.documentStatusID = rs.getInt("DocumentStatusID");
            d.pointOfSaleID = rs.getInt("PointOfSaleID");
            d.number = rs.getInt("Number");
            d.payCardSlipNumber = rs.getString("PayCardSlipNumber");
            d.year = rs.getInt("Year");
            d.fullNumber = rs.getString("FullNumber");
            d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
            d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
            try {
                d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            d.note = rs.getString("Note");
            d.place = rs.getString("Place");
            d.personID = rs.getLong("PersonID");
            d.person = Person.getById(d.getPersonID(), controller);
            d.cashBuyersID = rs.getLong("CashBuyersID");
            d.warehouseID = rs.getInt("WarehouseID");
            d.paymentMethodID = rs.getInt("PaymentMethodID");
            d.loyalityID = rs.getLong("LoyalityID");
            d.sum = rs.getDouble("Sum");
            d.sumWithDiscount = rs.getDouble("SumWithDiscount");
            d.paid = rs.getDouble("Paid");
            d.externalNumber = rs.getString("ExternalNumber");
            d.fromCashBox = rs.getBoolean("FromCashBox");
            d.workDayID = rs.getLong("WorkDayID");
            d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
            try {
                d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            d.sysUserAddID = rs.getLong("sysUserAddID");
            d.sysUserEditID = rs.getLong("sysUserEditID");
            try {
                d.departmentID = rs.getInt("DepartmentID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            d.dependentExpenses = rs.getDouble("DependentExpenses");
            d.discount = rs.getDouble("Discount");
            try {
                d.name = rs.getString("Name");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                d.jmbg = rs.getString("JMBG");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            d.realized = rs.getBoolean("Realized");
            d.reservated = rs.getBoolean("Reservated");
            rs.close();
            ps.close();
            return d;
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Document> getByPersonID(Connection connection, int PersonCategoryID, java.util.Date from, java.util.Date to, String filter) {
        String query = "SELECT d.*\r\nFROM person p \r\nLEFT JOIN document d ON d.PersonID = p.PersonID\r\nLEFT JOIN loyality l ON l.PersonID = p.PersonID = d.PersonID WHERE p.PersonCategoryID = ?\r\nAND d.Date BETWEEN ? AND ?\r\nAND (p.FirstName LIKE ? OR p.LastName LIKE ? OR l.CardNumber LIKE ? OR p.Code LIKE ?) GROUP BY p.PersonID, d.DocumentID, d.Date ORDER BY p.sysDTCreated DESC";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, PersonCategoryID);
            ps.setTimestamp(2, new Timestamp(from.getTime()));
            try {
                ps.setTimestamp(3, new Timestamp(to.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(3, new Timestamp(new java.util.Date().getTime()));
            }
            ps.setString(4, "%" + filter + "%");
            ps.setString(5, "%" + filter + "%");
            ps.setString(6, "%" + filter + "%");
            ps.setString(7, "%" + filter + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
            return list;
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<Document> getObeservableListNI(int type, int paymentID, Object object, PointOfSale pos, java.util.Date date, boolean osnovniNaciniPlacanja, boolean prikaziNI, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = null;
        query = paymentID == 0 ? "select d.*,       p.Name as PersonName  from document d  left join documenttype dt on d.DocumentTypeID = dt.DocumentTypeID  left join workday w on w.WorkDayID = d.WorkDayID  left join person p on p.PersonID = d.PersonID  left join pointofsale ps on d.PointOfSaleID = ps.PointOfSaleID   left join paymentmethod pm on pm.PaymentMethodID = d.PaymentMethodID where dt.DocumentTypeID = 12   and ps.ObjectID = ?" : "select d.*,       p.Name as PersonName  from document d  left join documenttype dt on d.DocumentTypeID = dt.DocumentTypeID  left join workday w on w.WorkDayID = d.WorkDayID  left join person p on p.PersonID = d.PersonID  left join pointofsale ps on d.PointOfSaleID = ps.PointOfSaleID   left join paymentmethod pm on pm.PaymentMethodID = d.PaymentMethodID where dt.DocumentTypeID = 12   and ps.ObjectID = ? and pm.PaymentMethodID = ?";
        if (DocumentType.getById(type, connection).getCode().equals("R")) {
            if (!prikaziNI) {
                query = query + "   and d.DocumentID not in (select dr.DocumentParentID  \t\t\t\t\t\t\t  from documentrelationship dr\t\t\t\t\t\t\t where dr.RelationshipTypeID = 2 \t\t\t\t\t\t\t   and dr.Active = true)";
            }
            query = query + "   and w.Date = ?";
        } else {
            query = query + "   and d.Date >= ? and d.Date < DATE_ADD(?, INTERVAL 1 DAY)  ";
        }
        if (pos.getPointOfSaleID() != 0) {
            query = query + " and ps.PointOfSaleID = " + pos.getPointOfSaleID();
        }
        if (osnovniNaciniPlacanja) {
            query = query + " and pm.ParentPaymentMethodID is null ";
        }
        query = query + " order by d.Date desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, object.getObjectID());
            if (paymentID != 0) {
                ps.setInt(2, paymentID);
                ps.setDate(3, new Date(date.getTime()));
                if (!DocumentType.getById(type, connection).getCode().equals("R")) {
                    ps.setDate(4, new Date(date.getTime()));
                }
            } else {
                ps.setDate(2, new Date(date.getTime()));
            }
            if (!DocumentType.getById(type, connection).getCode().equals("R")) {
                ps.setDate(3, new Date(date.getTime()));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                rs.next();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = rs.getString("PersonName");
                try {
                    d.name = rs.getString("Name");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Document getParentID(long documetnId, Connection connection) {
        String query = "select dr.DocumentParentID as DocumentID  from document d  left JOIN documentrelationship dr on dr.DocumentChildID = d.DocumentID  where d.DocumentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, documetnId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Document d = new Document();
            d.documentID = rs.getLong("DocumentID");
            rs.close();
            ps.close();
            return d;
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<Document> getList(int type, int objectId, java.util.Date startDate, java.util.Date endDate, Connection connection) {
        ArrayList<Document> list = new ArrayList<Document>();
        String query = "select d.*,       p.Name as PersonName  from document d  left join documenttype dt on d.DocumentTypeID = dt.DocumentTypeID  left join person p on p.PersonID = d.PersonID  left join pointofsale ps on d.PointOfSaleID = ps.PointOfSaleID  where d.Date >= ? and d.Date <= DATE_ADD(?,INTERVAL 1 DAY) and dt.DocumentTypeID = ?   and ps.ObjectID = ?";
        if (DocumentType.getById(type, connection).getCode().equals("R")) {
            query = query + "   and d.DocumentID not in (select dr.DocumentParentID  \t\t\t\t\t\t\t  from documentrelationship dr\t\t\t\t\t\t\t where dr.RelationshipTypeID = 2 \t\t\t\t\t\t\t   and dr.Active = true)";
        }
        query = query + " order by d.Date desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(startDate.getTime()));
            ps.setTimestamp(2, new Timestamp(endDate.getTime()));
            ps.setInt(3, type);
            ps.setInt(4, objectId);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = rs.getString("PersonName");
                try {
                    d.name = rs.getString("Name");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add(d);
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getInternaOtpremnicaList(int type, int departmentID, java.util.Date startDate, java.util.Date endDate, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.*,       p.Name as PersonName  from document d  left join documenttype dt on d.DocumentTypeID = dt.DocumentTypeID  left join person p on p.PersonID = d.PersonID where d.DocumentStatusID <> 2 and d.Date >= ? and d.Date <= DATE_ADD(?,INTERVAL 1 DAY) and dt.DocumentTypeID = ? order by d.Date desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(startDate.getTime()));
            ps.setTimestamp(2, new Timestamp(endDate.getTime()));
            ps.setInt(3, type);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = Settings.round(rs.getDouble("SumWithDiscount"), 2);
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = rs.getString("PersonName");
                try {
                    d.name = rs.getString("Name");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                d.locked = rs.getBoolean("documentLocked");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getObeservableList(int type, int objectId, java.util.Date startDate, java.util.Date endDate, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        for (Document d : Document.getList(type, objectId, startDate, endDate, connection)) {
            list.add((java.lang.Object)d);
        }
        return list;
    }

    public static ObservableList<Document> getReservationObservableList(boolean sve, boolean realized, boolean timeout, LocalDate from, LocalDate to, ScreensController controller) {
        String query = "";
        query = realized ? "SELECT d.* FROM document d WHERE d.DocumentTypeID = (SELECT dt.DocumentTypeID FROM documenttype dt WHERE dt.Code = 'RE') " + (!sve ? "AND d.Realized = 1 " : " ") + " AND d.Date BETWEEN '" + from + "' AND DATE_ADD('" + to + "', INTERVAL 1 DAY)" : "SELECT d.* FROM document d WHERE d.DocumentTypeID = (SELECT dt.DocumentTypeID FROM documenttype dt WHERE dt.Code = 'RE') " + (!sve ? "AND d.Realized = 0 " : " ") + " AND d.Date BETWEEN '\r\n" + from + "' AND DATE_ADD('" + to + "', INTERVAL 1 DAY)" + (sve ? "" : (timeout ? " AND d.DeliveryDate < NOW()" : " AND d.DeliveryDate >= NOW()"));
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = pStatement.executeQuery();
            System.out.println(pStatement);
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.note2 = rs.getString("Note2");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                d.locked = rs.getBoolean("documentLocked");
                d.statusName = !d.isRealized() ? (d.getDeliveryDate().before(new java.util.Date()) ? "Istekla" : "Aktivna") : "Realizovana";
                d.order = DocumentRelationship.getChildID(d.getDocumentID(), controller) != 0L ? "Da" : "Ne";
                list.add((java.lang.Object)d);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getOrdersObservableList(LocalDate from, LocalDate to, ScreensController controller) {
        String query = "SELECT d.* FROM document d WHERE d.DocumentTypeID = (SELECT dt.DocumentTypeID FROM documenttype dt WHERE dt.Code = 'POR') AND d.Date BETWEEN '" + from + "' AND DATE_ADD('" + to + "', INTERVAL 1 DAY)";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = pStatement.executeQuery();
            System.out.println(pStatement);
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add((java.lang.Object)d);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getObeservableListNalogIspravka(int type, Object object, PointOfSale pos, java.util.Date date, boolean prikaziNI, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.*,       p.Name as PersonName  from document d  left join documenttype dt on d.DocumentTypeID = dt.DocumentTypeID  left join workday w on w.WorkDayID = d.WorkDayID  left join person p on p.PersonID = d.PersonID  left join pointofsale ps on d.PointOfSaleID = ps.PointOfSaleID   left join paymentmethod pm on pm.PaymentMethodID = d.PaymentMethodID  where dt.DocumentTypeID = ?  and ps.ObjectID = ?";
        if (DocumentType.getById(type, connection).getCode().equals("NI")) {
            if (prikaziNI) {
                query = query + "   and d.DocumentID not in (select dr.DocumentParentID  \t\t\t\t\t\t\t  from documentrelationship dr\t\t\t\t\t\t\t where dr.RelationshipTypeID = 2 \t\t\t\t\t\t\t   and dr.Active = true)";
            }
            query = query + "   and w.Date = ?";
        } else {
            query = query + "   and d.Date >= ? and d.Date < DATE_ADD(?, INTERVAL 1 DAY)  ";
        }
        if (pos.getPointOfSaleID() != 0) {
            query = query + " and ps.PointOfSaleID = " + pos.getPointOfSaleID();
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, type);
            ps.setInt(2, object.getObjectID());
            ps.setDate(3, new Date(date.getTime()));
            if (!DocumentType.getById(type, connection).getCode().equals("NI")) {
                ps.setDate(4, new Date(date.getTime()));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = rs.getString("PersonName");
                try {
                    d.name = rs.getString("Name");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getKnjigaList(Person person, String documentTypeId, java.util.Date from, java.util.Date to, String filter, boolean realized, boolean uValuti, boolean vanValute, int interval, ScreensController controller) {
        String query = null;
        if (uValuti && vanValute) {
            query = "SELECT d.* FROM document d JOIN person p ON p.PersonID = d.PersonID WHERE d.CurrencyDate BETWEEN ? AND DATE_ADD(?, INTERVAL 1 DAY) AND d.DocumentTypeID IN (" + documentTypeId + ") AND d.Realized = ? " + (person.getPersonID() == -1L ? "" : "AND d.PersonID = " + person.getPersonID()) + " ORDER BY d.Number DESC";
        } else if (!(uValuti || vanValute || realized)) {
            query = "";
        } else {
            String valuta = uValuti && !vanValute ? ">=" : "<=";
            query = "SELECT d.* FROM document d JOIN person p ON p.PersonID = d.PersonID WHERE d.Date >= ? AND d.Date <= DATE_ADD(?, INTERVAL 1 DAY) AND d.DocumentTypeID IN (" + documentTypeId + ") AND d.Realized = ? AND (d.Number LIKE '%" + filter + "%' OR p.Name LIKE '%" + filter + "%')" + (realized ? "" : " AND d.CurrencyDate " + valuta + " DATE_ADD(NOW(), INTERVAL ? DAY)") + (person.getPersonID() == -1L ? "" : "AND d.PersonID = " + person.getPersonID()) + " ORDER BY d.Number DESC";
        }
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(from.getTime()));
            pStatement.setTimestamp(2, new Timestamp(to.getTime()));
            if (uValuti && vanValute) {
                pStatement.setBoolean(3, realized);
            } else if (!uValuti && !vanValute) {
                pStatement.setBoolean(3, realized);
            } else if (realized) {
                pStatement.setBoolean(3, realized);
            } else {
                pStatement.setBoolean(3, realized);
                pStatement.setInt(4, interval);
            }
            System.out.println(pStatement);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException e) {
                    d.deliveryDate = null;
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException e) {
                    d.currencyDate = null;
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.sum = rs.getDouble("Sum");
                d.paid = d.realized ? d.sumWithDiscount : PaymentRecord.getPaidAmountSum(d.documentID, controller);
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.discount = rs.getDouble("Discount");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add((java.lang.Object)d);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getKnjigaListPrikazi(Person person, String documentTypeId, boolean prikaziuValuti, boolean prikazivanValute, int interval, ScreensController controller) {
        String query = null;
        query = prikaziuValuti ? "SELECT d.* FROM document d JOIN person p ON p.PersonID = d.PersonID \r\nWHERE d.CurrencyDate BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL ? DAY) AND d.DocumentTypeID IN (?) AND d.Realized = 0  ORDER BY d.Number DESC" : "SELECT d.* FROM document d JOIN person p ON p.PersonID = d.PersonID \r\nWHERE d.CurrencyDate BETWEEN DATE_ADD(NOW(), INTERVAL ? DAY) AND NOW() AND d.DocumentTypeID IN (?) AND d.Realized = 0  ORDER BY d.Number DESC";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            if (prikaziuValuti) {
                pStatement.setInt(1, interval);
            } else {
                pStatement.setInt(1, interval * -1);
            }
            pStatement.setString(2, documentTypeId);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException e) {
                    d.deliveryDate = null;
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException e) {
                    d.currencyDate = null;
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.sum = rs.getDouble("Sum");
                d.paid = d.realized ? d.sumWithDiscount : PaymentRecord.getPaidAmountSum(d.documentID, controller);
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.discount = rs.getDouble("Discount");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add((java.lang.Object)d);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getObeservableList(int type, int paymentID, Object object, PointOfSale pos, java.util.Date date, boolean osnovniNaciniPlacanja, boolean prikaziNI, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = null;
        query = paymentID == 0 ? "select d.*,       p.Name as PersonName  from document d  left join documenttype dt on d.DocumentTypeID = dt.DocumentTypeID  left join workday w on w.WorkDayID = d.WorkDayID  left join person p on p.PersonID = d.PersonID  left join pointofsale ps on d.PointOfSaleID = ps.PointOfSaleID   left join paymentmethod pm on pm.PaymentMethodID = d.PaymentMethodID where dt.DocumentTypeID = ?   and ps.ObjectID = ?" : "select d.*,       p.Name as PersonName  from document d  left join documenttype dt on d.DocumentTypeID = dt.DocumentTypeID  left join workday w on w.WorkDayID = d.WorkDayID  left join person p on p.PersonID = d.PersonID  left join pointofsale ps on d.PointOfSaleID = ps.PointOfSaleID   left join paymentmethod pm on pm.PaymentMethodID = d.PaymentMethodID where dt.DocumentTypeID = ?   and ps.ObjectID = ? and pm.PaymentMethodID = ? ";
        if (DocumentType.getById(type, connection).getCode().equals("R")) {
            if (!prikaziNI) {
                query = query + "   and d.DocumentID not in (select dr.DocumentParentID  \t\t\t\t\t\t\t  from documentrelationship dr\t\t\t\t\t\t\t where dr.RelationshipTypeID = 2 \t\t\t\t\t\t\t   and dr.Active = true)";
            }
            query = query + "   and w.Date = ?";
        } else {
            query = query + "   and d.Date >= ? and d.Date < DATE_ADD(?, INTERVAL 1 DAY)  ";
        }
        if (pos.getPointOfSaleID() != 0) {
            query = query + " and ps.PointOfSaleID = " + pos.getPointOfSaleID();
        }
        if (osnovniNaciniPlacanja) {
            query = query + " and pm.ParentPaymentMethodID is null ";
        }
        query = query + " order by d.Date desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, type);
            ps.setInt(2, object.getObjectID());
            if (paymentID != 0) {
                ps.setInt(3, paymentID);
                ps.setDate(4, new Date(date.getTime()));
                if (!DocumentType.getById(type, connection).getCode().equals("R")) {
                    ps.setDate(5, new Date(date.getTime()));
                }
            } else {
                ps.setDate(3, new Date(date.getTime()));
            }
            if (!DocumentType.getById(type, connection).getCode().equals("R")) {
                ps.setDate(4, new Date(date.getTime()));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = rs.getString("PersonName");
                try {
                    d.name = rs.getString("Name");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getObeservableList(int type, int paymentID, Object object, PointOfSale pos, java.util.Date startDate, java.util.Date endDate, boolean osnovniNaciniPlacanja, boolean prikaziNI, Connection connection, boolean personIsIndividual) {
        ObservableList list = FXCollections.observableArrayList();
        String filterText = personIsIndividual ? " AND p.PersonTypeID = 1 " : "";
        String query = null;
        try {
            PreparedStatement ps = null;
            query = paymentID == -1 ? "SELECT d.*, CASE p.PersonTypeID \r\n \twhen 2 then p.Name\r\n \twhen 1 then  CONCAT(p.FirstName, ' ', p.LastName )\r\n \tEND PersonName FROM document d  LEFT JOIN documenttype dt ON d.DocumentTypeID = dt.DocumentTypeID  LEFT JOIN workday w ON w.WorkDayID = d.WorkDayID  LEFT JOIN person p ON p.PersonID = d.PersonID  LEFT JOIN pointofsale ps ON d.PointOfSaleID = ps.PointOfSaleID   LEFT JOIN paymentmethod pm ON pm.PaymentMethodID = d.PaymentMethodID  WHERE dt.DocumentTypeID = ? AND ps.ObjectID = ? AND d.DocumentStatusID NOT IN (SELECT ds.DocumentStatusID FROM documentstatus ds WHERE ds.Name = 'Storniran') and d.DocumentStatusID<>2   AND w.Date >= ? AND w.Date <= ?" : "SELECT d.*,CASE p.PersonTypeID \r\n \twhen 2 then p.Name\r\n \twhen 1 then  CONCAT(p.FirstName, ' ', p.LastName )\r\n \tEND PersonName  FROM document d  LEFT JOIN documenttype dt ON d.DocumentTypeID = dt.DocumentTypeID  LEFT JOIN workday w ON w.WorkDayID = d.WorkDayID  LEFT JOIN person p ON p.PersonID = d.PersonID  LEFT JOIN pointofsale ps ON d.PointOfSaleID = ps.PointOfSaleID   LEFT JOIN paymentmethod pm ON pm.PaymentMethodID = d.PaymentMethodID  WHERE dt.DocumentTypeID = ? AND ps.ObjectID = ? AND d.DocumentStatusID NOT IN (SELECT ds.DocumentStatusID FROM documentstatus ds WHERE ds.Name = 'Storniran') and d.DocumentStatusID<>2   AND w.Date >= ? AND w.Date <= ? AND pm.PaymentMethodID = ?";
            if (DocumentType.getById(type, connection).getCode().equals("R") && !prikaziNI) {
                query = query + "   and d.DocumentID not in (select dr.DocumentParentID  \t\t\t\t\t\t\t  from documentrelationship dr\t\t\t\t\t\t\t where dr.RelationshipTypeID = 2 \t\t\t\t\t\t\t   and dr.Active = true)";
            }
            if (pos.getPointOfSaleID() != 0) {
                query = query + " and ps.PointOfSaleID = " + pos.getPointOfSaleID();
            }
            if (osnovniNaciniPlacanja) {
                query = query + " and pm.ParentPaymentMethodID is null ";
            }
            query = query + filterText;
            query = query + " order by d.Date desc";
            ps = connection.prepareStatement(query);
            ps.setInt(1, type);
            ps.setInt(2, object.getObjectID());
            ps.setDate(3, new Date(startDate.getTime()));
            ps.setDate(4, new Date(endDate.getTime()));
            if (paymentID != -1) {
                ps.setInt(5, paymentID);
            }
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String limitedNote;
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = limitedNote = Document.limitNoteOnSpecificNumberOfChar(rs.getString("Note"), 30);
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                PaymentMethod pMethod = PaymentMethod.getByID(d.paymentMethodID, connection);
                d.paymentMethodName = pMethod.getName();
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                String refNumber = rs.getString("ReferentNumber");
                int refIndex = refNumber != null ? refNumber.indexOf(45) : 0;
                d.fullNumber = refNumber != null ? refNumber.substring(refIndex + 1, refNumber.length()) : "";
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = rs.getString("PersonName");
                try {
                    d.name = rs.getString("PersonName");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                d.locked = rs.getBoolean("documentLocked");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getObeservableListWebRacun(int type, java.util.Date startDate, java.util.Date endDate, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = null;
        try {
            PreparedStatement ps = null;
            query = "SELECT d.*, ds.Name AS StatusName, p.Name AS PersonName FROM document d  LEFT JOIN documenttype dt ON d.DocumentTypeID = dt.DocumentTypeID  LEFT JOIN person p ON p.PersonID = d.PersonID  LEFT JOIN paymentmethod pm ON pm.PaymentMethodID = d.PaymentMethodID  LEFT JOIN documentstatus ds ON ds.DocumentStatusID = d.DocumentStatusID  WHERE dt.DocumentTypeID = ?   AND d.Date >= ? AND d.Date <= DATE_ADD(?, INTERVAL 1 DAY) ORDER BY d.Date DESC";
            ps = connection.prepareStatement(query);
            ps.setInt(1, type);
            ps.setDate(2, new Date(startDate.getTime()));
            ps.setDate(3, new Date(endDate.getTime()));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = rs.getString("PersonName");
                try {
                    d.name = rs.getString("Name");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.statusName = rs.getString("StatusName");
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (NullPointerException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void insertParent(int RelationshipTypeID, long parentId, Connection connection) {
        String query = "insert into documentrelationship(RelationshipTypeID,DocumentParentID,DocumentChildID,Active,sysUserAddID,sysDTCreated)  values(?,?,?,?,?,?) ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, RelationshipTypeID);
            ps.setLong(2, parentId);
            ps.setLong(3, this.documentID);
            ps.setBoolean(4, true);
            ps.setLong(5, this.getSysUserAddID());
            ps.setTimestamp(6, new Timestamp(new java.util.Date().getTime()));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insertParentReserve(int RelationshipTypeID, long parentId, Connection connection) {
        String query = "insert into documentrelationship(RelationshipTypeID,DocumentParentID,DocumentChildID,Active,sysUserAddID,sysDTCreated)  values(?,?,?,?,?,?) ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, RelationshipTypeID);
            ps.setLong(2, this.documentID);
            ps.setLong(3, parentId);
            ps.setBoolean(4, true);
            ps.setLong(5, this.getSysUserAddID());
            ps.setTimestamp(6, new Timestamp(new java.util.Date().getTime()));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void printInvoice(Person customer, ScreensController controller, Window owner) throws SQLException {
        String reportFileName = "rs/petcom/master/jasper/Invoice.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get(controller.getSettings().getConnection()));
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller).getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("person", customer);
        hm.put("document", this);
        hm.put("documentId", this.documentID);
        hm.put("billAmount", ScreensController.BrojUSlova(this.getSumWithDiscount()));
        hm.put("gotovinski", this.getPaymentMethodID() != 5);
        hm.put("BI", this.bi != null && !this.bi.equals("") ? this.bi : this.fullNumber);
        if (controller.getSettings().getActualByName("napomena.gotovinski.kupac") != null) {
            hm.put("napomena", controller.getSettings().getActualByName("napomena.faktura"));
        } else {
            hm.put("napomena", "");
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
            hm2.put("report", (java.lang.Object)printViewPane);
            controller.showModalDialog("Faktura", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printInvoice(Person person, CashBuyer cashBuyer, ScreensController controller, Window owner) {
        String reportFileName = "rs/petcom/master/jasper/InvoiceCashBuyersNew.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("object", Object.get(controller.getSettings().getConnection()));
        hm.put("barcodeInReport", Boolean.parseBoolean(controller.getSettings().getActualByName("barkod.vidljiv.izlazni.dokumenti")));
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller).getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("buyer", cashBuyer);
        hm.put("person", person);
        try {
            hm.put("paymentMethod", controller.getCurrentBill().getPaymentMethod().getName());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            hm.put("paymentMethod", PaymentMethod.getByID(this.getPaymentMethodID(), controller.getSettings().getConnection()).getName());
        }
        hm.put("document", this);
        hm.put("documentId", this.documentID);
        hm.put("docNumber", String.valueOf(this.getNumber()));
        hm.put("billAmount", ScreensController.BrojUSlova(this.getSumWithDiscount()));
        hm.put("BI", this.bi != null && !this.bi.equals("") ? this.bi : this.fullNumber);
        if (controller.getSettings().getActualByName("napomena.gotovinski.kupac") != null) {
            hm.put("napomena", controller.getSettings().getActualByName("napomena.gotovinski.kupac"));
        } else {
            hm.put("napomena", this.getNote());
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            if (controller.getSettings().getActualByName("automatska.stampa.gotovinski").equals("true")) {
                for (int i = 0; i < Integer.parseInt(controller.getSettings().getActualByName("broj.kopija.gotovinski")); ++i) {
                    JasperPrintManager.printReport((JasperPrint)jprint, (boolean)false);
                }
            } else {
                JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
                HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
                hm2.put("report", (java.lang.Object)printViewPane);
                controller.showModalDialog("Gotovinski racun", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void NarrowGotBillPrint(ScreensController controller) {
        NarrowGotBill ng = new NarrowGotBill(this, controller);
        ng.makeContent();
    }

    public void printWebInvoice(Person person, ScreensController controller, Window owner) {
        String reportFileName = "rs/petcom/master/jasper/WebInvoice.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        for (Images images : Images.getImagesList(controller)) {
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("company.memorandum.boolean"))) {
                if (images.getName().equals("memorandum")) {
                    try {
                        hm.put("memorandum", ImageIO.read(images.getImage()));
                        hm.put("logo", null);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                hm.put("memorandum", null);
                continue;
            }
            hm.put("memorandum", null);
            if (images.getName().equals("logo")) {
                try {
                    hm.put("logo", ImageIO.read(images.getImage()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            hm.put("logo", null);
        }
        hm.put("objekat", Object.get(controller.getSettings().getConnection()));
        try {
            hm.put("address", Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()));
            hm.put("addressCompany", Address.getByID(CompanyConfig.getByID(controller.getObject().getCompanyConfigID(), controller).getAddressID(), controller.getSettings().getConnection()));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        hm.put("person", person);
        try {
            hm.put("paymentMethod", controller.getCurrentBill().getPaymentMethod().getName());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            // empty catch block
        }
        hm.put("document", this);
        hm.put("documentId", this.documentID);
        hm.put("docNumber", String.valueOf(this.getNumber()));
        hm.put("billAmount", ScreensController.BrojUSlova(this.getSumWithDiscount()));
        if (controller.getSettings().getActualByName("napomena.web.racun") != null) {
            hm.put("napomena", controller.getSettings().getActualByName("napomena.web.racun"));
        } else {
            hm.put("napomena", "");
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
            hm2.put("report", (java.lang.Object)printViewPane);
            controller.showModalDialog("Web racun", ScreensController.DIALOG_PRINT_PREVIEW, hm2, owner);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public static int getNextNumber(int typeId, long posId, ScreensController controller) {
        return SQLHelper.QueryToInt("SELECT d.Number FROM document d WHERE d.DocumentTypeID = " + typeId + " AND d.Year = YEAR(NOW()) AND d.PointOfSaleID = " + posId + " ORDER BY d.DocumentID DESC LIMIT 1", controller.getSettings().getConnection(), DocumentType.getById(typeId, controller.getSettings().getConnection()).getFirstNumber());
    }

    public static int getNextNumberNivelacija(int typeId, ScreensController controller) {
        return SQLHelper.QueryToInt("select MAX(d.Number) FROM document d WHERE d.DocumentTypeID = " + typeId + " AND d.PointOfSaleID IN (SELECT ps.PointOfSaleID FROM pointofsale ps) and d.Year = YEAR(now())", controller.getSettings().getConnection(), DocumentType.getById(typeId, controller.getSettings().getConnection()).getFirstNumber());
    }

    public static int getNextNumber(int typeId, Department department, ScreensController controller, LocalDate date) {
        return SQLHelper.QueryToInt("select Coalesce(max(d.Number),0) from document d where d.DocumentStatusID <>2 and  d.DocumentTypeID =" + typeId + " AND d.Year= YEAR('" + date + "') and d.DepartmentID =" + department.getDepartmentID(), controller.getSettings().getConnection(), DocumentType.getById(typeId, controller.getSettings().getConnection()).getFirstNumber());
    }

    public static int getNextNumberForType(int typeId, ScreensController controller) {
        return SQLHelper.QueryToInt("select Coalesce(max(d.Number),0) from document d where d.DocumentTypeID =" + typeId, controller.getSettings().getConnection(), 1);
    }

    public static int getNextNumberCentralniMagacin(int typeId, WarehouseCentral warehouseCentral, ScreensController controller) {
        return SQLHelper.QueryToInt("select max(d.Number) from document d where d.DocumentTypeID = " + typeId + "  and d.Year = YEAR(NOW()) and d.WarehouseID = " + warehouseCentral.getWarehouseId(), controller.getSettings().getConnection(), DocumentType.getById(typeId, controller.getSettings().getConnection()).getFirstNumber());
    }

    public static int getNextNumberForDocumentType(int typeId, Object object, ScreensController controller) {
        return SQLHelper.QueryToInt("select getMaxNumberForDocumentType(" + object.getObjectID() + "," + typeId + ")", controller.getSettings().getConnection(), DocumentType.getById(typeId, controller.getSettings().getConnection()).getFirstNumber());
    }

    public static long getFakturaIDDokumenta(long documentId, ScreensController controller) {
        return SQLHelper.QueryToInt("select getFakturaIDDokumenta(" + documentId + ")", controller.getSettings().getConnection(), -1);
    }

    public static ObservableList<Document> getProfakturaList(int documentTypeID, String datumOd, String datumDo, boolean realized, boolean reservated, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT d.*, COALESCE(p.Name, '') AS PersonName, CONCAT(p.FirstName, ' ', p.LastName) AS PersonName1 FROM document d, person p WHERE d.DocumentTypeID = " + String.valueOf(documentTypeID) + " AND p.PersonID = d.PersonID AND d.Date BETWEEN '" + datumOd + " 00:00:00'  AND '" + datumDo + " 23:59:59'  AND d.Realized = ? AND d.Reservated = ? ORDER BY d.DocumentID DESC;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setBoolean(1, realized);
            pStatement.setBoolean(2, reservated);
            System.out.println(pStatement);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.note2 = rs.getString("note2");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = !rs.getString("PersonName").equals("") ? rs.getString("PersonName") : rs.getString("PersonName1");
                try {
                    d.name = rs.getString("Name");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                d.locked = rs.getBoolean("documentLocked");
                list.add((java.lang.Object)d);
            }
            pStatement.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getProfakturaToReserveList(int documentTypeID, boolean realized, boolean reservated, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT d.*, CONCAT(p.FirstName,' ',p.LastName) AS PersonName  FROM document d, person p  WHERE d.DocumentTypeID = " + documentTypeID + "  AND p.PersonID = d.PersonID AND Date(d.Date) BETWEEN ? AND ? AND d.Realized = ? AND d.Reservated = ? ORDER BY d.DocumentID DESC";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(WorkDay.getFistWarkDayEver(controller.getSettings().getConnection()).getDateFrom().getTime()));
            pStatement.setTimestamp(2, new Timestamp(new java.util.Date().getTime()));
            pStatement.setBoolean(3, realized);
            pStatement.setBoolean(4, reservated);
            System.out.println(pStatement);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.note2 = rs.getString("Note2");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.personName = rs.getString("PersonName");
                try {
                    d.name = rs.getString("Name");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.jmbg = rs.getString("JMBG");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                list.add((java.lang.Object)d);
            }
            pStatement.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static java.util.Date Poslednji_popis_department_pre_datuma_v4(int departmentID, java.util.Date date, Connection connection) {
        String query = "select poslednji_popis_department_pre_datuma_v4(? ,?)";
        Document d = new Document();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, departmentID);
            ps.setDate(2, new Date(date.getTime()));
            ResultSet rs = ps.executeQuery();
            rs.next();
            d.date = rs.getTimestamp(1);
            rs.close();
            ps.close();
            return d.date;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return d.date;
        }
    }

    public static java.util.Date Poslednji_popis_department_pre_datuma_v5(int departmentID, java.util.Date date, Connection connection) {
        String query = "select poslednji_popis_department_pre_datuma_v5(? ,?)";
        Document d = new Document();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, departmentID);
            ps.setDate(2, new Date(date.getTime()));
            ResultSet rs = ps.executeQuery();
            rs.next();
            d.date = rs.getTimestamp(1);
            rs.close();
            ps.close();
            return d.date;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return d.date;
        }
    }

    public static ObservableList<Document> CALL_productCard_getWarehouse(long productId, java.util.Date dateOd, java.util.Date dateDo, int warehouseID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "CALL productCard_getWarehouse(?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            ps.setDate(2, new Date(dateOd.getTime()));
            ps.setDate(3, new Date(dateDo.getTime()));
            ps.setInt(4, warehouseID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.setDocumentID(rs.getInt("Tip"));
                d.setDate(rs.getDate("Datum"));
                d.setUlaz(rs.getDouble("Ulaz"));
                d.setIzlaz(rs.getDouble("Izlaz"));
                d.setStanje(rs.getDouble("Stanje"));
                d.setNabavnaCena(rs.getDouble("NabavnaCena"));
                d.setNabavnaVrednost(rs.getDouble("NabavnaVrednost"));
                d.setProdajnaCena(rs.getDouble("ProdajnaCena"));
                d.setProdajnaVrednost(rs.getDouble("ProdajnaVrednost"));
                d.setNazivDokumenta(rs.getString("NazivDokumenta"));
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> CALL_productCard_get(long productId, java.util.Date dateOd, java.util.Date dateDo, int departmentID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "CALL productCard_get(?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            ps.setDate(2, new Date(dateOd.getTime()));
            ps.setDate(3, new Date(dateDo.getTime()));
            ps.setInt(4, departmentID);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            ArrayList documents = new ArrayList();
            while (rs.next()) {
                Document d = new Document();
                d.setDocumentID(rs.getInt("Tip"));
                d.setDate(rs.getDate("Datum"));
                d.setUlaz(rs.getDouble("Ulaz"));
                d.setIzlaz(rs.getDouble("Izlaz"));
                d.setStanje(rs.getDouble("Stanje"));
                d.setNabavnaCena(rs.getDouble("NabavnaCena"));
                d.setNabavnaVrednost(rs.getDouble("NabavnaVrednost"));
                d.setProdajnaCena(rs.getDouble("ProdajnaCena"));
                d.setProdajnaVrednost(rs.getDouble("ProdajnaVrednost"));
                d.setNazivDokumenta(rs.getString("NazivDokumenta"));
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Document> getStalniGostRacun(int objectID, java.util.Date dateOd, java.util.Date dateDo, int paymentMethodID, long PersonId, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "Select d.DocumentID, d.Date as Datum, d.Sum as Iznos, d.Discount as Popust, d.SumWithDiscount as IznosSaPopustom, pm.Name as Nacin_Placanja, pm.PaymentMethodID, d.FullNumber from document d join workday wd on wd.WorkDayID = d.WorkDayID join paymentmethod pm on pm.PaymentMethodID = d.PaymentMethodID join pointofsale pos on pos.PointOfSaleID = d.PointOfSaleID join object o on o.ObjectID = pos.ObjectID where o.ObjectID = ? \tand wd.Date BETWEEN ? and ? \tand d.PersonID = ?";
        if (paymentMethodID > 0) {
            query = query + " \tand pm.PaymentMethodID = ?";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, objectID);
            ps.setDate(2, new Date(dateOd.getTime()));
            ps.setDate(3, new Date(dateDo.getTime()));
            ps.setLong(4, PersonId);
            if (paymentMethodID > 0) {
                ps.setInt(5, paymentMethodID);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.date = rs.getDate("Datum");
                d.sum = rs.getDouble("Iznos");
                d.discount = rs.getDouble("Popust");
                d.sumWithDiscount = rs.getDouble("IznosSaPopustom");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.paymentMethodName = rs.getString("Nacin_Placanja");
                d.fullNumber = rs.getString("FullNumber");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static java.util.Date getLastInitialInventory(Department department, Connection connection) {
        String query = "select coalesce(max(d.Date), \t\t        (select min(Date) from document ))  from document d where d.DocumentTypeID = 11   and d.DepartmentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getDate(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static java.util.Date getDateFromFirstActiveReservation(ScreensController controller) {
        String query = "SELECT COALESCE(d.Date, NOW()) FROM document d WHERE d.DocumentTypeID = (SELECT dt.DocumentTypeID FROM documenttype dt WHERE dt.Code = 'RE') AND d.Realized = 0 AND d.DeliveryDate >= NOW()";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getTimestamp(1);
            }
            return new java.util.Date();
        }
        catch (SQLException e) {
            return new java.util.Date();
        }
    }

    public long getParentID(int relationshipId, Connection connection) {
        String query = "select \tDocumentParentID   from documentrelationship  where DocumentChildID = ?   and RelationShipTypeID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.documentID);
            ps.setInt(2, relationshipId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getLong("DocumentParentID");
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public static ObservableList<Document> getRacuneZaUpdate(ScreensController screensController) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.DocumentID from document d where d.DocumentTypeID = 3 order by d.Number";
        try {
            PreparedStatement pStatement = screensController.getSettings().getConnection().prepareStatement(query);
            ResultSet resultSet = pStatement.executeQuery();
            while (resultSet.next()) {
                Document product = Document.getByID(resultSet.getLong(1), screensController.getSettings().getConnection());
                list.add((java.lang.Object)product);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void updateRealized(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`document` SET `Realized` = ? WHERE  `DocumentID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setBoolean(1, this.realized);
            pStatement.setLong(2, this.documentID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void changeFullNumber(int pdvId, Connection connection) {
        String query = "UPDATE product SET `Number` = ? ";
        try {
            PreparedStatement statement = connection.prepareStatement(query);
            statement.setInt(1, pdvId);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public static ObservableList<Document> getKnjigaKomitenataList(LocalDate from, LocalDate to, Person person, String filter, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT d.DocumentID, p.Name AS Komitent, CONCAT(dt.Code,'-',d.Number) AS ImeDokumenta, COALESCE(d.SumWithDiscount, d.Sum) AS Sum, d.Number, d.Date, d.CurrencyDate, COALESCE((SELECT SUM(pr.PaidAmount) FROM paymentrecord pr WHERE pr.DocumentID = d.DocumentID),0) AS Uplaceno FROM document d LEFT JOIN documenttype dt ON dt.DocumentTypeID = d.DocumentTypeID  LEFT JOIN person p ON p.PersonID = d.PersonID WHERE d.Date BETWEEN ? AND ? AND (-1 = ? OR d.PersonID = ?) AND d.PersonID IS NOT NULL AND d.DocumentTypeID NOT IN (3,6) AND dt.Stock <> 0 AND p.Name LIKE '%" + filter.trim() + "%' ORDER BY d.DocumentID ASC";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, WorkDay.start(from, controller.getSettings().getConnection()));
            pStatement.setTimestamp(2, WorkDay.end(to, controller.getSettings().getConnection()) != null ? WorkDay.end(to, controller.getSettings().getConnection()) : new Timestamp(new java.util.Date().getTime()));
            pStatement.setLong(3, person.getPersonID());
            pStatement.setLong(4, person.getPersonID());
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Document document = new Document();
                document.setDocumentID(rSet.getLong("DocumentID"));
                document.setNazivDokumenta(rSet.getString("ImeDokumenta"));
                document.setPersonName(rSet.getString("Komitent"));
                document.setSum(rSet.getDouble("Sum"));
                document.setDate(rSet.getTimestamp("Date"));
                document.setCurrencyDate(rSet.getTimestamp("CurrencyDate"));
                list.add((java.lang.Object)document);
                if (PaymentRecord.getListByDocumentId(controller, document.documentID).isEmpty()) continue;
                for (PaymentRecord paymentRecord : PaymentRecord.getListByDocumentId(controller, document.documentID)) {
                    Document doc = new Document();
                    doc.setDocumentID(paymentRecord.getDocumentID());
                    doc.setNazivDokumenta(document.getNazivDokumenta());
                    doc.setDeliveryDate(paymentRecord.getSysCreateDate());
                    doc.setCurrencyDate(null);
                    doc.setPaid(paymentRecord.getPaidAmount());
                    list.add((java.lang.Object)doc);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Document getBillSumByPerson(Connection connection, Person person) {
        String query = "SELECT SUM(d.Sum) AS Sum FROM document d WHERE d.PersonID = ?";
        Document document = new Document();
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setLong(1, person.getPersonID());
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            document.setSum(rSet.getDouble("Sum"));
            return document;
        }
        catch (SQLException e) {
            document.setSum(0.0);
            return document;
        }
    }

    public static void getReceivingReportToExcel(ScreensController controller, ObservableList<Document> list, String putanja, String name) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Pregled loyaltija");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Ime i prezime");
        header.createCell(1).setCellValue("Kod kartice");
        header.createCell(2).setCellValue("Datum");
        header.createCell(3).setCellValue("Nacin placanja");
        header.createCell(4).setCellValue("Mesto");
        header.createCell(5).setCellValue("Racun");
        header.createCell(6).setCellValue("Popust");
        header.createCell(7).setCellValue("Racun sa popustom");
        sheet.setColumnWidth(0, 6400);
        sheet.setColumnWidth(1, 3200);
        sheet.setColumnWidth(2, 4100);
        sheet.setColumnWidth(3, 3200);
        sheet.setColumnWidth(4, 3200);
        sheet.setColumnWidth(5, 3200);
        sheet.setColumnWidth(6, 3200);
        sheet.setColumnWidth(7, 3200);
        int index = 1;
        for (Document document : list) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(Person.getById(document.getPersonID(), controller).getFirstLastName());
            try {
                row.createCell(1).setCellValue(Person.getById(document.getPersonID(), controller).getLoyality().getCardNumber());
            }
            catch (NullPointerException e) {
                row.createCell(1).setCellValue(Person.getById(document.getPersonID(), controller).getCode());
            }
            row.createCell(2).setCellValue(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(document.getDate()));
            row.createCell(3).setCellValue(PaymentMethod.getByID(document.getPaymentMethodID(), controller.getSettings().getConnection()).getName());
            row.createCell(4).setCellValue(Person.getById(document.getPersonID(), controller).getCity());
            row.createCell(5).setCellValue(document.getSum());
            row.createCell(6).setCellValue(document.getDiscount());
            row.createCell(7).setCellValue(document.getSumWithDiscount());
            ++index;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(putanja + File.separator + name);
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getRobnaKarticaToExcel(ScreensController controller, ObservableList<Document> list, String putanja, String name) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Robna kartica");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Datum");
        header.createCell(1).setCellValue("Ulaz");
        header.createCell(2).setCellValue("Izlaz");
        header.createCell(3).setCellValue("Stanje");
        header.createCell(4).setCellValue("Nab. cena");
        header.createCell(5).setCellValue("Nab. vrednost");
        header.createCell(6).setCellValue("Prod. cena");
        header.createCell(7).setCellValue("Prod. vrednost");
        header.createCell(8).setCellValue("Naziv dok.");
        sheet.setColumnWidth(0, 3200);
        sheet.setColumnWidth(1, 3200);
        sheet.setColumnWidth(2, 4100);
        sheet.setColumnWidth(3, 4100);
        sheet.setColumnWidth(4, 4100);
        sheet.setColumnWidth(5, 4100);
        sheet.setColumnWidth(6, 4100);
        sheet.setColumnWidth(7, 4100);
        sheet.setColumnWidth(8, 4100);
        int index = 1;
        for (Document document : list) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(document.getDate());
            row.createCell(1).setCellValue(document.getUlaz());
            row.createCell(2).setCellValue(document.getIzlaz());
            row.createCell(3).setCellValue(document.getStanje());
            row.createCell(4).setCellValue(document.getNabavnaCena());
            row.createCell(5).setCellValue(document.getNabavnaVrednost());
            row.createCell(6).setCellValue(document.getProdajnaCena());
            row.createCell(7).setCellValue(document.getProdajnaVrednost());
            row.createCell(8).setCellValue(document.getNazivDokumenta());
            ++index;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(putanja + File.separator + name);
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getPorudzbenicaToExcel(ScreensController controller, List<DocumentDetails> list, String putanja, Document doc, BorderPane rootPane) {
        XSSFWorkbook wb = new XSSFWorkbook();
        Connection connection = controller.getSettings().getConnection();
        XSSFSheet sheet = wb.createSheet("Porudzbenica");
        XSSFRow orderNumber = sheet.createRow(0);
        orderNumber.createCell(2).setCellValue("Porud\u017ebenica broj:" + doc.getNumber());
        XSSFRow orderDate = sheet.createRow(1);
        orderDate.createCell(2).setCellValue("Datum porud\u017ebenice:" + Utility.formatToDateString(doc.getDate(), "dd.MM.yyyy"));
        XSSFRow empty = sheet.createRow(2);
        XSSFRow header = sheet.createRow(3);
        header.createCell(0).setCellValue("Redni Broj");
        header.createCell(1).setCellValue("\u0160ifra");
        header.createCell(2).setCellValue("Opis");
        header.createCell(3).setCellValue("Kolicina");
        header.createCell(4).setCellValue("Kupac");
        header.createCell(5).setCellValue("\u017deljeni rok");
        header.createCell(6).setCellValue("Napomena");
        header.createCell(7).setCellValue("Rok");
        sheet.setColumnWidth(0, 3100);
        sheet.setColumnWidth(1, 3100);
        sheet.setColumnWidth(2, 17800);
        sheet.setColumnWidth(3, 2100);
        sheet.setColumnWidth(4, 5300);
        sheet.setColumnWidth(5, 2600);
        sheet.setColumnWidth(6, 2600);
        sheet.setColumnWidth(7, 2600);
        int index = 4;
        int rowNumber = 1;
        double quantitySum = 0.0;
        for (DocumentDetails dd : list) {
            Document document = Document.getByDocumentID(dd.getDocumentID(), connection, controller);
            Person person = document.getPerson();
            String name = person.getPersonTypeID() == 1 ? person.getFirstName() + " " + person.getLastName() : person.getName();
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue((double)rowNumber++);
            row.createCell(1).setCellValue(dd.getBarcode());
            row.createCell(2).setCellValue(dd.getProductName());
            row.createCell(3).setCellValue(dd.getQuantity());
            row.createCell(4).setCellValue(name);
            row.createCell(5).setCellValue(Utility.formatToDateString(document.getDeliveryDate(), "dd.MM.yyyy"));
            row.createCell(6).setCellValue("");
            row.createCell(7).setCellValue("");
            ++index;
            quantitySum += dd.getQuantity();
        }
        XSSFRow sumQ = sheet.createRow(index + 1);
        sumQ.createCell(2).setCellValue("Ukupna koli\u010dina:" + quantitySum);
        XSSFRow volumeNRow = sheet.createRow(index + 2);
        volumeNRow.createCell(2).setCellValue("Ukupna neto zapremina:");
        XSSFRow volumeBRow = sheet.createRow(index + 3);
        volumeBRow.createCell(2).setCellValue("Ukupna bruto zapremina:");
        XSSFRow deadlineRow = sheet.createRow(index + 4);
        deadlineRow.createCell(2).setCellValue("Planirani rok isporuke:");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(putanja);
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (e.getMessage().contains("used by another process")) {
                controller.alert("Obavestenje", "Izabrani fajl je u upotrebi. Zatvorite fajl i poku\u0161ajte export ponovo.", rootPane.getScene().getWindow());
            }
            return;
        }
    }

    public static void getPregledRacunaToExcel(ScreensController controller, List<Document> documentList, String putanja, BorderPane rootPane) {
        int rowNum = 0;
        boolean sheetNUm = false;
        XSSFWorkbook wb = new XSSFWorkbook();
        Connection connection = controller.getSettings().getConnection();
        XSSFSheet sheet = wb.createSheet("Pregled ra\u010duna");
        sheet.setColumnWidth(0, 3750);
        sheet.setColumnWidth(1, 3750);
        sheet.setColumnWidth(2, 7500);
        sheet.setColumnWidth(3, 3750);
        sheet.setColumnWidth(4, 3750);
        sheet.setColumnWidth(5, 3750);
        for (Document doc : documentList) {
            XSSFRow documentDataRow = sheet.createRow(rowNum++);
            documentDataRow.createCell(0).setCellValue("Datum ra\u010duna:");
            documentDataRow.createCell(1).setCellValue(Utility.formatToDateString(doc.getDate(), "dd.MM.yyyy"));
            documentDataRow.createCell(2).setCellValue("");
            documentDataRow.createCell(3).setCellValue("Broj ra\u010duna:");
            documentDataRow.createCell(4).setCellValue((double)doc.getNumber());
            documentDataRow.createCell(5).setCellValue("");
            Document.makeRowBold(wb, documentDataRow);
            Person person = Person.getById(doc.getPersonID(), controller);
            documentDataRow = sheet.createRow(rowNum++);
            documentDataRow.createCell(0).setCellValue("Komitent");
            if (person != null && person.getPersonTypeID() == 2) {
                documentDataRow.createCell(1).setCellValue(person.getFirstLastName());
            } else {
                documentDataRow.createCell(1).setCellValue(person != null ? person.getName() : "");
            }
            documentDataRow.createCell(2).setCellValue("");
            documentDataRow.createCell(3).setCellValue("Iznos ra\u010duna:");
            documentDataRow.createCell(4).setCellValue(doc.getSumWithDiscount());
            documentDataRow.createCell(5).setCellValue("");
            Document.makeRowBold(wb, documentDataRow);
            documentDataRow = sheet.createRow(rowNum++);
            documentDataRow.createCell(0).setCellValue("Na\u010din pla\u0107anja:");
            documentDataRow.createCell(1).setCellValue(PaymentMethod.getByID(doc.getPaymentMethodID(), connection).getName().substring(0, 7));
            documentDataRow.createCell(2).setCellValue("");
            if (doc.getPaymentMethodID() == 5) {
                documentDataRow.createCell(3).setCellValue("Broj Fakture:");
                long child = DocumentRelationship.getChildID(doc.getDocumentID(), controller);
                documentDataRow.createCell(4).setCellValue((double)Document.getByID(child, connection).getNumber());
            } else {
                documentDataRow.createCell(3).setCellValue("");
                documentDataRow.createCell(4).setCellValue("");
            }
            documentDataRow.createCell(5).setCellValue("");
            Document.makeRowBold(wb, documentDataRow);
            documentDataRow = sheet.createRow(rowNum++);
            ObservableList<DocumentDetails> detalisList = DocumentDetails.getObeservableList(doc.getDocumentID(), connection);
            documentDataRow = sheet.createRow(rowNum++);
            documentDataRow.createCell(0).setCellValue("Stavke:");
            documentDataRow.createCell(1).setCellValue("BarKod");
            documentDataRow.createCell(2).setCellValue("Naziv");
            documentDataRow.createCell(3).setCellValue("Koli\u010dina");
            documentDataRow.createCell(4).setCellValue("Cena");
            documentDataRow.createCell(5).setCellValue("Vrednost");
            Document.makeRowBold(wb, documentDataRow);
            for (DocumentDetails detail : detalisList) {
                Product product = Product.getByID(detail.getProductID(), controller);
                XSSFRow detailsDataRow = sheet.createRow(rowNum++);
                detailsDataRow.createCell(0).setCellValue("");
                detailsDataRow.createCell(1).setCellValue(product.getBarcode());
                detailsDataRow.createCell(2).setCellValue(product.getName());
                detailsDataRow.createCell(3).setCellValue(detail.getQuantity());
                detailsDataRow.createCell(4).setCellValue(detail.getPriceWithDiscount());
                detailsDataRow.createCell(5).setCellValue(detail.getValue());
            }
            documentDataRow = sheet.createRow(rowNum++);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(putanja);
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (e.getMessage().contains("used by another process")) {
                controller.alert("Obavestenje", "Izabrani fajl je u upotrebi. Zatvorite fajl i poku\u0161ajte export ponovo.", rootPane.getScene().getWindow());
            }
            return;
        }
    }

    public static void makeRowBold(XSSFWorkbook wb, XSSFRow row) {
        XSSFCellStyle style = wb.createCellStyle();
        XSSFFont font = wb.createFont();
        font.setBold(true);
        style.setFont((Font)font);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            row.getCell(i).setCellStyle((CellStyle)style);
        }
    }

    public boolean getExciseExists(ScreensController controller) {
        String query = "SELECT \r\nROUND(COALESCE((SELECT ep.Value * e.Value / 1 FROM exciseproduct ep LEFT JOIN excise e ON e.ExciseID = ep.ExciseID WHERE ep.ProductID = p.ProductID),0),2) AS Akciza\r\nFROM documentdetails dd\r\nLEFT JOIN product p ON p.ProductID = dd.ProductID\r\nLEFT JOIN vat v ON v.VatID = p.VatID\r\nLEFT JOIN unit u ON u.UnitID = p.UnitID\r\nWHERE dd.DocumentID = ?\r\nORDER BY dd.DocumentDetailsID";
        boolean postoji = false;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.documentID);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                if (rSet.getDouble("Akciza") == 0.0) continue;
                postoji = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return postoji;
    }

    public void updatePayCardSlipNumber(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`document` SET `PayCardSlipNumber` = NULL WHERE  `DocumentID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.documentID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int getRelationShipType(ScreensController controller) {
        String query = "SELECT dr.RelationshipTypeID from documentrelationship dr WHERE dr.DocumentChildID =?  ";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, this.documentID);
            ResultSet rSet = ps.executeQuery();
            rSet.next();
            return rSet.getInt("RelationshipTypeID");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void updateDocument(LocalDateTime from, LocalDateTime to, WorkDay workDay, Connection connection) {
        String query = "UPDATE document d SET d.WorkDayID = ? WHERE d.Date between ? and ? and PointOfSaleID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, workDay.getWorkDayID());
            ps.setTimestamp(2, Timestamp.valueOf(from));
            ps.setTimestamp(3, Timestamp.valueOf(to));
            ps.setInt(4, workDay.getPointOfSaleID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void updateProfakturaReserved(ScreensController controller) {
        String query = "UPDATE document d SET d.Reservated = 0 WHERE d.DocumentID IN (SELECT dr.DocumentParentID  FROM documentrelationship dr WHERE dr.DocumentChildID =? )";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, this.documentID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteDocumentRelationShipProfaktura(ScreensController controller) throws SQLException {
        this.updateProfakturaReserved(controller);
        String query = " DELETE FROM documentrelationship WHERE DocumentChildID = ? AND relationshipTypeId=7 ";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
        ps.setLong(1, this.documentID);
        ps.executeUpdate();
        ps.close();
    }

    public void delete(ScreensController controller) throws SQLException {
        String query = "delete from document where DocumentID = ?";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
        ps.setLong(1, this.documentID);
        ps.executeUpdate();
        ps.close();
    }

    public static void deleteAll(WorkDay wDay, ScreensController controller) {
        String query = "DELETE d FROM document d WHERE d.Date < ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAllBills(WorkDay wDay, ScreensController controller) {
        String query = "DELETE d FROM document d WHERE d.Date < ? AND d.DocumentTypeID IN (3,4,17)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<Document> getReservationList(boolean realized, ScreensController controller) {
        String query = "SELECT d.* FROM document d WHERE d.DocumentTypeID = 29 AND d.Realized = ?";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setBoolean(1, realized);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                Document d = new Document();
                d.documentID = rs.getLong("DocumentID");
                d.documentTypeID = rs.getInt("DocumentTypeID");
                d.documentStatusID = rs.getInt("DocumentStatusID");
                d.pointOfSaleID = rs.getInt("PointOfSaleID");
                d.number = rs.getInt("Number");
                d.year = rs.getInt("Year");
                d.fullNumber = rs.getString("FullNumber");
                d.alternativeFullNumber = rs.getString("AlternativeFullNumber");
                d.date = new java.util.Date(rs.getTimestamp("Date").getTime());
                try {
                    d.deliveryDate = new java.util.Date(rs.getTimestamp("DeliveryDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.currencyDate = new java.util.Date(rs.getTimestamp("CurrencyDate").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateFrom = new java.util.Date(rs.getDate("DateFrom").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    d.dateTo = new java.util.Date(rs.getDate("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.note = rs.getString("Note");
                d.place = rs.getString("Place");
                d.personID = rs.getLong("PersonID");
                d.cashBuyersID = rs.getLong("CashBuyersID");
                d.warehouseID = rs.getInt("WarehouseID");
                d.paymentMethodID = rs.getInt("PaymentMethodID");
                d.loyalityID = rs.getLong("LoyalityID");
                d.sum = rs.getDouble("Sum");
                d.sumWithDiscount = rs.getDouble("SumWithDiscount");
                d.paid = rs.getDouble("Paid");
                d.externalNumber = rs.getString("ExternalNumber");
                d.fromCashBox = rs.getBoolean("FromCashBox");
                d.workDayID = rs.getLong("WorkDayID");
                d.sysDTCreated = new java.util.Date(rs.getTimestamp("sysDTCreated").getTime());
                try {
                    d.sysDTEdit = new java.util.Date(rs.getTimestamp("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.sysUserAddID = rs.getLong("sysUserAddID");
                d.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    d.departmentID = rs.getInt("DepartmentID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                d.dependentExpenses = rs.getDouble("DependentExpenses");
                d.discount = rs.getDouble("Discount");
                d.realized = rs.getBoolean("Realized");
                d.reservated = rs.getBoolean("Reservated");
                d.person = Person.getById(d.personID, controller);
                list.add((java.lang.Object)d);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static double getSumBillForPeriodByLoyaltyID(Loyality l, ScreensController controller) {
        double suma = 0.0;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT SUM(d.SumWithDiscount)  AS SUMA FROM document d WHERE d.PersonID IN (SELECT l.PersonID FROM loyality l WHERE l.LoyalityID = ?)  AND d.Date BETWEEN DATE_SUB(NOW(), INTERVAL " + (l.getPeriodDays().startsWith("DAY") ? l.getPeriodDays().substring(3) : " 1") + " " + (l.getPeriodDays().startsWith("DAY") ? "DAY" : l.getPeriodDays()) + ") AND NOW() AND d.DocumentTypeID = 3");
            pStatement.setLong(1, l.getLoyalityID());
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            suma = Settings.round(rSet.getDouble("SUMA"), 2);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return suma;
    }

    public static double getActiveReservationsSumForPeriod(Loyality l, ScreensController controller) {
        String lastingPeriod;
        String periodType;
        String period = l.getPeriodDays();
        if (period.startsWith("DAY")) {
            periodType = "DAY";
            lastingPeriod = period.substring(3);
        } else {
            periodType = period;
            lastingPeriod = "1";
        }
        String query = "SELECT coalesce(sum(dd.Quantity * dd.PriceWithDiscount),0) AS VALUE ,NOW() ,  DATE_SUB(NOW() ,INTERVAL 1 YEAR) FROM document d JOIN documentdetails dd ON d.DocumentID = dd.DocumentID WHERE d.PersonID IN (SELECT l.PersonID FROM loyality l WHERE l.LoyalityID = ?) AND d.DocumentTypeID = 29 AND d.Realized = 0 AND dd.Closed = 0 AND d.Date BETWEEN  DATE_SUB(NOW() ,INTERVAL " + lastingPeriod + " " + periodType + ") AND NOW()";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, l.getLoyalityID());
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getDouble("value");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static String getLastFullNumberByBill(ScreensController controller, Document document) {
        String query = "SELECT IF(d.FullNumber <> '', (CAST(d.FullNumber AS UNSIGNED) + 1), '') AS FullNumber FROM document d WHERE d.PointOfSaleID = ? AND d.FullNumber <> '' AND d.DocumentTypeID = 3 ORDER BY d.DocumentID DESC LIMIT 1";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, document.getPointOfSaleID());
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            return rSet.getString("FullNumber");
        }
        catch (SQLException e) {
            return "";
        }
    }

    public static int getMaxFullNumber(ScreensController controller, Document d) {
        String query = "SELECT * FROM document d WHERE d.DocumentTypeID=3 AND d.PointOfSaleID=? order BY d.DocumentID DESC LIMIT 2";
        try {
            PreparedStatement pstatement = controller.getSettings().getConnection().prepareStatement(query);
            pstatement.setInt(1, d.getPointOfSaleID());
            ResultSet rSet = pstatement.executeQuery();
            System.out.println(rSet);
            rSet.next();
            rSet.next();
            if (rSet.getString("FullNumber") == null || rSet.getString("FullNumber").equals("")) {
                return 0;
            }
            return Integer.parseInt(rSet.getString("FullNumber"));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean docHaveCombinedPayment(ScreensController controller, java.util.Date from, java.util.Date to) {
        String query = "SELECT COUNT( d.PaymentMethodID) AS paymentMethod FROM document d \r\nWHERE d.DocumentTypeID = 3\r\nAND d.WorkDayID BETWEEN \r\n(SELECT COALESCE(\r\n\t(SELECT wd.WorkDayID FROM workday wd WHERE wd.Date =?),\r\n\t(SELECT wd1.WorkdayId FROM workday wd1 order BY wd1.WorkDayID LIMIT 1)) AS idfrom)\r\nAND \r\n(SELECT COALESCE(\r\n\t(SELECT wd.WorkDayID FROM workday wd WHERE wd.Date = ?),\r\n\t(SELECT wd1.WorkdayId FROM workday wd1 order BY wd1.WorkDayID DESC LIMIT 1)) AS idTo)\r\nAND\r\nd.PaymentMethodID = 6";
        try {
            PreparedStatement pstatement = controller.getSettings().getConnection().prepareStatement(query);
            pstatement.setDate(1, new Date(from.getTime()));
            pstatement.setDate(2, new Date(to.getTime()));
            ResultSet rSet = pstatement.executeQuery();
            rSet.next();
            return rSet.getInt("paymentMethod") > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ObservableList<Document> getCanceledDocuments(ScreensController controller, java.util.Date from, java.util.Date to) {
        Connection connection = controller.getSettings().getConnection();
        Date dateFrom = new Date(from.getTime());
        Date dateTo = new Date(to.getTime());
        ObservableList canceledDocuments = FXCollections.observableArrayList();
        String parameters = "SET @dateFrom = ?,  @dateTo = ?";
        String query = "SELECT d.DocumentID, d.Number,d.Date, d.PersonID, d.FullNumber, d.PaymentMethodID, d.SumWithDiscount FROM document d WHERE\r\nd.DocumentTypeID = 3 and d.DocumentStatusID = 3\r\nand d.WorkDayID BETWEEN\r\n(SELECT COALESCE (\r\n(SELECT wd.WorkDayID FROM workday wd WHERE wd.Date = @dateFrom),\r\n (SELECT wd.WorkDayID FROM workday wd WHERE wd.Date < @dateFrom order BY wd.WorkDayID DESC LIMIT 1))\r\n) AND\r\n(SELECT COALESCE (\r\n(SELECT wd.WorkDayID FROM workday wd WHERE wd.Date = @dateTo),\r\n (SELECT wd.WorkDayID FROM workday wd WHERE wd.Date < @dateTo order BY wd.WorkDayID DESC LIMIT 1)))";
        try {
            PreparedStatement ps = connection.prepareStatement(parameters);
            ps.setDate(1, dateFrom);
            ps.setDate(2, dateTo);
            System.out.println(ps);
            ps.execute();
            ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Document canceledDocument = new Document();
                canceledDocument.setDocumentID(rs.getLong("DocumentId"));
                canceledDocument.setNumber(rs.getInt("Number"));
                canceledDocument.setDate(rs.getTimestamp("Date"));
                canceledDocument.setPerson(Person.getById(rs.getLong("PersonId"), controller));
                canceledDocument.setPersonID(rs.getLong("PersonId"));
                canceledDocument.setBi(rs.getString("FullNumber"));
                canceledDocument.setPaymentMethodID(rs.getInt("PaymentMethodId"));
                canceledDocument.setPaymentMethodName(PaymentMethod.getByID(rs.getInt("PaymentMethodId"), connection).getName());
                canceledDocument.setSumWithDiscount(rs.getDouble("SumWithDiscount"));
                canceledDocuments.add((java.lang.Object)canceledDocument);
            }
            return canceledDocuments;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void cancelDocument(ScreensController controller, long documentId) {
        Connection connection = controller.getSettings().getConnection();
        String queryString = "UPDATE document d SET d.DocumentStatusID = 1 WHERE d.DocumentID =?";
        try {
            PreparedStatement ps = connection.prepareStatement(queryString);
            ps.setLong(1, documentId);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static String limitNoteOnSpecificNumberOfChar(String note, int limit) {
        if (note != null) {
            return note.length() > limit ? note.substring(0, limit) : note;
        }
        return "";
    }
}

