/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Prijemnica;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductCategory;
import rs.petcom.master.fical.FiscalPrinter;
import rs.petcom.renameconnection.ChangeConnection;

public class WorkDay {
    private long WorkDayID;
    private int PointOfSaleID;
    private java.util.Date date;
    private java.util.Date DateFrom;
    private boolean closingInProgress;
    private java.util.Date DateTo;
    private long sysUserAddID;
    private long sysUserEditID;
    private LocalDateTime fromTo;
    private LocalDateTime toTime;

    public LocalDateTime getToTime() {
        return this.toTime;
    }

    public void setToTime(LocalDateTime toTime) {
        this.toTime = toTime;
    }

    public static void deleteByDate(LocalDate from, LocalDate to, Connection connection, ScreensController controller) {
        String insertSql = "INSERT INTO workday (PointOfSaleID, `Date`, DateFrom, DateTo, ClosingInProgress, sysUserAddID, sysUserEditID) VALUES(?, ?, ?, ?, b'0', ?, ?)";
        String query = "delete from workday   where  Date between  ? and ?";
        String sqlQuery = "select * from workday order by WorkDayID  desc limit 1";
        ArrayList<WorkDay> workDayList = new ArrayList<WorkDay>();
        PreparedStatement pStatement = null;
        try {
            ChangeConnection.getConnectionAdmin(controller);
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setDate(1, Date.valueOf(from));
            pStatement.setDate(2, Date.valueOf(to));
            pStatement.executeUpdate();
            ChangeConnection.getConnectionUser(controller);
            long day = WorkDay.daysBetweenInclusive(from, to);
            for (long i = 0L; i <= day; ++i) {
                LocalDateTime fromTime = LocalDateTime.of(from, LocalTime.of(0, 0, 0)).plusDays(i);
                LocalDateTime toTime = LocalDateTime.of(from, LocalTime.of(23, 59, 59)).plusDays(i);
                LocalDate newDate = from.plusDays(i);
                String sql = "select  d.PointOfSaleID, d.WorkDayID  from document  d  where d.`Date` between '" + fromTime + "' and '" + toTime + "' group by d.PointOfSaleID";
                pStatement = controller.getSettings().getConnection().prepareStatement(sql);
                ResultSet resultSet1 = pStatement.executeQuery();
                while (resultSet1.next()) {
                    pStatement = controller.getSettings().getConnection().prepareStatement(insertSql);
                    long point = 1L;
                    if (resultSet1.getLong("PointOfSaleID") == 0L) {
                        System.out.println("Ovo je nula");
                        continue;
                    }
                    if (resultSet1.getLong("PointOfSaleID") != 0L) {
                        point = resultSet1.getLong("PointOfSaleID");
                    }
                    pStatement.setLong(1, point);
                    pStatement.setDate(2, Date.valueOf(newDate));
                    pStatement.setTimestamp(3, Timestamp.valueOf(fromTime));
                    if (LocalDate.now().isEqual(fromTime.toLocalDate())) {
                        pStatement.setTimestamp(4, null);
                    } else {
                        pStatement.setTimestamp(4, Timestamp.valueOf(toTime));
                    }
                    pStatement.setLong(5, controller.getUser().getUserID());
                    pStatement.setLong(6, controller.getUser().getUserID());
                    pStatement.executeUpdate();
                    pStatement = connection.prepareStatement(sqlQuery);
                    ResultSet resultSet = pStatement.executeQuery();
                    if (!resultSet.first()) continue;
                    WorkDay workDay = new WorkDay();
                    workDay.setWorkDayID(resultSet.getLong("WorkDayID"));
                    workDay.setDate(resultSet.getDate("Date"));
                    workDay.setFromTo(fromTime);
                    workDay.setPointOfSaleID(resultSet.getInt("PointOfSaleID"));
                    workDay.setToTIme(toTime);
                    workDayList.add(workDay);
                }
            }
            for (WorkDay workDay : workDayList) {
                Document.updateDocument(workDay.getFromTo(), workDay.getToTime(), workDay, controller.getSettings().getConnection());
            }
            pStatement.close();
        }
        catch (SQLException e) {
            ChangeConnection.getConnectionUser(controller);
            e.printStackTrace();
        }
    }

    private void setToTIme(LocalDateTime toTime) {
        this.toTime = toTime;
    }

    public LocalDateTime getFromTo() {
        return this.fromTo;
    }

    public void setFromTo(LocalDateTime fromTo) {
        this.fromTo = fromTo;
    }

    public static long daysBetweenInclusive(LocalDate ld1, LocalDate ld2) {
        return Math.abs(ChronoUnit.DAYS.between(ld1, ld2)) + 1L;
    }

    private static long toEpochMilli(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public long getWorkDayID() {
        return this.WorkDayID;
    }

    public void setWorkDayID(long workDayID) {
        this.WorkDayID = workDayID;
    }

    public int getPointOfSaleID() {
        return this.PointOfSaleID;
    }

    public void setPointOfSaleID(int pointOfSaleID) {
        this.PointOfSaleID = pointOfSaleID;
    }

    public java.util.Date getDate() {
        return this.date;
    }

    public void setDate(java.util.Date date) {
        this.date = date;
    }

    public java.util.Date getDateFrom() {
        return this.DateFrom;
    }

    public void setDateFrom(java.util.Date dateFrom) {
        this.DateFrom = dateFrom;
    }

    public java.util.Date getDateTo() {
        return this.DateTo;
    }

    public void setDateTo(java.util.Date dateTo) {
        this.DateTo = dateTo;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public boolean isClosingInProgress() {
        return this.closingInProgress;
    }

    public void setClosingInProgress(boolean closingInProgress) {
        this.closingInProgress = closingInProgress;
    }

    public static boolean isActive(long workDayID, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement(" select wd.DateTo  from workday wd  where wd.WorkDayID=?");
            ps.setLong(1, workDayID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            WorkDay wd = new WorkDay();
            wd.DateTo = rs.getDate("DateTo");
            if (wd.DateTo == null) {
                return true;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static ObservableList<WorkDay> getWorkDays(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT * FROm workday wd");
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e) {
                    wd.DateTo = null;
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                list.add((Object)wd);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static WorkDay getFromDb(PointOfSale pos, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from workday   where PointOfSaleID = ? order by DateFrom desc  limit 1");
            ps.setInt(1, pos.getPointOfSaleID());
            ResultSet rs = ps.executeQuery();
            rs.next();
            WorkDay wd = new WorkDay();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            rs.close();
            ps.close();
            return wd;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static WorkDay getFromDbZatvorenDan(PointOfSale pos, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from workday   where PointOfSaleID = ? and DateFrom IS NOT NULL order by DateFrom desc limit 1");
            ps.setInt(1, pos.getPointOfSaleID());
            ResultSet rs = ps.executeQuery();
            rs.next();
            WorkDay wd = new WorkDay();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            rs.close();
            ps.close();
            return wd;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static WorkDay getFromDb(long workdayId, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from workday   where WorkDayID = ?");
            ps.setLong(1, workdayId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            WorkDay wd = new WorkDay();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            rs.close();
            ps.close();
            return wd;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static WorkDay getFromDbByDate(LocalDate date, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from workday   where Date = DATE(?) and PointOfSaleID = ? ORDER BY WorkDayID DESC LIMIT 1");
            ps.setDate(1, Date.valueOf(date));
            ps.setInt(2, Integer.parseInt(Settings.getPosCode()));
            ResultSet rs = ps.executeQuery();
            rs.next();
            WorkDay wd = new WorkDay();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            rs.close();
            ps.close();
            return wd;
        }
        catch (SQLException e) {
            String queryString = "select *  from workday  where DATE > DATE(?)  and PointOfSaleID = ?  ORDER BY WorkDayID  LIMIT 1";
            try {
                PreparedStatement ps = connection.prepareStatement(queryString);
                ps.setDate(1, Date.valueOf(date));
                ps.setInt(2, Integer.parseInt(Settings.getPosCode()));
                ResultSet rs = ps.executeQuery();
                rs.next();
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e1) {
                    wd.DateTo = null;
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                rs.close();
                ps.close();
                return wd;
            }
            catch (SQLException e3) {
                e3.printStackTrace();
                return null;
            }
        }
    }

    public static WorkDay getDateToByDate(LocalDate date, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from workday   where Date = DATE(?) ORDER BY WorkDayID DESC LIMIT 1");
            ps.setDate(1, Date.valueOf(date));
            ResultSet rs = ps.executeQuery();
            rs.next();
            WorkDay wd = new WorkDay();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            rs.close();
            ps.close();
            return wd;
        }
        catch (SQLException e) {
            String queryString = "select *  from workday  where DATE < DATE(?) ORDER BY WorkDayID desc LIMIT 1";
            try {
                PreparedStatement ps = connection.prepareStatement(queryString);
                ps.setDate(1, Date.valueOf(date));
                ResultSet rs = ps.executeQuery();
                rs.next();
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e1) {
                    wd.DateTo = null;
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                rs.close();
                ps.close();
                return wd;
            }
            catch (SQLException e3) {
                e3.printStackTrace();
                return null;
            }
        }
    }

    public WorkDay getPrevious(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from workday   where PointOfSaleID = ?    and Date < ? order by DateFrom desc  limit 1");
            ps.setInt(1, this.PointOfSaleID);
            ps.setDate(2, new Date(this.date.getTime()));
            ResultSet rs = ps.executeQuery();
            rs.next();
            WorkDay wd = new WorkDay();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            rs.close();
            ps.close();
            return wd;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static void openWorkDay(int posId, long userId, Connection connection) {
        PointOfSale pos = new PointOfSale();
        pos.setPointOfSaleID(posId);
        WorkDay wd = WorkDay.getFromDb(pos, connection);
        PreparedStatement ps = null;
        try {
            String query = "update workday    set DateTo = now()  where DateTo is null    and PointOfSaleId = ?";
            ps = connection.prepareStatement(query);
            ps.setInt(1, posId);
            ps.executeUpdate();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            ps = connection.prepareStatement("insert into workday(PointOfSaleId,Date,DateFrom,sysUserAddID)  values(?, '" + (wd != null ? (sdf.parse(sdf.format(wd.getDate())).before(sdf.parse(sdf.format(new java.util.Date()))) ? sdf.format(new java.util.Date()) : WorkDay.addOneDay(sdf.format(new java.util.Date()))) : sdf.format(new java.util.Date())) + "',now(),?)");
            try {
                System.out.println("User id je " + userId);
                ps.setInt(1, posId);
                ps.setLong(2, userId);
            }
            catch (Exception e) {
                ps.setLong(2, 1L);
            }
            System.out.println(ps);
            ps.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String addOneDay(String date) {
        return LocalDate.parse(date).plusDays(1L).toString();
    }

    public static void openWorkDayAutomaticly(int posId, long userId, Connection connection) {
        PointOfSale pos = new PointOfSale();
        pos.setPointOfSaleID(posId);
        WorkDay wd = WorkDay.getFromDb(pos, connection);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (wd != null && sdf.format(wd.getDate()).equals(sdf.format(new java.util.Date()))) {
            try {
                wd.reopen(userId, posId, connection);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                String query = "update workday    set DateTo = now()  where DateTo is null    and PointOfSaleId = ?";
                PreparedStatement ps = connection.prepareStatement(query);
                ps.setInt(1, posId);
                ps.executeUpdate();
                ps = connection.prepareStatement("insert into workday(PointOfSaleId,Date,DateFrom,sysUserAddID)  values(?,now(),now(),?)");
                ps.setInt(1, posId);
                ps.setLong(2, userId);
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void closeWorkDay(User user, PointOfSale pos, Connection connection) throws SQLException {
        this.DateTo = Settings.DatefromLocalDateTime(LocalDateTime.now());
        PreparedStatement ps = connection.prepareStatement(" update workday set DateTo = now(), sysUserEditID = ?   where PointOfSaleId = ? and DateTo is null ");
        try {
            if (user != null) {
                ps.setLong(1, user.getUserID());
            } else {
                ps.setLong(1, 1L);
            }
        }
        catch (Exception e) {
            ps.setLong(1, 1L);
        }
        ps.setInt(2, this.PointOfSaleID);
        ps.executeUpdate();
        ps.close();
        if (user != null) {
            Log.writeLog(user, "PointOfSaleID: " + pos.getPointOfSaleID() + " - Zatvaranje dana", connection);
        }
    }

    public void reopen(long userId, int posId, Connection connection) throws SQLException {
        PreparedStatement ps = connection.prepareStatement("update workday set DateTo = null, sysUserEditID = ?   where PointOfSaleId = ?    and WorkDayID = ?");
        ps.setLong(1, userId);
        ps.setInt(2, posId);
        ps.setLong(3, this.WorkDayID);
        ps.executeUpdate();
        ps.close();
    }

    public static Timestamp start(LocalDate date, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select min(DateFrom) from workday where Date = ?");
            ps.setDate(1, Date.valueOf(date));
            ResultSet rs = ps.executeQuery();
            int rowCount = 0;
            while (rs.next()) {
                if (rs.getTimestamp(1) == null) continue;
                ++rowCount;
                return rs.getTimestamp(1);
            }
            if (rowCount == 0) {
                ps = connection.prepareStatement("select min(DateFrom) from workday where Date > ?");
                ps.setDate(1, Date.valueOf(date));
                rs = ps.executeQuery();
                rs.next();
                return rs.getTimestamp(1);
            }
            rs.close();
            ps.close();
            return null;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static WorkDay getByDate(Connection connection) {
        WorkDay wd = new WorkDay();
        try {
            PreparedStatement ps = connection.prepareStatement("select * from workday where Date = DATE(now()) limit 1");
            ResultSet rs = ps.executeQuery();
            rs.next();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return wd;
    }

    public static WorkDay getByDateMax(Connection connection) {
        WorkDay wd = new WorkDay();
        try {
            PreparedStatement ps = connection.prepareStatement("select max(w.WorkDayID) as WorkDayID from workday w ");
            ResultSet rs = ps.executeQuery();
            rs.next();
            wd.WorkDayID = rs.getLong("WorkDayID");
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return wd;
    }

    public static WorkDay getFistWarkDayEver(Connection connection) {
        WorkDay wd = new WorkDay();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT *, MIN(w.DateFrom) AS FirstDate FROM workday w");
            ResultSet rs = ps.executeQuery();
            rs.next();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("FirstDate").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return wd;
    }

    public static Timestamp end(LocalDate date, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select max(coalesce(DateTo,now())) from workday where Date = ?");
            ps.setDate(1, Date.valueOf(date));
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getTimestamp(1);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static java.util.Date getFirstStart(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select min(DateFrom) from workday");
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getTimestamp(1);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static LocalDateTime getFirstStart(int departmentId, LocalDate date, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select workday_start(?, ?)");
            ps.setInt(1, departmentId);
            ps.setDate(2, new Date(Settings.fromLocalDate(date).getTime()));
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getTimestamp(1).toLocalDateTime();
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static LocalDateTime getDateFromForDep(LocalDateTime wdDate, int departmentId, Connection connection) {
        LocalDateTime dateFrom = null;
        String query = "SELECT `workday_start_v5`(?, ?) as DateFrom";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, departmentId);
            ps.setDate(2, new Date(Settings.DatefromLocalDateTime(wdDate).getTime()));
            ResultSet rs = ps.executeQuery();
            rs.next();
            dateFrom = rs.getTimestamp("DateFrom").toLocalDateTime();
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dateFrom;
    }

    public static WorkDay getDateFromForDep(LocalDate wdDate, int departmentId, Connection connection) {
        WorkDay workDay = null;
        String query = "SELECT `workday_start_v5`(?, ?) as DateFrom";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, departmentId);
            ps.setDate(2, new Date(Settings.fromLocalDate(wdDate).getTime()));
            ResultSet rs = ps.executeQuery();
            rs.next();
            workDay = WorkDay.getFromDbByDate(Settings.fromDate(rs.getTimestamp("DateFrom")), connection);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return workDay;
    }

    public static LocalDateTime getDateToForDep(LocalDate wdDate, int departmentId, Connection connection) throws SQLException {
        LocalDateTime dateFrom = LocalDateTime.now();
        String query = "SELECT `workday_end_v4`(?, ?) as DateTo";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setInt(1, departmentId);
        ps.setDate(2, new Date(Settings.fromLocalDate(wdDate).getTime()));
        ResultSet rs = ps.executeQuery();
        rs.next();
        dateFrom = rs.getTimestamp("DateTo").toLocalDateTime();
        rs.close();
        ps.close();
        return dateFrom;
    }

    public static LocalDateTime getDateToForDep1(LocalDate wdDate, int departmentId, Connection connection) throws SQLException {
        LocalDateTime dateFrom = LocalDateTime.now();
        String query = "SELECT `workday_end`(?, ?) as DateTo";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setInt(1, departmentId);
        ps.setDate(2, new Date(Settings.fromLocalDate(wdDate).getTime()));
        ResultSet rs = ps.executeQuery();
        rs.next();
        dateFrom = rs.getTimestamp("DateTo").toLocalDateTime();
        rs.close();
        ps.close();
        return dateFrom;
    }

    public static LocalDateTime getKrajaDanaZaDatum(java.util.Date wdDate, int departmentId, ScreensController controller) {
        LocalDateTime dateFrom = LocalDateTime.now();
        String query = "SELECT `workday_end_v4`(?, ?) as DateTo";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, departmentId);
            ps.setDate(2, new Date(wdDate.getTime()));
            ResultSet rs = ps.executeQuery();
            System.out.println(ps);
            rs.next();
            dateFrom = rs.getTimestamp("DateTo").toLocalDateTime();
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dateFrom;
    }

    public static LocalDateTime getPocetakDanaZaDatum(java.util.Date wdDate, int departmentId, ScreensController controller) {
        LocalDateTime dateFrom = LocalDateTime.now();
        String query = "SELECT `workday_start_v5`(?, ?) as DateFrom";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, departmentId);
            ps.setDate(2, new Date(wdDate.getTime()));
            ResultSet rs = ps.executeQuery();
            rs.next();
            dateFrom = rs.getTimestamp("DateFrom").toLocalDateTime();
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dateFrom;
    }

    public static LocalDateTime datumPocetnogStanja(int departmentId, java.util.Date datum, Connection connection) {
        LocalDateTime dateFrom = null;
        String query = "SELECT `poslednji_popis_department_pre_datuma_v5`(?, ?) as DateTo";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, departmentId);
            ps.setDate(2, new Date(datum.getTime()));
            ResultSet rs = ps.executeQuery();
            rs.next();
            dateFrom = rs.getTimestamp("DateTo").toLocalDateTime();
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dateFrom;
    }

    public static WorkDay getLastStartForDep(int posId, Connection connection) {
        block6: {
            String query = "select min(w.DateFrom), w.* from workday w where w.Date in (select max(wd.Date) \t\t\t\tfrom workday wd \t\t\t\twhere wd.PointOfSaleID = ? )";
            try {
                PreparedStatement ps = connection.prepareStatement(query);
                ps.setInt(1, posId);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) break block6;
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e) {
                    wd.DateTo = null;
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                rs.close();
                ps.close();
                return wd;
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    public static WorkDay getStartForDepByDate(int departmentId, java.util.Date date, Connection connection) {
        block6: {
            String query = "select wd.* from workday wd join pointofsaledepartment posd on posd.PointOfSaleID = wd.PointOfSaleID and posd.DepartmentID = ? where wd.Date = ?  order by wd.DateFrom asc limit 1";
            try {
                PreparedStatement ps = connection.prepareStatement(query);
                ps.setInt(1, departmentId);
                ps.setDate(2, new Date(date.getTime()));
                System.out.println(ps);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) break block6;
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e) {
                    wd.DateTo = new java.util.Date();
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                rs.close();
                ps.close();
                return wd;
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    public ArrayList<Long> getWdRecapDocumentID(int documentType, Connection connection) {
        ArrayList<Long> list = new ArrayList<Long>();
        String query = "select d.DocumentID from document d  inner join workday w on w.WorkDayID = d.WorkDayID\t\t\t\t\tand w.Date = ? and w.PointOfSaleID = ? where d.DocumentTypeID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new Date(this.date.getTime()));
            ps.setInt(2, this.PointOfSaleID);
            ps.setInt(3, documentType);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getLong("DocumentID"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void saveRecap(ScreensController controller) throws SQLException {
        ArrayList<DocumentDetails> list = DocumentDetails.getSoldItems(this, controller);
        Document d = new Document();
        if (this.getDateTo() != null) {
            d.setDate(this.getDateTo());
        } else {
            d.setDate(new java.util.Date());
        }
        d.setWorkDayID(this.WorkDayID);
        d.setDocumentTypeID(17);
        d.setYear(Integer.parseInt(new SimpleDateFormat("yyyy").format(this.date)));
        d.setNumber(Document.getNextNumber(17, this.getPointOfSaleID(), controller));
        d.setSysUserAddID(controller.getUser().getUserID());
        d.setDocumentStatusID(1);
        d.setPointOfSaleID(this.getPointOfSaleID());
        long documentId = d.insertSaveRecap(controller.getSettings().getConnection());
        for (DocumentDetails dd : list) {
            if (!ProductCategory.getByID(controller, Product.getByID(dd.getProductID(), controller).getProductCategoryID()).isUtrosciPrikaz()) continue;
            dd.setDocumentID(documentId);
            dd.insert(controller.getSettings().getConnection());
        }
    }

    public ArrayList<Long> getWdDepNivelationDocID(int documentType, Connection connection) {
        ArrayList<Long> list = new ArrayList<Long>();
        String query = "select d.DocumentID from document d join workday wd on wd.WorkDayID = d.WorkDayID \t\t\t\tand wd.Date = ? join pointofsaledepartment posd on posd.PointOfSaleID = wd.PointOfSaleID\t\t\t\t\t\t\t\t\tand posd.DepartmentID = ? where d.DocumentTypeID = 15";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new Date(this.date.getTime()));
            ps.setLong(2, PointOfSale.getDepartmentIdById(this.PointOfSaleID, connection));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getLong("DocumentID"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void createNewNivelationBetweenPriceList(ScreensController controller) throws SQLException {
        int departmentID = PointOfSale.getDepartmentIdById(this.getPointOfSaleID(), controller.getSettings().getConnection());
        WorkDay startForDep = WorkDay.getStartForDepByDate(departmentID, this.date, controller.getSettings().getConnection());
        Document nivelacijaDoc = new Document();
        nivelacijaDoc.setDate(this.DateFrom);
        nivelacijaDoc.setWorkDayID(this.getWorkDayID());
        nivelacijaDoc.setDocumentTypeID(15);
        nivelacijaDoc.setYear(Integer.parseInt(new SimpleDateFormat("yyyy").format(new java.util.Date())));
        nivelacijaDoc.setNumber(Document.getNextNumberNivelacija(15, controller));
        nivelacijaDoc.setNote("Promena izmedju cenovnika");
        nivelacijaDoc.setSysUserAddID(controller.getUser().getUserID());
        nivelacijaDoc.setDocumentStatusID(1);
        nivelacijaDoc.setPointOfSaleID(this.getPointOfSaleID());
        nivelacijaDoc.setDepartmentID(departmentID);
        LocalDateTime from = Settings.LocalDateTimefromDate(startForDep.getDateFrom());
        ArrayList<PriceListDetailes> listChangedPrice = PriceListDetailes.getChangedPriceBetweenPriceList(departmentID, from, Settings.LocalDateTimefromDate(this.getDateTo()), controller.getSettings().getConnection());
        long documentId = 0L;
        if (!listChangedPrice.isEmpty()) {
            documentId = nivelacijaDoc.insertWithModifiedDate(controller.getSettings().getConnection());
        }
        for (PriceListDetailes pld : listChangedPrice) {
            Product p = Product.getByID(pld.getProductID(), controller);
            DocumentDetails dd = new DocumentDetails();
            dd.setDocumentID(documentId);
            dd.setProductID(pld.getProductID());
            if (pld.getPriceListDetailsID() == -1L) {
                dd.setQuantity(pld.getQuantity());
            } else {
                double qty;
                double oldQty = Product.getNewCurrentStock(controller, WorkDay.datumPocetnogStanja(departmentID, pld.getDate(), controller.getSettings().getConnection()), WorkDay.getDateToForDep(Settings.fromDate(pld.getDate()), departmentID, controller.getSettings().getConnection()), pld.getProductID(), Prijemnica.getIdForInvoice(controller, pld.getProductID(), from));
                if (oldQty - (qty = this.differnetPriceForNivelationFromInvoice(controller, departmentID, from, pld.getDate(), pld.getPrice(), pld.getProductID())) > 0.0) {
                    dd.setQuantity(oldQty - qty);
                } else {
                    dd.setQuantity(0.0);
                }
            }
            dd.setPrice(Product.getCurrentPrice(pld.getProductID(), departmentID, false, controller.getSettings().getConnection()));
            dd.setNewPrice(pld.getPrice());
            dd.setSysUserAddID(controller.getUser().getUserID());
            dd.setUnitID(p.getUnitID());
            dd.setVatID(p.getVatID());
            dd.insert(controller.getSettings().getConnection());
            if (pld.isNivelation()) continue;
            pld.updateNivelation(controller.getSettings().getConnection());
        }
    }

    public void createNivelationAfterNewPrice(ScreensController controller, ObservableList<PriceListDetailes> listChangedPrice) throws SQLException {
        int departmentID = PointOfSale.getDepartmentIdById(this.getPointOfSaleID(), controller.getSettings().getConnection());
        WorkDay startForDep = WorkDay.getStartForDepByDate(departmentID, this.date, controller.getSettings().getConnection());
        Document nivelacijaDoc = new Document();
        nivelacijaDoc.setDate(this.DateFrom);
        nivelacijaDoc.setWorkDayID(this.getWorkDayID());
        nivelacijaDoc.setDocumentTypeID(15);
        nivelacijaDoc.setYear(Integer.parseInt(new SimpleDateFormat("yyyy").format(new java.util.Date())));
        nivelacijaDoc.setNumber(Document.getNextNumberNivelacija(15, controller));
        nivelacijaDoc.setNote("Po promeni cene");
        nivelacijaDoc.setSysUserAddID(controller.getUser().getUserID());
        nivelacijaDoc.setDocumentStatusID(1);
        nivelacijaDoc.setPointOfSaleID(this.getPointOfSaleID());
        nivelacijaDoc.setDepartmentID(departmentID);
        LocalDateTime from = Settings.LocalDateTimefromDate(startForDep.getDateFrom());
        long documentId = 0L;
        if (!listChangedPrice.isEmpty()) {
            documentId = nivelacijaDoc.insertWithModifiedDate(controller.getSettings().getConnection());
        }
        for (PriceListDetailes pld : listChangedPrice) {
            Product p = Product.getByID(pld.getProductID(), controller);
            DocumentDetails dd = new DocumentDetails();
            dd.setDocumentID(documentId);
            dd.setProductID(pld.getProductID());
            if (pld.getPriceListDetailsID() == -1L) {
                dd.setQuantity(pld.getQuantity());
            } else {
                double qty = this.differnetPriceForNivelationFromInvoice(controller, departmentID, from, pld.getDate(), pld.getPrice(), pld.getProductID());
                System.out.println("Stanje koje se nivelise " + qty);
                if (qty > 0.0) {
                    dd.setQuantity(qty);
                } else {
                    dd.setQuantity(0.0);
                }
            }
            dd.setPrice(Product.getCurrentPrice(pld.getProductID(), departmentID, false, controller.getSettings().getConnection()));
            dd.setNewPrice(pld.getPrice());
            dd.setSysUserAddID(controller.getUser().getUserID());
            dd.setUnitID(p.getUnitID());
            dd.setVatID(p.getVatID());
            dd.insert(controller.getSettings().getConnection());
        }
    }

    public boolean createNivelation(ScreensController controller) throws SQLException {
        boolean uradjena = false;
        int departmentID = PointOfSale.getDepartmentIdById(this.getPointOfSaleID(), controller.getSettings().getConnection());
        Document nivelacijaDoc = new Document();
        nivelacijaDoc.setDate(this.DateFrom);
        nivelacijaDoc.setWorkDayID(this.getWorkDayID());
        nivelacijaDoc.setDocumentTypeID(15);
        nivelacijaDoc.setDepartmentID(departmentID);
        nivelacijaDoc.setYear(Integer.parseInt(new SimpleDateFormat("yyyy").format(this.DateFrom)));
        nivelacijaDoc.setNumber(Document.getNextNumber(15, Department.getById(nivelacijaDoc.getDepartmentID(), controller.getSettings().getConnection()), controller, Settings.fromDate(this.DateFrom)));
        nivelacijaDoc.setNote("Po aktivnom cenovniku");
        nivelacijaDoc.setSysUserAddID(controller.getUser().getUserID());
        nivelacijaDoc.setDocumentStatusID(1);
        nivelacijaDoc.setPointOfSaleID(this.getPointOfSaleID());
        nivelacijaDoc.setLocked(true);
        LocalDateTime from = Settings.LocalDateTimefromDate(this.getDateFrom());
        ArrayList<PriceListDetailes> listChangedPrice = PriceListDetailes.getChangedPrice(departmentID, from, Settings.LocalDateTimefromDate(this.getDateTo() != null ? this.getDateTo() : new java.util.Date()), controller.getSettings().getConnection());
        long documentId = 0L;
        boolean brisiNivelaciju = true;
        for (PriceListDetailes pld : listChangedPrice) {
            Product p = Product.getByID(pld.getProductID(), controller);
            DocumentDetails dd = new DocumentDetails();
            dd.setProductID(pld.getProductID());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(pld.getDate());
            calendar.add(5, -1);
            if (pld.getPriceListDetailsID() == -1L) {
                dd.setQuantity(pld.getQuantity());
            } else {
                double odqty;
                double qty = this.differnetPriceForNivelationFromInvoice(controller, departmentID, from, pld.getDate(), pld.getPrice(), pld.getProductID());
                if (qty != 0.0) {
                    odqty = Product.getNewCurrentStock(controller, WorkDay.datumPocetnogStanja(departmentID, pld.getDate(), controller.getSettings().getConnection()), Settings.LocalDateTimefromDate(pld.getDate()), pld.getProductID(), -1L);
                    dd.setQuantity(odqty - qty);
                } else {
                    odqty = Product.getNewCurrentStock(controller, WorkDay.datumPocetnogStanja(departmentID, pld.getDate(), controller.getSettings().getConnection()), Settings.LocalDateTimefromDate(pld.getDate()), pld.getProductID(), -1L);
                    dd.setQuantity(odqty);
                }
            }
            dd.setPrice(pld.getPreviousPrice());
            dd.setNewPrice(pld.getPrice());
            dd.setSysUserAddID(controller.getUser().getUserID());
            dd.setUnitID(p.getUnitID());
            dd.setVatID(p.getVatID());
            dd.setProduct(Product.getByID(dd.getProductID(), controller));
            if (!(dd.getQuantity() > 0.0)) continue;
            if (documentId == 0L) {
                documentId = nivelacijaDoc.insertWithModifiedDate(controller.getSettings().getConnection());
                uradjena = true;
            }
            dd.setDocumentID(documentId);
            brisiNivelaciju = false;
            dd.insert(controller.getSettings().getConnection());
        }
        return uradjena;
    }

    private double differnetPriceForNivelationFromInvoice(ScreensController controller, int departmentId, LocalDateTime from, java.util.Date to, Double price, long productId) {
        String query = "SELECT sum(dd.Quantity - \r\n(SELECT COALESCE(SUM(dd.Quantity), 0) FROM documentdetails dd WHERE dd.sysDTCreated BETWEEN ? AND ? \r\nAND dd.DocumentID IN (SELECT d.DocumentID FROM document d WHERE d.DocumentTypeID = 3)\r\nAND dd.Price <> current_price_before_date(dd.ProductID, dd.sysDTCreated, ?)\r\nAND dd.ProductID = ?)) AS Quantity \r\nFROM documentdetails dd \r\nLEFT JOIN document d ON d.DocumentID = dd.DocumentID\r\nWHERE CAST(d.DeliveryDate AS DATE) BETWEEN CAST(? AS DATE) AND CAST(? AS DATE) \r\nAND dd.DocumentID IN (SELECT d.DocumentID FROM document d WHERE d.DocumentTypeID = 1)\r\nAND dd.NewPrice = ? \r\nAND dd.ProductID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(Settings.DatefromLocalDateTime(from).getTime()));
            try {
                ps.setTimestamp(2, new Timestamp(to.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(2, new Timestamp(new java.util.Date().getTime()));
            }
            ps.setDouble(3, departmentId);
            ps.setLong(4, productId);
            ps.setTimestamp(5, Timestamp.valueOf(from));
            ps.setTimestamp(6, new Timestamp(to.getTime() + 5000L));
            ps.setDouble(7, price);
            ps.setLong(8, productId);
            System.out.println(ps);
            ResultSet rSet = ps.executeQuery();
            rSet.next();
            double qty = rSet.getDouble("Quantity");
            return qty;
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    public void createNivelationSellingChangePrice(ScreensController controller) throws SQLException {
        int departmentID = PointOfSale.getDepartmentIdById(this.getPointOfSaleID(), controller.getSettings().getConnection());
        WorkDay startForDep = WorkDay.getStartForDepByDate(departmentID, this.date, controller.getSettings().getConnection());
        Document nivelacijaDoc = new Document();
        nivelacijaDoc.setDate(this.DateTo != null ? this.DateTo : new java.util.Date());
        nivelacijaDoc.setWorkDayID(this.getWorkDayID());
        nivelacijaDoc.setDocumentTypeID(15);
        nivelacijaDoc.setYear(Integer.parseInt(new SimpleDateFormat("yyyy").format(this.DateFrom)));
        nivelacijaDoc.setNumber(Document.getNextNumberNivelacija(15, controller));
        nivelacijaDoc.setSysUserAddID(controller.getUser().getUserID());
        nivelacijaDoc.setDocumentStatusID(1);
        nivelacijaDoc.setPointOfSaleID(this.getPointOfSaleID());
        nivelacijaDoc.setDepartmentID(departmentID);
        nivelacijaDoc.setLocked(true);
        LocalDateTime from = Settings.LocalDateTimefromDate(startForDep.getDateFrom());
        ArrayList<DocumentDetails> listChangedPrice = DocumentDetails.getChangedPriceDocumentDetails(departmentID, from, Settings.LocalDateTimefromDate(this.getDateTo() != null ? this.getDateTo() : new java.util.Date()), controller.getSettings().getConnection());
        long documentId = 0L;
        if (!listChangedPrice.isEmpty()) {
            documentId = nivelacijaDoc.insertWithModifiedDate(controller.getSettings().getConnection());
        }
        for (DocumentDetails pld : listChangedPrice) {
            Product p = Product.getByID(pld.getProductID(), controller);
            DocumentDetails dd = new DocumentDetails();
            dd.setDocumentID(documentId);
            dd.setProductID(pld.getProductID());
            dd.setQuantity(pld.getQuantity());
            dd.setPrice(pld.getPrice());
            dd.setNewPrice(pld.getPriceWithDiscount());
            dd.setSysUserAddID(controller.getUser().getUserID());
            dd.setUnitID(p.getUnitID());
            dd.setVatID(p.getVatID());
            if (!(dd.getQuantity() >= 0.0)) continue;
            dd.insert(controller.getSettings().getConnection());
        }
    }

    public void createNivelationBetweenPriceList(ScreensController controller) throws SQLException {
        int departmentID = PointOfSale.getDepartmentIdById(this.getPointOfSaleID(), controller.getSettings().getConnection());
        WorkDay startForDep = WorkDay.getStartForDepByDate(departmentID, this.date, controller.getSettings().getConnection());
        Document nivelacijaDoc = new Document();
        nivelacijaDoc.setDate(this.DateTo);
        nivelacijaDoc.setWorkDayID(this.getWorkDayID());
        nivelacijaDoc.setDocumentTypeID(15);
        nivelacijaDoc.setYear(Integer.parseInt(new SimpleDateFormat("yyyy").format(new java.util.Date())));
        nivelacijaDoc.setNumber(Document.getNextNumberNivelacija(15, controller));
        nivelacijaDoc.setNote("Izmedju cenovnika");
        nivelacijaDoc.setSysUserAddID(controller.getUser().getUserID());
        nivelacijaDoc.setDocumentStatusID(1);
        nivelacijaDoc.setPointOfSaleID(this.getPointOfSaleID());
        nivelacijaDoc.setDepartmentID(departmentID);
        LocalDateTime from = Settings.LocalDateTimefromDate(startForDep.getDateFrom());
        ArrayList<PriceListDetailes> listChangedPrice = PriceListDetailes.getChangedPriceBetweenPriceList(departmentID, from, Settings.LocalDateTimefromDate(this.getDateTo()), controller.getSettings().getConnection());
        long documentId = 0L;
        if (!listChangedPrice.isEmpty()) {
            documentId = nivelacijaDoc.insertWithModifiedDate(controller.getSettings().getConnection());
        }
        for (PriceListDetailes pld : listChangedPrice) {
            Product p = Product.getByID(pld.getProductID(), controller);
            DocumentDetails dd = new DocumentDetails();
            dd.setDocumentID(documentId);
            dd.setProductID(pld.getProductID());
            if (pld.getPriceListDetailsID() == -1L) {
                dd.setQuantity(pld.getQuantity());
            } else {
                double qty = this.differnetPriceForNivelationFromInvoice(controller, departmentID, from, pld.getDate(), pld.getPrice(), pld.getProductID());
                if (qty > 0.0) {
                    dd.setQuantity(qty);
                } else {
                    dd.setQuantity(0.0);
                }
            }
            dd.setPrice(pld.getPreviousPrice());
            dd.setNewPrice(pld.getPrice());
            dd.setSysUserAddID(controller.getUser().getUserID());
            dd.setUnitID(p.getUnitID());
            dd.setVatID(p.getVatID());
            dd.insert(controller.getSettings().getConnection());
        }
    }

    public static ArrayList<WorkDay> getFullList(ScreensController controller) {
        ArrayList<WorkDay> list = new ArrayList<WorkDay>();
        String query = "SELECT * FROM workday";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e) {
                    wd.DateTo = null;
                }
                wd.closingInProgress = rs.getBoolean("ClosingInProgress");
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                list.add(wd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<WorkDay> getList(LocalDate dateFrom, LocalDate dateTo, int objectId, Connection connection) {
        ArrayList<WorkDay> list = new ArrayList<WorkDay>();
        String query = "select *   from workday w  left join pointofsale p on p.PointOfSaleID = w.PointOfSaleID where w.Date >= ? and w.Date <= ? and p.ObjectID = ? order by w.WorkDayID DESC";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new Date(Settings.fromLocalDate(dateFrom).getTime()));
            ps.setDate(2, new Date(Settings.fromLocalDate(dateTo).getTime()));
            ps.setInt(3, objectId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e) {
                    wd.DateTo = null;
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                list.add(wd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<WorkDay> getListByKepKnjiga(LocalDate dateFrom, LocalDate dateTo, Connection connection) {
        ArrayList<WorkDay> list = new ArrayList<WorkDay>();
        String query = "select *   from workday w where w.Date >= ? and w.Date <= ? GROUP BY w.Date order by w.WorkDayID DESC ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new Date(Settings.fromLocalDate(dateFrom).getTime()));
            ps.setDate(2, new Date(Settings.fromLocalDate(dateTo).getTime()));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e) {
                    wd.DateTo = null;
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                list.add(wd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<WorkDay> getListV1(LocalDate dateFrom, LocalDate dateTo, int objectId, Connection connection) {
        ArrayList<WorkDay> list = new ArrayList<WorkDay>();
        String query = "select *   from workday w left join pointofsale p on p.PointOfSaleID = w.PointOfSaleID left join pointofsaledepartment posd on posd.PointOfSaleID = p.PointOfSaleID where w.Date >= DATE(`workday_start_v5`(posd.DepartmentID, ?)) \t\tand w.Date <= DATE(`workday_start_v5`(posd.DepartmentID, ?)) \t\tand p.ObjectID = ? ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new Date(Settings.fromLocalDate(dateFrom).getTime()));
            ps.setDate(2, new Date(Settings.fromLocalDate(dateTo).getTime()));
            ps.setInt(3, objectId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e) {
                    wd.DateTo = null;
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                list.add(wd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<WorkDay> getListWithLastClosedPOSInDep(LocalDate dateFrom, LocalDate dateTo, int objectId, Connection connection) {
        ArrayList<WorkDay> list = new ArrayList<WorkDay>();
        String query = "select *  from workday w join pointofsale p on p.PointOfSaleID = w.PointOfSaleID join pointofsaledepartment posd on posd.PointOfSaleID = p.PointOfSaleID where w.Date >= DATE(`workday_start_v5`(posd.DepartmentID, ?)) \tand w.Date <= DATE(`workday_start_v5`(posd.DepartmentID, ?)) \tand p.ObjectID = ? \tand w.DateTo in (select max(wd.DateTo) \t\t\t\t\tfrom workday wd \t\t\t\t\tjoin pointofsale po on po.PointOfSaleID = wd.PointOfSaleID \t\t\t\t\tjoin pointofsaledepartment posd1 on posd1.PointOfSaleID = po.PointOfSaleID \t\t\t\t\twhere wd.Date = w.Date) and w.DateTo is not null ORDER BY w.WorkDayID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new Date(Settings.fromLocalDate(dateFrom).getTime()));
            ps.setDate(2, new Date(Settings.fromLocalDate(dateTo).getTime()));
            ps.setInt(3, objectId);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e) {
                    wd.DateTo = null;
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                list.add(wd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static HashMap<String, Object> allowClose(ScreensController controller) throws IOException {
        WorkDay w = WorkDay.getFromDb(controller.getPointOfSale(), controller.getSettings().getConnection());
        String data = FiscalPrinter.getSummaryData(controller.getSettings().getFiscalFolder()).trim();
        String[] datas = data.split("\n");
        datas = datas[0].split(";");
        double cash = (double)Integer.parseInt(datas[0]) / 100.0;
        double check = (double)Integer.parseInt(datas[1]) / 100.0;
        double card = (double)Integer.parseInt(datas[2].trim()) / 100.0;
        double dbSum = 0.0;
        for (Document d : Document.getObeservableList(3, 0, controller.getObject(), controller.getPointOfSale(), w.getDate(), true, true, controller.getSettings().getConnection())) {
            dbSum += d.getSumWithDiscount();
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        String text = "Gotovina:\t " + cash + "\nKartica:\t " + card + "\nCek:\t\t" + check + "\nUkupno: \t" + (cash + card + check);
        hm.put("text", text);
        if (dbSum == cash + card + check) {
            hm.put("allowed", true);
        } else {
            hm.put("allowed", false);
        }
        return hm;
    }

    public static boolean isTableLocked(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("SHOW OPEN TABLES FROM masterdb WHERE In_use > 0;");
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return true;
            }
            PreparedStatement ps1 = connection.prepareStatement("select * from workday wd where wd.ClosingInProgress = 1");
            ResultSet rs1 = ps1.executeQuery();
            if (rs1.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setLockTable(boolean lock, Connection connection) throws SQLException {
        PreparedStatement ps = connection.prepareStatement("UPDATE `workday` SET `ClosingInProgress`=? WHERE  `WorkDayID`=?;");
        ps.setInt(1, lock ? 1 : 0);
        ps.setLong(2, this.WorkDayID);
        ps.executeUpdate();
    }

    public boolean isOpenInDep(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select w.* from workday w join pointofsaledepartment posd on posd.PointOfSaleID = w.PointOfSaleID \t\t\t\t\t\t\t\t\tand posd.DepartmentID = ? where w.DateTo is null and w.Date = DATE(?)");
            ps.setLong(1, PointOfSale.getDepartmentIdById(this.PointOfSaleID, connection));
            ps.setDate(2, new Date(this.date.getTime()));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static WorkDay getLastOpenWD(ScreensController controller) {
        String query = "SELECT * FROM workday wd WHERE wd.DateTo IS NULL AND wd.PointOfSaleID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, controller.getPointOfSale().PointOfSaleID);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            WorkDay wd = new WorkDay();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            rs.close();
            ps.close();
            return wd;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WorkDay getLastOpenWDByDate(java.util.Date date, ScreensController controller) {
        String query = "SELECT * FROM workday wd WHERE wd.Date <= ? AND wd.PointOfSaleID = ? order BY wd.WorkDayID DESC LIMIT 1";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setDate(1, new Date(date.getTime()));
            ps.setInt(2, controller.getPointOfSale().PointOfSaleID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            WorkDay wd = new WorkDay();
            wd.WorkDayID = rs.getLong("WorkDayID");
            wd.PointOfSaleID = rs.getInt("PointOfSaleID");
            wd.date = new java.util.Date(rs.getDate("Date").getTime());
            wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
            try {
                wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
            }
            catch (NullPointerException e) {
                wd.DateTo = null;
            }
            wd.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                wd.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            rs.close();
            ps.close();
            return wd;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void updateClosingInProgress(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`workday` SET `ClosingInProgress`= ? WHERE  `WorkDayID` = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setBoolean(1, this.closingInProgress);
            pStatement.setLong(2, this.WorkDayID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteNivelacijaForWD(ScreensController controller) {
        String query = "DELETE FROM documentdetails WHERE DocumentID IN (SELECT d.DocumentID FROM document d WHERE d.DocumentTypeID = 15 and d.WorkDayID = ?) ";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.WorkDayID);
            pStatement.executeUpdate();
            query = "DELETE FROM document WHERE DocumentTypeID = 15 and WorkDayID = ? ";
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.WorkDayID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteNivelacija(ScreensController controller) {
        String query = "DELETE FROM documentdetails WHERE DocumentID IN (SELECT d.DocumentID FROM document d WHERE d.DocumentTypeID = 15) ";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
            query = "DELETE FROM document WHERE DocumentTypeID = 15";
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<WorkDay> getWorkDayFroNivelation(LocalDate from, LocalDate to, ScreensController controller) {
        ArrayList<WorkDay> list = new ArrayList<WorkDay>();
        String query = "SELECT * FROM workday wd WHERE wd.Date BETWEEN ? AND ? AND wd.PointOfSaleID = 1";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setDate(1, new Date(Settings.fromLocalDate(from).getTime()));
            ps.setDate(2, new Date(Settings.fromLocalDate(to).getTime()));
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                WorkDay wd = new WorkDay();
                wd.WorkDayID = rs.getLong("WorkDayID");
                wd.PointOfSaleID = rs.getInt("PointOfSaleID");
                wd.date = new java.util.Date(rs.getDate("Date").getTime());
                wd.DateFrom = new java.util.Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    wd.DateTo = new java.util.Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException e) {
                    wd.DateTo = null;
                }
                wd.sysUserAddID = rs.getLong("sysUserAddID");
                try {
                    wd.sysUserEditID = rs.getLong("sysUserEditID");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                list.add(wd);
            }
            rs.close();
            ps.close();
            return list;
        }
        catch (SQLException e) {
            return null;
        }
    }
}

