/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class WarehouseCentral {
    private int warehouseId;
    private String code;
    private String name;
    private boolean active;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private int objectId;

    public int getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseId(int warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public String toString() {
        return this.name;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `warehouse_central` (`Code`, `Name`, `Active`, `sysUserAddID`, `ObjectID`) VALUES (?, ?, ?, 1, ?)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.code);
            pStatement.setString(2, this.name);
            pStatement.setBoolean(3, this.active);
            pStatement.setInt(4, controller.getObject().getObjectID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `warehouse_central` SET `Code` = ?, `Name` = ?, `Active`= ?, `sysDTEdit`= now(), `sysUserEditID` = 1 WHERE  `WarehouseID` = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.code);
            pStatement.setString(2, this.name);
            pStatement.setBoolean(3, this.active);
            pStatement.setInt(4, this.warehouseId);
            pStatement.setInt(4, controller.getObject().getObjectID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<WarehouseCentral> getList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM warehouse_central wc";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                WarehouseCentral warehouseCentral = new WarehouseCentral();
                warehouseCentral.setWarehouseId(rSet.getInt("WarehouseID"));
                warehouseCentral.setCode(rSet.getString("Code"));
                warehouseCentral.setName(rSet.getString("Name"));
                warehouseCentral.setActive(rSet.getBoolean("Active"));
                warehouseCentral.setSysDTCreated(new Date(rSet.getTimestamp("sysDTCreated").getTime()));
                try {
                    warehouseCentral.setSysDTEdit(new Date(rSet.getTimestamp("sysDTEdit").getTime()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                warehouseCentral.setSysUserAddID(rSet.getLong("sysUserAddID"));
                warehouseCentral.setSysUserEditID(rSet.getLong("sysUserEditID"));
                warehouseCentral.setObjectId(rSet.getInt("ObjectID"));
                list.add((Object)warehouseCentral);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static WarehouseCentral getByID(int warehouseID, Connection connection) {
        String query = "SELECT * FROM warehouse_central wc AND wc.WarehouseID = ?";
        WarehouseCentral warehouseCentral = new WarehouseCentral();
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setInt(1, warehouseID);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                warehouseCentral.setWarehouseId(rSet.getInt("WarehouseID"));
                warehouseCentral.setCode(rSet.getString("Code"));
                warehouseCentral.setName(rSet.getString("Name"));
                warehouseCentral.setActive(rSet.getBoolean("Active"));
                warehouseCentral.setSysDTCreated(new Date(rSet.getTimestamp("sysDTCreated").getTime()));
                try {
                    warehouseCentral.setSysDTEdit(new Date(rSet.getTimestamp("sysDTEdit").getTime()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                warehouseCentral.setSysUserAddID(rSet.getLong("sysUserAddID"));
                warehouseCentral.setSysUserEditID(rSet.getLong("sysUserEditID"));
                warehouseCentral.setObjectId(rSet.getInt("ObjectID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return warehouseCentral;
    }
}

