/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Vat {
    private int VatID;
    private String Name;
    private double Value;
    private double Value2;
    private double Value3;
    private boolean Active;
    private String Code;
    private ArrayList<Vat> list;

    public int getVatID() {
        return this.VatID;
    }

    public void setVatID(int vatID) {
        this.VatID = vatID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public double getValue() {
        return this.Value;
    }

    public void setValue(double value) {
        this.Value = value;
    }

    public double getValue2() {
        return this.Value2;
    }

    public void setValue2(double value2) {
        this.Value2 = value2;
    }

    public double getValue3() {
        return this.Value3;
    }

    public void setValue3(double value3) {
        this.Value3 = value3;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public String toString() {
        return this.Name;
    }

    public Vat getVat(int id, Connection connection) {
        if (this.list == null) {
            try {
                PreparedStatement ps = connection.prepareStatement("select * from Vat where Active = true");
                ResultSet rs = ps.executeQuery();
                this.list = new ArrayList();
                while (rs.next()) {
                    Vat vat = new Vat();
                    vat.VatID = rs.getInt("VatID");
                    vat.Name = rs.getString("Name");
                    vat.Value = rs.getDouble("Value");
                    vat.Value2 = rs.getDouble("Value2");
                    vat.Value3 = rs.getDouble("Value3");
                    vat.Active = rs.getBoolean("Active");
                    vat.Code = rs.getString("Code");
                    this.list.add(vat);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Vat vat = null;
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i).getVatID() != id) continue;
            vat = this.list.get(i);
        }
        return vat;
    }

    public static Vat getByCode(String code, Connection connection) {
        Vat vat = new Vat();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM Vat WHERE Code = ? ");
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            rs.next();
            vat.VatID = rs.getInt("VatID");
            vat.Name = rs.getString("Name");
            vat.Value = rs.getDouble("Value");
            vat.Value2 = rs.getDouble("Value2");
            vat.Value3 = rs.getDouble("Value3");
            vat.Active = rs.getBoolean("Active");
            vat.Code = rs.getString("Code");
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            return null;
        }
        return vat;
    }

    public static Vat getById(int id, Connection connection) {
        Vat vat = new Vat();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM vat v WHERE v.VatID = ?");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            vat.VatID = rs.getInt("VatID");
            vat.Name = rs.getString("Name");
            vat.Value = rs.getDouble("Value");
            vat.Value2 = rs.getDouble("Value2");
            vat.Value3 = rs.getDouble("Value3");
            vat.Active = rs.getBoolean("Active");
            vat.Code = rs.getString("Code");
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return vat;
    }

    public static ObservableList<Vat> getObeservableList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM vat v WHERE v.Active = 1";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Vat vat = new Vat();
                vat.VatID = rs.getInt("VatID");
                vat.Name = rs.getString("Name");
                vat.Value = rs.getDouble("Value");
                vat.Value2 = rs.getDouble("Value2");
                vat.Value3 = rs.getDouble("Value3");
                vat.Active = rs.getBoolean("Active");
                vat.Code = rs.getString("Code");
                list.add((Object)vat);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Vat> getAllRates(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM vat v ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Vat vat = new Vat();
                vat.VatID = rs.getInt("VatID");
                vat.Name = rs.getString("Name");
                vat.Value = rs.getDouble("Value");
                vat.Value2 = rs.getDouble("Value2");
                vat.Value3 = rs.getDouble("Value3");
                vat.Active = rs.getBoolean("Active");
                vat.Code = rs.getString("Code");
                list.add((Object)vat);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Vat> getVatList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM vat v where  v.active = 1 ORDER BY v.Active DESC";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Vat vat = new Vat();
                vat.VatID = rs.getInt("VatID");
                vat.Name = rs.getString("Name");
                vat.Value = rs.getDouble("Value");
                vat.Value2 = rs.getDouble("Value2");
                vat.Value3 = rs.getDouble("Value3");
                vat.Active = rs.getBoolean("Active");
                vat.Code = rs.getString("Code");
                list.add((Object)vat);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public int insertVat(Connection connection) {
        String query = "INSERT INTO `vat` (Name, Value, Value2, Value3, Active, Code) VALUES (?, ?, ?, ?, ?, ?)";
        int id = 0;
        try {
            PreparedStatement statement = connection.prepareStatement(query, 1);
            statement.setString(1, this.Name);
            statement.setDouble(2, this.Value);
            statement.setDouble(3, this.Value2);
            statement.setDouble(4, this.Value3);
            statement.setBoolean(5, this.Active);
            statement.setString(6, this.Code);
            statement.executeUpdate();
            ResultSet rs = statement.getGeneratedKeys();
            rs.next();
            id = rs.getInt(1);
            statement.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return id;
    }

    public int insertVat1(Connection connection) {
        String query = "INSERT INTO `vat` (vatId,Name, Value, Value2, Value3, Active, Code) VALUES (?,?, ?, ?, ?, ?, ?)";
        int id = 0;
        try {
            PreparedStatement statement = connection.prepareStatement(query);
            statement.setLong(1, 2000L);
            statement.setString(2, this.Name);
            statement.setDouble(3, this.Value);
            statement.setDouble(4, this.Value2);
            statement.setDouble(5, this.Value3);
            statement.setBoolean(6, false);
            statement.setString(7, this.Code);
            statement.executeUpdate();
            ResultSet rs = statement.getGeneratedKeys();
            if (rs.next()) {
                id = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return id;
    }

    public static void deleteAllFromVat(Connection connection) {
        String fkCheckOff = "SET FOREIGN_KEY_CHECKS = 0;";
        String deleteQuery = "DELETE from vat;";
        String resetIdQuery = "ALTER TABLE vat AUTO_INCREMENT = 1;";
        String fkCheckOn = "SET FOREIGN_KEY_CHECKS = 1;";
        Statement statement = null;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            statement.addBatch(fkCheckOff);
            statement.addBatch(deleteQuery);
            statement.addBatch(resetIdQuery);
            statement.addBatch(fkCheckOn);
            statement.executeBatch();
            connection.commit();
            connection.setAutoCommit(true);
            statement.close();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
                connection.setAutoCommit(true);
                statement.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public static void insertVatMasterDB(Connection connection) {
        String query = "INSERT INTO `vat` (`VatID`, `Name`, `Value`, `Value2`, `Value3`, `Active`, `Code`) VALUES (4, '0%', 1.00, 1.00, 0.00000000000000, b'0', 'GRUPA_A');";
        try {
            PreparedStatement statement = connection.prepareStatement(query);
            statement.executeUpdate();
            ResultSet rs = statement.getGeneratedKeys();
            rs.next();
            statement.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(int id, Connection connection) {
        String query = "DELETE FROM vat WHERE `VatID` = ?";
        try {
            PreparedStatement statement = connection.prepareStatement(query);
            statement.setLong(1, id);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateVat(int id, Connection connection) {
        String query = "UPDATE vat SET `Name` = ?, `Value` = ?, `Value2` = ?, `Value3` = ?, `Active` = ?, `Code` = ?   WHERE `VatID` = ?";
        try {
            PreparedStatement statement = connection.prepareStatement(query);
            statement.setString(1, this.Name);
            statement.setDouble(2, this.Value);
            statement.setDouble(3, this.Value2);
            statement.setDouble(4, this.Value3);
            statement.setBoolean(5, this.Active);
            statement.setString(6, this.Code);
            statement.setInt(7, id);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updateInPDV(boolean inPDV, Connection connection) {
        ObservableList<Vat> list = Vat.getVatList(connection);
        for (Vat v : list) {
            try {
                String query = "UPDATE vat SET `Active` = ? WHERE `VatID` = ?";
                PreparedStatement statement = connection.prepareStatement(query);
                if (v.Code.equals("GRUPA_A")) {
                    statement.setBoolean(1, !inPDV);
                    statement.setInt(2, v.VatID);
                    statement.executeUpdate();
                    statement.close();
                    continue;
                }
                statement.setBoolean(1, inPDV);
                statement.setInt(2, v.VatID);
                statement.executeUpdate();
                statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }
}

