/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.dal.IdCard;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Role;

public class User {
    private long userID;
    private String userName;
    private String password;
    private boolean active;
    private boolean ActiveUPOS;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private Date sanitaryDateExpire;
    private int PointOfSaleID;
    private IdCard idCard;
    private ArrayList<Role> userRole = new ArrayList();
    private List<PointOfSale> pointsOfSale = new ArrayList<PointOfSale>();

    public User() {
    }

    public User(String UserName) {
        this.userName = UserName;
    }

    public int getPointOfSaleID() {
        return this.PointOfSaleID;
    }

    public void setPointOfSaleID(int pointOfSaleID) {
        this.PointOfSaleID = pointOfSaleID;
    }

    public IdCard getIdCard() {
        return this.idCard;
    }

    public void setIdCard(IdCard idCard) {
        this.idCard = idCard;
    }

    public long getUserID() {
        return this.userID;
    }

    public void setUserID(long userID) {
        this.userID = userID;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActiveUPOS() {
        return this.ActiveUPOS;
    }

    public void setActiveUPOS(boolean activeUPOS) {
        this.ActiveUPOS = activeUPOS;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public Date getSanitaryDateExpire() {
        return this.sanitaryDateExpire;
    }

    public void setSanitaryDateExpire(Date sanitaryDateExpire) {
        this.sanitaryDateExpire = sanitaryDateExpire;
    }

    public ArrayList<Role> getUserRole() {
        return this.userRole;
    }

    public void setUserRole(ArrayList<Role> userRole) {
        this.userRole = userRole;
    }

    public List<PointOfSale> getPointsOfSale() {
        return this.pointsOfSale;
    }

    public void setPointsOfSale(List<PointOfSale> pointsOfSale) {
        this.pointsOfSale = pointsOfSale;
    }

    public String toString() {
        return this.userName;
    }

    public static User getFromDb(String userCode, String posCode, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select u.* from user u left join userpointofsale up on up.UserID = u.UserID left join pointofsale p on up.PointOfSaleID = p.PointOfSaleID where p.Code = ?\tand ((u.Password = ?) or (? in (select i.Code from idcard i where i.UserID = u.UserID)))");
            ps.setString(1, posCode);
            ps.setString(2, userCode);
            ps.setString(3, userCode);
            ResultSet rs = ps.executeQuery();
            rs.next();
            User user = new User();
            user.userID = rs.getLong("UserID");
            user.userName = rs.getString("UserName");
            user.password = rs.getString("Password");
            user.active = rs.getBoolean("Active");
            user.sysDTCreated = new Date(rs.getDate("sysDTCreated").getTime());
            try {
                user.sysDTEdit = new Date(rs.getDate("sysDTEdit").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            user.sysUserAddID = rs.getLong("sysUserAddID");
            user.sysUserEditID = rs.getLong("sysUserEditID");
            try {
                user.sanitaryDateExpire = new Date(rs.getDate("SanitaryDateExpire").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            user.userRole = Role.getList(user.userID, connection);
            return user;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static ObservableList<User> getUsersListByObjectId(Connection connection, int objectId) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT DISTINCT u.UserID,  u.Password, u.UserName, u.Active AS UserActive FROM user u, userpointofsale upos, pointofsale pos WHERE u.UserID = upos.UserID and pos.ObjectID = ? ORDER BY UserName";
        try {
            PreparedStatement statement = connection.prepareStatement(query);
            statement.setInt(1, objectId);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                User user = new User();
                user.userID = resultSet.getLong("UserID");
                user.userName = resultSet.getString("UserName");
                user.password = resultSet.getString("Password");
                user.active = resultSet.getBoolean("UserActive");
                user.pointsOfSale = User.getPointsOfSaleFromDb(user.getUserID(), connection);
                IdCard card = IdCard.getByUserID(user.getUserID(), connection);
                if (card != null) {
                    user.idCard = card;
                }
                list.add((Object)user);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static ObservableList<User> getListUser(String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT DISTINCT u.UserID, u.Code, u.CardCode, u.Password, u.UserName, upos.Active FROM user u, userpointofsale upos WHERE u.UserID = upos.UserID and u.UserName LIKE ? ORDER BY UserName";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, "%" + filter + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                User user = new User();
                user.userID = rs.getLong("UserID");
                user.userName = rs.getString("UserName");
                user.password = rs.getString("Password");
                user.active = rs.getBoolean("Active");
                list.add((Object)user);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static User getFromDb(String userCode, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT u.* FROM user u WHERE u.Password = ? OR (? IN (SELECT i.code FROM idcard i WHERE i.UserID = u.UserID))");
            ps.setString(1, userCode);
            ps.setString(2, userCode);
            ResultSet rs = ps.executeQuery();
            rs.next();
            User user = new User();
            user.userID = rs.getLong("UserID");
            user.userName = rs.getString("UserName");
            user.password = rs.getString("Password");
            user.active = rs.getBoolean("Active");
            user.sysDTCreated = new Date(rs.getDate("sysDTCreated").getTime());
            try {
                user.sysDTEdit = new Date(rs.getDate("sysDTEdit").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            user.sysUserAddID = rs.getLong("sysUserAddID");
            user.sysUserEditID = rs.getLong("sysUserEditID");
            try {
                user.sanitaryDateExpire = new Date(rs.getDate("SanitaryDateExpire").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            user.userRole = Role.getList(user.userID, connection);
            return user;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public boolean hasRole(String code) {
        boolean result = false;
        for (int i = 0; i < this.userRole.size(); ++i) {
            if (!this.userRole.get(i).getCode().equals(code)) continue;
            result = true;
            break;
        }
        return result;
    }

    public long newUser(Connection connection) {
        long id = 0L;
        String query = "INSERT INTO user (UserName, Password, Active) VALUES (?, ?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setString(1, this.userName);
            ps.setString(2, this.password);
            ps.setBoolean(3, this.active);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            id = rs.getLong(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return id;
    }

    public static void insertUserIntoUserPOS(long userID, int posID, boolean active, Connection connection) {
        String query = "INSERT INTO userpointofsale (UserID, PointOfSaleID, Active) VALUES (?, ?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ps.setInt(2, posID);
            ps.setBoolean(3, active);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updateUserPos(long userId, PointOfSale pointOfSale, Connection connection) {
        String query = "UPDATE userpointofsale SET Active = ? WHERE UserID = ? and PointOfSaleID = ? ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setBoolean(1, pointOfSale.isActive());
            ps.setLong(2, userId);
            ps.setInt(3, pointOfSale.getPointOfSaleID());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insertUserIntoPosMenu(long userID, int posID, Connection connection) {
        String query = "INSERT INTO posmenuuser (UserID, PosMenuID) VALUES (?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ps.setInt(2, posID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insertUserRole(long userID, int roleID, Connection connection) {
        String query = "INSERT INTO userrole (UserID, RoleID) VALUES (?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ps.setInt(2, roleID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateUser(Connection connection, int posID) {
        String query = "UPDATE user u JOIN userpointofsale upos ON upos.UserID = u.UserID SET u.Code = ?, u.CardCode = ?, u.Password = ? WHERE u.UserID = ? and upos.PointOfSaleID = ?";
    }

    public void updateUser(Connection connection, String userName, String password, boolean active, long userId) {
        String query = "UPDATE user u SET u.UserName = ? , u.Password = ?, u.Active = ? WHERE u.UserID = ?";
        try {
            PreparedStatement statement = connection.prepareStatement(query);
            statement.setString(1, userName);
            statement.setString(2, password);
            statement.setBoolean(3, active);
            statement.setLong(4, userId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteUser(Connection connection) {
        String query = "DELETE FROM user WHERE  UserID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.getUserID());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteUserRole(long userID, int roleID, Connection connection) {
        String query = "DELETE FROM userrole WHERE  UserID = ? AND RoleID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ps.setInt(2, roleID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteUserRoles(long userId, Connection connection) {
        String query = "DELETE FROM userrole WHERE  UserID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteUserPOS(long userID, Connection connection) {
        String query = "DELETE FROM userpointofsale WHERE  UserID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, userID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteUserPOS(long userID, int posID, Connection connection) {
        String query = "DELETE FROM userpointofsale WHERE  UserID = ? AND PointOfSaleID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, userID);
            ps.setInt(2, posID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteUserPosMenu(long userID, int posID, Connection connection) {
        String query = "DELETE FROM posmenuuser WHERE UserID = ? AND PosMenuID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ps.setInt(2, posID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteAllUserPosMenu(long userId, Connection connection) {
        String query = "DELETE FROM posmenuuser WHERE  UserID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<User> getUserIdFromPOS(long userID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT upos.* FROM userpointofsale upos WHERE upos.UserID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                User user = new User();
                user.PointOfSaleID = rs.getInt("PointOfSaleID");
                list.add((Object)user);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<User> getUserList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT u.* FROM user u WHERE u.UserID <> 1";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                User user = new User();
                user.userID = rs.getLong("UserID");
                user.userName = rs.getString("UserName");
                user.password = rs.getString("Password");
                user.active = rs.getBoolean("Active");
                user.sysDTCreated = new Date(rs.getDate("sysDTCreated").getTime());
                try {
                    user.sysDTEdit = new Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                user.sysUserAddID = rs.getLong("sysUserAddID");
                user.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    user.sanitaryDateExpire = new Date(rs.getDate("SanitaryDateExpire").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                user.userRole = Role.getList(user.userID, connection);
                list.add((Object)user);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return list;
    }

    public static User getUserByID(long userID, Connection connection) {
        block6: {
            String query = "SELECT * FROM user where UserID = ?";
            try {
                PreparedStatement ps = connection.prepareStatement(query);
                ps.setLong(1, userID);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) break block6;
                User user = new User();
                user.userID = rs.getLong("UserID");
                user.userName = rs.getString("UserName");
                user.password = rs.getString("Password");
                user.active = rs.getBoolean("Active");
                user.sysDTCreated = new Date(rs.getDate("sysDTCreated").getTime());
                try {
                    user.sysDTEdit = new Date(rs.getDate("sysDTEdit").getTime());
                }
                catch (NullPointerException e) {
                    user.sysDTEdit = null;
                }
                user.sysUserAddID = rs.getLong("sysUserAddID");
                user.sysUserEditID = rs.getLong("sysUserEditID");
                try {
                    user.sanitaryDateExpire = new Date(rs.getDate("SanitaryDateExpire").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                user.userRole = Role.getList(user.userID, connection);
                return user;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Boolean getUPosActive(long userID, int posID, Connection connection) {
        String query = "SELECT upos.Active FROM userpointofsale upos WHERE upos.UserID = ? AND upos.PointOfSaleID = ?";
        User u = new User();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ps.setInt(2, posID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            u.ActiveUPOS = rs.getBoolean("Active");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return u.isActiveUPOS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PointOfSale> getPointsOfSaleFromDb(long userID, Connection connection) {
        ArrayList<PointOfSale> list = new ArrayList<PointOfSale>();
        String query = "SELECT pos.PointOfSaleID, pos.Code, pos.Name, pos.ObjectID, pos.sysDTCreated, upos.Active FROM pointofsale pos, userpointofsale upos WHERE  upos.PointOfSaleID = pos.PointOfSaleID AND upos.UserID = ?";
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(query);
            statement.setLong(1, userID);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                PointOfSale pointOfSale = new PointOfSale();
                pointOfSale.setPointOfSaleID(resultSet.getInt("PointOfSaleID"));
                pointOfSale.setCode(resultSet.getString("Code"));
                pointOfSale.setName(resultSet.getString("Name"));
                pointOfSale.setActive(resultSet.getBoolean("Active"));
                pointOfSale.setObjectID(resultSet.getInt("ObjectID"));
                pointOfSale.setSysDTCreated(new Date(resultSet.getDate("sysDTCreated").getTime()));
                list.add(pointOfSale);
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }
}

