/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;

public class StampaStikera {
    private String personName;
    private String productName;
    private String code;
    private String barCode;
    private String unitCode;
    private int priceInt;
    private Double priceDecimal;
    private int quantity;
    private String priceDec;
    private String netAmount;

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public int getPriceInt() {
        return this.priceInt;
    }

    public void setPriceInt(int priceInt) {
        this.priceInt = priceInt;
    }

    public Double getPriceDecimal() {
        return this.priceDecimal;
    }

    public void setPriceDecimal(Double priceDecimal) {
        this.priceDecimal = priceDecimal;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String getPriceDec() {
        return this.priceDec;
    }

    public void setPriceDec(String priceDec) {
        this.priceDec = priceDec;
    }

    public String getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(String netAmount) {
        this.netAmount = netAmount;
    }

    public static ObservableList<StampaStikera> getList(ScreensController controller, long documentId) {
        String query = "select pe.Name as PersonName, p.Name as ProductName, p.Code, COALESCE((select b1.BarCode from barcode b1 where b1.ProductID = p.ProductID), '0') AS BarCode, u.Code as UnitCode, TRUNCATE(dd.NewPrice, 0) as PriceInt, (dd.NewPrice - TRUNCATE(dd.NewPrice, 0)) as PriceDecimal, ROUND(dd.Quantity, 0) AS Quantity\r\nfrom documentdetails dd\r\nleft join product p on p.ProductID = dd.ProductID\r\nleft join document d on d.DocumentID = dd.DocumentID \r\nleft join person pe on pe.PersonID = d.PersonID\r\nleft join netamounttype nat on nat.NetAmountTypeID = p.NetAmountTypeID\r\nleft join unit u on u.UnitID = p.UnitID\r\nwhere dd.DocumentID = ?";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, documentId);
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                int mod = (int)Settings.roundOnTwo(rSet.getDouble("PriceDecimal") * 100.0);
                String priceDec = "";
                if (mod == 0) {
                    priceDec = "00";
                } else {
                    new String();
                    priceDec = String.valueOf(mod);
                }
                StampaStikera stampaStikera = new StampaStikera();
                stampaStikera.setPersonName(rSet.getString("PersonName"));
                stampaStikera.setProductName(rSet.getString("ProductName"));
                stampaStikera.setCode(rSet.getString("Code"));
                stampaStikera.setBarCode(rSet.getString("BarCode"));
                stampaStikera.setUnitCode(rSet.getString("UnitCode"));
                stampaStikera.setPriceDec(priceDec);
                stampaStikera.setPriceInt(rSet.getInt("PriceInt"));
                stampaStikera.setPriceDecimal(rSet.getDouble("PriceDecimal"));
                stampaStikera.setQuantity(rSet.getInt("Quantity"));
                for (int i = 0; i < stampaStikera.getQuantity(); ++i) {
                    list.add((Object)stampaStikera);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<StampaStikera> getListOnePeace(ScreensController controller, long documentId) {
        String query = "select pe.Name as PersonName, p.Name as ProductName, p.Code, COALESCE((select b1.BarCode from barcode b1 where b1.ProductID = p.ProductID order BY b1.BarCodeID LIMIT 1), '0') AS BarCode, u.Code as UnitCode, TRUNCATE(dd.NewPrice, 0) as PriceInt, (dd.NewPrice - TRUNCATE(dd.NewPrice, 0)) as PriceDecimal, ROUND(dd.Quantity, 0) AS Quantity\r\nfrom documentdetails dd\r\nleft join product p on p.ProductID = dd.ProductID\r\nleft join document d on d.DocumentID = dd.DocumentID \r\nleft join person pe on pe.PersonID = d.PersonID\r\nleft join netamounttype nat on nat.NetAmountTypeID = p.NetAmountTypeID\r\nleft join unit u on u.UnitID = p.UnitID\r\nwhere dd.DocumentID = ?";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, documentId);
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                int mod = (int)Settings.roundOnTwo(rSet.getDouble("PriceDecimal") * 100.0);
                String priceDec = "";
                if (mod == 0) {
                    priceDec = "00";
                } else {
                    new String();
                    priceDec = String.valueOf(mod);
                }
                StampaStikera stampaStikera = new StampaStikera();
                stampaStikera.setPersonName(rSet.getString("PersonName"));
                stampaStikera.setProductName(rSet.getString("ProductName"));
                stampaStikera.setCode(rSet.getString("Code"));
                stampaStikera.setBarCode(rSet.getString("BarCode"));
                stampaStikera.setUnitCode(rSet.getString("UnitCode"));
                stampaStikera.setPriceDec(priceDec);
                stampaStikera.setPriceInt(rSet.getInt("PriceInt"));
                stampaStikera.setPriceDecimal(rSet.getDouble("PriceDecimal"));
                stampaStikera.setQuantity(rSet.getInt("Quantity"));
                list.add((Object)stampaStikera);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

