/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlRunner {
    public static final String DELIMITER_LINE_REGEX = "(?i)DELIMITER.+";
    public static final String DELIMITER_LINE_SPLIT_REGEX = "(?i)DELIMITER";
    public static final String DEFAULT_DELIMITER = ";";
    private final boolean autoCommit;
    private final boolean stopOnError;
    private final Connection connection;
    private String delimiter = ";";

    public SqlRunner(Connection connection, boolean autoCommit, boolean stopOnError) {
        if (connection == null) {
            throw new RuntimeException("SqlRunner requires an SQL Connection");
        }
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
    }

    public void runScript(Reader reader) throws SQLException {
        boolean originalAutoCommit = this.connection.getAutoCommit();
        try {
            if (originalAutoCommit != this.autoCommit) {
                this.connection.setAutoCommit(this.autoCommit);
            }
            this.runScript(this.connection, reader);
        }
        finally {
            this.connection.setAutoCommit(originalAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScript(Connection conn, Reader reader) {
        StringBuffer command = null;
        try {
            LineNumberReader lineReader = new LineNumberReader(reader);
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                Matcher matcher;
                Pattern pattern;
                String trimmedLine;
                if (command == null) {
                    command = new StringBuffer();
                }
                if ((trimmedLine = line.trim()).startsWith("--") || trimmedLine.startsWith("//") || trimmedLine.startsWith("#")) continue;
                if (trimmedLine.endsWith(this.delimiter)) {
                    pattern = Pattern.compile(DELIMITER_LINE_REGEX);
                    matcher = pattern.matcher(trimmedLine);
                    if (matcher.matches()) {
                        this.delimiter = trimmedLine.split(DELIMITER_LINE_SPLIT_REGEX)[1].trim();
                        line = lineReader.readLine();
                        if (line == null) break;
                        trimmedLine = line.trim();
                    }
                    command.append(line.substring(0, line.lastIndexOf(this.delimiter)));
                    command.append(" ");
                    Statement stmt = null;
                    ResultSet rs = null;
                    try {
                        stmt = conn.createStatement();
                        boolean hasResults = false;
                        if (this.stopOnError) {
                            hasResults = stmt.execute(command.toString());
                        } else {
                            try {
                                stmt.execute(command.toString());
                            }
                            catch (SQLException e) {
                                e.fillInStackTrace();
                            }
                        }
                        if (this.autoCommit && !conn.getAutoCommit()) {
                            conn.commit();
                        }
                        rs = stmt.getResultSet();
                        if (hasResults && rs != null) {
                            int i;
                            ResultSetMetaData md = rs.getMetaData();
                            int cols = md.getColumnCount();
                            for (i = 0; i < cols; ++i) {
                                md.getColumnLabel(i + 1);
                            }
                            while (rs.next()) {
                                for (i = 1; i <= cols; ++i) {
                                    rs.getString(i);
                                }
                            }
                        }
                        command = null;
                        continue;
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (stmt == null) continue;
                        try {
                            stmt.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                }
                pattern = Pattern.compile(DELIMITER_LINE_REGEX);
                matcher = pattern.matcher(trimmedLine);
                if (matcher.matches()) {
                    this.delimiter = trimmedLine.split(DELIMITER_LINE_SPLIT_REGEX)[1].trim();
                    line = lineReader.readLine();
                    if (line == null) break;
                    trimmedLine = line.trim();
                }
                command.append(line);
                command.append(" ");
            }
            if (!this.autoCommit) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            e.fillInStackTrace();
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }
}

