/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.StringConverter;
import rs.petcom.enums.FiscalPrinterDriver;
import rs.petcom.enums.TerminalDataRow;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.CustomLogger;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.IpAddress;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.TerminalData;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Prijemnica;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.FillProgressIndicator;

public class Settings {
    private String dbserver = "localhost";
    private String database = "masterdb";
    private String username = "root";
    private String password = "928374";
    private String fiscalFolder = "";
    private int departmentId = 1;
    private String posPrinter = "";
    private String posFolder = "";
    private String defaultArticleColor = "";
    private String defaultAdditionalColor = "";
    private String defaultDescriptionalColor = "";
    private int defaultQuantity = 1;
    private String posType = "";
    private static String posCode = "";
    private int wdProductsReport = 0;
    private int wdOperatorReport = 0;
    private int wdStateReport = 0;
    private int wdDailyReport = 0;
    private String LCD;
    private int wdPluReport = 0;
    private boolean fullscreen = false;
    private int objectId = 0;
    private int kitchenMonitorId = 0;
    private boolean loyality = false;
    private int uplacenIznos = 0;
    private int tezinskiBarKod;
    private boolean popust = false;
    private boolean sabiranjeArtikala;
    private String pozadina;
    private boolean sellWithoutStock;
    private boolean kolBarkod;
    private boolean kolPLUkod;
    private boolean kolBoja;
    private boolean kolVelicina;
    private boolean kolStanje;
    private boolean numerikUkljucen;
    private String jasperToPDF;
    private int brojArtikalaZaUcitavanje;
    private int valutaPlacanja;
    private boolean loyalityPopustPrioritet;
    private boolean automatskoZatvaranjeDana = false;
    private String vremeOtvaranjaDana;
    Duration time = Duration.ZERO;
    Duration splitTime = Duration.ZERO;
    private boolean traziLicencu;
    private boolean ponudiSledeciKod;
    private boolean ponudiSledeciBarKod;
    private boolean srednjaNabavnaCena = false;
    private boolean sinhorinizacija = false;
    private String serverIPaddress = "localhost";
    private String lokalizacija = "sr";
    private long id;
    private String actual;
    private String name;
    private FiscalPrinterDriver fpDriver;
    private String lpfrPath;
    private String plstPath;
    private String vprfPath;
    private String JID;
    private String PAK;
    private boolean trainingMode;
    private String stampa;
    private String refNumberTemp = "";
    private String primaryAdressVprf;
    private String passwordVprf;
    private String putanjaSertifikat;
    private static final Logger LOGGER = Logger.getLogger("global");
    private Connection connection;
    private Object objectDatas;
    private Stage taskUpdateStage;

    public void setPutanjaSertifikat(String putanjaSertifikat) {
        this.putanjaSertifikat = putanjaSertifikat;
    }

    public String getVprfPath() {
        return this.vprfPath;
    }

    public String getPasswordVprf() {
        return this.passwordVprf;
    }

    public void setPasswordVprf(String passwordVprf) {
        this.passwordVprf = passwordVprf;
    }

    public void setVprfPath(String vprfPath) {
        this.vprfPath = vprfPath;
    }

    public String getPrimaryAdressVprf() {
        return this.primaryAdressVprf;
    }

    public void setPrimaryAdressVprf(String primaryAdressVprf) {
        this.primaryAdressVprf = primaryAdressVprf;
    }

    public String getJID() {
        return this.JID;
    }

    public void setJID(String JID) {
        this.JID = JID;
    }

    public String getPAK() {
        return this.PAK;
    }

    public void setPAK(String PAK) {
        this.PAK = PAK;
    }

    public String getRefNumberTemp() {
        return this.refNumberTemp;
    }

    public void setRefNumberTemp(String refNumberTemp) {
        this.refNumberTemp = refNumberTemp;
    }

    public static String getValue(ScreensController controller, String name) {
        String sql = "select * from settings   where name =?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = controller.getSettings().getConnection().prepareStatement(sql);
            preparedStatement.setString(1, name);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.first()) {
                return resultSet.getString("actual");
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    public String getStampa() {
        return this.stampa;
    }

    public void setStampa(String stampa) {
        this.stampa = stampa;
    }

    public void setLoyalityPopustPrioritet(boolean loyalityPopustPrioritet) {
        this.loyalityPopustPrioritet = loyalityPopustPrioritet;
    }

    public boolean isLoyalityPopustPrioritet() {
        return this.loyalityPopustPrioritet;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setActual(String actual) {
        this.actual = actual;
    }

    public String getActual() {
        return this.actual;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValutaPlacanja(int valutaPlacanja) {
        this.valutaPlacanja = valutaPlacanja;
    }

    public int getValutaPlacanja() {
        return this.valutaPlacanja;
    }

    public void setBrojArtikalaZaUcitavanje(int brojArtikalaZaUcitavanje) {
        this.brojArtikalaZaUcitavanje = brojArtikalaZaUcitavanje;
    }

    public int getBrojArtikalaZaUcitavanje() {
        return this.brojArtikalaZaUcitavanje;
    }

    public void setJasperToPDF(String jasperToPDF) {
        this.jasperToPDF = jasperToPDF;
    }

    public String getJasperToPDF() {
        return this.jasperToPDF;
    }

    public void setNumerikUkljucen(boolean numerikUkljucen) {
        this.numerikUkljucen = numerikUkljucen;
    }

    public boolean isNumerikUkljucen() {
        return this.numerikUkljucen;
    }

    public String getDbserver() {
        return this.dbserver;
    }

    public void setDbserver(String dbserver) {
        this.dbserver = dbserver;
    }

    public String getServerIPaddress() {
        return this.serverIPaddress;
    }

    public void setServerIPaddress(String serverIPaddress) {
        this.serverIPaddress = serverIPaddress;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static String getPosCode() {
        return posCode;
    }

    public void setPosCode(String posCode) {
        Settings.posCode = posCode;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getFiscalFolder() {
        return this.fiscalFolder;
    }

    public void setFiscalFolder(String fiscalFolder) {
        this.fiscalFolder = fiscalFolder;
    }

    public int getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(int departmentId) {
        this.departmentId = departmentId;
    }

    public String getPosPrinter() {
        return this.posPrinter;
    }

    public void setPosPrinter(String posPrinter) {
        this.posPrinter = posPrinter;
    }

    public String getPosFolder() {
        return this.posFolder;
    }

    public void setPosFolder(String posFolder) {
        this.posFolder = posFolder;
    }

    public String getDefaultArticleColor() {
        return this.defaultArticleColor;
    }

    public void setDefaultArticleColor(String defaultArticleColor) {
        this.defaultArticleColor = defaultArticleColor;
    }

    public String getDefaultAdditionalColor() {
        return this.defaultAdditionalColor;
    }

    public void setDefaultAdditionalColor(String defaultAdditionalColor) {
        this.defaultAdditionalColor = defaultAdditionalColor;
    }

    public String getDefaultDescriptionalColor() {
        return this.defaultDescriptionalColor;
    }

    public void setDefaultDescriptionalColor(String defaultDescriptionalColor) {
        this.defaultDescriptionalColor = defaultDescriptionalColor;
    }

    public int getDefaultQuantity() {
        return this.defaultQuantity;
    }

    public void setDefaultQuantity(int defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
    }

    public String getPosType() {
        return this.posType;
    }

    public void setPosType(String posType) {
        this.posType = posType;
    }

    public int getWdProductsReport() {
        return this.wdProductsReport;
    }

    public void setWdProductsReport(int wdProductsReport) {
        this.wdProductsReport = wdProductsReport;
    }

    public int getWdOperatorReport() {
        return this.wdOperatorReport;
    }

    public void setWdOperatorReport(int wdOperatorReport) {
        this.wdOperatorReport = wdOperatorReport;
    }

    public int getWdStateReport() {
        return this.wdStateReport;
    }

    public void setWdStateReport(int wdStateReport) {
        this.wdStateReport = wdStateReport;
    }

    public int getWdDailyReport() {
        return this.wdDailyReport;
    }

    public void setWdDailyReport(int wdDailyReport) {
        this.wdDailyReport = wdDailyReport;
    }

    public int getWdPluReport() {
        return this.wdPluReport;
    }

    public void setWdPluReport(int wdPluReport) {
        this.wdPluReport = wdPluReport;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public boolean isTraziLicencu() {
        return this.traziLicencu;
    }

    public void setTraziLicencu(boolean traziLicencu) {
        this.traziLicencu = traziLicencu;
    }

    public boolean isPonudiSledeciKod() {
        return this.ponudiSledeciKod;
    }

    public void setPonudiSledeciKod(boolean ponudiSledeciKod) {
        this.ponudiSledeciKod = ponudiSledeciKod;
    }

    public boolean isPonudiSledeciBarKod() {
        return this.ponudiSledeciBarKod;
    }

    public void setPonudiSledeciBarKod(boolean ponudiSledeciBarKod) {
        this.ponudiSledeciBarKod = ponudiSledeciBarKod;
    }

    public boolean isSrednjaNabavnaCena() {
        return this.srednjaNabavnaCena;
    }

    public void setSrednjaNabavnaCena(boolean srednjaNabavnaCena) {
        this.srednjaNabavnaCena = srednjaNabavnaCena;
    }

    public boolean isSinhorinizacija() {
        return this.sinhorinizacija;
    }

    public void setSinhorinizacija(boolean sinhorinizacija) {
        this.sinhorinizacija = sinhorinizacija;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public int getKitchenMonitorId() {
        return this.kitchenMonitorId;
    }

    public void setKitchenMonitorId(int kitchenMonitorId) {
        this.kitchenMonitorId = kitchenMonitorId;
    }

    public void setPopust(boolean popust) {
        this.popust = popust;
    }

    public boolean isPopust() {
        return this.popust;
    }

    public void setSabiranjeArtikala(boolean sabiranjeArtikala) {
        this.sabiranjeArtikala = sabiranjeArtikala;
    }

    public boolean isSabiranjeArtikala() {
        return this.sabiranjeArtikala;
    }

    public void setPozadina(String pozadina) {
        this.pozadina = pozadina;
    }

    public String getPozadina() {
        return this.pozadina;
    }

    public String getLokalizacija() {
        return this.lokalizacija;
    }

    public void setLokalizacija(String lokalizacija) {
        this.lokalizacija = lokalizacija;
    }

    public void setSellWithoutStock(boolean sellWithoutStock) {
        this.sellWithoutStock = sellWithoutStock;
    }

    public boolean isSellWithoutStock() {
        return this.sellWithoutStock;
    }

    public boolean isKolBarkod() {
        return this.kolBarkod;
    }

    public void setKolBarkod(boolean kolBarkod) {
        this.kolBarkod = kolBarkod;
    }

    public boolean isKolPlukod() {
        return this.kolPLUkod;
    }

    public void setKolPlukod(boolean kolPlukod) {
        this.kolPLUkod = kolPlukod;
    }

    public boolean isKolBoja() {
        return this.kolBoja;
    }

    public void setKolBoja(boolean kolBoja) {
        this.kolBoja = kolBoja;
    }

    public boolean isKolVelicina() {
        return this.kolVelicina;
    }

    public void setKolVelicina(boolean kolVelicina) {
        this.kolVelicina = kolVelicina;
    }

    public boolean isKolStanje() {
        return this.kolStanje;
    }

    public void setKolStanje(boolean prikaziStanjeFront) {
        this.kolStanje = prikaziStanjeFront;
    }

    public FiscalPrinterDriver getFpDriver() {
        return this.fpDriver;
    }

    public void setFpDriver(FiscalPrinterDriver fpDriver) {
        this.fpDriver = fpDriver;
    }

    public String getLpfrPath() {
        return this.lpfrPath;
    }

    public String getPlstPath() {
        return this.plstPath;
    }

    public void setPlstPath(String plstPath) {
        this.plstPath = plstPath;
    }

    public void setLpfrPath(String lpfrPath) {
        this.lpfrPath = lpfrPath;
    }

    public boolean isTrainingMode() {
        return this.trainingMode;
    }

    public void setTrainingMode(boolean trainingMode) {
        this.trainingMode = trainingMode;
    }

    public Object getObjectDatas() {
        return this.objectDatas;
    }

    public Settings(long id, String actual, String name) {
        this.id = id;
        this.actual = actual;
        this.name = name;
    }

    public Settings(String actual, String name) {
        this.actual = actual;
        this.name = name;
    }

    public Settings(IpAddress ip) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        try {
            CustomLogger.setup();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Problems with creating the log files");
        }
        LOGGER.setLevel(Level.FINEST);
        LOGGER.info("Program start");
        try {
            String line;
            File file = new File("setup.cnf");
            if (file.createNewFile()) {
                this.saveTerminalDataBackOffice();
            }
            FileInputStream fis = new FileInputStream("setup.cnf");
            InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
            BufferedReader br = new BufferedReader(isr);
            this.database = ip.getDatabase();
            this.dbserver = ip.getDbServer();
            while ((line = br.readLine()) != null) {
                try {
                    String[] red = line.split("=");
                    switch (red[0].trim()) {
                        case "posCode": {
                            posCode = red[1].trim();
                            break;
                        }
                        case "departmentId": {
                            this.departmentId = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "fiscalFolder": {
                            this.fiscalFolder = red[1].trim();
                            break;
                        }
                        case "serverIPaddress": {
                            this.serverIPaddress = red[1].trim();
                            break;
                        }
                        case "posPrinter": {
                            this.posPrinter = red[1].trim();
                            break;
                        }
                        case "posFolder": {
                            this.posFolder = red[1].trim();
                            break;
                        }
                        case "defaultArticleColor": {
                            this.defaultArticleColor = red[1].trim();
                            break;
                        }
                        case "defaultAdditionalColor": {
                            this.defaultAdditionalColor = red[1].trim();
                            break;
                        }
                        case "defaultDescriptionalColor": {
                            this.defaultDescriptionalColor = red[1].trim();
                            break;
                        }
                        case "defaultQuantity": {
                            this.defaultQuantity = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "posType": {
                            this.posType = red[1].trim();
                            break;
                        }
                        case "workDayClose.productsReport": {
                            this.wdProductsReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "workDayClose.operatorReport": {
                            this.wdOperatorReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "workDayClose.pluReport": {
                            this.wdPluReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "workDayClose.stateReport": {
                            this.wdStateReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "workDayClose.dailyReport": {
                            this.wdDailyReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "fullscreen": {
                            this.fullscreen = red[1].trim().equals("true");
                            break;
                        }
                        case "traziLicencu": {
                            this.traziLicencu = red[1].trim().equals("true");
                            break;
                        }
                        case "objectId": {
                            this.objectId = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "kitchenMonitorId": {
                            this.kitchenMonitorId = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "loyality": {
                            this.loyality = red[1].trim().equals("true");
                            break;
                        }
                        case "uplacenIznosNeophodan": {
                            this.uplacenIznos = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "tezinskiBarKod": {
                            this.tezinskiBarKod = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "popust": {
                            this.popust = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "sabiranjeArtikala": {
                            this.sabiranjeArtikala = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "background": {
                            this.pozadina = red[1].trim();
                            break;
                        }
                        case "lokalizacija": {
                            this.lokalizacija = red[1].trim();
                            break;
                        }
                        case "kolBarkod": {
                            this.kolBarkod = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "kolPLUkod": {
                            this.kolPLUkod = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "kolBoja": {
                            this.kolBoja = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "kolVelicina": {
                            this.kolVelicina = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "kolStanje": {
                            this.kolStanje = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "numerikUkljucen": {
                            this.numerikUkljucen = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "ponudiSledeciKod": {
                            this.ponudiSledeciKod = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "ponudiSledeciBarKod": {
                            this.ponudiSledeciBarKod = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "srednjaNabavnaCena": {
                            this.srednjaNabavnaCena = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "sinhorinizacija": {
                            this.sinhorinizacija = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "jasperToPDF": {
                            this.jasperToPDF = red[1].trim();
                            break;
                        }
                        case "brojArtikalaZaUcitavanje": {
                            this.brojArtikalaZaUcitavanje = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "valutaPlacanja": {
                            this.valutaPlacanja = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "loyalityPopustPrioritet": {
                            this.loyalityPopustPrioritet = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "automatskoZatvaranjeDana": {
                            this.automatskoZatvaranjeDana = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "vremeOtvaranjaDana": {
                            this.vremeOtvaranjaDana = red[1].trim();
                            break;
                        }
                        case "fpDriver": {
                            this.fpDriver = FiscalPrinterDriver.getByName(red[1].trim());
                            break;
                        }
                        case "trening": {
                            this.fpDriver = FiscalPrinterDriver.getByName(red[1].trim());
                            break;
                        }
                        case "LpfrPutanja": {
                            this.lpfrPath = red[1].trim();
                            break;
                        }
                        case "VprfPutanja": {
                            this.vprfPath = red[1].trim();
                            break;
                        }
                        case "tfPASSWORD": {
                            this.passwordVprf = red[1].trim();
                            break;
                        }
                        case "tfJID": {
                            this.JID = red[1].trim();
                            break;
                        }
                        case "tfPak": {
                            this.PAK = red[1].trim();
                            break;
                        }
                        case "LCD": {
                            this.LCD = red[1].trim();
                            break;
                        }
                        case "primarnaAdresaVprf": {
                            this.primaryAdressVprf = red[1].trim();
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            br.close();
            if (this.connection == null) {
                this.connection = DriverManager.getConnection("jdbc:mysql://" + this.dbserver + "/" + this.database + "?user=root&password=928374&useSSL=false&dontTrackOpenResources=true&autoReconnect=true&characterEncoding=UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Settings() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        try {
            CustomLogger.setup();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Problems with creating the log files");
        }
        LOGGER.setLevel(Level.FINEST);
        LOGGER.info("Program start");
        try {
            String line;
            File file = new File("setup.cnf");
            if (file.createNewFile()) {
                this.saveTerminalData();
            } else {
                TerminalData t_Data = new TerminalData();
                t_Data.checkAndAdjustTerminalData(TerminalDataRow.values());
            }
            FileInputStream fis = new FileInputStream("setup.cnf");
            InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                try {
                    String[] red = line.split("=");
                    switch (red[0].trim()) {
                        case "dbserver": {
                            this.dbserver = red[1].trim();
                            break;
                        }
                        case "database": {
                            this.database = red[1].trim();
                            break;
                        }
                        case "serverIPaddress": {
                            this.serverIPaddress = red[1].trim();
                            break;
                        }
                        case "posCode": {
                            posCode = red[1].trim();
                            break;
                        }
                        case "departmentId": {
                            this.departmentId = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "fiscalFolder": {
                            this.fiscalFolder = red[1].trim();
                            break;
                        }
                        case "posFolder": {
                            this.posFolder = red[1].trim();
                            break;
                        }
                        case "defaultArticleColor": {
                            this.defaultArticleColor = red[1].trim();
                            break;
                        }
                        case "defaultAdditionalColor": {
                            this.defaultAdditionalColor = red[1].trim();
                            break;
                        }
                        case "defaultDescriptionalColor": {
                            this.defaultDescriptionalColor = red[1].trim();
                            break;
                        }
                        case "defaultQuantity": {
                            this.defaultQuantity = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "posType": {
                            this.posType = red[1].trim();
                            break;
                        }
                        case "workDayClose.productsReport": {
                            this.wdProductsReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "workDayClose.operatorReport": {
                            this.wdOperatorReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "workDayClose.pluReport": {
                            this.wdPluReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "workDayClose.stateReport": {
                            this.wdStateReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "workDayClose.dailyReport": {
                            this.wdDailyReport = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "fullscreen": {
                            this.fullscreen = red[1].trim().equals("true");
                            break;
                        }
                        case "traziLicencu": {
                            this.traziLicencu = red[1].trim().equals("true");
                            break;
                        }
                        case "objectId": {
                            this.objectId = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "kitchenMonitorId": {
                            this.kitchenMonitorId = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "loyality": {
                            this.loyality = red[1].trim().equals("true");
                            break;
                        }
                        case "uplacenIznosNeophodan": {
                            this.uplacenIznos = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "tezinskiBarKod": {
                            this.tezinskiBarKod = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "popust": {
                            this.popust = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "sabiranjeArtikala": {
                            this.sabiranjeArtikala = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "background": {
                            this.pozadina = red[1].trim();
                            break;
                        }
                        case "lokalizacija": {
                            this.lokalizacija = red[1].trim();
                        }
                        case "kolBarkod": {
                            this.kolBarkod = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "kolPLUkod": {
                            this.kolPLUkod = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "kolBoja": {
                            this.kolBoja = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "kolVelicina": {
                            this.kolVelicina = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "kolStanje": {
                            this.kolStanje = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "numerikUkljucen": {
                            this.numerikUkljucen = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "ponudiSledeciKod": {
                            this.ponudiSledeciKod = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "ponudiSledeciBarKod": {
                            this.ponudiSledeciBarKod = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "srednjaNabavnaCena": {
                            this.srednjaNabavnaCena = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "sinhorinizacija": {
                            this.sinhorinizacija = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "jasperToPDF": {
                            this.jasperToPDF = red[1].trim();
                            break;
                        }
                        case "brojArtikalaZaUcitavanje": {
                            this.brojArtikalaZaUcitavanje = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "valutaPlacanja": {
                            this.valutaPlacanja = Integer.parseInt(red[1].trim());
                            break;
                        }
                        case "loyalityPopustPrioritet": {
                            this.loyalityPopustPrioritet = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "automatskoZatvaranjeDana": {
                            this.automatskoZatvaranjeDana = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "vremeOtvaranjaDana": {
                            this.vremeOtvaranjaDana = red[1].trim();
                            break;
                        }
                        case "fpDriver": {
                            this.fpDriver = FiscalPrinterDriver.getByName(red[1].trim());
                            break;
                        }
                        case "trening": {
                            this.trainingMode = Boolean.parseBoolean(red[1].trim());
                            break;
                        }
                        case "LpfrPutanja": {
                            this.lpfrPath = red[1].trim();
                            break;
                        }
                        case "PlstPutanja": {
                            this.plstPath = red[1].trim();
                            break;
                        }
                        case "stampa": {
                            this.stampa = red[1].trim();
                            break;
                        }
                        case "VprfPutanja": {
                            this.vprfPath = red[1].trim();
                            break;
                        }
                        case "tfPASSWORD": {
                            this.passwordVprf = red[1].trim();
                            break;
                        }
                        case "tfJID": {
                            this.JID = red[1].trim();
                            break;
                        }
                        case "tfPak": {
                            this.PAK = red[1].trim();
                            break;
                        }
                        case "LCD": {
                            this.LCD = red[1].trim();
                            break;
                        }
                        case "primarnaAdresaVprf": {
                            this.primaryAdressVprf = red[1].trim();
                            break;
                        }
                        case "tfPutanjaSertifikat": {
                            this.putanjaSertifikat = red[1].trim();
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException red) {}
            }
            br.close();
            if (this.connection == null) {
                try {
                    this.connection = DriverManager.getConnection("jdbc:mysql://" + this.dbserver + "/" + this.database + "?user=petcom&password=928374&useSSL=false&dontTrackOpenResources=true&autoReconnect=true&characterEncoding=UTF-8");
                }
                catch (Exception e) {
                    this.connection = DriverManager.getConnection("jdbc:mysql://" + this.dbserver + "/" + this.database + "?user=root&password=928374&useSSL=false&dontTrackOpenResources=true&autoReconnect=true&characterEncoding=UTF-8");
                }
            }
            if (this.objectDatas == null) {
                this.objectDatas = Object.get(this.connection);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Connection getNewConnection(String dbServer, String database) {
        try {
            return DriverManager.getConnection("jdbc:mysql://" + dbServer + "/" + database + "?user=root&password=&useSSL=false&dontTrackOpenResources=true&autoReconnect=false&characterEncoding=UTF-8");
        }
        catch (SQLException e) {
            return null;
        }
    }

    private void saveTerminalData() {
        try {
            File makeDirTMaster = new File("C:\\TMaster");
            if (makeDirTMaster != null) {
                makeDirTMaster.mkdir();
            }
            FileOutputStream outputStream = new FileOutputStream("./setup.cnf");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            bufferedWriter.write("dbserver=localhost");
            bufferedWriter.newLine();
            bufferedWriter.write("database=masterdb");
            bufferedWriter.newLine();
            bufferedWriter.write("posCode=1");
            bufferedWriter.newLine();
            bufferedWriter.write("fiscalFolder=C:/TMaster/fiscal/");
            bufferedWriter.newLine();
            bufferedWriter.write("defaultQuantity=0");
            bufferedWriter.newLine();
            bufferedWriter.write("workDayClose.productsReport=0");
            bufferedWriter.newLine();
            bufferedWriter.write("workDayClose.operatorReport=0");
            bufferedWriter.newLine();
            bufferedWriter.write("workDayClose.pluReport=0");
            bufferedWriter.newLine();
            bufferedWriter.write("workDayClose.stateReport=1");
            bufferedWriter.newLine();
            bufferedWriter.write("workDayClose.dailyReport=1");
            bufferedWriter.newLine();
            bufferedWriter.write("fullscreen=true");
            bufferedWriter.newLine();
            bufferedWriter.write("loyality=false");
            bufferedWriter.newLine();
            bufferedWriter.write("uplacenIznosNeophodan=0");
            bufferedWriter.newLine();
            bufferedWriter.write("tezinskiBarKod=28");
            bufferedWriter.newLine();
            bufferedWriter.write("sabiranjeArtikala=false");
            bufferedWriter.newLine();
            bufferedWriter.write("background=C:/TMaster/trade.jpg");
            bufferedWriter.newLine();
            bufferedWriter.write("lokalizacija=sr");
            bufferedWriter.newLine();
            bufferedWriter.write("kolPLUkod=false");
            bufferedWriter.newLine();
            bufferedWriter.write("kolStanje=false");
            bufferedWriter.newLine();
            bufferedWriter.write("numerikUkljucen=true");
            bufferedWriter.newLine();
            bufferedWriter.write("jasperToPDF=C:/TMaster/PDF/");
            bufferedWriter.newLine();
            bufferedWriter.write("brojArtikalaZaUcitavanje=15");
            bufferedWriter.newLine();
            bufferedWriter.write("ponudiSledeciKod=false");
            bufferedWriter.newLine();
            bufferedWriter.write("ponudiSledeciBarKod=false");
            bufferedWriter.newLine();
            bufferedWriter.write("sinhorinizacija=false");
            bufferedWriter.newLine();
            bufferedWriter.write("srednjaNabavnaCena=false");
            bufferedWriter.newLine();
            bufferedWriter.write("serverIPaddress=localhost");
            bufferedWriter.newLine();
            bufferedWriter.write("fpDriver=FpMaster");
            bufferedWriter.newLine();
            bufferedWriter.write("trening=false");
            bufferedWriter.newLine();
            bufferedWriter.write("LpfrPutanja=");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException ex) {
            return;
        }
    }

    private void saveTerminalDataBackOffice() {
        try {
            File makeDirTMaster = new File("C:\\TMaster");
            if (makeDirTMaster != null) {
                makeDirTMaster.mkdir();
            }
            FileOutputStream outputStream = new FileOutputStream("./setup.cnf");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            bufferedWriter.write("dbserver=localhost");
            bufferedWriter.newLine();
            bufferedWriter.write("database=masterdb");
            bufferedWriter.newLine();
            bufferedWriter.write("posCode=1");
            bufferedWriter.newLine();
            bufferedWriter.write("objectId=1");
            bufferedWriter.newLine();
            bufferedWriter.write("fiscalFolder=C:/TMaster/fiscal/");
            bufferedWriter.newLine();
            bufferedWriter.write("fullscreen=false");
            bufferedWriter.newLine();
            bufferedWriter.write("jasperToPDF=C:/TMaster/PDF/");
            bufferedWriter.newLine();
            bufferedWriter.write("lokalizacija=sr");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException ex) {
            return;
        }
    }

    public int getTezinskiBarKod() {
        return this.tezinskiBarKod;
    }

    public boolean isKolPLUkod() {
        return this.kolPLUkod;
    }

    public void setKolPLUkod(boolean kolPLUkod) {
        this.kolPLUkod = kolPLUkod;
    }

    public void setTezinskiBarKod(int tezinskiBarKod) {
        this.tezinskiBarKod = tezinskiBarKod;
    }

    public int getUplacenIznos() {
        return this.uplacenIznos;
    }

    public void setUplacenIznos(int uplacenIznos) {
        this.uplacenIznos = uplacenIznos;
    }

    public boolean isLoyality() {
        return this.loyality;
    }

    public void setLoyality(boolean loyality) {
        this.loyality = loyality;
    }

    public boolean isAutomatskoZatvaranjeDana() {
        return this.automatskoZatvaranjeDana;
    }

    public void setAutomatskoZatvaranjeDana(boolean automatskoZatvaranjeDana) {
        this.automatskoZatvaranjeDana = automatskoZatvaranjeDana;
    }

    public String getVremeOtvaranjaDana() {
        return this.vremeOtvaranjaDana;
    }

    public void setVremeOtvaranjaDana(String vremeOtvaranjaDana) {
        this.vremeOtvaranjaDana = vremeOtvaranjaDana;
    }

    public static SimpleDateFormat getTimeFromatter() {
        return new SimpleDateFormat("HH:mm:ss");
    }

    public static SimpleDateFormat getDateFromatter() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }

    public static SimpleDateFormat getDateTimeFromatter() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    public static DateTimeFormatter getLocalDateTimeFromatter() {
        return DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    }

    public static DateTimeFormatter getLocalTimeFromatter() {
        return DateTimeFormatter.ofPattern("HH:mm:ss");
    }

    public static NumberFormat getNumberFormat(int fractionDigits, boolean useGrouping) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        nf.setGroupingUsed(useGrouping);
        return nf;
    }

    public static UnaryOperator<TextFormatter.Change> getDoubleFilter() {
        DecimalFormat numberFormat = (DecimalFormat)DecimalFormat.getNumberInstance();
        final String decSep = "" + numberFormat.getDecimalFormatSymbols().getDecimalSeparator();
        UnaryOperator<TextFormatter.Change> filter = new UnaryOperator<TextFormatter.Change>(){

            @Override
            public TextFormatter.Change apply(TextFormatter.Change t) {
                if (t.isReplaced() && t.getText().matches("[^0-9]")) {
                    t.setText(t.getControlText().substring(t.getRangeStart(), t.getRangeEnd()));
                }
                if (t.isAdded()) {
                    if (t.getControlText().contains(decSep)) {
                        if (t.getText().matches("[^0-9]")) {
                            t.setText("");
                        }
                    } else if (t.getText().matches("[^0-9" + decSep + "]")) {
                        t.setText("");
                    }
                }
                return t;
            }
        };
        return filter;
    }

    public static UnaryOperator<TextFormatter.Change> getDoubleFilterWithDecimal() {
        DecimalFormat numberFormat = (DecimalFormat)DecimalFormat.getNumberInstance();
        final String decSep = "" + numberFormat.getDecimalFormatSymbols().getDecimalSeparator();
        UnaryOperator<TextFormatter.Change> filter = new UnaryOperator<TextFormatter.Change>(){

            @Override
            public TextFormatter.Change apply(TextFormatter.Change t) {
                if (t.isReplaced() && t.getText().matches("[^0-9] -")) {
                    t.setText(t.getControlText().substring(t.getRangeStart(), t.getRangeEnd()));
                }
                if (t.isAdded()) {
                    if (t.getControlText().contains(decSep) || t.getControlText().contains(".")) {
                        if (t.getText().matches("[^0-9]")) {
                            t.setText("");
                        }
                    } else if (t.getText().matches("[^0-9.,]")) {
                        t.setText("");
                    }
                }
                return t;
            }
        };
        return filter;
    }

    public static void makeHeaderWrappable(TableColumn<?, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.CENTER);
        label.setTextAlignment(TextAlignment.CENTER);
        StackPane stack = new StackPane();
        stack.getChildren().add((java.lang.Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }

    public static java.util.Date fromLocalDate(LocalDate date) {
        Instant instant = date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return java.util.Date.from(instant);
    }

    public static java.util.Date DatefromLocalDateTime(LocalDateTime date) {
        Instant instant = date.atZone(ZoneId.systemDefault()).toInstant();
        return java.util.Date.from(instant);
    }

    public static LocalDate fromDate(java.util.Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime LocalDateTimefromDate(java.util.Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public String getSetting(String setting, PointOfSale pos) {
        String query = "select s.actual   from settings s  where s.name = ? and s.PointOfSaleID = ? union all select s.actual  from settings s where s.name = ? and s.PointOfSaleID is null limit 1";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setString(1, setting);
            if (pos != null) {
                ps.setInt(2, pos.getPointOfSaleID());
            } else {
                ps.setNull(2, 4);
            }
            ps.setString(3, setting);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getString(1);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public boolean getRow(String name) {
        boolean row = true;
        String query = "SELECT * FROM settings s where s.name = '" + name + "'";
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            if (rSet.next()) {
                row = false;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return row;
    }

    public boolean getRowLike(String name) {
        boolean row = true;
        String query = "SELECT * FROM settings s where s.name LIKE  '%" + name + "%'";
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            if (rSet.next()) {
                row = false;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return row;
    }

    public ObservableList<Settings> getList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from settings";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add((java.lang.Object)new Settings(rs.getLong("id"), rs.getString("actual"), rs.getString("name")));
            }
        }
        catch (SQLException e) {
            return null;
        }
        return list;
    }

    public StringConverter<LocalDate> getDatePickerConverter() {
        return new StringConverter<LocalDate>(){
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

            public String toString(LocalDate date) {
                if (date != null) {
                    return this.dateFormatter.format(date);
                }
                return "";
            }

            public LocalDate fromString(String string) {
                if (string != null && !string.isEmpty()) {
                    return LocalDate.parse(string, this.dateFormatter);
                }
                return null;
            }
        };
    }

    public static void startInfoAnimation(String labelText, Label label, int cycleCount, int fontSize) {
        label.setText(labelText);
        label.setStyle("-fx-background-color: #7CB72A;-fx-font-weight: bold;-fx-text-fill: black;-fx-font-size: " + fontSize + "px");
        label.setVisible(true);
        FadeTransition transtitionStart = new FadeTransition();
        transtitionStart.setNode((Node)label);
        transtitionStart.setDuration(new Duration(1000.0));
        transtitionStart.setFromValue(1.0);
        transtitionStart.setToValue(0.0);
        transtitionStart.setCycleCount(cycleCount);
        transtitionStart.setAutoReverse(true);
        transtitionStart.play();
    }

    public static void stopInfoAnimation(Label label) {
        label.setStyle("-fx-background-color: #21252e;-fx-font-weight: bold;-fx-text-fill: #21252e;-fx-font-size: 0px");
    }

    public static StringConverter<Product> getProductStringConverter(final ObservableList<Product> productList, final int cbType) {
        new StringConverter<Product>(){

            public Product fromString(String string) {
                Product p = null;
                for (int i = 0; i < productList.size(); ++i) {
                    if (cbType == ScreensController.COMBOBOX_PRODUCT_CODE && (((Product)productList.get(i)).getCode() + " " + ((Product)productList.get(i)).getName()).toLowerCase().equals(string.toLowerCase())) {
                        p = (Product)productList.get(i);
                    }
                    if (cbType == ScreensController.COMBOBOX_BARCODE && ((Product)productList.get(i)).getBarcodeLast().toLowerCase().equals(string.toLowerCase())) {
                        p = (Product)productList.get(i);
                    }
                    if (cbType != ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE || !(((Product)productList.get(i)).getCode() + " " + ((Product)productList.get(i)).getName() + " " + ((Product)productList.get(i)).getBarcodeLast()).toLowerCase().equals(string.toLowerCase())) continue;
                    p = (Product)productList.get(i);
                }
                return p;
            }

            public String toString(Product object) {
                if (object == null) {
                    return "";
                }
                String p = "";
                if (cbType == ScreensController.COMBOBOX_PRODUCT_CODE) {
                    p = object.getCode() + " " + object.getName();
                }
                if (cbType == ScreensController.COMBOBOX_BARCODE) {
                    p = object.getBarcodeLast();
                }
                if (cbType == ScreensController.COMBOBOX_PRODUCT_CODE_BARCODE) {
                    p = object.getCode() + " " + object.getName() + " " + object.getBarcodeLast();
                }
                return p;
            }
        };
        return null;
    }

    public void runTask(String info, Window owner) {
        double wndwWidth = 300.0;
        Label updateLabel = new Label(info);
        updateLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 20px; -fx-alignment: CENTER;");
        updateLabel.setPrefWidth(300.0);
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefWidth(300.0);
        VBox updatePane = new VBox();
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((java.lang.Object[])new Node[]{updateLabel, progress});
        final Stage taskUpdateStage = new Stage();
        taskUpdateStage.setScene(new Scene((Parent)updatePane));
        taskUpdateStage.initOwner(owner);
        taskUpdateStage.initModality(Modality.WINDOW_MODAL);
        taskUpdateStage.initStyle(StageStyle.UTILITY);
        taskUpdateStage.show();
        Task<Void> longTask = new Task<Void>(){

            protected Void call() throws Exception {
                int max = 50;
                for (int i = 1; i <= max && this.isCancelled(); ++i) {
                    this.updateProgress(i, max);
                    this.updateMessage("Task part " + String.valueOf(i) + " complete");
                }
                return null;
            }
        };
        longTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                taskUpdateStage.hide();
            }
        });
        progress.progressProperty().bind((ObservableValue)longTask.progressProperty());
        updateLabel.textProperty().bind((ObservableValue)longTask.messageProperty());
        taskUpdateStage.show();
        new Thread((Runnable)longTask).start();
    }

    public Node getProgressInfoStage(String info) {
        double wndwWidth = 300.0;
        Label updateLabel = new Label(info);
        updateLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 20px; -fx-alignment: CENTER;");
        updateLabel.setPrefWidth(300.0);
        updateLabel.setMaxWidth(Double.MAX_VALUE);
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefWidth(300.0);
        progress.setMaxWidth(Double.MAX_VALUE);
        VBox updatePane = new VBox();
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((java.lang.Object[])new Node[]{updateLabel, progress});
        return updatePane;
    }

    public Stage getInfoStage(String info, Window owner) {
        double wndwWidth = 350.0;
        Label updateLabel = new Label(info);
        updateLabel.setPrefHeight(200.0);
        updateLabel.setWrapText(true);
        updateLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 19px; -fx-alignment: CENTER;");
        updateLabel.setPrefWidth(350.0);
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefWidth(owner.getWidth() / 2.0);
        progress.setPrefHeight(owner.getHeight() / 4.0);
        VBox updatePane = new VBox();
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setAlignment(Pos.CENTER);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((java.lang.Object[])new Node[]{progress, updateLabel});
        this.taskUpdateStage = new Stage();
        this.taskUpdateStage.setScene(new Scene((Parent)updatePane));
        this.taskUpdateStage.initOwner(owner);
        this.taskUpdateStage.initModality(Modality.WINDOW_MODAL);
        this.taskUpdateStage.initStyle(StageStyle.UNDECORATED);
        this.taskUpdateStage.show();
        return this.taskUpdateStage;
    }

    public Stage getInfoStageNew(String info, Window owner) {
        double wndwWidth = 350.0;
        Label updateLabel = new Label(info);
        updateLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 19px; -fx-alignment: CENTER;");
        updateLabel.setPrefWidth(350.0);
        FillProgressIndicator progress = new FillProgressIndicator();
        progress.setPrefWidth(140.0);
        VBox updatePane = new VBox();
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setAlignment(Pos.CENTER);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((java.lang.Object[])new Node[]{progress, updateLabel});
        this.taskUpdateStage = new Stage();
        this.taskUpdateStage.setScene(new Scene((Parent)updatePane));
        this.taskUpdateStage.initOwner(owner);
        this.taskUpdateStage.initModality(Modality.WINDOW_MODAL);
        this.taskUpdateStage.initStyle(StageStyle.UNDECORATED);
        this.taskUpdateStage.show();
        return this.taskUpdateStage;
    }

    public Stage getTimerInfoStage(String info, Window owner) {
        double wndwWidth = 350.0;
        SimpleDoubleProperty timeSeconds = new SimpleDoubleProperty();
        Label timerLabel = new Label();
        timerLabel.setText("00:00:00");
        timerLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 19px; -fx-alignment: CENTER;");
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), (EventHandler)new EventHandler<ActionEvent>((DoubleProperty)timeSeconds){
            final /* synthetic */ DoubleProperty val$timeSeconds;
            {
                this.val$timeSeconds = doubleProperty;
            }

            public void handle(ActionEvent t) {
                Duration duration = ((KeyFrame)t.getSource()).getTime();
                Settings.this.time = Settings.this.time.add(duration);
                Settings.this.splitTime = Settings.this.splitTime.add(duration);
                this.val$timeSeconds.set(Settings.this.time.toSeconds());
            }
        }, new KeyValue[0])});
        timeline.setCycleCount(-1);
        timeline.play();
        VBox updatePane = new VBox();
        updatePane.setPrefWidth(350.0);
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setAlignment(Pos.CENTER);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((java.lang.Object[])new Node[]{timerLabel});
        this.taskUpdateStage = new Stage();
        this.taskUpdateStage.setScene(new Scene((Parent)updatePane));
        this.taskUpdateStage.initOwner(owner);
        this.taskUpdateStage.initModality(Modality.WINDOW_MODAL);
        this.taskUpdateStage.initStyle(StageStyle.UNDECORATED);
        this.taskUpdateStage.show();
        return this.taskUpdateStage;
    }

    public String getActualByName(String name) {
        try {
            PreparedStatement ps = this.getConnection().prepareStatement("SELECT s.actual FROM settings s WHERE s.name = '" + name + "'");
            ResultSet rs = ps.executeQuery();
            rs.next();
            this.actual = rs.getString(1);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            this.actual = null;
        }
        return this.actual;
    }

    public void update(ScreensController controller) {
        String query = "UPDATE settings SET actual = ? WHERE name = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.actual);
            pStatement.setString(2, this.name);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public void insert(String name, String actual) {
        String query = "INSERT INTO `" + this.getDatabase() + "`.`settings` (`actual`, `name`) VALUES (?, '" + name + "');";
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement(query);
            if (actual.equals("")) {
                pStatement.setNull(1, 12);
            } else {
                pStatement.setString(1, actual);
            }
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static double test(Product selectedProduct, Department department, LocalDate dpTo, ScreensController controller) throws SQLException {
        LocalDateTime datumPocetnogStanja = WorkDay.datumPocetnogStanja(department.getDepartmentID(), Settings.fromLocalDate(dpTo), controller.getSettings().getConnection());
        ObservableList<Prijemnica> prijemnicaList = Prijemnica.getList(Settings.DatefromLocalDateTime(datumPocetnogStanja), Settings.fromLocalDate(dpTo), department, -1L, controller);
        double stock = Product.getStockByProduct(selectedProduct, datumPocetnogStanja, controller);
        int brojPrijemnica = 0;
        double rez = 0.0;
        double purchaceValue = 0.0;
        boolean exit = false;
        if (stock > 0.0) {
            for (Prijemnica prijemnica : prijemnicaList) {
                ObservableList<DocumentDetails> documentDetailsList = DocumentDetails.getObeservableList(prijemnica.getDocumentID(), controller.getSettings().getConnection());
                for (DocumentDetails documentDetails : documentDetailsList) {
                    if (selectedProduct.getProductID() != documentDetails.getProductID()) continue;
                    ++brojPrijemnica;
                    if ((rez += documentDetails.getQuantity()) < stock) {
                        purchaceValue += documentDetails.getPriceWithDiscount();
                        continue;
                    }
                    if (rez == 0.0) continue;
                    purchaceValue += documentDetails.getPriceWithDiscount();
                    purchaceValue /= (double)brojPrijemnica;
                    exit = true;
                }
                if (!exit) continue;
                break;
            }
        }
        return purchaceValue;
    }

    public static double roundOnTwo(double sum1) {
        double sum = sum1 * 1000.0;
        sum = Math.floor(sum);
        sum /= 1000.0;
        sum *= 100.0;
        sum = Math.round(sum);
        return sum /= 100.0;
    }

    public static double roundOnThree(double sum1) {
        double sum = (double)Math.round((float)sum1 * 1000.0f) / 1000.0;
        return sum;
    }

    public static Date sqlDateFromLocalDate(LocalDate date) {
        return Date.valueOf(date);
    }

    public static java.util.Date getFirstDateOfMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static String formatLocalDate(LocalDate localDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        String d = formatter.format(localDate);
        return d;
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        String dt = formatter.format(localDateTime);
        return dt;
    }

    public String getPutanjaSertifikat() {
        return this.putanjaSertifikat;
    }

    public String getLCD() {
        return this.LCD;
    }

    public void setLCD(String LCD) {
        this.LCD = LCD;
    }

    public String getActualByLike(String s) {
        try {
            PreparedStatement ps = this.getConnection().prepareStatement("SELECT s.name FROM settings s WHERE s.name LIKE '%" + s + "%'");
            ResultSet rs = ps.executeQuery();
            rs.next();
            String name = rs.getString(1);
            String[] array = name.split("\\.");
            String lastIndex = array[array.length - 1];
            System.out.println("Last index " + lastIndex);
            ps.close();
            rs.close();
            return lastIndex;
        }
        catch (Exception e) {
            LOGGER.warning("Greska u logici" + e.getMessage());
            return "23:59:59";
        }
    }
}

