/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.util.ArrayList;
import java.util.Date;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.OfferPrice;
import rs.petcom.master.dal.OfferPriceDetailes;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.RoundItemDescription;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductDepartment;

public class Round {
    Date vreme;
    ArrayList<RoundItem> itemList = new ArrayList();
    ArrayList<RoundItem> offerGroup = new ArrayList();
    ArrayList<Long> offerPriceList = new ArrayList();
    ArrayList<RoundItem> itemsInOfferPrice;

    public void setOfferGroup(ArrayList<RoundItem> offerGroup) {
        this.offerGroup = offerGroup;
    }

    public ArrayList<RoundItem> getOfferGroup() {
        return this.offerGroup;
    }

    public ArrayList<RoundItem> getItemList() {
        return this.itemList;
    }

    public void setItemList(ArrayList<RoundItem> itemList) {
        this.itemList = itemList;
    }

    public void addRoundItem(RoundItem roundItem) {
        boolean inserted = false;
        if (roundItem.getAdditionalList().size() == 0 && roundItem.getDescriptionalList().size() == 0) {
            for (int i = 0; i < this.itemList.size(); ++i) {
                if (this.itemList.get(i).getProductDepartment().getProduct().getProductID() != roundItem.getProductDepartment().getProduct().getProductID() || this.itemList.get(i).getAdditionalList().size() != 0) continue;
                this.itemList.get(i).setQuantity(this.itemList.get(i).getQuantity() + roundItem.getQuantity());
                inserted = true;
                break;
            }
        }
        if (!inserted) {
            this.itemList.add(roundItem);
        }
    }

    public void addAdtitionalToLastItem(ProductDepartment product, double quantity) {
        boolean inserted = false;
        RoundItem lastItem = this.itemList.get(this.itemList.size() - 1);
        for (int i = 0; i < lastItem.getAdditionalList().size(); ++i) {
            if (lastItem.getAdditionalList().get(i).getProductDepartment().getProduct().getProductID() != product.getProductID()) continue;
            lastItem.getAdditionalList().get(i).setQuantity(lastItem.getAdditionalList().get(i).getQuantity() + quantity);
            inserted = true;
            break;
        }
        if (!inserted) {
            RoundItem newItem = new RoundItem();
            newItem.setProductDepartment(product);
            newItem.setQuantity(quantity);
            lastItem.getAdditionalList().add(newItem);
        }
    }

    public void addDescriptionalToLastItem(RoundItemDescription description) {
        int i;
        boolean inserted = false;
        RoundItem lastItem = this.itemList.get(this.itemList.size() - 1);
        double quantityOfDescriptionItems = 0.0;
        for (i = 0; i < lastItem.getDescriptionalList().size(); ++i) {
            quantityOfDescriptionItems += lastItem.getDescriptionalList().get(i).getQuantity();
        }
        if (quantityOfDescriptionItems < lastItem.getQuantity()) {
            for (i = 0; i < lastItem.getDescriptionalList().size(); ++i) {
                if (lastItem.getDescriptionalList().get(i).getDescription().getDescriptionID() != description.getDescription().getDescriptionID()) continue;
                lastItem.getDescriptionalList().get(i).setQuantity(lastItem.getDescriptionalList().get(i).getQuantity() + description.getQuantity());
                inserted = true;
                break;
            }
            if (!inserted) {
                if (lastItem.getQuantity() - quantityOfDescriptionItems >= description.getQuantity()) {
                    lastItem.getDescriptionalList().add(description);
                } else {
                    description.setQuantity(lastItem.getQuantity() - quantityOfDescriptionItems);
                    lastItem.getDescriptionalList().add(description);
                }
            }
        }
    }

    public void addDescriptionalToItem(int index, RoundItemDescription description) {
        int i;
        boolean inserted = false;
        RoundItem item = this.itemList.get(index);
        double quantityOfDescriptionItems = 0.0;
        for (i = 0; i < item.getDescriptionalList().size(); ++i) {
            quantityOfDescriptionItems += item.getDescriptionalList().get(i).getQuantity();
        }
        if (quantityOfDescriptionItems < item.getQuantity()) {
            for (i = 0; i < item.getDescriptionalList().size(); ++i) {
                if (item.getDescriptionalList().get(i).getDescription().getDescriptionID() != description.getDescription().getDescriptionID()) continue;
                item.getDescriptionalList().get(i).setQuantity(item.getDescriptionalList().get(i).getQuantity() + description.getQuantity());
                inserted = true;
                break;
            }
            if (!inserted) {
                item.getDescriptionalList().add(description);
            }
        }
    }

    public boolean cleanupLast() {
        boolean cleanupDone = false;
        try {
            RoundItem lastItem = this.itemList.get(this.itemList.size() - 1);
            if (lastItem.getAdditionalList().size() == 0 && lastItem.getDescriptionalList().size() == 0) {
                for (int i = 0; i < this.itemList.size() - 1; ++i) {
                    if (!this.itemList.get(i).getProductDepartment().getProduct().equals(lastItem.getProductDepartment().getProduct()) || this.itemList.get(i).getAdditionalList().size() != 0 || this.itemList.get(i).getDescriptionalList().size() != 0) continue;
                    this.itemList.get(i).setQuantity(this.itemList.get(i).getQuantity() + lastItem.getQuantity());
                    cleanupDone = true;
                    break;
                }
            }
            if (cleanupDone) {
                this.itemList.remove(this.itemList.size() - 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return cleanupDone;
    }

    public double getSumWithDiscount() {
        double sum = 0.0;
        for (RoundItem ri : this.itemList) {
            sum += ri.getSumWithDiscount();
        }
        return sum;
    }

    public double getFinalSumWithDiscount() {
        double sum = 0.0;
        for (RoundItem ri : this.itemList) {
            double quantity = Settings.roundOnThree(ri.getQuantity());
            double price = ri.getProductDepartment().getProduct().getPrice();
            double diff = Settings.roundOnTwo(price - price * ri.getProductDepartment().getProduct().getDiscount() / 100.0);
            double value = Settings.roundOnTwo(quantity * diff);
            System.out.println(value);
            sum += value;
        }
        return sum;
    }

    public double getSumQuantity(long productID) {
        double quantity = 0.0;
        for (int i = 0; i < this.itemList.size(); ++i) {
            if (productID != this.itemList.get(i).getProductDepartment().getProductID()) continue;
            quantity += this.itemList.get(i).getQuantity();
        }
        return quantity;
    }

    public double getDiscount() {
        double sum = 0.0;
        for (RoundItem ri : this.itemList) {
            sum += ri.getDiscount();
        }
        return sum;
    }

    public void removeAllItems() {
        this.itemList.clear();
    }

    public boolean eqals(Round newRound) {
        return this.vreme == newRound.vreme;
    }

    public boolean createOrder() {
        boolean result = false;
        for (RoundItem ri : this.itemList) {
            if (ri.getProductDepartment().getKitchenDisplayID() <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    public void setDiscountIfNotZero(double discount) {
        for (RoundItem roundItem : this.itemList) {
            roundItem.setDiscountIfNotZero(discount);
        }
    }

    public void setDiscountIfNotInOffer(double discount) {
        for (RoundItem roundItem : this.itemList) {
            if (roundItem.isAlreadyInOfferPrice()) continue;
            roundItem.getProductDepartment().getProduct().setDiscount(discount);
        }
    }

    public void setDiscount(double discount) {
        for (RoundItem roundItem : this.itemList) {
            roundItem.getProductDepartment().getProduct().setPrice(roundItem.getRegularPrice());
            roundItem.getProductDepartment().getProduct().setDiscount(discount);
        }
    }

    public void recalculateOfferPrices() {
        this.offerPriceList.clear();
        this.itemsInOfferPrice = new ArrayList();
        for (RoundItem roundItem : this.itemList) {
            int i;
            if (roundItem.getOfferPriceDetails() == null || this.offerPriceList.contains(roundItem.getOfferPriceDetails().getOfferPriceID())) continue;
            this.offerPriceList.add(roundItem.getOfferPriceDetails().getOfferPriceID());
            for (i = 0; i < this.itemList.size(); ++i) {
                if (this.itemList.get(i).getOfferPriceDetails() == null || this.itemList.get(i).getOfferPriceDetails().getOfferPriceID() != roundItem.getOfferPriceDetails().getOfferPriceID()) continue;
                this.itemsInOfferPrice.add(this.itemList.get(i));
                this.itemList.get(i).getProductDepartment().getProduct().setPrice(this.itemList.get(i).getRegularPrice());
                this.itemList.get(i).setAlreadyInOfferPrice(true);
                if (this.itemsInOfferPrice.size() % this.itemList.get(i).getOfferPriceDetails().getOfferPriceQuantity() != 0) continue;
                RoundItem minPriceItem = this.getMinPriceWithinOfferGroup(this.itemsInOfferPrice, this.itemList.get(i).getOfferPriceDetails().getOfferPriceQuantity());
                if (minPriceItem.getOfferPriceDetails().getPrice() > 0.0) {
                    minPriceItem.getProductDepartment().getProduct().setPrice(minPriceItem.getOfferPriceDetails().getPrice());
                } else {
                    minPriceItem.getProductDepartment().getProduct().setPrice(minPriceItem.getRegularPrice() * minPriceItem.getOfferPriceDetails().getDiscount() / 100.0);
                }
                this.itemsInOfferPrice.clear();
            }
            for (i = 0; i < this.itemsInOfferPrice.size(); ++i) {
                this.itemsInOfferPrice.get(i).setAlreadyInOfferPrice(false);
            }
        }
    }

    public void recalculateOfferPricewNewRountActive(ScreensController controller) {
        for (int i = 0; i < controller.getBillList().get(0).getRoundList().get(0).getItemList().size(); ++i) {
            controller.getBillList().get(0).getRoundList().get(0).getItemList().get(i).getQuantity();
            OfferPriceDetailes offerPriceDetailes = OfferPriceDetailes.getRoundActive(controller.getBillList().get(0).getRoundList().get(0).getItemList().get(i).getProductDepartment().getProductID(), controller.getSettings().getConnection());
            if (controller.getBillList().get(0).getRoundList().get(0).getItemList().get(i).getQuantity() % offerPriceDetailes.getQuantity() != 0.0) continue;
            if (offerPriceDetailes.getPrice() > 0.0) {
                controller.getBillList().get(0).getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().setDiscount((controller.getBillList().get(0).getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getPrice() - offerPriceDetailes.getPrice()) * 100.0 / controller.getBillList().get(0).getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getPrice());
                continue;
            }
            if (!(offerPriceDetailes.getDiscount() > 0.0)) continue;
            controller.getBillList().get(0).getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().setDiscount(offerPriceDetailes.getDiscount());
        }
    }

    public void recalculateOfferPricesNew(ScreensController controller) {
        this.offerPriceList.clear();
        this.itemsInOfferPrice = new ArrayList();
        for (RoundItem roundItem : this.itemList) {
            int i;
            if (roundItem.getOfferPriceDetails() == null || this.offerPriceList.contains(roundItem.getOfferPriceDetails().getOfferPriceID())) continue;
            this.offerPriceList.add(roundItem.getOfferPriceDetails().getOfferPriceID());
            for (i = 0; i < this.itemList.size(); ++i) {
                if (this.itemList.get(i).getOfferPriceDetails() == null || this.itemList.get(i).getOfferPriceDetails().getOfferPriceID() != roundItem.getOfferPriceDetails().getOfferPriceID()) continue;
                this.itemsInOfferPrice.add(this.itemList.get(i));
                this.itemList.get(i).getProductDepartment().getProduct().setPrice(this.itemList.get(i).getRegularPrice());
                this.itemList.get(i).setAlreadyInOfferPrice(true);
                OfferPrice offerPrice = OfferPrice.getOfferPrice(this.itemList.get(i).getOfferPriceDetails().getOfferPriceID(), controller.getSettings().getConnection());
                boolean zaokruzi = true;
                if (offerPrice.isRoundActive()) {
                    for (RoundItem roundI : this.itemList) {
                        double popust;
                        if (zaokruzi) {
                            try {
                                if (roundI.getOfferPriceDetails().getOfferPriceDetailsID() == this.itemList.get(i).getOfferPriceDetails().getOfferPriceDetailsID()) {
                                    popust = (roundI.getProductDepartment().getProduct().getPrice() - roundI.getOfferPriceDetails().getPrice()) * 100.0 / roundI.getProductDepartment().getProduct().getPrice();
                                    roundI.getProductDepartment().getProduct().setDiscount(popust);
                                    zaokruzi = true;
                                }
                            }
                            catch (NullPointerException e) {
                                zaokruzi = false;
                            }
                        }
                        if (zaokruzi) continue;
                        if (this.itemList.get(i).getOfferPriceDetails().getQuantity() == roundI.getQuantity()) {
                            try {
                                if (roundItem.getOfferPriceDetails().getPrice() > 0.0) {
                                    popust = (roundI.getProductDepartment().getProduct().getPrice() - roundI.getOfferPriceDetails().getPrice()) * 100.0 / roundI.getProductDepartment().getProduct().getPrice();
                                    roundI.getProductDepartment().getProduct().setDiscount(popust);
                                    zaokruzi = true;
                                } else if (offerPrice.isFirstPrice()) {
                                    double cena = Product.getCurrentPrice(roundI.getProductDepartment().getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), offerPrice.isFirstPrice(), controller.getSettings().getConnection());
                                    double cenaSaPopustom = cena * roundI.getOfferPriceDetails().getDiscount() / 100.0;
                                    double popust2 = (roundI.getRegularPrice() - cenaSaPopustom) * 100.0 / roundI.getRegularPrice();
                                    roundI.getProductDepartment().getProduct().setDiscount(popust2);
                                    roundI.getProductDepartment().getProduct().setPrice(roundI.getRegularPrice());
                                } else {
                                    roundI.getProductDepartment().getProduct().setDiscount(roundItem.getOfferPriceDetails().getDiscount());
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            this.itemsInOfferPrice.clear();
                        }
                        zaokruzi = true;
                    }
                    continue;
                }
                if ((double)this.itemsInOfferPrice.size() % this.itemList.get(i).getOfferPriceDetails().getQuantity() != 0.0) continue;
                RoundItem minPriceItem = this.getMinPriceWithinOfferGroup(this.itemsInOfferPrice, this.itemList.get(i).getOfferPriceDetails().getOfferPriceQuantity());
                if (minPriceItem.getOfferPriceDetails().getPrice() > 0.0) {
                    double popust = (roundItem.getProductDepartment().getProduct().getPrice() - minPriceItem.getOfferPriceDetails().getPrice()) * 100.0 / roundItem.getProductDepartment().getProduct().getPrice();
                    minPriceItem.getProductDepartment().getProduct().setDiscount(popust);
                } else if (offerPrice.isFirstPrice()) {
                    double cena = Product.getCurrentPrice(minPriceItem.getProductDepartment().getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), offerPrice.isFirstPrice(), controller.getSettings().getConnection());
                    double cenaSaPopustom = cena * minPriceItem.getOfferPriceDetails().getDiscount() / 100.0;
                    double popust = (minPriceItem.getRegularPrice() - cenaSaPopustom) * 100.0 / minPriceItem.getRegularPrice();
                    minPriceItem.getProductDepartment().getProduct().setDiscount(popust);
                    minPriceItem.getProductDepartment().getProduct().setPrice(minPriceItem.getRegularPrice());
                } else {
                    minPriceItem.getProductDepartment().getProduct().setDiscount(minPriceItem.getOfferPriceDetails().getDiscount());
                }
                this.itemsInOfferPrice.clear();
            }
            for (i = 0; i < this.itemsInOfferPrice.size(); ++i) {
                this.itemsInOfferPrice.get(i).setAlreadyInOfferPrice(false);
            }
        }
    }

    private RoundItem getMinPriceWithinOfferGroup(ArrayList<RoundItem> list, int kolicina) {
        RoundItem minPriceItem = new RoundItem();
        minPriceItem.setRegularPrice(1000000.0);
        for (int i = 0; i < kolicina; ++i) {
            if (!(minPriceItem.getRegularPrice() >= list.get(i).getRegularPrice())) continue;
            minPriceItem = list.get(i);
        }
        return minPriceItem;
    }

    public static double roundOnTwo(double sum1) {
        double sum = (double)Math.round(sum1 * 1000.0) / 1000.0;
        sum = (double)Math.round(sum * 100.0) / 100.0;
        return sum;
    }
}

