/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class Role {
    private int RoleID;
    private String Code;
    private String Name;
    private boolean Active;
    private boolean selected;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getRoleID() {
        return this.RoleID;
    }

    public void setRoleID(int roleID) {
        this.RoleID = roleID;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public String toString() {
        return this.Name;
    }

    public static ArrayList<Role> getList(long userId, Connection connection) {
        ArrayList<Role> list = new ArrayList<Role>();
        try {
            PreparedStatement ps = connection.prepareStatement("select *   from userrole ur   left join role r on ur.RoleID = r.RoleID  where (ur.UserID =  ?) and (ur.Active = true) and (r.Active = true)");
            ps.setLong(1, userId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Role role = new Role();
                role.RoleID = rs.getInt("RoleID");
                role.Code = rs.getString("Code");
                role.Name = rs.getString("Name");
                role.Active = rs.getBoolean("Active");
                list.add(role);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Role> getRole(long userID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT r.Name FROM role r JOIN userrole ur ON ur.RoleID = r.RoleID JOIN user u ON u.UserID = ur.UserID WHERE u.UserID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Role role = new Role();
                role.Name = rs.getString("Name");
                list.add((Object)role);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Role getRole(String code, ScreensController controller) {
        String query = "SELECT r.* FROM role r WHERE r.Code = ?";
        Role role = new Role();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            rs.next();
            role.RoleID = rs.getInt("RoleID");
            role.Code = rs.getString("Code");
            role.Name = rs.getString("Name");
            role.Active = rs.getBoolean("Active");
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return role;
    }

    public static ObservableList<Role> getRoleList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM role ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Role role = new Role();
                role.RoleID = rs.getInt("RoleID");
                role.Code = rs.getString("Code");
                role.Name = rs.getString("Name");
                role.Active = rs.getBoolean("Active");
                list.add((Object)role);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Role> getRoleLightList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM role where RoleID IN(2,4,5,8,9,11)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Role role = new Role();
                role.RoleID = rs.getInt("RoleID");
                role.Code = rs.getString("Code");
                role.Name = rs.getString("Name");
                role.Active = rs.getBoolean("Active");
                list.add((Object)role);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Role> getRoleId(long userID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT upos.* FROM userrole upos WHERE upos.UserID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Role role = new Role();
                role.RoleID = rs.getInt("RoleID");
                list.add((Object)role);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public boolean equals(Object obj) {
        return obj instanceof Role ? ((Role)obj).getRoleID() == this.RoleID : false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static void insertRoleMasterDB(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`role` (`Code`, `Name`) VALUES ('vise.racuna', 'Vi\u0161e ra\u010duna');";
        try {
            PreparedStatement statement = controller.getSettings().getConnection().prepareStatement(query);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insertRoleMasterDB(ScreensController controller, String role, String roleName) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`role` (`Code`, `Name`) VALUES (?, ?);";
        try {
            PreparedStatement statement = controller.getSettings().getConnection().prepareStatement(query);
            statement.setString(1, role);
            statement.setString(2, roleName);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

