/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.summary.RazlikaUCenuSummary;

public class RazlikaUCeni {
    private ScreensController controller;
    private Connection connection;
    private Product product;
    private double quantity;
    private double purchacePrice;
    private double sellPrice;
    private double differencePrice;
    private double purchaceValue;
    private double sellValue;
    private double differenceValue;
    private ObservableList<RazlikaUCenuSummary> rucSummaryList;

    public RazlikaUCeni() {
    }

    public RazlikaUCeni(ScreensController controller) {
        this.controller = controller;
        this.connection = controller.getSettings().getConnection();
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getPurchacePrice() {
        return this.purchacePrice;
    }

    public void setPurchacePrice(double purchacePrice) {
        this.purchacePrice = purchacePrice;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(double sellPrice) {
        this.sellPrice = sellPrice;
    }

    public double getDifferencePrice() {
        return this.differencePrice;
    }

    public void setDifferencePrice(double differencePrice) {
        this.differencePrice = differencePrice;
    }

    public double getPurchaceValue() {
        return this.purchaceValue;
    }

    public void setPurchaceValue(double purchaceValue) {
        this.purchaceValue = purchaceValue;
    }

    public double getSellValue() {
        return this.sellValue;
    }

    public void setSellValue(double sellValue) {
        this.sellValue = sellValue;
    }

    public double getDifferenceValue() {
        return this.differenceValue;
    }

    public void setDifferenceValue(double differenceValue) {
        this.differenceValue = differenceValue;
    }

    public ObservableList<RazlikaUCenuSummary> getRucSummaryList() {
        return this.rucSummaryList;
    }

    public ObservableList<RazlikaUCeni> getRazlikaUceniListByDateLAST(LocalDate dateFrom, LocalDate dateTo) {
        RazlikaUCenuSummary rucSummary = new RazlikaUCenuSummary();
        Date from = Settings.sqlDateFromLocalDate(dateFrom);
        Date to = Settings.sqlDateFromLocalDate(dateTo);
        String query = "SELECT ProductId, PriceWithDiscount, SUM(Quantity) AS Quantity, COALESCE(PPrice,0) AS PurchasePrice FROM \r\n\t(SELECT dd.ProductID, dd.PriceWithDiscount, \r\n\tROUND((SELECT (dd1.PurchacePrice * v.Value)  FROM documentdetails dd1 \r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tJOIN product p1 ON dd1.ProductID = p1.ProductID\r\n\t\tJOIN vat v ON p1.VatID = v.VatID \r\n\t\tWHERE d1.DocumentTypeID = 1 AND dd1.ProductID = dd.ProductID\r\n\t\tAND CAST(d1.Date AS DATE) <= CAST(d.Date AS DATE)\r\n\t\tORDER BY d1.date desc LIMIT 1), 2) AS PPrice, \r\n\tdd.Quantity FROM documentdetails dd \r\n\t\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID \r\n\t\tWHERE d.DocumentTypeID = 3  AND d.DocumentStatusID IN (1,2) \r\n\t\tAND CAST(d.Date AS DATE)BETWEEN CAST(? AS DATE) AND CAST(? AS DATE) \r\n\t\torder BY dd.ProductId) AS trt \r\ngroup BY ProductId, PPrice, PriceWithDiscount";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = this.connection.prepareStatement(query);
            pStatement.setDate(1, from);
            pStatement.setDate(2, to);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                long productId = rSet.getLong("ProductID");
                Product product = Product.getByID(productId, this.controller);
                RazlikaUCeni razlikaUCeni = this.makeRUC(rSet, product);
                this.addRucSumary(razlikaUCeni, rucSummary);
                list.add((Object)razlikaUCeni);
            }
            this.setRucSummaryList(rucSummary);
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ObservableList<RazlikaUCeni> getRazlikaUceniListByDateAVG(LocalDate dateFrom, LocalDate dateTo) {
        RazlikaUCenuSummary rucSummary = new RazlikaUCenuSummary();
        Date from = Settings.sqlDateFromLocalDate(dateFrom);
        Date to = Settings.sqlDateFromLocalDate(dateTo);
        String params = "SET @dateFrom = ?, @dateTo = ?";
        String query = "SELECT ProductId, PriceWithDiscount, SUM(Quantity) AS Quantity, COALESCE(PPrice,0) AS PurchasePrice FROM \r\n\t(SELECT dd.ProductID, dd.PriceWithDiscount, \r\n\t(SELECT coalesce(\r\n\t\t(SELECT round(AVG(dd1.PurchacePrice * v.Value),2) AS PPrice FROM documentdetails dd1 \r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tJOIN product p1 ON dd1.ProductID = p1.ProductID\r\n\t\tJOIN vat v ON p1.VatID = v.VatID \r\n\t\tWHERE d1.DocumentTypeID = 1 AND dd1.ProductID = dd.ProductID\r\n\t\tAND CAST(d1.Date AS DATE) BETWEEN @dateFrom AND @dateTo\r\n\t\tORDER BY d1.date ),\r\n\t\t(SELECT ROUND((SELECT (dd1.PurchacePrice * v.Value)  FROM documentdetails dd1 \r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tJOIN product p1 ON dd1.ProductID = p1.ProductID\r\n\t\tJOIN vat v ON p1.VatID = v.VatID \r\n\t\tWHERE d1.DocumentTypeID = 1 AND dd1.ProductID = dd.ProductID\r\n\t\tAND CAST(d1.Date AS DATE) <= @dateFrom\r\n\t\tORDER BY d1.date desc LIMIT 1), 2)))) AS PPrice, dd.Quantity \r\n\t   FROM documentdetails dd \r\n\t\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID \r\n\t\tWHERE d.DocumentTypeID = 3  AND d.DocumentStatusID IN (1,2) \r\n\t\tAND CAST(d.Date AS DATE)BETWEEN CAST(@dateFrom AS DATE) AND CAST(@dateTo AS DATE) \r\n\t\torder BY dd.ProductId) AS trt \r\ngroup BY ProductId, PriceWithDiscount";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = this.connection.prepareStatement(params);
            pStatement.setDate(1, from);
            pStatement.setDate(2, to);
            pStatement.execute();
            pStatement = this.connection.prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                long productId = rSet.getLong("ProductID");
                Product product = Product.getByID(productId, this.controller);
                RazlikaUCeni razlikaUCeni = this.makeRUC(rSet, product);
                this.addRucSumary(razlikaUCeni, rucSummary);
                list.add((Object)razlikaUCeni);
            }
            this.setRucSummaryList(rucSummary);
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private RazlikaUCeni makeRUC(ResultSet rSet, Product product) throws SQLException {
        RazlikaUCeni razlikaUCeni = new RazlikaUCeni();
        razlikaUCeni.setProduct(product);
        razlikaUCeni.setQuantity(rSet.getDouble("Quantity"));
        razlikaUCeni.setPurchacePrice(rSet.getDouble("PurchasePrice"));
        razlikaUCeni.setSellPrice(rSet.getDouble("PriceWithDiscount"));
        razlikaUCeni.setDifferencePrice(Settings.round(razlikaUCeni.getSellPrice() - razlikaUCeni.getPurchacePrice(), 2));
        razlikaUCeni.setPurchaceValue(Settings.round(razlikaUCeni.getQuantity() * razlikaUCeni.getPurchacePrice(), 2));
        razlikaUCeni.setSellValue(Settings.round(razlikaUCeni.getQuantity() * razlikaUCeni.getSellPrice(), 2));
        razlikaUCeni.setDifferenceValue(Settings.round(razlikaUCeni.getSellValue() - razlikaUCeni.getPurchaceValue(), 2));
        return razlikaUCeni;
    }

    private void addRucSumary(RazlikaUCeni ruc, RazlikaUCenuSummary rucSummary) {
        rucSummary.setPurchaceValueTotal(ruc.getPurchaceValue());
        rucSummary.setSellValueTotal(ruc.getSellValue());
        rucSummary.setDiffereneceValueTotal(ruc.getDifferenceValue());
    }

    private ObservableList<RazlikaUCenuSummary> setRucSummaryList(RazlikaUCenuSummary rucSummary) {
        this.rucSummaryList = FXCollections.observableArrayList();
        rucSummary.roundOnTwo();
        this.rucSummaryList.add((Object)rucSummary);
        return this.rucSummaryList;
    }
}

