/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.OfferPrice;

public class PriceList {
    private Long PriceListID;
    private int ObjectID;
    private int PointOfSaleID;
    private String Title;
    private String Comment;
    private Date DateFrom;
    private Date DateTo;
    private byte DomFrom;
    private byte DomTo;
    private boolean Monday;
    private boolean Tuesday;
    private boolean Wednesday;
    private boolean Thursday;
    private boolean Friday;
    private boolean Saturday;
    private boolean Sunday;
    private Date TimeFrom;
    private Date TimeTo;
    private byte Priority;
    private boolean Active;
    private int PriceListTypeID;
    private long offerPriceID;
    private long buyerOfferPriceID;

    public Long getPriceListID() {
        return this.PriceListID;
    }

    public void setPriceListID(Long priceListID) {
        this.PriceListID = priceListID;
    }

    public int getObjectID() {
        return this.ObjectID;
    }

    public void setObjectID(int objectID) {
        this.ObjectID = objectID;
    }

    public int getPointOfSaleID() {
        return this.PointOfSaleID;
    }

    public void setPointOfSaleID(int pointOfSaleID) {
        this.PointOfSaleID = pointOfSaleID;
    }

    public String getTitle() {
        return this.Title;
    }

    public void setTitle(String title) {
        this.Title = title;
    }

    public String getComment() {
        return this.Comment;
    }

    public void setComment(String comment) {
        this.Comment = comment;
    }

    public Date getDateFrom() {
        return this.DateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.DateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.DateTo;
    }

    public void setDateTo(Date dateTo) {
        this.DateTo = dateTo;
    }

    public byte getDomFrom() {
        return this.DomFrom;
    }

    public void setDomFrom(byte domFrom) {
        this.DomFrom = domFrom;
    }

    public byte getDomTo() {
        return this.DomTo;
    }

    public void setDomTo(byte domTo) {
        this.DomTo = domTo;
    }

    public boolean isMonday() {
        return this.Monday;
    }

    public void setMonday(boolean monday) {
        this.Monday = monday;
    }

    public boolean isTuesday() {
        return this.Tuesday;
    }

    public void setTuesday(boolean tuesday) {
        this.Tuesday = tuesday;
    }

    public boolean isWednesday() {
        return this.Wednesday;
    }

    public void setWednesday(boolean wednesday) {
        this.Wednesday = wednesday;
    }

    public boolean isThursday() {
        return this.Thursday;
    }

    public void setThursday(boolean thursday) {
        this.Thursday = thursday;
    }

    public boolean isFriday() {
        return this.Friday;
    }

    public void setFriday(boolean friday) {
        this.Friday = friday;
    }

    public boolean isSaturday() {
        return this.Saturday;
    }

    public void setSaturday(boolean saturday) {
        this.Saturday = saturday;
    }

    public boolean isSunday() {
        return this.Sunday;
    }

    public void setSunday(boolean sunday) {
        this.Sunday = sunday;
    }

    public Date getTimeFrom() {
        return this.TimeFrom;
    }

    public void setTimeFrom(Date timeFrom) {
        this.TimeFrom = timeFrom;
    }

    public Date getTimeTo() {
        return this.TimeTo;
    }

    public void setTimeTo(Date timeTo) {
        this.TimeTo = timeTo;
    }

    public byte getPriority() {
        return this.Priority;
    }

    public void setPriority(byte priority) {
        this.Priority = priority;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public int getPriceListTypeID() {
        return this.PriceListTypeID;
    }

    public void setPriceListTypeID(int priceListTypeID) {
        this.PriceListTypeID = priceListTypeID;
    }

    public long getOfferPriceID() {
        return this.offerPriceID;
    }

    public void setOfferPriceID(long offerPriceID) {
        this.offerPriceID = offerPriceID;
    }

    public long getBuyerOfferPriceID() {
        return this.buyerOfferPriceID;
    }

    public void setBuyerOfferPriceID(long buyerOfferPriceID) {
        this.buyerOfferPriceID = buyerOfferPriceID;
    }

    public String toString() {
        return this.Title;
    }

    public static void srediPricelist(Connection connection) {
        String queryDocument = "select distinct d.ProductID as priceProductId, d.NewPrice as price  from documentdetails d where  d.ProductID in \n(select DISTINCT  p.ProductID as productid  from product p left join pricelistdetails pl  on p.ProductID  = pl.ProductID where pl.ProductID is null)\norder by d.ProductID, d.sysDTCreated  desc ";
        String query = "insert into pricelistdetails (PriceListID,ProductID, Price, `Date`)\nvalues(?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(queryDocument);
            ResultSet resultSet = ps.executeQuery();
            Long priceProd = null;
            Date utilDate = new Date();
            java.sql.Date sqlDate = new java.sql.Date(utilDate.getTime());
            Time sqlTime = new Time(utilDate.getTime());
            while (resultSet.next()) {
                Long priceProductId = resultSet.getLong("priceProductId");
                Double price = resultSet.getDouble("price");
                if (priceProd != null && priceProductId.equals(priceProd)) continue;
                if (price > 0.0) {
                    ps = connection.prepareStatement(query);
                    ps.setLong(1, 1L);
                    ps.setLong(2, priceProductId);
                    ps.setDouble(3, price);
                    ps.setDate(4, sqlDate);
                    ps.executeUpdate();
                }
                priceProd = priceProductId;
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public long insert(Connection connection) {
        long result = -1L;
        String query = "insert into pricelist (\tObjectID,PointOfSaleID,Title,Comment,\t\t\t\t\t\tDateFrom,DateTo,DomFrom,DomTo,Monday,Tuesday,\t\t\t\t\t\tWednesday,Thursday,Friday,Saturday,Sunday,\t\t\t\t\t\tTimeFrom,TimeTo,Priority,Active,PriceListTypeID) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            if (this.ObjectID > 0) {
                ps.setInt(1, this.ObjectID);
            } else {
                ps.setNull(1, 4);
            }
            if (this.PointOfSaleID > 0) {
                ps.setInt(2, this.PointOfSaleID);
            } else {
                ps.setNull(2, 4);
            }
            ps.setString(3, this.Title);
            ps.setString(4, this.Comment);
            ps.setTimestamp(5, new Timestamp(this.DateFrom.getTime()));
            try {
                ps.setTimestamp(6, new Timestamp(this.DateTo.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(6, 91);
            }
            ps.setByte(7, this.DomFrom);
            ps.setByte(8, this.DomTo);
            ps.setBoolean(9, this.Monday);
            ps.setBoolean(10, this.Tuesday);
            ps.setBoolean(11, this.Wednesday);
            ps.setBoolean(12, this.Thursday);
            ps.setBoolean(13, this.Friday);
            ps.setBoolean(14, this.Saturday);
            ps.setBoolean(15, this.Sunday);
            if (this.TimeFrom != null) {
                ps.setTime(16, new Time(this.TimeFrom.getTime()));
            } else {
                ps.setNull(16, 92);
            }
            if (this.TimeFrom != null) {
                ps.setTime(17, new Time(this.TimeTo.getTime()));
            } else {
                ps.setNull(17, 92);
            }
            ps.setByte(18, this.Priority);
            ps.setBoolean(19, this.Active);
            ps.setInt(20, this.PriceListTypeID);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            result = rs.getLong(1);
            this.PriceListID = result;
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void update(Connection connection) {
        String query = "update pricelist set \tObjectID = ?,\tPointOfSaleID = ?,\tTitle = ?,\tComment = ?,\tDateFrom = ?,\tDateTo = ?,\tDomFrom = ?,\tDomTo = ?,\tMonday = ?,\tTuesday = ?,\tWednesday = ?,\tThursday = ?,\tFriday = ?,\tSaturday = ?,\tSunday = ?,\tTimeFrom = ?,\tTimeTo = ?,\tPriority = ?,\tActive = ?,\tPriceListTypeID = ? where PriceListID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (this.ObjectID > 0) {
                ps.setInt(1, this.ObjectID);
            } else {
                ps.setNull(1, 4);
            }
            if (this.PointOfSaleID > 0) {
                ps.setInt(2, this.PointOfSaleID);
            } else {
                ps.setNull(2, 4);
            }
            ps.setString(3, this.Title);
            ps.setString(4, this.Comment);
            ps.setTimestamp(5, new Timestamp(this.DateFrom.getTime()));
            if (this.DateTo != null) {
                ps.setTimestamp(6, new Timestamp(this.DateTo.getTime()));
            } else {
                ps.setNull(6, 93);
            }
            if (this.DomFrom > 0) {
                ps.setByte(7, this.DomFrom);
            } else {
                ps.setNull(7, 91);
            }
            if (this.DomTo > 0) {
                ps.setByte(8, this.DomTo);
            } else {
                ps.setNull(8, 91);
            }
            ps.setBoolean(9, this.Monday);
            ps.setBoolean(10, this.Tuesday);
            ps.setBoolean(11, this.Wednesday);
            ps.setBoolean(12, this.Thursday);
            ps.setBoolean(13, this.Friday);
            ps.setBoolean(14, this.Saturday);
            ps.setBoolean(15, this.Sunday);
            if (this.TimeFrom != null) {
                ps.setTime(16, new Time(this.TimeFrom.getTime()));
            } else {
                ps.setNull(16, 92);
            }
            if (this.TimeTo != null) {
                ps.setTime(17, new Time(this.TimeTo.getTime()));
            } else {
                ps.setNull(17, 92);
            }
            ps.setByte(18, this.Priority);
            ps.setBoolean(19, this.Active);
            ps.setInt(20, this.PriceListTypeID);
            ps.setLong(21, this.PriceListID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) throws SQLException {
        String query = "delete from pricelist where PriceListID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.PriceListID);
        ps.executeUpdate();
        ps.close();
    }

    public static ArrayList<PriceList> getList(Object object, boolean selectAll, Connection connection) {
        ArrayList<PriceList> list = new ArrayList<PriceList>();
        String upit = "select *   from pricelist pl where  ObjectID is null    or\t((ObjectID is not null) and (ObjectID = ?))  and pl.Active = ? order by priority desc ";
        String upitAll = "select *   from pricelist pl order by priority desc";
        try {
            PreparedStatement ps;
            if (selectAll) {
                ps = connection.prepareStatement(upitAll);
            } else {
                ps = connection.prepareStatement(upit);
                ps.setInt(1, object.getObjectID());
                ps.setBoolean(2, !selectAll);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PriceList pl = new PriceList();
                pl.PriceListID = rs.getLong("PriceListID");
                pl.ObjectID = rs.getInt("ObjectID");
                pl.PointOfSaleID = rs.getInt("PointOfSaleID");
                pl.Title = rs.getString("Title");
                pl.Comment = rs.getString("Comment");
                pl.DateFrom = new Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    pl.DateTo = new Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                pl.DomFrom = rs.getByte("DomFrom");
                pl.DomTo = rs.getByte("DomTo");
                pl.Monday = rs.getBoolean("Monday");
                pl.Tuesday = rs.getBoolean("Tuesday");
                pl.Wednesday = rs.getBoolean("Wednesday");
                pl.Thursday = rs.getBoolean("Thursday");
                pl.Friday = rs.getBoolean("Friday");
                pl.Saturday = rs.getBoolean("Saturday");
                pl.Sunday = rs.getBoolean("Saturday");
                pl.TimeFrom = rs.getTime("TimeFrom");
                pl.TimeTo = rs.getTime("TimeTo");
                pl.Priority = rs.getByte("Priority");
                pl.Active = rs.getBoolean("Active");
                pl.PriceListTypeID = rs.getInt("PriceListTypeID");
                list.add(pl);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<PriceList> getListPregled(Object object, boolean selectAll, Connection connection) {
        ArrayList<PriceList> list = new ArrayList<PriceList>();
        String upit = "select *   from pricelist pl where  ObjectID is null    or\t((ObjectID is not null) and (ObjectID = ?))  and pl.Active = ? order by priority desc ";
        String upitAll = "select *   from pricelist pl where pl.Active = ? order by priority desc";
        try {
            PreparedStatement ps;
            if (selectAll) {
                ps = connection.prepareStatement(upitAll);
                ps.setBoolean(1, selectAll);
            } else {
                ps = connection.prepareStatement(upit);
                ps.setInt(1, object.getObjectID());
                ps.setBoolean(2, selectAll);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PriceList pl = new PriceList();
                pl.PriceListID = rs.getLong("PriceListID");
                pl.ObjectID = rs.getInt("ObjectID");
                pl.PointOfSaleID = rs.getInt("PointOfSaleID");
                pl.Title = rs.getString("Title");
                pl.Comment = rs.getString("Comment");
                pl.DateFrom = new Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    pl.DateTo = new Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                pl.DomFrom = rs.getByte("DomFrom");
                pl.DomTo = rs.getByte("DomTo");
                pl.Monday = rs.getBoolean("Monday");
                pl.Tuesday = rs.getBoolean("Tuesday");
                pl.Wednesday = rs.getBoolean("Wednesday");
                pl.Thursday = rs.getBoolean("Thursday");
                pl.Friday = rs.getBoolean("Friday");
                pl.Saturday = rs.getBoolean("Saturday");
                pl.Sunday = rs.getBoolean("Saturday");
                pl.TimeFrom = rs.getTime("TimeFrom");
                pl.TimeTo = rs.getTime("TimeTo");
                pl.Priority = rs.getByte("Priority");
                pl.Active = rs.getBoolean("Active");
                pl.PriceListTypeID = rs.getInt("PriceListTypeID");
                list.add(pl);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static PriceList getActive(LocalDateTime dateWhen, int objectID, Connection connection) {
        String upit = "select *  from pricelist pl where  (pl.ObjectID is null or pl.ObjectID = ?)  \t\tand pl.DateFrom <= ?\t\t\tand (pl.DateTo >= ? or pl.DateTo is null)\t\t\tand pl.Active = true order by pl.priority desc limit 1";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setInt(1, objectID);
            ps.setTimestamp(2, Timestamp.valueOf(dateWhen));
            ps.setTimestamp(3, Timestamp.valueOf(dateWhen));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                PriceList pl = new PriceList();
                pl.PriceListID = rs.getLong("PriceListID");
                pl.ObjectID = rs.getInt("ObjectID");
                pl.PointOfSaleID = rs.getInt("PointOfSaleID");
                pl.Title = rs.getString("Title");
                pl.Comment = rs.getString("Comment");
                pl.DateFrom = new Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    pl.DateTo = new Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                pl.DomFrom = rs.getByte("DomFrom");
                pl.DomTo = rs.getByte("DomTo");
                pl.Monday = rs.getBoolean("Monday");
                pl.Tuesday = rs.getBoolean("Tuesday");
                pl.Wednesday = rs.getBoolean("Wednesday");
                pl.Thursday = rs.getBoolean("Thursday");
                pl.Friday = rs.getBoolean("Friday");
                pl.Saturday = rs.getBoolean("Saturday");
                pl.Sunday = rs.getBoolean("Saturday");
                pl.TimeFrom = rs.getTime("TimeFrom");
                pl.TimeTo = rs.getTime("TimeTo");
                pl.Priority = rs.getByte("Priority");
                pl.Active = rs.getBoolean("Active");
                pl.PriceListTypeID = rs.getInt("PriceListTypeID");
                return pl;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static PriceList getRegular(LocalDateTime dateWhen, int objectID, Connection connection) {
        String upit = "SELECT pl.* FROM pricelist pl  WHERE pl.Active = TRUE AND pl.PriceListTypeID = 1 AND pl.DateFrom <= NOW() AND (pl.DateTo IS NULL OR pl.DateTo >= NOW()) AND (pl.ObjectID = ? OR pl.ObjectID IS NULL) ORDER BY pl.Priority DESC LIMIT 1";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setInt(1, objectID);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                PriceList pl = new PriceList();
                pl.PriceListID = rs.getLong("PriceListID");
                pl.ObjectID = rs.getInt("ObjectID");
                pl.PointOfSaleID = rs.getInt("PointOfSaleID");
                pl.Title = rs.getString("Title");
                pl.Comment = rs.getString("Comment");
                pl.DateFrom = new Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    pl.DateTo = new Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                pl.DomFrom = rs.getByte("DomFrom");
                pl.DomTo = rs.getByte("DomTo");
                pl.Monday = rs.getBoolean("Monday");
                pl.Tuesday = rs.getBoolean("Tuesday");
                pl.Wednesday = rs.getBoolean("Wednesday");
                pl.Thursday = rs.getBoolean("Thursday");
                pl.Friday = rs.getBoolean("Friday");
                pl.Saturday = rs.getBoolean("Saturday");
                pl.Sunday = rs.getBoolean("Saturday");
                pl.TimeFrom = rs.getTime("TimeFrom");
                pl.TimeTo = rs.getTime("TimeTo");
                pl.Priority = rs.getByte("Priority");
                pl.Active = rs.getBoolean("Active");
                pl.PriceListTypeID = rs.getInt("PriceListTypeID");
                return pl;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ObservableList<PriceList> getObeservableListPregled(boolean active, Object object, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        for (PriceList pl : PriceList.getListPregled(object, active, connection)) {
            list.add((java.lang.Object)pl);
        }
        return list;
    }

    public static ObservableList<PriceList> getObeservableList(boolean active, Object object, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        for (PriceList pl : PriceList.getList(object, active, connection)) {
            list.add((java.lang.Object)pl);
        }
        return list;
    }

    public static ObservableList<PriceList> getNewList(ScreensController controller) {
        String quString = "SELECT * FROM pricelist pl";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PriceList priceList;
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(quString);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                PriceList priceList2 = new PriceList();
                priceList2.setTitle(rSet.getString("Title"));
                priceList2.setDateFrom(new Date(rSet.getTimestamp("DateFrom").getTime()));
                try {
                    priceList2.setDateTo(new Date(rSet.getTimestamp("DateTo").getTime()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                priceList2.setActive(rSet.getBoolean("Active"));
                priceList2.setPriceListTypeID(rSet.getInt("PriceListTypeID"));
                list.add((java.lang.Object)priceList2);
            }
            for (OfferPrice offerPrice : OfferPrice.getList(controller)) {
                priceList = new PriceList();
                priceList.setTitle(offerPrice.getName());
                priceList.setDateFrom(offerPrice.getDateFrom());
                try {
                    priceList.setDateTo(offerPrice.getDateTo());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                priceList.setActive(offerPrice.isActive());
                priceList.setPriceListTypeID(offerPrice.getPriceListTypeID());
                priceList.setOfferPriceID(offerPrice.getOfferPriceID());
                list.add((java.lang.Object)priceList);
            }
            for (BuyerOfferPrice buyerOfferPrice : BuyerOfferPrice.getList(controller)) {
                priceList = new PriceList();
                priceList.setTitle(buyerOfferPrice.getName());
                priceList.setDateFrom(buyerOfferPrice.getDateFrom());
                try {
                    priceList.setDateTo(buyerOfferPrice.getDateTo());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                priceList.setActive(buyerOfferPrice.isActive());
                priceList.setPriceListTypeID(buyerOfferPrice.getPriceListTypeID());
                priceList.setBuyerOfferPriceID(buyerOfferPrice.getBuyerOfferPriceID());
                list.add((java.lang.Object)priceList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PriceList> getPriceList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM pricelist pl";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                PriceList pl = new PriceList();
                pl.PriceListID = rs.getLong("PriceListID");
                pl.ObjectID = rs.getInt("ObjectID");
                pl.PointOfSaleID = rs.getInt("PointOfSaleID");
                pl.Title = rs.getString("Title");
                pl.Comment = rs.getString("Comment");
                pl.DateFrom = new Date(rs.getTimestamp("DateFrom").getTime());
                try {
                    pl.DateTo = new Date(rs.getTimestamp("DateTo").getTime());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                pl.DomFrom = rs.getByte("DomFrom");
                pl.DomTo = rs.getByte("DomTo");
                pl.Monday = rs.getBoolean("Monday");
                pl.Tuesday = rs.getBoolean("Tuesday");
                pl.Wednesday = rs.getBoolean("Wednesday");
                pl.Thursday = rs.getBoolean("Thursday");
                pl.Friday = rs.getBoolean("Friday");
                pl.Saturday = rs.getBoolean("Saturday");
                pl.Sunday = rs.getBoolean("Saturday");
                pl.TimeFrom = rs.getTime("TimeFrom");
                pl.TimeTo = rs.getTime("TimeTo");
                pl.Priority = rs.getByte("Priority");
                pl.Active = rs.getBoolean("Active");
                pl.PriceListTypeID = rs.getInt("PriceListTypeID");
                list.add((java.lang.Object)pl);
            }
            rs.close();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

