/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class Present {
    private long presentId;
    private double billSumFrom;
    private double billSumTo;
    private double discountPercent;
    private double discountMonay;
    private String message;
    private boolean activePresent;
    private boolean activeDiscount;

    public long getPresentId() {
        return this.presentId;
    }

    public void setPresentId(long presentId) {
        this.presentId = presentId;
    }

    public double getBillSumFrom() {
        return this.billSumFrom;
    }

    public void setBillSumFrom(double billSumFrom) {
        this.billSumFrom = billSumFrom;
    }

    public double getBillSumTo() {
        return this.billSumTo;
    }

    public void setBillSumTo(double billSumTo) {
        this.billSumTo = billSumTo;
    }

    public double getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(double discountPercent) {
        this.discountPercent = discountPercent;
    }

    public double getDiscountMonay() {
        return this.discountMonay;
    }

    public void setDiscountMonay(double discountMonay) {
        this.discountMonay = discountMonay;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isActivePresent() {
        return this.activePresent;
    }

    public void setActivePresent(boolean activePresent) {
        this.activePresent = activePresent;
    }

    public boolean isActiveDiscount() {
        return this.activeDiscount;
    }

    public void setActiveDiscount(boolean activeDiscount) {
        this.activeDiscount = activeDiscount;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`present` (`BillSumFrom`, `BillSumTo`, `DiscountPercent`, `DiscountMonay`, `Message`, `ActivePresent`, `ActiveDiscount`) VALUES (?, ?, ?, ?, ?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query, 1);
            pStatement.setDouble(1, this.billSumFrom);
            pStatement.setDouble(2, this.billSumTo);
            pStatement.setDouble(3, this.discountPercent);
            pStatement.setDouble(4, this.discountMonay);
            pStatement.setString(5, this.message);
            pStatement.setBoolean(6, this.activePresent);
            pStatement.setBoolean(7, this.activeDiscount);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`present` SET `BillSumFrom` = ?, `BillSumTo` = ?, `DiscountPercent` = ?, `DiscountMonay` = ?, `Message` = ?, `ActivePresent` = ?, `ActiveDiscount` = ? WHERE  `PresentID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setDouble(1, this.billSumFrom);
            pStatement.setDouble(2, this.billSumTo);
            pStatement.setDouble(3, this.discountPercent);
            pStatement.setDouble(4, this.discountMonay);
            pStatement.setString(5, this.message);
            pStatement.setBoolean(6, this.activePresent);
            pStatement.setBoolean(7, this.activeDiscount);
            pStatement.setLong(8, this.presentId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Present getPresent(ScreensController controller) {
        String query = "SELECT p.* FROM present p";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            Present present = new Present();
            present.setPresentId(rSet.getLong("PresentID"));
            present.setBillSumFrom(rSet.getDouble("BillSumFrom"));
            present.setBillSumTo(rSet.getDouble("BillSumTo"));
            present.setDiscountPercent(rSet.getDouble("DiscountPercent"));
            present.setDiscountMonay(rSet.getDouble("DiscountMonay"));
            present.setMessage(rSet.getString("Message"));
            present.setActivePresent(rSet.getBoolean("ActivePresent"));
            present.setActiveDiscount(rSet.getBoolean("ActiveDiscount"));
            return present;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static ObservableList<Present> getPresentList(ScreensController controller) {
        String query = "SELECT p.* FROM present p";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            Present present = new Present();
            present.setPresentId(rSet.getLong("PresentID"));
            present.setBillSumFrom(rSet.getDouble("BillSumFrom"));
            present.setBillSumTo(rSet.getDouble("BillSumTo"));
            present.setDiscountPercent(rSet.getDouble("DiscountPercent"));
            present.setDiscountMonay(rSet.getDouble("DiscountMonay"));
            present.setMessage(rSet.getString("Message"));
            present.setActivePresent(rSet.getBoolean("ActivePresent"));
            present.setActiveDiscount(rSet.getBoolean("ActiveDiscount"));
            list.add((Object)present);
            return list;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void delete(ScreensController controller) {
        String query = "DELETE FROM `masterdb`.`present` WHERE  `PresentID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.presentId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

