/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.product.Product;

public class PointOfSaleProductDescription {
    private int PointOfSaleProductDescriptionID;
    private int PointOfSaleID;
    private long ProductID;
    private int DescriptionID;
    private boolean Active;
    private String color;
    private String Name;
    private int PositionBtn;

    public int getPositionBtn() {
        return this.PositionBtn;
    }

    public void setPositionBtn(int positionBtn) {
        this.PositionBtn = positionBtn;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public int getPointOfSaleProductDescriptionID() {
        return this.PointOfSaleProductDescriptionID;
    }

    public void setPointOfSaleProductDescriptionID(int pointOfSaleProductDescriptionID) {
        this.PointOfSaleProductDescriptionID = pointOfSaleProductDescriptionID;
    }

    public int getPointOfSaleID() {
        return this.PointOfSaleID;
    }

    public void setPointOfSaleID(int pointOfSaleID) {
        this.PointOfSaleID = pointOfSaleID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public int getDescriptionID() {
        return this.DescriptionID;
    }

    public void setDescriptionID(int descriptionID) {
        this.DescriptionID = descriptionID;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void insert(Connection connection) {
        String query = "INSERT INTO pointofsaleproductdescription (    PointOfSaleID,    ProductID,\tDescriptionID,\tActive,\tcolor) VALUES (?,?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.PointOfSaleID);
            ps.setLong(2, this.ProductID);
            ps.setLong(3, this.DescriptionID);
            ps.setBoolean(4, this.Active);
            ps.setString(5, this.color);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(Connection connection) {
        String query = "UPDATE pointofsaleproductdescription SET  PointOfSaleID = ?, ProductID = ?, DescriptionID = ?, Active = ?, color = ?, PositionBtn = ? WHERE PointOfSaleProductDescriptionID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.PointOfSaleID);
            ps.setLong(2, this.ProductID);
            ps.setLong(3, this.DescriptionID);
            ps.setBoolean(4, this.Active);
            ps.setString(5, this.color);
            ps.setInt(6, this.PositionBtn);
            ps.setInt(7, this.PointOfSaleProductDescriptionID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) {
        String query = "DELETE FROM pointofsaleproductdescription WHERE PointOfSaleProductDescriptionID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.PointOfSaleProductDescriptionID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<PointOfSaleProductDescription> getListLoadTableOpisni(PointOfSale pos, Product product, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT DISTINCT psd.*, d.Name FROM pointofsaleproductdescription psd JOIN description d on d.DescriptionID = psd.DescriptionID JOIN product p on p.ProductID = psd.ProductID WHERE psd.PointOfSaleID = ? and p.ProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pos.getPointOfSaleID());
            if (product != null) {
                ps.setLong(2, product.getProductID());
            } else {
                ps.setNull(2, -5);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PointOfSaleProductDescription pospd = new PointOfSaleProductDescription();
                pospd.PointOfSaleProductDescriptionID = rs.getInt("PointOfSaleProductDescriptionID");
                pospd.PointOfSaleID = rs.getInt("PointOfSaleID");
                pospd.ProductID = rs.getLong("ProductID");
                pospd.DescriptionID = rs.getInt("DescriptionID");
                pospd.Active = rs.getBoolean("Active");
                pospd.color = rs.getString("color");
                pospd.Name = rs.getString("Name");
                pospd.PositionBtn = rs.getInt("PositionBtn");
                list.add((Object)pospd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PointOfSaleProductDescription> getListOpisni(int pos, long product, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT psd.*, d.Name FROM pointofsaleproductdescription psd LEFT JOIN description d ON psd.DescriptionID = d.DescriptionID WHERE d.Active AND psd.PointOfSaleID = ? AND psd.ProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pos);
            ps.setLong(2, product);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PointOfSaleProductDescription pospd = new PointOfSaleProductDescription();
                pospd.PointOfSaleProductDescriptionID = rs.getInt("PointOfSaleProductDescriptionID");
                pospd.PointOfSaleID = rs.getInt("PointOfSaleID");
                pospd.ProductID = rs.getLong("ProductID");
                pospd.DescriptionID = rs.getInt("DescriptionID");
                pospd.Active = rs.getBoolean("Active");
                pospd.color = rs.getString("color");
                pospd.Name = rs.getString("Name");
                pospd.PositionBtn = rs.getInt("PositionBtn");
                list.add((Object)pospd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

