/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.person.Address;

public class PointOfSale {
    int PointOfSaleID;
    String Code;
    String Name;
    String DepartmentName;
    boolean Active;
    Date sysDTCreated;
    Date sysDTEdit;
    long sysUserAddID;
    long sysUserEditID;
    int ObjectID;
    boolean Selected;
    private boolean posDescriptionalMandatory;

    public int getPointOfSaleID() {
        return this.PointOfSaleID;
    }

    public void setPointOfSaleID(int pointOfSaleID) {
        this.PointOfSaleID = pointOfSaleID;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getDepartmentName() {
        return this.DepartmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.DepartmentName = departmentName;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public int getObjectID() {
        return this.ObjectID;
    }

    public void setObjectID(int objectID) {
        this.ObjectID = objectID;
    }

    public boolean isPosDescriptionalMandatory() {
        return this.posDescriptionalMandatory;
    }

    public void setPosDescriptionalMandatory(boolean posDescriptionalMandatory) {
        this.posDescriptionalMandatory = posDescriptionalMandatory;
    }

    public boolean isSelected() {
        return this.Selected;
    }

    public void setSelected(boolean selected) {
        this.Selected = selected;
    }

    public PointOfSale() {
    }

    public PointOfSale(int id, String Name) {
        this.PointOfSaleID = id;
        this.Name = Name;
    }

    public PointOfSale(String code, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from pointofsale where code = ? ");
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            rs.next();
            this.PointOfSaleID = rs.getInt("PointOfSaleID");
            this.Code = rs.getString("Code");
            this.Name = rs.getString("Name");
            this.Active = rs.getBoolean("Active");
            this.sysDTCreated = new Date(rs.getDate("sysDTCreated").getTime());
            try {
                this.sysDTEdit = new Date(rs.getDate("sysDTEdit").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                this.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.ObjectID = rs.getInt("ObjectID");
            String query = "select * from settings";
            ps = connection.prepareCall(query);
            rs = ps.executeQuery();
            while (rs.next()) {
                switch (rs.getString("name")) {
                    case "descriptional.mandatory": {
                        this.posDescriptionalMandatory = rs.getString("actual").equals("true");
                        break;
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public PointOfSale(int posId, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from pointofsale where PointOfSaleID = ? ");
            ps.setInt(1, posId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            this.PointOfSaleID = rs.getInt("PointOfSaleID");
            this.Code = rs.getString("Code");
            this.Name = rs.getString("Name");
            this.Active = rs.getBoolean("Active");
            this.sysDTCreated = new Date(rs.getDate("sysDTCreated").getTime());
            try {
                this.sysDTEdit = new Date(rs.getDate("sysDTEdit").getTime());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.sysUserAddID = rs.getLong("sysUserAddID");
            try {
                this.sysUserEditID = rs.getLong("sysUserEditID");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.ObjectID = rs.getInt("ObjectID");
            String query = "select * from settings";
            ps = connection.prepareCall(query);
            rs = ps.executeQuery();
            while (rs.next()) {
                switch (rs.getString("name")) {
                    case "descriptional.mandatory": {
                        this.posDescriptionalMandatory = rs.getString("actual").equals("true");
                        break;
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Address getAddress(ScreensController controller) {
        Object object = Object.getById(this.ObjectID, controller);
        Address address = Address.getByID(object.getAddressID(), controller.getSettings().getConnection());
        return address;
    }

    public static ArrayList<PointOfSale> getPosList(Object object, Connection connection) {
        ArrayList<PointOfSale> list = new ArrayList<PointOfSale>();
        String query = "select * from pointofsale ps where ps.Active = true and ps.ObjectID = ? order by ps.Name";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, object.getObjectID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PointOfSale pos = new PointOfSale();
                pos.setPointOfSaleID(rs.getInt("PointOfSaleID"));
                pos.setCode(rs.getString("Code"));
                pos.setName(rs.getString("Name"));
                pos.setActive(rs.getBoolean("Active"));
                pos.setObjectID(rs.getInt("ObjectID"));
                list.add(pos);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public String toString() {
        return this.Name;
    }

    public ArrayList<Department> getDepartmentList(Connection connection) {
        ArrayList<Department> list = new ArrayList<Department>();
        String query = "select  d.*  from pointofsaledepartment pd  left join department d on d.DepartmentID = pd.DepartmentID where PointOfSaleID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.PointOfSaleID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Department d = new Department();
                d.setDepartmentID(rs.getInt("DepartmentID"));
                d.setName(rs.getString("Name"));
                d.setShortName(rs.getString("ShortName"));
                d.setCode(rs.getString("Code"));
                d.setActive(rs.getBoolean("Active"));
                d.setPrinterID(rs.getInt("PrinterID"));
                d.setObjectID(rs.getInt("ObjectID"));
                list.add(d);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PointOfSale> getPOSList(int departmentID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT pos.* FROM pointofsale pos JOIN department d ON d.ObjectID = pos.ObjectID WHERE d.DepartmentID = ? OR -1 = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, departmentID);
            ps.setInt(2, departmentID);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PointOfSale pos = new PointOfSale();
                pos.setPointOfSaleID(rs.getInt("PointOfSaleID"));
                pos.setCode(rs.getString("Code"));
                pos.setName(rs.getString("Name"));
                pos.setActive(rs.getBoolean("Active"));
                pos.setObjectID(rs.getInt("ObjectID"));
                list.add((java.lang.Object)pos);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PointOfSale> getPOSListByDeparments(String ids, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM pointofsale pos LEFT JOIN pointofsaledepartment posd ON posd.PointOfSaleID = pos.PointOfSaleID\r\nWHERE FIND_IN_SET(posd.DepartmentID, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, ids);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PointOfSale pos = new PointOfSale();
                pos.setPointOfSaleID(rs.getInt("PointOfSaleID"));
                pos.setCode(rs.getString("Code"));
                pos.setName(rs.getString("Name"));
                pos.setActive(rs.getBoolean("Active"));
                pos.setObjectID(rs.getInt("ObjectID"));
                list.add((java.lang.Object)pos);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PointOfSale> getPOSGroupTableList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT pos.Name, pos.PointOfSaleID, d.Name as DepartmentName FROM pointofsale pos JOIN department d ON d.ObjectID = pos.ObjectID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PointOfSale pos = new PointOfSale();
                pos.PointOfSaleID = rs.getInt("PointOfSaleID");
                pos.Name = rs.getString("Name");
                pos.DepartmentName = rs.getNString("DepartmentName");
                list.add((java.lang.Object)pos);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return list;
    }

    public static ObservableList<PointOfSale> getPosIDList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT pos.PointOfSaleID FROM pointofsale pos";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PointOfSale pos = new PointOfSale();
                pos.PointOfSaleID = rs.getInt("PointOfSaleID");
                list.add((java.lang.Object)pos);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return list;
    }

    public static int getDepartmentIdByCode(String posCode, Connection connection) {
        String query = "select dp.DepartmentID from department dp join pointofsaledepartment posdp on posdp.DepartmentID = dp.DepartmentID join pointofsale pos on pos.PointOfSaleID = posdp.PointOfSaleID where pos.Code = ?";
        int departmentID = -1;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, posCode);
            ResultSet rs = ps.executeQuery();
            rs.next();
            departmentID = rs.getInt("DepartmentID");
            rs.close();
            ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return departmentID;
    }

    public static int getDepartmentIdById(int posId, Connection connection) {
        String query = "select dp.DepartmentID from department dp join pointofsaledepartment posdp on posdp.DepartmentID = dp.DepartmentID join pointofsale pos on pos.PointOfSaleID = posdp.PointOfSaleID where pos.PointOfSaleID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, posId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getInt("DepartmentID");
        }
        catch (SQLException sQLException) {
            return -1;
        }
    }

    public static ObservableList<PointOfSale> getPosIDListFromPD(long productDepartmentID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT pos.PointOfSaleID  FROM pointofsale pos JOIN department d ON d.ObjectID = pos.ObjectID JOIN productdepartment pd ON pd.DepartmentID = d.DepartmentID WHERE pd.ProductDepartmentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productDepartmentID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PointOfSale pos = new PointOfSale();
                pos.PointOfSaleID = rs.getInt("PointOfSaleID");
                list.add((java.lang.Object)pos);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return list;
    }

    public boolean equals(java.lang.Object obj) {
        if (!(obj instanceof PointOfSale)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PointOfSale that = (PointOfSale)obj;
        return that.PointOfSaleID == this.PointOfSaleID && that.Code.equals(this.Code) && that.Active == this.Active && that.Name.equals(this.Name) && that.ObjectID == this.ObjectID && that.Selected == this.Selected;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.PointOfSaleID;
        result = 31 * result + (this.Code == null ? 0 : this.Code.hashCode());
        result = 31 * result + (this.Active ? 1 : 0);
        result = 31 * result + (this.Name == null ? 0 : this.Name.hashCode());
        result = 31 * result + this.ObjectID;
        result = 31 * result + (this.Selected ? 1 : 0);
        return result;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `pointofsale` (`Code`, `Name`, `Active`, `sysDTCreated`, `sysUserAddID`, `ObjectID`) VALUES (?, ?, ?, NOW(), ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query, 1);
            pStatement.setString(1, this.Code);
            pStatement.setString(2, this.Name);
            pStatement.setBoolean(3, this.Active);
            pStatement.setLong(4, this.sysUserAddID);
            pStatement.setLong(5, this.ObjectID);
            pStatement.executeUpdate();
            ResultSet rSet = pStatement.getGeneratedKeys();
            rSet.next();
            this.PointOfSaleID = rSet.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insertPOSDepartment(Department department, ScreensController controller) {
        String query = "INSERT INTO `pointofsaledepartment` (`PointOfSaleID`, `DepartmentID`) VALUES (?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, this.PointOfSaleID);
            pStatement.setInt(2, department.getDepartmentID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `pointofsale` SET `Code`= ?, `Name` = ?, `Active` = ?, `sysDTEdit` = NOW(), `sysUserEditID` = ? WHERE `PointOfSaleID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.Code);
            pStatement.setString(2, this.Name);
            pStatement.setBoolean(3, this.Active);
            pStatement.setLong(4, this.sysUserEditID);
            pStatement.setInt(5, this.PointOfSaleID);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updatePOSDepartment(Department department, ScreensController controller) {
        String query = "UPDATE `pointofsaledepartment` SET `DepartmentID` = ? WHERE  `PointOfSaleID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, department.getDepartmentID());
            pStatement.setInt(2, this.PointOfSaleID);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(ScreensController controller) {
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("DELETE FROM pointofsale WHERE  `PointOfSaleID` = ?");
            ps.setLong(1, this.PointOfSaleID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deletePOSDepartment(ScreensController controller) {
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("DELETE FROM `pointofsaledepartment` WHERE  `PointOfSaleID` = ?");
            ps.setLong(1, this.PointOfSaleID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

