/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class PaymentMethod {
    private int PaymentMethodID;
    private String Code;
    private String Name;
    private int Sort;
    private boolean IsDefault;
    private boolean ExactAmountDefault;
    private boolean Active;
    private int ParentPaymentMethodID;
    private boolean complex = false;
    private Boolean isRefBrojAvans = false;

    public Boolean getRefBrojAvans() {
        return this.isRefBrojAvans;
    }

    public void setRefBrojAvans(Boolean refBrojAvans) {
        this.isRefBrojAvans = refBrojAvans;
    }

    public static void updateName(ScreensController controller, String code, String prenos_na_ra\u010dun, boolean b) {
        String sql = "UPDATE `paymentmethod` SET `Name` = ? WHERE `paymentmethod`.Code  like ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(sql);
            pStatement.setString(1, prenos_na_ra\u010dun);
            pStatement.setString(2, "%" + code + "%");
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setExactAmountDefault(boolean exactAmountDefault) {
        this.ExactAmountDefault = exactAmountDefault;
    }

    public boolean isExactAmountDefault() {
        return this.ExactAmountDefault;
    }

    public int getPaymentMethodID() {
        return this.PaymentMethodID;
    }

    public void setPaymentMethodID(int paymentMethodID) {
        this.PaymentMethodID = paymentMethodID;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public int getSort() {
        return this.Sort;
    }

    public void setSort(int sort) {
        this.Sort = sort;
    }

    public boolean isIsDefault() {
        return this.IsDefault;
    }

    public void setIsDefault(boolean isDefault) {
        this.IsDefault = isDefault;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public int getParentPaymentMethodID() {
        return this.ParentPaymentMethodID;
    }

    public void setParentPaymentMethodID(int parentPaymentMethodID) {
        this.ParentPaymentMethodID = parentPaymentMethodID;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public void setComplex(boolean complex) {
        this.complex = complex;
    }

    public String toString() {
        return this.Name;
    }

    public static ArrayList<PaymentMethod> getAllList(Connection connection) {
        ArrayList<PaymentMethod> list = new ArrayList<PaymentMethod>();
        try {
            PreparedStatement ps = connection.prepareStatement("select * from paymentmethod pm  where pm.Active = true    and pm.ParentPaymentMethodID is null");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PaymentMethod pm = new PaymentMethod();
                pm.PaymentMethodID = rs.getInt("PaymentMethodID");
                pm.Code = rs.getString("Code");
                pm.Name = rs.getString("Name");
                pm.Sort = rs.getInt("Sort");
                pm.IsDefault = rs.getBoolean("IsDefault");
                try {
                    pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                pm.Active = rs.getBoolean("Active");
                pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
                pm.complex = false;
                list.add(pm);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PaymentMethod> getList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("SELECT * FROM paymentmethod pm ");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PaymentMethod pm = new PaymentMethod();
                pm.PaymentMethodID = rs.getInt("PaymentMethodID");
                pm.Code = rs.getString("Code");
                pm.Name = rs.getString("Name");
                pm.Sort = rs.getInt("Sort");
                pm.IsDefault = rs.getBoolean("IsDefault");
                try {
                    pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                pm.Active = rs.getBoolean("Active");
                pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
                pm.complex = false;
                list.add((Object)pm);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<PaymentMethod> getList(Connection connection) {
        ArrayList<PaymentMethod> list = new ArrayList<PaymentMethod>();
        try {
            PreparedStatement ps = connection.prepareStatement("select * from paymentmethod pm  where pm.Active = true    and pm.ParentPaymentMethodID is null  \tand (select count(pm2.PaymentMethodID) \t   from paymentmethod pm2 \t  where pm2.ParentPaymentMethodID = pm.PaymentMethodID) = 0  order by pm.Sort ");
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PaymentMethod pm = new PaymentMethod();
                pm.PaymentMethodID = rs.getInt("PaymentMethodID");
                pm.Code = rs.getString("Code");
                pm.Name = rs.getString("Name");
                pm.Sort = rs.getInt("Sort");
                pm.IsDefault = rs.getBoolean("IsDefault");
                try {
                    pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                pm.Active = rs.getBoolean("Active");
                pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
                pm.complex = false;
                list.add(pm);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PaymentMethod> getFakturaPaymentList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT pm.*  FROM paymentmethod pm WHERE pm.Active = TRUE  AND pm.ParentPaymentMethodID IS NULL AND (SELECT COUNT(pm2.PaymentMethodID) FROM paymentmethod pm2  WHERE pm2.ParentPaymentMethodID = pm.PaymentMethodID) = 0 ORDER BY pm.Sort LIMIT 4";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                PaymentMethod pm = new PaymentMethod();
                pm.PaymentMethodID = rs.getInt("PaymentMethodID");
                pm.Code = rs.getString("Code");
                pm.Name = rs.getString("Name");
                pm.Sort = rs.getInt("Sort");
                pm.IsDefault = rs.getBoolean("IsDefault");
                try {
                    pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                pm.Active = rs.getBoolean("Active");
                pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
                pm.complex = false;
                list.add((Object)pm);
            }
            pStatement.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<PaymentMethod> getComplexList(Connection connection) {
        ArrayList<PaymentMethod> list = new ArrayList<PaymentMethod>();
        try {
            PreparedStatement ps = connection.prepareStatement("select * from paymentmethod pm  where pm.Active = true    and pm.ParentPaymentMethodID is null  \tand (select count(pm2.PaymentMethodID) \t   from paymentmethod pm2 \t  where pm2.ParentPaymentMethodID = pm.PaymentMethodID) > 0  order by pm.Sort ");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PaymentMethod pm = new PaymentMethod();
                pm.PaymentMethodID = rs.getInt("PaymentMethodID");
                pm.Code = rs.getString("Code");
                pm.Name = rs.getString("Name");
                pm.Sort = rs.getInt("Sort");
                pm.IsDefault = rs.getBoolean("IsDefault");
                try {
                    pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                pm.Active = rs.getBoolean("Active");
                pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
                pm.complex = true;
                list.add(pm);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<PaymentMethod> getSubList(int parent, Connection connection) {
        ArrayList<PaymentMethod> list = new ArrayList<PaymentMethod>();
        try {
            PreparedStatement ps = connection.prepareStatement("select * from paymentmethod pm  where pm.Active = true  \tand ParentPaymentMethodID = ? order by pm.Sort ");
            ps.setInt(1, parent);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PaymentMethod pm = new PaymentMethod();
                pm.PaymentMethodID = rs.getInt("PaymentMethodID");
                pm.Code = rs.getString("Code");
                pm.Name = rs.getString("Name");
                pm.Sort = rs.getInt("Sort");
                pm.IsDefault = rs.getBoolean("IsDefault");
                try {
                    pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                pm.Active = rs.getBoolean("Active");
                pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
                pm.complex = false;
                list.add(pm);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static PaymentMethod getByName(String name, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select pm.*,   (select count(pm2.PaymentMethodID) \t\t    from paymentmethod pm2 \t\t   where pm2.ParentPaymentMethodID = pm.PaymentMethodID) as children   from paymentmethod pm  where Name = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            rs.next();
            PaymentMethod pm = new PaymentMethod();
            pm.PaymentMethodID = rs.getInt("PaymentMethodID");
            pm.Code = rs.getString("Code");
            pm.Name = rs.getString("Name");
            pm.Sort = rs.getInt("Sort");
            pm.IsDefault = rs.getBoolean("IsDefault");
            try {
                pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            pm.Active = rs.getBoolean("Active");
            pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
            pm.complex = rs.getInt("children") > 0;
            rs.close();
            ps.close();
            return pm;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createOtpPaymentmethod(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO `paymentmethod` (`Code`, `Name`, `Sort`, `Active`) VALUES ('OTP', 'Otpremnica', 8, b'0');");
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static PaymentMethod getByCode(String code, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from paymentmethod where Code = ?");
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            rs.next();
            PaymentMethod pm = new PaymentMethod();
            pm.PaymentMethodID = rs.getInt("PaymentMethodID");
            pm.Code = rs.getString("Code");
            pm.Name = rs.getString("Name");
            pm.Sort = rs.getInt("Sort");
            pm.IsDefault = rs.getBoolean("IsDefault");
            try {
                pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
            pm.Active = rs.getBoolean("Active");
            rs.close();
            ps.close();
            return pm;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static PaymentMethod getByNameMethod(String name, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from paymentmethod where Code like ? ");
            ps.setString(1, "%" + name + "%");
            ResultSet rs = ps.executeQuery();
            PaymentMethod pm = new PaymentMethod();
            if (rs.next()) {
                pm.PaymentMethodID = rs.getInt("PaymentMethodID");
                pm.Code = rs.getString("Code");
                pm.Name = rs.getString("Name");
                pm.Sort = rs.getInt("Sort");
                pm.IsDefault = rs.getBoolean("IsDefault");
                try {
                    pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
                pm.Active = rs.getBoolean("Active");
            }
            rs.close();
            ps.close();
            return pm;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static PaymentMethod getByID(int id, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from paymentmethod where PaymentMethodID = ?");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            PaymentMethod pm = new PaymentMethod();
            pm.PaymentMethodID = rs.getInt("PaymentMethodID");
            pm.Code = rs.getString("Code");
            pm.Name = rs.getString("Name");
            pm.Sort = rs.getInt("Sort");
            pm.IsDefault = rs.getBoolean("IsDefault");
            try {
                pm.ExactAmountDefault = rs.getBoolean("ExactAmountDefault");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            pm.ParentPaymentMethodID = rs.getInt("ParentPaymentMethodID");
            pm.Active = rs.getBoolean("Active");
            rs.close();
            ps.close();
            return pm;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getNextSort(ScreensController controller) {
        int sort = 0;
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("SELECT MAX(pm.Sort) AS Sort FROM paymentmethod pm WHERE pm.ParentPaymentMethodID IS NULL");
            ResultSet rs = ps.executeQuery();
            rs.next();
            sort = rs.getInt("Sort");
            rs.close();
            ps.close();
            return sort + 1;
        }
        catch (SQLException e) {
            return sort;
        }
    }

    public static void insertPM(ScreensController controller, String code, String name, boolean active) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`paymentmethod` (`Code`, `Name`, `Sort`, `Active`) VALUES (?, ?, ?, ?)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, code);
            pStatement.setString(2, name);
            pStatement.setInt(3, PaymentMethod.getNextSort(controller));
            pStatement.setBoolean(4, active);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String FLinkPaymentCode(String payment) {
        switch (payment) {
            case "CASH": {
                return "0";
            }
            case "CARD": {
                return "1";
            }
            case " CHECK": {
                return "2";
            }
            case "F": {
                return "3";
            }
        }
        return "0";
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`paymentmethod` SET `Code`= ?, `Name`= ?, `Sort`= ?, `IsDefault`= ?, `ExactAmountDefault`= ?, `Active`= ? WHERE  `PaymentMethodID`= ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.Code);
            pStatement.setString(2, this.Name);
            pStatement.setInt(3, this.Sort);
            pStatement.setBoolean(4, this.IsDefault);
            pStatement.setBoolean(5, this.ExactAmountDefault);
            pStatement.setBoolean(6, this.Active);
            pStatement.setLong(7, this.PaymentMethodID);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`paymentmethod` (`Code`, `Name`, `Sort`, `IsDefault`, `ExactAmountDefault`, `Active`) VALUES (?, ?, ?, ?, ?, ?)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.Code);
            pStatement.setString(2, this.Name);
            pStatement.setInt(3, PaymentMethod.getNextSort(controller));
            pStatement.setBoolean(4, this.IsDefault);
            pStatement.setBoolean(5, this.ExactAmountDefault);
            pStatement.setBoolean(6, this.Active);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

