/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.OfferPrice;
import rs.petcom.master.dal.product.Product;
import rs.petcom.renameconnection.ChangeConnection;

public class OfferPriceDetailes {
    private long OfferPriceDetailsID;
    private long OfferPriceID;
    private long ProductID;
    private double Price;
    private double Discount;
    private int offerPriceQuantity;
    private double quantity;
    private Product product;
    private String nameProduct;
    private String code;
    private Double totalAmount;
    private String a;
    double sum = 0.0;
    private String vreme;

    public void setVreme(String vreme) {
        this.vreme = vreme;
    }

    public String getVreme() {
        return this.vreme;
    }

    public static ObservableList<OfferPriceDetailes> getObeservableList(java.util.Date fromLocalDate, Connection connection, boolean check) {
        String sql = "select * from billcancellation b where CAST(b.datetimesys  AS Datetime) <= ?";
        if (check) {
            sql = "select sum(quantity)as quantity, price,nameProduct,code,datetimesys  from billcancellation b where CAST(b.datetimesys  AS Datetime) <= ? group by b.code";
        }
        PreparedStatement preparedStatementp = null;
        ObservableList list = FXCollections.observableArrayList();
        try {
            preparedStatementp = connection.prepareStatement(sql);
            preparedStatementp.setDate(1, new Date(fromLocalDate.getTime()));
            ResultSet resultSet = preparedStatementp.executeQuery();
            double sum = 0.0;
            while (resultSet.next()) {
                OfferPriceDetailes priceDetailes = new OfferPriceDetailes();
                priceDetailes.setPrice(resultSet.getDouble("quantity") * resultSet.getDouble("price"));
                priceDetailes.setQuantity(resultSet.getDouble("quantity"));
                priceDetailes.setNameProduct(resultSet.getString("nameProduct"));
                priceDetailes.setCode(resultSet.getString("code"));
                priceDetailes.setVreme(resultSet.getTimestamp("datetimesys").toString());
                priceDetailes.setTotalAmount(priceDetailes.getPrice());
                priceDetailes.a = "aaa";
                list.add((Object)priceDetailes);
            }
            for (OfferPriceDetailes offerPriceDetailes : list) {
                sum += offerPriceDetailes.getTotalAmount().doubleValue();
            }
            if (list != null && !list.isEmpty() && list.size() > 0) {
                ((OfferPriceDetailes)list.get((int)0)).sum = sum;
            }
            resultSet.close();
            preparedStatementp.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void deleteBiillCancilation(ScreensController controller) {
        String sql = "delete  from billcancellation";
        PreparedStatement preparedStatementp = null;
        try {
            ChangeConnection.getConnectionAdmin(controller);
            preparedStatementp = controller.getSettings().getConnection().prepareStatement(sql);
            preparedStatementp.executeUpdate();
            ChangeConnection.getConnectionUser(controller);
            preparedStatementp.close();
        }
        catch (Exception e) {
            ChangeConnection.getConnectionUser(controller);
            controller.alert("Doslo je do greske!", "Pregled storniranih artikala nije obrisan. \n", controller.getRoot().getScene().getWindow());
            e.printStackTrace();
        }
    }

    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getNameProduct() {
        return this.nameProduct;
    }

    public void setNameProduct(String nameProduct) {
        this.nameProduct = nameProduct;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setOfferPriceQuantity(int offerPriceQuantity) {
        this.offerPriceQuantity = offerPriceQuantity;
    }

    public int getOfferPriceQuantity() {
        return this.offerPriceQuantity;
    }

    public double getSum() {
        return this.sum;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public long getOfferPriceDetailsID() {
        return this.OfferPriceDetailsID;
    }

    public void setOfferPriceDetailsID(long offerPriceDetailsID) {
        this.OfferPriceDetailsID = offerPriceDetailsID;
    }

    public long getOfferPriceID() {
        return this.OfferPriceID;
    }

    public void setOfferPriceID(long offerPriceID) {
        this.OfferPriceID = offerPriceID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public double getPrice() {
        return this.Price;
    }

    public void setPrice(double price) {
        this.Price = price;
    }

    public double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(double discount) {
        this.Discount = discount;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public static ObservableList<OfferPriceDetailes> getByProduct(long productID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "select opd.*, opd.Quantity AS Kolicina from offerpricedetails opd join offerprice op on op.OfferPriceID = opd.OfferPriceID \t\t\t\t\tand op.Active = true \t\t\t\t\tand op.DateFrom < now() \t\t\t\t\tand op.DateTo > now() where opd.ProductID = ? ";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                OfferPriceDetailes opd = new OfferPriceDetailes();
                opd.setOfferPriceDetailsID(rs.getLong("OfferPriceDetailsID"));
                opd.setProductID(rs.getLong("ProductID"));
                opd.setPrice(rs.getDouble("Price"));
                opd.setDiscount(rs.getDouble("Discount"));
                opd.setOfferPriceID(rs.getLong("OfferPriceID"));
                opd.setOfferPriceQuantity(rs.getInt("Kolicina"));
                opd.setQuantity(rs.getDouble("Quantity"));
                list.add((Object)opd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<OfferPriceDetailes> getByOfferPriceID(long offerPriceID, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT opd.*  FROM offerpricedetails opd JOIN offerprice op ON op.OfferPriceID = opd.OfferPriceID WHERE opd.OfferPriceID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(upit);
            ps.setLong(1, offerPriceID);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                OfferPriceDetailes opd = new OfferPriceDetailes();
                opd.setOfferPriceDetailsID(rs.getLong("OfferPriceDetailsID"));
                opd.setProductID(rs.getLong("ProductID"));
                opd.setPrice(rs.getDouble("Price"));
                opd.setDiscount(rs.getDouble("Discount"));
                opd.setOfferPriceID(rs.getLong("OfferPriceID"));
                opd.setQuantity(rs.getDouble("Quantity"));
                opd.setProduct(Product.getByID(opd.getProductID(), controller));
                list.add((Object)opd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static OfferPriceDetailes getRoundActive(long productId, Connection connection) {
        String upit = "SELECT opd.*, p.Code, p.ShortName, bc.BarCode FROM offerpricedetails opd LEFT JOIN offerprice op On op.OfferPriceID = opd.OfferPriceID LEFT JOIN product p On p.ProductID = opd.ProductID LEFT JOIN barcode bc ON bc.ProductID = p.ProductID WHERE opd.ProductID = ? AND op.Active = TRUE";
        OfferPriceDetailes opd = new OfferPriceDetailes();
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, productId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                opd.setOfferPriceDetailsID(rs.getLong("OfferPriceDetailsID"));
                opd.setProductID(rs.getLong("ProductID"));
                opd.setPrice(rs.getDouble("Price"));
                opd.setDiscount(rs.getDouble("Discount"));
                opd.setOfferPriceID(rs.getLong("OfferPriceID"));
                opd.setQuantity(rs.getDouble("Quantity"));
                Product product = new Product();
                product.setCode(rs.getString("Code"));
                product.setShortName(rs.getString("ShortName"));
                product.setBarcode(rs.getString("BarCode"));
                opd.setProduct(product);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return opd;
    }

    public static OfferPriceDetailes getByOfferPriceDetailsId(long offerPriceDetailsId, Connection connection) {
        String upit = "SELECT opd.*  FROM offerpricedetails opd WHERE opd.OfferPriceDetailsID = ?";
        OfferPriceDetailes opd = new OfferPriceDetailes();
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, offerPriceDetailsId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                opd.setOfferPriceDetailsID(rs.getLong("OfferPriceDetailsID"));
                opd.setProductID(rs.getLong("ProductID"));
                opd.setPrice(rs.getDouble("Price"));
                opd.setDiscount(rs.getDouble("Discount"));
                opd.setOfferPriceID(rs.getLong("OfferPriceID"));
                opd.setQuantity(rs.getDouble("Quantity"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return opd;
    }

    public static ObservableList<OfferPriceDetailes> getListByOfferPriceID(long offerPriceID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT opd.*, p.Code, p.ShortName, bc.BarCode FROM offerpricedetails opd LEFT JOIN product p On p.ProductID = opd.ProductID LEFT JOIN barcode bc ON bc.ProductID = p.ProductID WHERE opd.OfferPriceID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, offerPriceID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                OfferPriceDetailes opd = new OfferPriceDetailes();
                opd.setOfferPriceDetailsID(rs.getLong("OfferPriceDetailsID"));
                opd.setProductID(rs.getLong("ProductID"));
                opd.setPrice(rs.getDouble("Price"));
                opd.setDiscount(rs.getDouble("Discount"));
                opd.setOfferPriceID(rs.getLong("OfferPriceID"));
                opd.setQuantity(rs.getDouble("Quantity"));
                System.out.println("opd.getQuantity() " + opd.getQuantity());
                Product product = new Product();
                product.setCode(rs.getString("Code"));
                product.setShortName(rs.getString("ShortName"));
                product.setBarcode(rs.getString("BarCode"));
                opd.setProduct(product);
                list.add((Object)opd);
            }
            System.out.println(ps);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public Long insert(Connection connection) {
        long result = 0L;
        String query = "INSERT INTO `offerpricedetails` (`ProductID`, `Price`, `Discount`, `OfferPriceID`, `Quantity`) VALUES (?, ?, ?, ?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.ProductID);
            ps.setDouble(2, this.Price);
            ps.setDouble(3, this.Discount);
            ps.setLong(4, this.OfferPriceID);
            ps.setDouble(5, this.quantity);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            result = rs.getLong(1);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void delete(ScreensController controller) {
        String query = "DELETE FROM `offerpricedetails` WHERE  `OfferPriceDetailsID` = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setLong(1, this.getOfferPriceDetailsID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `offerpricedetails` SET `Price` = ?, `Discount` = ?, `Quantity` = ? WHERE `OfferPriceDetailsID` = ? AND `OfferPriceID` = ?;";
        try {
            PreparedStatement statement = controller.getSettings().getConnection().prepareStatement(query);
            statement.setDouble(1, this.Price);
            statement.setDouble(2, this.Discount);
            statement.setDouble(3, this.quantity);
            statement.setLong(4, this.OfferPriceDetailsID);
            statement.setLong(5, this.OfferPriceID);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public static void getReceivingReportToExcel(ScreensController controller, ObservableList<OfferPriceDetailes> list, String putanja, String name) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Akcijski cenovnik");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Sifra");
        header.createCell(1).setCellValue("Naziv artikla");
        header.createCell(2).setCellValue("Barkod");
        header.createCell(3).setCellValue("Cena");
        sheet.setColumnWidth(0, 4100);
        sheet.setColumnWidth(1, 12800);
        sheet.setColumnWidth(2, 4100);
        sheet.setColumnWidth(3, 3200);
        int index = 1;
        for (OfferPriceDetailes offerPriceDetailes : list) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(offerPriceDetailes.getProduct().getCode());
            row.createCell(1).setCellValue(offerPriceDetailes.getProduct().getShortName());
            row.createCell(2).setCellValue(offerPriceDetailes.getProduct().getBarcode());
            row.createCell(3).setCellValue(offerPriceDetailes.getPrice());
            ++index;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(putanja + File.separator + name);
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void delete(Product product, OfferPrice offerPrice, ScreensController controller) {
        String query = "DELETE FROM offerpricedetails WHERE offerpricedetails.OfferPriceDetailsID = ? AND OfferPriceID = ?";
        try {
            PreparedStatement statement = controller.getSettings().getConnection().prepareStatement(query);
            statement.setLong(1, product.getPriceListDetailsId());
            statement.setLong(2, offerPrice.getOfferPriceID());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

