/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.OfferPriceDetailes;

public class OfferPrice {
    private Long OfferPriceID;
    private int ObjectID;
    private String Name;
    private Date DateFrom;
    private Date DateTo;
    private boolean Active;
    private boolean FirstPrice;
    private boolean roundActive;
    private boolean activeTest;
    private int priceListTypeID;
    private ArrayList<OfferPriceDetailes> offerPriceDetailsList;

    public void setOfferPriceDetailsList(ArrayList<OfferPriceDetailes> offerPriceDetailsList) {
        this.offerPriceDetailsList = offerPriceDetailsList;
    }

    public ArrayList<OfferPriceDetailes> getOfferPriceDetailsList() {
        return this.offerPriceDetailsList;
    }

    public Long getOfferPriceID() {
        return this.OfferPriceID;
    }

    public void setOfferPriceID(Long offerPriceID) {
        this.OfferPriceID = offerPriceID;
    }

    public int getObjectID() {
        return this.ObjectID;
    }

    public void setObjectID(int objectID) {
        this.ObjectID = objectID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public Date getDateFrom() {
        return this.DateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.DateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.DateTo;
    }

    public void setDateTo(Date dateTo) {
        this.DateTo = dateTo;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public boolean isFirstPrice() {
        return this.FirstPrice;
    }

    public void setFirstPrice(boolean firstPrice) {
        this.FirstPrice = firstPrice;
    }

    public boolean isRoundActive() {
        return this.roundActive;
    }

    public void setRoundActive(boolean roundActive) {
        this.roundActive = roundActive;
    }

    public boolean isActiveTest() {
        return this.activeTest;
    }

    public void setActiveTest(boolean activeTest) {
        this.activeTest = activeTest;
    }

    public int getPriceListTypeID() {
        return this.priceListTypeID;
    }

    public void setPriceListTypeID(int priceListTypeID) {
        this.priceListTypeID = priceListTypeID;
    }

    public long insert(Connection connection) {
        String query = "INSERT INTO `offerprice` (`ObjectID`, `Name`, `DateFrom`, `DateTo`, `Active`, `FirstPrice`, `RoundActive`, `PriceListTypeID`)  VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setInt(1, this.ObjectID);
            ps.setString(2, this.Name);
            ps.setTimestamp(3, new Timestamp(this.DateFrom.getTime()));
            try {
                ps.setTimestamp(4, new Timestamp(this.DateTo.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(4, 91);
            }
            ps.setBoolean(5, this.Active);
            ps.setBoolean(6, this.FirstPrice);
            ps.setBoolean(7, this.roundActive);
            ps.setInt(8, 6);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.setOfferPriceID(rs.getLong(1));
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.getOfferPriceID();
    }

    public void update(Connection connection) {
        String query = "UPDATE `offerprice` SET `ObjectID`=?, `Name`=?, `DateFrom`=?, `DateTo`=?, `Active`=?, `FirstPrice`=?, `RoundActive`=?, `PriceListTypeID`=? WHERE  `OfferPriceID`=?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (this.ObjectID > 0) {
                ps.setInt(1, this.ObjectID);
            } else {
                ps.setNull(1, 4);
            }
            ps.setString(2, this.Name);
            ps.setTimestamp(3, new Timestamp(this.DateFrom.getTime()));
            try {
                ps.setTimestamp(4, new Timestamp(this.DateTo.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(4, 91);
            }
            ps.setBoolean(5, this.Active);
            ps.setBoolean(6, this.FirstPrice);
            ps.setBoolean(7, this.roundActive);
            ps.setInt(8, this.priceListTypeID);
            ps.setLong(9, this.OfferPriceID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<OfferPrice> getList(int objectID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT op.* FROM offerprice op WHERE op.ObjectID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setInt(1, objectID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                OfferPrice op = new OfferPrice();
                op.setOfferPriceID(rs.getLong("OfferPriceID"));
                try {
                    op.setObjectID(rs.getInt("ObjectID"));
                }
                catch (NullPointerException e) {
                    op.setObjectID(-1);
                }
                op.setName(rs.getString("Name"));
                op.setDateFrom(new Date(rs.getTimestamp("DateFrom").getTime()));
                op.setDateTo(new Date(rs.getTimestamp("DateTo").getTime()));
                op.setActive(rs.getBoolean("Active"));
                op.setFirstPrice(rs.getBoolean("FirstPrice"));
                op.setRoundActive(rs.getBoolean("RoundActive"));
                op.setPriceListTypeID(rs.getInt("PriceListTypeID"));
                list.add((Object)op);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            OfferPrice.createColumnActive(connection);
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<OfferPrice> getList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT op.* FROM offerprice op";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(upit);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                OfferPrice op = new OfferPrice();
                op.setOfferPriceID(rs.getLong("OfferPriceID"));
                try {
                    op.setObjectID(rs.getInt("ObjectID"));
                }
                catch (NullPointerException e) {
                    op.setObjectID(-1);
                }
                op.setName(rs.getString("Name"));
                op.setDateFrom(new Date(rs.getTimestamp("DateFrom").getTime()));
                op.setDateTo(new Date(rs.getTimestamp("DateTo").getTime()));
                op.setActive(rs.getBoolean("Active"));
                op.setFirstPrice(rs.getBoolean("FirstPrice"));
                op.setRoundActive(rs.getBoolean("RoundActive"));
                op.setPriceListTypeID(rs.getInt("PriceListTypeID"));
                list.add((Object)op);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            OfferPrice.createColumnActive(controller.getSettings().getConnection());
            e.printStackTrace();
        }
        return list;
    }

    public static OfferPrice getOfferPrice(long offerPriceId, Connection connection) {
        String upit = "SELECT * FROM offerprice op WHERE op.OfferPriceID = ? ";
        OfferPrice op = new OfferPrice();
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, offerPriceId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                op.setOfferPriceID(rs.getLong("OfferPriceID"));
                try {
                    op.setObjectID(rs.getInt("ObjectID"));
                }
                catch (NullPointerException e) {
                    op.setObjectID(-1);
                }
                op.setName(rs.getString("Name"));
                op.setDateFrom(new Date(rs.getTimestamp("DateFrom").getTime()));
                op.setDateTo(new Date(rs.getTimestamp("DateTo").getTime()));
                op.setActive(rs.getBoolean("Active"));
                op.setFirstPrice(rs.getBoolean("FirstPrice"));
                op.setRoundActive(rs.getBoolean("RoundActive"));
                op.setPriceListTypeID(rs.getInt("PriceListTypeID"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return op;
    }

    public void delete(Connection connection) throws SQLException {
        String query = "DELETE FROM `offerprice` WHERE  `OfferPriceID`=?;";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, this.getOfferPriceID());
        ps.executeUpdate();
        ps.close();
    }

    private static void createColumnActive(Connection connection) {
        try {
            PreparedStatement pStatement = connection.prepareStatement("ALTER TABLE `offerprice` ADD COLUMN `Active` INT NULL DEFAULT '0';");
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

