/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.product.Product;

public class NormativeItem {
    private long ProductComponentID;
    private long ArticleProductDepartmenID;
    private Product product;
    private BigDecimal normative;
    private int order;
    private String UnitName;
    private long IngredientProductDepartmentID;

    public String getUnitName() {
        return this.UnitName;
    }

    public void setUnitName(String unitName) {
        this.UnitName = unitName;
    }

    public long getProductComponentID() {
        return this.ProductComponentID;
    }

    public void setProductComponentID(long productComponentID) {
        this.ProductComponentID = productComponentID;
    }

    public long getArticleProductDepartmenID() {
        return this.ArticleProductDepartmenID;
    }

    public void setArticleProductDepartmenID(long articleProductDepartmenID) {
        this.ArticleProductDepartmenID = articleProductDepartmenID;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getNormative() {
        return this.normative;
    }

    public void setNormative(BigDecimal bigDecimal) {
        this.normative = bigDecimal;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getCode() {
        return this.product.getCode();
    }

    public String getName() {
        return this.product.getName();
    }

    public String getShortName() {
        return this.product.getShortName();
    }

    public void update(Connection connection) {
        String query = "update productcomponent set  Normative = ?, `Order` = ?  where ProductComponentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setBigDecimal(1, this.normative);
            ps.setInt(2, this.order);
            ps.setLong(3, this.ProductComponentID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insert(Connection connection) {
        String query = "insert into productcomponent \t(`ArticleProductDepartmenID`,`IngredientProductDepartmentID`, \t `Normative`,`Order`) values( ? , ? , ? , ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ArticleProductDepartmenID);
            ps.setLong(2, this.product.getProductDepartmentID());
            ps.setBigDecimal(3, this.normative);
            ps.setInt(4, this.order);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) {
        String query = "delete from productcomponent  where\tProductComponentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ProductComponentID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<NormativeItem> getObeservableList(long productId, Department department, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select distinct p.ProductID, \t   p.Code,  \t   p.Name,\t   p.ShortName,       u.Name as UnitName, \t   pc.ProductComponentID,\t   ROUND (pc.Normative,6) as Normative,\t   pc.Order,       pd.ProductDepartmentID,       pc.IngredientProductDepartmentID  from productcomponent pc  left join productdepartment pd on pd.ProductDepartmentID = pc.IngredientProductDepartmentID  left join product p on pd.ProductID = p.ProductID  left join unit u on u.UnitID = p.UnitID  where pc.ArticleProductDepartmenID = ?   and pd.DepartmentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            ps.setInt(2, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product p = new Product();
                p.setProductID(rs.getLong("ProductID"));
                p.setCode(rs.getString("Code"));
                p.setName(rs.getString("Name"));
                p.setShortName(rs.getString("ShortName"));
                p.setProductDepartmentID(rs.getLong("ProductDepartmentID"));
                NormativeItem ni = new NormativeItem();
                ni.setUnitName(rs.getString("UnitName"));
                ni.setProductComponentID(rs.getLong("ProductComponentID"));
                ni.setIngredientProductDepartmentID(rs.getLong("IngredientProductDepartmentID"));
                ni.setProduct(p);
                ni.setNormative(rs.getBigDecimal("Normative"));
                ni.setOrder(rs.getInt("Order"));
                list.add((Object)ni);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public long getIngredientProductDepartmentID() {
        return this.IngredientProductDepartmentID;
    }

    public void setIngredientProductDepartmentID(long ingredientProductDepartmentID) {
        this.IngredientProductDepartmentID = ingredientProductDepartmentID;
    }
}

