/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.User;

public class LogRecordModel {
    private int logRecordId;
    private String logRecordDateTime;
    private String userName;
    private String description;
    private Connection connection;

    public LogRecordModel() {
    }

    public LogRecordModel(ScreensController controller) {
        this.connection = controller.getSettings().getConnection();
    }

    public int getLogRecordId() {
        return this.logRecordId;
    }

    public void setLogRecordId(int logRecordId) {
        this.logRecordId = logRecordId;
    }

    public String getLogRecordDateTime() {
        return this.logRecordDateTime;
    }

    public void setLogRecordDateTime(String logRecordDateTime) {
        this.logRecordDateTime = logRecordDateTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ObservableList<LogRecordModel> getLogRcordsBetweenDates(LocalDate dateFrom, LocalDate dateTo) {
        String logDateTime = "";
        ObservableList listOfLogRecords = FXCollections.observableArrayList();
        String query = "SELECT * FROM log l  WHERE CAST(l.Time AS DATE) BETWEEN ? AND ? ";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, this.convertLocalToSqlDate(dateFrom));
            ps.setDate(2, this.convertLocalToSqlDate(dateTo));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                logDateTime = this.formattedLocalDateTime(rs.getTimestamp("Time").toLocalDateTime());
                LogRecordModel logRecord = new LogRecordModel();
                logRecord.setLogRecordId(rs.getInt("LogID"));
                logRecord.setLogRecordDateTime(logDateTime);
                User user = User.getUserByID(rs.getLong("UserID"), this.connection);
                logRecord.setUserName(user.getUserName());
                logRecord.setDescription(rs.getString("Description").replace("\n", " "));
                listOfLogRecords.add((Object)logRecord);
            }
            return listOfLogRecords;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Date convertLocalToSqlDate(LocalDate locDate) {
        return Date.valueOf(locDate);
    }

    private String formattedLocalDateTime(LocalDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy. hh:mm:ss");
        return formatter.format(dateTime);
    }
}

