/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.Product;

public class KepKnjiga {
    private String nazivDokumenta;
    private double vrednostPoDokumentu;
    private long brojDokumenta;
    private Date datumDokumenta;
    private long tipDokumenta;
    private long stock;
    private double donosZaduzenja;
    private double donosRazduzenja;
    private double donosSum;
    private double sumZaduzenje;
    private double sumRazduzenje;
    private double sumPrenos;
    private String dobavljac;

    public KepKnjiga() {
    }

    public KepKnjiga(String nazivDokumenta, double vrednostPoDokumentu, long brojDokumenta, Date datumDokumenta, long tipDokumenta, long stock, double donosZaduzenja, double donosRazduzenja, double donosSum, double sumZaduzenje, double sumRazduzenje, double sumPrenos, String dobavljac) {
        this.nazivDokumenta = nazivDokumenta;
        this.vrednostPoDokumentu = vrednostPoDokumentu;
        this.brojDokumenta = brojDokumenta;
        this.datumDokumenta = datumDokumenta;
        this.tipDokumenta = tipDokumenta;
        this.stock = stock;
        this.donosZaduzenja = donosZaduzenja;
        this.donosRazduzenja = donosRazduzenja;
        this.donosSum = donosSum;
        this.sumZaduzenje = sumZaduzenje;
        this.sumRazduzenje = sumRazduzenje;
        this.sumPrenos = sumPrenos;
        this.dobavljac = dobavljac;
    }

    public String getNazivDokumenta() {
        return this.nazivDokumenta;
    }

    public void setNazivDokumenta(String nazivDokumenta) {
        this.nazivDokumenta = nazivDokumenta;
    }

    public double getVrednostPoDokumentu() {
        return this.vrednostPoDokumentu;
    }

    public void setVrednostPoDokumentu(double vrednostPoDokumentu) {
        this.vrednostPoDokumentu = vrednostPoDokumentu;
    }

    public long getBrojDokumenta() {
        return this.brojDokumenta;
    }

    public void setBrojDokumenta(long brojDokumenta) {
        this.brojDokumenta = brojDokumenta;
    }

    public Date getDatumDokumenta() {
        return this.datumDokumenta;
    }

    public void setDatumDokumenta(Date datumDokumenta) {
        this.datumDokumenta = datumDokumenta;
    }

    public long getTipDokumenta() {
        return this.tipDokumenta;
    }

    public void setTipDokumenta(long tipDokumenta) {
        this.tipDokumenta = tipDokumenta;
    }

    public long getStock() {
        return this.stock;
    }

    public void setStock(long stock) {
        this.stock = stock;
    }

    public double getDonosZaduzenja() {
        return this.donosZaduzenja;
    }

    public void setDonosZaduzenja(double donosZaduzenja) {
        this.donosZaduzenja = donosZaduzenja;
    }

    public double getDonosRazduzenja() {
        return this.donosRazduzenja;
    }

    public void setDonosRazduzenja(double donosRazduzenja) {
        this.donosRazduzenja = donosRazduzenja;
    }

    public double getDonosSum() {
        return this.donosSum;
    }

    public void setDonosSum(double donosSum) {
        this.donosSum = donosSum;
    }

    public double getSumZaduzenje() {
        return this.sumZaduzenje;
    }

    public void setSumZaduzenje(double sumZaduzenje) {
        this.sumZaduzenje = sumZaduzenje;
    }

    public double getSumRazduzenje() {
        return this.sumRazduzenje;
    }

    public void setSumRazduzenje(double sumRazduzenje) {
        this.sumRazduzenje = sumRazduzenje;
    }

    public double getSumPrenos() {
        return this.sumPrenos;
    }

    public void setSumPrenos(double sumPrenos) {
        this.sumPrenos = sumPrenos;
    }

    public String getDobavljac() {
        return this.dobavljac;
    }

    public void setDobavljac(String dobavljac) {
        this.dobavljac = dobavljac;
    }

    public String toString() {
        return "KepKnjiga [nazivDokumenta=" + this.nazivDokumenta + ", vrednostPoDokumentu=" + this.vrednostPoDokumentu + ", brojDokumenta=" + this.brojDokumenta + ", datumDokumenta=" + this.datumDokumenta + ", tipDokumenta=" + this.tipDokumenta + ", stock=" + this.stock + ", donosZaduzenja=" + this.donosZaduzenja + ", donosRazduzenja=" + this.donosRazduzenja + ", donosSum=" + this.donosSum + ", sumZaduzenje=" + this.sumZaduzenje + ", sumRazduzenje=" + this.sumRazduzenje + ", sumPrenos=" + this.sumPrenos + ", dobavljac=" + this.dobavljac + "]";
    }

    public static ObservableList<KepKnjiga> createKepKnjigas(Date date, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        int departmentId = Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID();
        LocalDateTime datumPocetnogStanja = WorkDay.datumPocetnogStanja(departmentId, date, controller.getSettings().getConnection());
        LocalDateTime pocetakDana = WorkDay.getPocetakDanaZaDatum(date, departmentId, controller);
        LocalDateTime krajDana = WorkDay.getKrajaDanaZaDatum(date, departmentId, controller);
        ObservableList listaAditionalFields = FXCollections.observableArrayList();
        ObservableList<Product> donosSumList = Product.getNewReceivingReport("", (ObservableList<AditionalField>)listaAditionalFields, "", controller, departmentId, Settings.fromDate(new Date(date.getTime() - 1L)), false, false, false, false, false, false, false, true, true);
        double donosSum = 0.0;
        double donosZad = 0.0;
        double donosRazduzenje = KepKnjiga.getDonosRazduzenjeDoDatuma(datumPocetnogStanja, pocetakDana, controller);
        for (Product product : donosSumList) {
            donosSum += product.getPrice() * product.getStock();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (sdf.parse(sdf.format(Settings.DatefromLocalDateTime(datumPocetnogStanja))).compareTo(sdf.parse(sdf.format(date))) == 0) {
                donosSum = KepKnjiga.getPocetnoStanjeSum(pocetakDana, controller);
                donosRazduzenje = 0.0;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        donosZad = donosSum + donosRazduzenje;
        KepKnjiga kepKnjiga = new KepKnjiga("", 0.0, -1L, null, -1L, 0L, Settings.round(donosZad, 2), Settings.round(donosRazduzenje, 2), Settings.round(donosSum, 2), 0.0, 0.0, 0.0, "");
        list.add((Object)kepKnjiga);
        double sumDnevnoZaduzenje = 0.0;
        double sumDnevnoRazduzenje = 0.0;
        for (KepKnjiga knjiga : KepKnjiga.createKepKnjigaByDate(pocetakDana, departmentId, controller)) {
            list.add((Object)knjiga);
            sumDnevnoZaduzenje += knjiga.getVrednostPoDokumentu();
        }
        for (KepKnjiga knjigaDnevniPromet : KepKnjiga.createKepKnjigaByDateDnevniPromet(date, controller)) {
            list.add((Object)knjigaDnevniPromet);
            sumDnevnoRazduzenje += knjigaDnevniPromet.getVrednostPoDokumentu();
        }
        KepKnjiga kepKnjigaPrenos = new KepKnjiga("", 0.0, -1L, null, -1L, 0L, 0.0, 0.0, 0.0, Settings.round(donosZad + sumDnevnoZaduzenje, 2), Settings.round(donosRazduzenje + sumDnevnoRazduzenje, 2), Settings.round(donosZad + sumDnevnoZaduzenje - (donosRazduzenje + sumDnevnoRazduzenje), 2), "");
        list.add((Object)kepKnjigaPrenos);
        return list;
    }

    public static ObservableList<KepKnjiga> createKepKnjigaByDate(LocalDateTime pocetakDana, int departmentID, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT\r\n\t(SELECT dt.Name\r\n\tFROM documenttype dt\r\n\tWHERE dt.DocumentTypeID = d.DocumentTypeID) AS NazivDokumenta,\r\n\tSUM(ROUND(COALESCE(dd.Quantity *(IF( d.DocumentTypeID = 22, (-1 * dd.Price), if(d.DocumentTypeID = 9, (dd.NewPrice * -1), IF(d.DocumentTypeID = 15,(dd.NewPrice - dd.Price), if(d.DocumentTypeID = 7, (dd.NewPrice * -1),  if(d.DocumentTypeID = 14, (dd.NewPrice * -1), \r\n\tIF(d.DocumentTypeID = 1, dd.NewPrice, dd.PriceWithDiscount))))))),0),4)) AS VrednostPoDokumentu,\r\n\t(SELECT MIN(d1.Number)\r\n\t\tFROM documentdetails dd1\r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tWHERE d1.DocumentID in (d.DocumentID)) AS BrojDokumenta,\r\n\t(SELECT (if(d.DocumentTypeID = 1, d1.DeliveryDate, d1.Date)) \r\n\t\tFROM documentdetails dd1\r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tWHERE d1.DocumentID in (d.DocumentID)\r\n\t\tLIMIT 1) AS DatumDokumenta,\r\n\t(SELECT MIN(d1.DocumentTypeID)\r\n\t\tFROM documentdetails dd1\r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tWHERE d1.DocumentID in (d.DocumentID)) AS TipDokumenta,\r\n\t(SELECT dt1.Stock FROM documenttype dt1 WHERE dt1.DocumentTypeID = d.DocumentTypeID) AS Stock,\r\n \t0 AS DonosZaduzenja,\r\n\t0 AS DonosRazduzenja,\r\n\t0 AS DonosSum,\r\n\t0 AS SumZaduzenje,\r\n\t0 AS SumRazduzenje,\r\n\t0 AS SumPrenos,\r\n\t(SELECT (if(d.DocumentTypeID = 1 OR d.DocumentTypeId = 14, (SELECT CONCAT(p.Name, \", \", p.Address, \", \" , p.ZIP, \" \", p.City) FROM person p WHERE p.PersonID = d1.PersonID), 0))\r\n\t\tFROM documentdetails dd1\r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tWHERE d1.DocumentID in (d.DocumentID)\r\n\t\tLIMIT 1) AS Dobavljac\r\n\tFROM documentdetails dd\r\n\tJOIN document d ON d.DocumentID = dd.DocumentID \r\n\t  \t\t\t\t\t\t\t\tAND d.DocumentTypeID IN (SELECT dt1.DocumentTypeID \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFROM documenttype dt1\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWHERE dt1.DocumentTypeID <> 3 AND dt1.DocumentTypeID <> 11 AND dt1.DocumentTypeID <> 19 AND dt1.DocumentTypeID <> 17)\r\n\t\t\t\t\t\t\t\t\tAND if(d.DocumentTypeID = 1, CAST(d.DeliveryDate AS Date), CAST(d.Date AS DATE)) = CAST(? AS DATE) \r\n\t\t\t\t\t\t\t\t\tAND if(d.DocumentTypeID IN (6,17), d.PointOfSaleID IN \r\n\t\t\t\t\t\t\t\t\t(SELECT posd.PointOfSaleID FROM pointofsaledepartment posd WHERE posd.DepartmentID = ?), \r\n\t\t\t\t\t\t\t\t\td.DepartmentID =  ?)\r\nwhere d.DocumentTypeID !=22 GROUP BY d.DocumentID;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(Settings.DatefromLocalDateTime(pocetakDana).getTime()));
            pStatement.setInt(2, departmentID);
            pStatement.setInt(3, departmentID);
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                KepKnjiga kepKnjiga = new KepKnjiga();
                kepKnjiga.setNazivDokumenta(rSet.getString("NazivDokumenta"));
                kepKnjiga.setVrednostPoDokumentu(Settings.round(rSet.getDouble("VrednostPoDokumentu"), 2));
                kepKnjiga.setBrojDokumenta(rSet.getLong("BrojDokumenta"));
                kepKnjiga.setDatumDokumenta(rSet.getDate("DatumDokumenta"));
                kepKnjiga.setTipDokumenta(rSet.getLong("TipDokumenta"));
                kepKnjiga.setStock(rSet.getLong("Stock"));
                kepKnjiga.setDonosZaduzenja(rSet.getDouble("DonosZaduzenja"));
                kepKnjiga.setDonosRazduzenja(rSet.getDouble("DonosRazduzenja"));
                kepKnjiga.setDonosSum(rSet.getDouble("DonosSum"));
                kepKnjiga.setSumZaduzenje(rSet.getDouble("SumZaduzenje"));
                kepKnjiga.setSumRazduzenje(rSet.getDouble("SumRazduzenje"));
                kepKnjiga.setSumPrenos(rSet.getDouble("SumPrenos"));
                kepKnjiga.setDobavljac(rSet.getString("Dobavljac"));
                list.add((Object)kepKnjiga);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static ObservableList<KepKnjiga> createKepKnjigaByDateDnevniPromet(Date date, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "";
        boolean dailyTO = KepKnjiga.getDailyReport(date, controller);
        query = dailyTO ? "SELECT CONCAT('Dnevni promet',' (', (SELECT pos.Name FROM pointofsale pos WHERE pos.PointOfSaleID = wd.PointOfSaleID),')'), (SELECT SUM(dd.Quantity * dd.PriceWithDiscount) \r\n \t\tFROM documentdetails dd \r\n \t\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID  \r\n \t\tLEFT JOIN workday wd ON wd.WorkDayID = d.WorkDayID \r\n \t\tWHERE wd.WorkDayID = dt.DailyTurnoverWorkDayID AND d.DocumentTypeID = 3 and d.DocumentStatusID !=3 ), dt.DailyTurnoverNumber, DATE(dt.DailyTurnoverDate), 17, 0,0,0,0,0,0,0\r\n\t\tFROM dailyturnover dt \r\n\t\tLEFT JOIN workday wd ON wd.WorkDayID = dt.DailyTurnoverWorkDayID\r\n\t\tWHERE wd.Date = ? GROUP BY wd.PointOfSaleID;" : "SELECT\r\nif(d.DocumentTypeID = 3,\r\n CONCAT('Dnevni promet',' (', (SELECT pos.Name FROM pointofsale pos WHERE pos.PointOfSaleID = wd.PointOfSaleID),')'),'Nalog za ispravku'), \r\nif(d.DocumentTypeID = 3, SUM(dd.Quantity * dd.PriceWithDiscount), SUM(dd.Quantity * dd.PriceWithDiscount)*-1),\r\nif(d.DocumentTypeID = 3,DAYOFYEAR(?),d.Number) AS Number, \r\n CAST(d.Date AS Date) AS DATE, \r\n17, -1,0,0,0,0,0,0,''\r\n\t\t\t\tFROM documentdetails dd \r\n \t\t\t\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID  \r\n \t\t\t\tLEFT JOIN workday wd ON wd.WorkDayID = d.WorkDayID \r\n\t\t\t\t\tJOIN product p ON dd.ProductID = p.ProductID \r\n\t\t\t\tWHERE d.DocumentTypeID IN (3, 22)  and d.DocumentStatusID !=3\r\n\t\t\t\tAND CAST(d.Date AS Date) = CAST(? AS DATE) \tAND p.ProductCategoryID != 2 \r\n\t\t\t\tGROUP BY wd.PointOfSaleID;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(date.getTime()));
            if (!dailyTO) {
                pStatement.setTimestamp(2, new Timestamp(date.getTime()));
            }
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                KepKnjiga kepKnjiga = new KepKnjiga();
                kepKnjiga.setNazivDokumenta(rSet.getString(1));
                kepKnjiga.setVrednostPoDokumentu(rSet.getDouble(2));
                kepKnjiga.setBrojDokumenta(rSet.getLong(3));
                kepKnjiga.setDatumDokumenta(rSet.getDate(4));
                kepKnjiga.setTipDokumenta(rSet.getLong(5));
                kepKnjiga.setStock(rSet.getLong(6));
                kepKnjiga.setDonosZaduzenja(rSet.getDouble(7));
                kepKnjiga.setDonosRazduzenja(rSet.getDouble(8));
                kepKnjiga.setDonosSum(rSet.getDouble(9));
                kepKnjiga.setSumZaduzenje(rSet.getDouble(10));
                kepKnjiga.setSumRazduzenje(rSet.getDouble(11));
                kepKnjiga.setSumPrenos(rSet.getDouble(12));
                kepKnjiga.setDobavljac(rSet.getString(13));
                list.add((Object)kepKnjiga);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }

    private static boolean getDailyReport(Date date, ScreensController controller) {
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT COUNT(*) FROM dailyturnover dt WHERE dt.DailyTurnoverWorkDayID IN (SELECT wd.WorkDayID FROM workday wd WHERE wd.Date = ?)");
            pStatement.setTimestamp(1, new Timestamp(date.getTime()));
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            return rSet.getLong(1) != 0L;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static double getDonosRazduzenjeDoDatuma(LocalDateTime datumPocetnogStanja, LocalDateTime pocetakDana, ScreensController controller) {
        String query = "SELECT COALESCE(ROUND(SUM(dd.Quantity * IF(d.DocumentTypeID = 22, (-1) * dd.Price, dd.PriceWithDiscount)),4),0) AS Razduzenje\r\n\t\t\tFROM documentdetails dd\r\n\t\t\tINNER JOIN document d ON d.DocumentID = dd.DocumentID\r\n\t\t\tJOIN product p ON dd.ProductID = p.ProductID \r\n\t\t\tWHERE d.DocumentTypeID IN (SELECT dt.DocumentTypeID FROM documenttype dt WHERE dt.DocumentTypeID = 3 OR dt.DocumentTypeID = 22  ) and d.DocumentStatusID !=3  \r\n\t\t\tAND d.Date >= ?\r\n\t\t\tAND d.Date < ?\r\n\t\t\tAND p.ProductCategoryID != 2\t\t\tORDER BY dd.ProductID";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(Settings.DatefromLocalDateTime(datumPocetnogStanja).getTime()));
            pStatement.setTimestamp(2, new Timestamp(Settings.DatefromLocalDateTime(pocetakDana).getTime()));
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            return rSet.getDouble("Razduzenje");
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    public static double getPocetnoStanjeSum(LocalDateTime date, ScreensController controller) {
        String query = "SELECT COALESCE(SUM(dd.Quantity * (SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = dd.ProductID AND pld.Date <= ? ORDER BY pld.ProductID DESC LIMIT 1)),0) AS Zaduzenje\r\n\t\t\tFROM documentdetails dd\r\n\t\t\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID \r\n\t\t\tWHERE d.DocumentTypeID = 11\r\n\t\t\tAND DATE(d.Date) = DATE(?)\r\n\t\t\tORDER BY dd.ProductID";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(Settings.DatefromLocalDateTime(date).getTime()));
            pStatement.setTimestamp(2, new Timestamp(Settings.DatefromLocalDateTime(date).getTime()));
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            return rSet.getDouble("Zaduzenje");
        }
        catch (SQLException e) {
            return 0.0;
        }
    }
}

