/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.image.Image;
import rs.petcom.master.ScreensController;

public class Group {
    private int GroupID;
    private String Name;
    private int ParentGroupID;
    private boolean Active;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private String color;
    private Image picture;

    public Group() {
    }

    public Group(int GroupID, String Name) {
        this.GroupID = GroupID;
        this.Name = Name;
    }

    public int getGroupID() {
        return this.GroupID;
    }

    public void setGroupID(int groupID) {
        this.GroupID = groupID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public int getParentGroupID() {
        return this.ParentGroupID;
    }

    public void setParentGroupID(int parentGroupID) {
        this.ParentGroupID = parentGroupID;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Image getPicture() {
        return this.picture;
    }

    public void setPicture(Image picture) {
        this.picture = picture;
    }

    public String toString() {
        return this.getName();
    }

    public static ObservableList<Group> getList(String filter, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT g.* FROM `group` g WHERE g.Name LIKE ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, "%" + filter + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Group group = new Group();
                group.setGroupID(rs.getInt("GroupID"));
                group.setName(rs.getString("Name"));
                group.setParentGroupID(rs.getInt("ParentGroupID"));
                group.setActive(rs.getBoolean("Active"));
                group.setSysDTCreated(rs.getDate("sysDTCreated"));
                group.setSysDTEdit(rs.getDate("sysDTEdit"));
                group.setSysUserAddID(rs.getLong("sysUserAddID"));
                group.setSysUserEditID(rs.getLong("sysUserEditID"));
                group.setColor(rs.getString("Color"));
                if (rs.getBinaryStream("Picture") != null) {
                    InputStream iStream = rs.getBinaryStream("Picture");
                    FileOutputStream oStream = new FileOutputStream("photo.jpg");
                    byte[] content = new byte[1024];
                    int size = 0;
                    while ((size = iStream.read(content)) != -1) {
                        ((OutputStream)oStream).write(content, 0, size);
                    }
                    ((OutputStream)oStream).close();
                    iStream.close();
                    group.setPicture(new Image("file:photo.jpg"));
                } else {
                    group.setPicture(null);
                }
                list.add((Object)group);
            }
            ps.close();
            rs.close();
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Group> getGroupList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM `group` g WHERE g.ParentGroupID IS NULL ORDER BY g.GroupID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Group g = new Group();
                g.setGroupID(rs.getInt("GroupID"));
                g.setName(rs.getString("Name"));
                g.setActive(rs.getBoolean("Active"));
                g.setColor(rs.getString("Color"));
                if (rs.getBinaryStream("Picture") != null) {
                    InputStream iStream = rs.getBinaryStream("Picture");
                    FileOutputStream oStream = new FileOutputStream("photo.jpg");
                    byte[] content = new byte[1024];
                    int size = 0;
                    while ((size = iStream.read(content)) != -1) {
                        ((OutputStream)oStream).write(content, 0, size);
                    }
                    ((OutputStream)oStream).close();
                    iStream.close();
                    g.setPicture(new Image("file:photo.jpg"));
                } else {
                    g.setPicture(null);
                }
                list.add((Object)g);
            }
            rs.close();
            ps.close();
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Group> getSubGroupList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM `group` g WHERE g.ParentGroupID IS NOT NULL ORDER BY g.GroupID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Group g = new Group();
                g.setGroupID(rs.getInt("GroupID"));
                g.setName(rs.getString("Name"));
                g.setActive(rs.getBoolean("Active"));
                g.setColor(rs.getString("Color"));
                if (rs.getBinaryStream("Picture") != null) {
                    InputStream iStream = rs.getBinaryStream("Picture");
                    FileOutputStream oStream = new FileOutputStream("photo.jpg");
                    byte[] content = new byte[1024];
                    int size = 0;
                    while ((size = iStream.read(content)) != -1) {
                        ((OutputStream)oStream).write(content, 0, size);
                    }
                    ((OutputStream)oStream).close();
                    iStream.close();
                    g.setPicture(new Image("file:photo.jpg"));
                } else {
                    g.setPicture(null);
                }
                list.add((Object)g);
            }
            rs.close();
            ps.close();
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Group> getSubGroupListByGroupID(ScreensController controller, Group group) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT g.* FROM `group` g WHERE g.ParentGroupID IS NOT NULL AND g.ParentGroupID = ? ORDER BY g.GroupID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, group.getGroupID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Group g = new Group();
                g.setGroupID(rs.getInt("GroupID"));
                g.setName(rs.getString("Name"));
                g.setActive(rs.getBoolean("Active"));
                g.setColor(rs.getString("Color"));
                if (rs.getBinaryStream("Picture") != null) {
                    InputStream iStream = rs.getBinaryStream("Picture");
                    FileOutputStream oStream = new FileOutputStream("photo.jpg");
                    byte[] content = new byte[1024];
                    int size = 0;
                    while ((size = iStream.read(content)) != -1) {
                        ((OutputStream)oStream).write(content, 0, size);
                    }
                    ((OutputStream)oStream).close();
                    iStream.close();
                    g.setPicture(new Image("file:photo.jpg"));
                } else {
                    g.setPicture(null);
                }
                list.add((Object)g);
            }
            rs.close();
            ps.close();
        }
        catch (IOException | SQLException e) {
            return null;
        }
        return list;
    }

    public static ObservableList<Group> getSubgroupList(int groupID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM `group` g WHERE g.ParentGroupID = ? ORDER BY g.GroupID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, groupID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Group g = new Group();
                g.setGroupID(rs.getInt("GroupID"));
                g.setName(rs.getString("Name"));
                g.setColor(rs.getString("Color"));
                if (rs.getBinaryStream("Picture") != null) {
                    InputStream iStream = rs.getBinaryStream("Picture");
                    FileOutputStream oStream = new FileOutputStream("photo.jpg");
                    byte[] content = new byte[1024];
                    int size = 0;
                    while ((size = iStream.read(content)) != -1) {
                        ((OutputStream)oStream).write(content, 0, size);
                    }
                    ((OutputStream)oStream).close();
                    iStream.close();
                    g.setPicture(new Image("file:photo.jpg"));
                } else {
                    g.setPicture(null);
                }
                list.add((Object)g);
            }
            rs.close();
            ps.close();
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public int createNewGroup(ScreensController controller, File picture) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`group` (`Name`, `Active`, `ParentGroupID`, `sysUserAddID`, `sysDTCreated`, `Color`, `Picture`) VALUES (?, ?, ?, ?, ?, ?, ?);";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setString(1, this.Name);
            ps.setBoolean(2, this.Active);
            if (this.ParentGroupID == -1) {
                ps.setNull(3, 4);
            } else {
                ps.setInt(3, this.ParentGroupID);
            }
            ps.setLong(4, controller.getUser().getUserID());
            ps.setTimestamp(5, new Timestamp(this.sysDTCreated.getTime()));
            ps.setString(6, this.color);
            ps.setBlob(7, new FileInputStream(picture));
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.GroupID = rs.getInt(1);
            rs.close();
            ps.close();
            return this.GroupID;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void updateGroup(ScreensController controller, File picture) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`group` SET `Name` = ?, `Active` = ?, `ParentGroupID` = ?, `sysDTEdit` = ?, `sysUserEditID` = ?, `Color` = ?, `Picture` = ? WHERE `GroupID` = ?;";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setString(1, this.Name);
            ps.setBoolean(2, this.Active);
            if (this.ParentGroupID == -1) {
                ps.setNull(3, 4);
            } else {
                ps.setInt(3, this.ParentGroupID);
            }
            ps.setTimestamp(4, new Timestamp(this.sysDTEdit.getTime()));
            ps.setLong(5, this.sysUserEditID);
            ps.setString(6, this.color);
            try {
                ps.setBlob(7, new FileInputStream(picture));
            }
            catch (NullPointerException e) {
                ps.setNull(7, 2004);
            }
            ps.setInt(8, this.GroupID);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
        }
        catch (FileNotFoundException | SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(ScreensController controller) {
        String query = "DELETE FROM `" + controller.getSettings().getDatabase() + "`.`group` WHERE  `GroupID` = ?";
        for (Group g : Group.getSubgroupList(this.GroupID, controller.getSettings().getConnection())) {
            g.delete(controller);
        }
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, this.GroupID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Group getGroupById(long groupID, ScreensController controller) {
        String query = "SELECT g.* FROM `group` g WHERE g.GroupID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, groupID);
            ResultSet rs = pStatement.executeQuery();
            rs.next();
            Group group = new Group();
            group.setGroupID(rs.getInt("GroupID"));
            group.setName(rs.getString("Name"));
            group.setParentGroupID(rs.getInt("ParentGroupID"));
            group.setActive(rs.getBoolean("Active"));
            group.setSysDTCreated(rs.getDate("sysDTCreated"));
            group.setSysDTEdit(rs.getDate("sysDTEdit"));
            group.setSysUserAddID(rs.getLong("sysUserAddID"));
            group.setSysUserEditID(rs.getLong("sysUserEditID"));
            group.setColor(rs.getString("Color"));
            if (rs.getBinaryStream("Picture") != null) {
                InputStream iStream = rs.getBinaryStream("Picture");
                FileOutputStream oStream = new FileOutputStream("photo.jpg");
                byte[] content = new byte[1024];
                int size = 0;
                while ((size = iStream.read(content)) != -1) {
                    ((OutputStream)oStream).write(content, 0, size);
                }
                ((OutputStream)oStream).close();
                iStream.close();
                group.setPicture(new Image("file:photo.jpg"));
            } else {
                group.setPicture(null);
            }
            return group;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

