/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.LoyaltyFinancialDiscount;

public class FinancialDiscount {
    private long financialDiscountiD;
    private String name;
    private double value;
    private double discount;
    private boolean active;

    public long getFinancialDiscountiD() {
        return this.financialDiscountiD;
    }

    public void setFinancialDiscountiD(long financialDiscountiD) {
        this.financialDiscountiD = financialDiscountiD;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String toString() {
        return this.name;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `financialdiscount` (`Name`, `Value`, `Discount`, `Active`) VALUES (?, ?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setDouble(2, this.value);
            pStatement.setDouble(3, this.discount);
            pStatement.setBoolean(4, this.active);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `financialdiscount` SET `Name` = ?, `Value` = ?, `Discount` = ?, `Active`= ? WHERE  `FinancialDiscountID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setDouble(2, this.value);
            pStatement.setDouble(3, this.discount);
            pStatement.setBoolean(4, this.active);
            pStatement.setLong(5, this.financialDiscountiD);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(ScreensController controller) {
        String query = "DELETE FROM `financialdiscount` WHERE  `FinancialDiscountID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.financialDiscountiD);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<FinancialDiscount> getFinancialDiscountsList(ScreensController controller) {
        String query = "SELECT * FROM financialdiscount fd";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                FinancialDiscount financialDiscount = new FinancialDiscount();
                financialDiscount.setFinancialDiscountiD(rSet.getLong("FinancialDiscountiD"));
                financialDiscount.setName(rSet.getString("Name"));
                financialDiscount.setValue(rSet.getDouble("Value"));
                financialDiscount.setDiscount(rSet.getDouble("Discount"));
                financialDiscount.setActive(rSet.getBoolean("Active"));
                list.add((Object)financialDiscount);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static FinancialDiscount getFinancialDiscountById(long id, ScreensController controller) {
        String query = "SELECT * FROM financialdiscount fd where fd.FinancialDiscountiD = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, id);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            FinancialDiscount financialDiscount = new FinancialDiscount();
            financialDiscount.setFinancialDiscountiD(rSet.getLong("FinancialDiscountiD"));
            financialDiscount.setName(rSet.getString("Name"));
            financialDiscount.setValue(rSet.getDouble("Value"));
            financialDiscount.setDiscount(rSet.getDouble("Discount"));
            financialDiscount.setActive(rSet.getBoolean("Active"));
            return financialDiscount;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static double getDiscountforFinancialDiscount(Loyality l, double value, double reservationValue, ScreensController controller) {
        double discount = 0.0;
        double finalValue = value + reservationValue;
        for (LoyaltyFinancialDiscount lfdDiscount : LoyaltyFinancialDiscount.getListByLoyalty(l.getLoyalityID(), controller)) {
            FinancialDiscount financialDiscount = FinancialDiscount.getFinancialDiscountById(lfdDiscount.getFinancialDiscountID(), controller);
            if (!(finalValue >= financialDiscount.getValue())) continue;
            discount = financialDiscount.getDiscount();
        }
        return discount;
    }
}

