/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ExciseProduct {
    private long exciseProductId;
    private long exciseId;
    private long productId;
    private double value;

    public long getExciseProductId() {
        return this.exciseProductId;
    }

    public void setExciseProductId(long exciseProductId) {
        this.exciseProductId = exciseProductId;
    }

    public long getExciseId() {
        return this.exciseId;
    }

    public void setExciseId(long exciseId) {
        this.exciseId = exciseId;
    }

    public long getProductId() {
        return this.productId;
    }

    public void setProductId(long productId) {
        this.productId = productId;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public static ExciseProduct getByProductId(Connection connection, long productId) {
        String query = "SELECT ep.* FROM exciseproduct ep WHERE ep.ProductID = ?";
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setLong(1, productId);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            ExciseProduct exciseProduct = new ExciseProduct();
            exciseProduct.setExciseProductId(rSet.getLong("ExciseProductID"));
            exciseProduct.setExciseId(rSet.getLong("ExciseID"));
            exciseProduct.setProductId(rSet.getLong("ProductID"));
            exciseProduct.setValue(rSet.getDouble("Value"));
            return exciseProduct;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void insert(Connection connection) {
        String query = "INSERT INTO `exciseproduct` (`ExciseID`, `ProductID`, `Value`) VALUES (?, ?, ?);";
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setLong(1, this.exciseId);
            pStatement.setLong(2, this.productId);
            pStatement.setDouble(3, this.value);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(Connection connection) {
        String query = "UPDATE `exciseproduct` SET `ExciseID` = ?, `ProductID` = ?, `Value` = ? WHERE  `ExciseProductID` = ?;";
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setLong(1, this.exciseId);
            pStatement.setLong(2, this.productId);
            pStatement.setDouble(3, this.value);
            pStatement.setLong(4, this.exciseProductId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) {
        String query = "DELETE FROM `exciseproduct` WHERE  `ExciseProductID` = ?;";
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setLong(1, this.exciseProductId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

