/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PayCard;
import rs.petcom.master.dal.document.Document;

public class DocumentPayCard {
    private long documentPayCardId;
    private Document document;
    private PayCard payCard;
    private double value;
    private double documentSum;
    private double differentSum;
    private String payCardName;

    public long getDocumentPayCardId() {
        return this.documentPayCardId;
    }

    public void setDocumentPayCardId(long documentPayCardId) {
        this.documentPayCardId = documentPayCardId;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public PayCard getPayCard() {
        return this.payCard;
    }

    public void setPayCard(PayCard payCard) {
        this.payCard = payCard;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getDocumentSum() {
        return this.documentSum;
    }

    public void setDocumentSum(double documentSum) {
        this.documentSum = documentSum;
    }

    public double getDifferentSum() {
        return this.differentSum;
    }

    public void setDifferentSum(double differentSum) {
        this.differentSum = differentSum;
    }

    public String getPayCardName() {
        return this.payCardName;
    }

    public void setPayCardName(String payCardName) {
        this.payCardName = payCardName;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`documentpaycard` (`DocumentID`, `PayCardID`, `Value`) VALUES (?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.document.getDocumentID());
            pStatement.setLong(2, this.payCard.getPayCardId());
            pStatement.setDouble(3, this.value);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<DocumentPayCard> getList(ScreensController controller, LocalDateTime from, LocalDateTime to, String payCards) {
        ObservableList list = FXCollections.observableArrayList();
        String query = " SELECT \r\n dpc.PayCardID, \r\n SUM(dpc.Value) AS Value, \r\n SUM(d.SumWithDiscount) AS DocumentSum \r\nFROM documentpaycard dpc\r\nLEFT JOIN document d ON d.DocumentID = dpc.DocumentID\r\nWHERE FIND_IN_SET(dpc.PayCardID, ?)\r\nAND d.Date BETWEEN ? AND ? GROUP BY dpc.PayCardID";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, payCards);
            pStatement.setTimestamp(2, Timestamp.valueOf(from));
            pStatement.setTimestamp(3, Timestamp.valueOf(to));
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                DocumentPayCard documentPayCard = new DocumentPayCard();
                documentPayCard.setPayCard(PayCard.getById(rSet.getLong("PayCardID"), controller));
                documentPayCard.setValue(rSet.getDouble("Value"));
                documentPayCard.setDocumentSum(rSet.getDouble("DocumentSum"));
                documentPayCard.setDifferentSum(documentPayCard.getDocumentSum() - documentPayCard.getValue());
                documentPayCard.setPayCardName(documentPayCard.getPayCard().getName());
                list.add((Object)documentPayCard);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<DocumentPayCard> getListByPayCardID(ScreensController controller, long id) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT dpc.DocumentID FROM documentpaycard dpc WHERE dpc.PayCardID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, id);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                DocumentPayCard documentPayCard = new DocumentPayCard();
                documentPayCard.setDocument(Document.getByID(rSet.getLong("DocumentID"), controller.getSettings().getConnection()));
                list.add((Object)documentPayCard);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

