/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;

public class Department {
    private int DepartmentID;
    private String Name;
    private String ShortName;
    private String Code;
    private boolean Active;
    private int PrinterID;
    private int ObjectID;
    private boolean Selected = false;

    public Department() {
    }

    public Department(int id, String name) {
        this.DepartmentID = id;
        this.Name = name;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmentID) {
        this.DepartmentID = departmentID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getShortName() {
        return this.ShortName;
    }

    public void setShortName(String shortName) {
        this.ShortName = shortName;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public int getPrinterID() {
        return this.PrinterID;
    }

    public void setPrinterID(int printerID) {
        this.PrinterID = printerID;
    }

    public int getObjectID() {
        return this.ObjectID;
    }

    public void setObjectID(int objectID) {
        this.ObjectID = objectID;
    }

    public boolean isSelected() {
        return this.Selected;
    }

    public void setSelected(boolean selected) {
        this.Selected = selected;
    }

    public String toString() {
        return this.Name;
    }

    public static int getDepartmentID(int objectId, Connection connection) {
        String query = "select d.DepartmentID from department d join object o on o.ObjectID = d.ObjectID where o.ObjectID = ?";
        int id = 0;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, objectId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            id = rs.getInt("DepartmentID");
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return id;
    }

    public static Department getByCode(String code, Connection connection) {
        String query = "select * from department where Code = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Department d = new Department();
            d.DepartmentID = rs.getInt("DepartmentID");
            d.Name = rs.getString("Name");
            d.ShortName = rs.getString("ShortName");
            d.Code = rs.getString("Code");
            d.Active = rs.getBoolean("Active");
            d.PrinterID = rs.getInt("PrinterID");
            d.ObjectID = rs.getInt("ObjectID");
            rs.close();
            ps.close();
            return d;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Department getByObjectID(Object object, Connection connection) {
        String query = "select * from department where Code = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, object.getObjectID());
            ResultSet rs = ps.executeQuery();
            rs.next();
            Department d = new Department();
            d.DepartmentID = rs.getInt("DepartmentID");
            d.Name = rs.getString("Name");
            d.ShortName = rs.getString("ShortName");
            d.Code = rs.getString("Code");
            d.Active = rs.getBoolean("Active");
            d.PrinterID = rs.getInt("PrinterID");
            d.ObjectID = rs.getInt("ObjectID");
            rs.close();
            ps.close();
            return d;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Department getById(int id, Connection connection) throws SQLException {
        String query = "select * from department where DepartmentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        rs.next();
        Department d = new Department();
        d.DepartmentID = rs.getInt("DepartmentID");
        d.Name = rs.getString("Name");
        d.ShortName = rs.getString("ShortName");
        d.Code = rs.getString("Code");
        d.Active = rs.getBoolean("Active");
        d.PrinterID = rs.getInt("PrinterID");
        d.ObjectID = rs.getInt("ObjectID");
        ps.close();
        return d;
    }

    public static ObservableList<Department> getListByProductIDId(long productId, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from department where DepartmentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Department d = new Department();
            d.DepartmentID = rs.getInt("DepartmentID");
            d.Name = rs.getString("Name");
            d.ShortName = rs.getString("ShortName");
            d.Code = rs.getString("Code");
            d.Active = rs.getBoolean("Active");
            d.PrinterID = rs.getInt("PrinterID");
            d.ObjectID = rs.getInt("ObjectID");
            list.add((java.lang.Object)d);
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Department> getList(Object object, String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.*   from department d where d.DepartmentID in (select pd.DepartmentID \t\t\t\t\t\t\tfrom pointofsaledepartment pd\t\t\t\t\t\t\tleft join pointofsale p on p.PointOfSaleID = pd.PointOfSaleID\t\t\t\t\t\t   where p.ObjectID = ?)   and Name like ?  order by Name";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, object.getObjectID());
            ps.setString(2, "%" + filter + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Department d = new Department();
                d.DepartmentID = rs.getInt("DepartmentID");
                d.Name = rs.getString("Name");
                d.ShortName = rs.getString("ShortName");
                d.Code = rs.getString("Code");
                d.Active = rs.getBoolean("Active");
                d.PrinterID = rs.getInt("PrinterID");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Department> getList(Object object, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.*   from department d where d.ObjectID  = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, object.getObjectID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Department d = new Department();
                d.DepartmentID = rs.getInt("DepartmentID");
                d.Name = rs.getString("Name");
                d.ShortName = rs.getString("ShortName");
                d.Code = rs.getString("Code");
                d.Active = rs.getBoolean("Active");
                d.PrinterID = rs.getInt("PrinterID");
                d.ObjectID = rs.getInt("ObjectID");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Department> getListByObjects(String ids, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM department d where FIND_IN_SET(d.ObjectID , ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, ids);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Department d = new Department();
                d.DepartmentID = rs.getInt("DepartmentID");
                d.Name = rs.getString("Name");
                d.ShortName = rs.getString("ShortName");
                d.Code = rs.getString("Code");
                d.Active = rs.getBoolean("Active");
                d.PrinterID = rs.getInt("PrinterID");
                d.ObjectID = rs.getInt("ObjectID");
                list.add((java.lang.Object)d);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Department getByPOS(PointOfSale pointOfSale, Connection connection) {
        Department d = new Department();
        String query = "SELECT * FROM department d\tLEFT JOIN pointofsaledepartment posd ON posd.DepartmentID = d.DepartmentID\tWHERE posd.PointOfSaleID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pointOfSale.getPointOfSaleID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                d.DepartmentID = rs.getInt("DepartmentID");
                d.Name = rs.getString("Name");
                d.ShortName = rs.getString("ShortName");
                d.Code = rs.getString("Code");
                d.Active = rs.getBoolean("Active");
                d.PrinterID = rs.getInt("PrinterID");
                d.ObjectID = rs.getInt("ObjectID");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return d;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`department` (`Name`, `ShortName`, `Code`, `Active`, `ObjectID`) VALUES (?, ?, ?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.Name);
            pStatement.setString(2, this.ShortName);
            pStatement.setString(3, this.Code);
            pStatement.setBoolean(4, this.Active);
            pStatement.setInt(5, this.ObjectID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`department` SET `Name` = ?, `ShortName` = ?, `Code` = ?, `Active` = ?, `ObjectID` = ? WHERE  `DepartmentID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.Name);
            pStatement.setString(2, this.ShortName);
            pStatement.setString(3, this.Code);
            pStatement.setBoolean(4, this.Active);
            pStatement.setInt(5, this.ObjectID);
            pStatement.setInt(6, this.DepartmentID);
            System.out.println(pStatement);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

